/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.wsdl.Message;
import javax.xml.namespace.QName;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationPropertyAlias;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationSetProperty;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Validate;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.Catch;
import oracle.tip.tools.ide.common.bpelparser.iface.CatchAll;
import oracle.tip.tools.ide.common.bpelparser.iface.Compensate;
import oracle.tip.tools.ide.common.bpelparser.iface.CompensationHandler;
import oracle.tip.tools.ide.common.bpelparser.iface.CorrelationSet;
import oracle.tip.tools.ide.common.bpelparser.iface.Empty;
import oracle.tip.tools.ide.common.bpelparser.iface.Flow;
import oracle.tip.tools.ide.common.bpelparser.iface.FlowN;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.JavaEmbedding;
import oracle.tip.tools.ide.common.bpelparser.iface.OnAlarm;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Pick;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.iface.Terminate;
import oracle.tip.tools.ide.common.bpelparser.iface.Throw;
import oracle.tip.tools.ide.common.bpelparser.iface.Transformation;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Wait;
import oracle.tip.tools.ide.common.bpelparser.iface.While;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.datasources.schema.SchemaDataSource;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.BaseTreeCellRenderer;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.common.utils.MessageType;
import oracle.tip.tools.ide.common.xsdgrammar.SchemaBuilder;
import oracle.tip.tools.ide.pm.gui.explorer.ActivityInfo;
import oracle.tip.tools.ide.pm.gui.explorer.CheckBoxTreeCellRendererPanel;
import oracle.tip.tools.ide.pm.gui.explorer.ExceptionNodeDetailsPanel;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTree;
import oracle.tip.tools.ide.pm.gui.explorer.PropertyAliasTreeCellPanel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Element;

public class ExplorerTreeCellRenderer
extends BaseTreeCellRenderer
implements Accessible {
    private static Color UNFOCUSED_BACKGROUND = new Color(237, 237, 237);
    public static Icon XML_ELEMENT_ICON = null;
    public static Icon XML_CHOICE_ICON = null;
    public static Icon XML_ANY_ELEMENT_ICON = null;
    public static Icon XML_ATTRIBUTE_ICON = null;
    public static Icon XML_SEQUENCE_ICON = null;
    public static Icon XML_ANY_ATTRIBUTE_ICON = null;
    public static Icon XML_ANY_ICON = null;
    public static Icon XML_OPT_ATTRIBUTE_ICON = null;
    public static Icon XML_OPT_REPEATING_ELEMENT_ICON = null;
    public static Icon XML_REPEATING_ELEMENT_ICON = null;
    public static Icon XML_OPT_ELEMENT_ICON = null;
    protected PropertyAliasTreeCellPanel m_expandedPropAliasPnl;
    protected PropertyAliasTreeCellPanel m_collapsedPropAliasPnl;
    protected CheckBoxTreeCellRendererPanel m_unitTestRendererPnl;
    protected ExplorerTree m_explorerTree;
    protected boolean m_bHasError;

    public ExplorerTreeCellRenderer(ExplorerTree explorerTree) {
        this.m_explorerTree = explorerTree;
        this.m_unitTestRendererPnl = new CheckBoxTreeCellRendererPanel();
        this.m_expandedPropAliasPnl = new PropertyAliasTreeCellPanel(explorerTree, true);
        this.m_collapsedPropAliasPnl = new PropertyAliasTreeCellPanel(explorerTree, false);
    }

    public static Icon getActivityIcon(Activity a) {
        boolean bEditable = a.isEditable();
        if (a instanceof Process) {
            return ExplorerTreeCellRenderer.getStateIcon("process_node", bEditable);
        }
        if (a instanceof Scope) {
            return ExplorerTreeCellRenderer.getStateIcon("scope_node", bEditable);
        }
        if (a instanceof Sequence) {
            return ExplorerTreeCellRenderer.getStateIcon("sequence_node", bEditable);
        }
        if (a instanceof Flow) {
            return ExplorerTreeCellRenderer.getStateIcon("flow_node", bEditable);
        }
        if (a instanceof FlowN) {
            return ExplorerTreeCellRenderer.getStateIcon("flow_n_node", bEditable);
        }
        if (a instanceof Pick) {
            return ExplorerTreeCellRenderer.getStateIcon("pick_node", bEditable);
        }
        if (a instanceof Invoke) {
            return ExplorerTreeCellRenderer.getStateIcon("invoke_node", bEditable);
        }
        if (a instanceof Reply) {
            return ExplorerTreeCellRenderer.getStateIcon("reply_node", bEditable);
        }
        if (a instanceof Receive) {
            return ExplorerTreeCellRenderer.getStateIcon("receive_node", bEditable);
        }
        if (a instanceof Wait) {
            return ExplorerTreeCellRenderer.getStateIcon("wait_node", bEditable);
        }
        if (a instanceof Empty) {
            return ExplorerTreeCellRenderer.getStateIcon("empty_node", bEditable);
        }
        if (a instanceof Compensate) {
            return ExplorerTreeCellRenderer.getStateIcon("compensate_node", bEditable);
        }
        if (a instanceof Throw) {
            return ExplorerTreeCellRenderer.getStateIcon("throw_node", bEditable);
        }
        if (a instanceof Terminate) {
            return ExplorerTreeCellRenderer.getStateIcon("terminate_node", bEditable);
        }
        if (a instanceof CompensationHandler) {
            return ExplorerTreeCellRenderer.getStateIcon("compensate_node", bEditable);
        }
        if (a instanceof While) {
            return ExplorerTreeCellRenderer.getStateIcon("while_node", bEditable);
        }
        if (a instanceof Transformation) {
            return ExplorerTreeCellRenderer.getStateIcon("transform_node", bEditable);
        }
        if (a instanceof Assign) {
            return ExplorerTreeCellRenderer.getStateIcon("assign_node", bEditable);
        }
        if (a instanceof JavaEmbedding) {
            return ExplorerTreeCellRenderer.getStateIcon("java_embedding_node", bEditable);
        }
        if (a instanceof Catch) {
            return ExplorerTreeCellRenderer.getStateIcon("catch_node", bEditable);
        }
        if (a instanceof CatchAll) {
            return ExplorerTreeCellRenderer.getStateIcon("catch_all_node", bEditable);
        }
        if (a instanceof OnMessage) {
            return ExplorerTreeCellRenderer.getStateIcon("on_message_node", bEditable);
        }
        if (a instanceof OnAlarm) {
            return ExplorerTreeCellRenderer.getStateIcon("on_alarm_node", bEditable);
        }
        if (a instanceof Validate) {
            return ExplorerTreeCellRenderer.getStateIcon("validate_node", bEditable);
        }
        return ExplorerTreeCellRenderer.getStateIcon("application/bpel/window_gear.png", bEditable);
    }

    private static Icon getStateIcon(String key, boolean bEnabled) {
        if (bEnabled) {
            return ImageCache.getIcon(key);
        }
        return ImageCache.createDisabledIcon(ImageCache.getIcon(key));
    }

    protected Icon getXPathNodeIcon(Element elem) {
        Icon icon;
        String structAttr = elem.getAttribute("struct-elem");
        if (structAttr != null && structAttr.equals("true")) {
            icon = elem.getNodeName().startsWith("anyAttribute") ? XML_ANY_ATTRIBUTE_ICON : (elem.getNodeName().startsWith("any") ? XML_ANY_ICON : XML_ELEMENT_ICON);
        } else {
            String schemaType = elem.getAttribute("schemaType");
            if (schemaType != null && schemaType.equals("xsd:attribute")) {
                icon = SchemaBuilder.isOptional((Element)elem) ? XML_OPT_ATTRIBUTE_ICON : XML_ATTRIBUTE_ICON;
            } else {
                boolean optional = SchemaBuilder.isOptional((Element)elem);
                boolean repeating = SchemaBuilder.isRepeating((Element)elem);
                icon = SchemaBuilder.isAnyType((Element)elem) ? XML_ANY_ELEMENT_ICON : (optional && repeating ? XML_OPT_REPEATING_ELEMENT_ICON : (!optional && repeating ? XML_REPEATING_ELEMENT_ICON : (optional && !repeating ? XML_OPT_ELEMENT_ICON : XML_ELEMENT_ICON)));
            }
        }
        return icon;
    }

    protected void renderXPathNode(ExplorerTreeNode explorerTreeNode, List<TextInfo> textLst, List<Icon> iconLst, boolean bShowDetails) {
        textLst.clear();
        iconLst.clear();
        Element elem = (Element)explorerTreeNode.m_data;
        String schemaType = elem.getAttribute("schemaType");
        if (schemaType.equalsIgnoreCase("xsd:element")) {
            if (bShowDetails) {
                String nsValue = XMLHelper.getAttribute((Element)elem, (String)"namespace");
                String local = XMLHelper.getAttribute((Element)elem, (String)"localName");
                textLst.add(this.createTextInfo(BPELStringTranslator.getString("ELEMENT"), this.m_font, Color.black));
                if (nsValue != null) {
                    String ns = "{" + nsValue + "} ";
                    textLst.add(this.createTextInfo(ns, this.m_font, Color.lightGray));
                }
                textLst.add(this.createTextInfo(local, this.m_font, Color.black));
            } else {
                textLst.add(this.createTextInfo(XMLHelper.getAttribute((Element)elem, (String)"name"), this.m_font, Color.black));
            }
            iconLst.add(XML_ELEMENT_ICON);
        } else if (schemaType.equalsIgnoreCase("xsd:choice")) {
            iconLst.add(XML_CHOICE_ICON);
            textLst.add(this.createTextInfo("<", this.m_font, Color.black));
            textLst.add(this.createTextInfo("choice", this.m_font, Color.blue));
            textLst.add(this.createTextInfo(">", this.m_font, Color.black));
        } else if (schemaType.equalsIgnoreCase("xsd:sequence")) {
            iconLst.add(XML_SEQUENCE_ICON);
            textLst.add(this.createTextInfo("<", this.m_font, Color.black));
            textLst.add(this.createTextInfo("sequence", this.m_font, Color.blue));
            textLst.add(this.createTextInfo(">", this.m_font, Color.black));
        } else if (schemaType.equalsIgnoreCase("xsd:all")) {
            textLst.add(this.createTextInfo("<", this.m_font, Color.black));
            textLst.add(this.createTextInfo("all", this.m_font, Color.blue));
            textLst.add(this.createTextInfo(">", this.m_font, Color.black));
        } else if (schemaType.equalsIgnoreCase("xsd:attribute")) {
            iconLst.add(XML_ATTRIBUTE_ICON);
            if (bShowDetails) {
                textLst.add(this.createTextInfo("<", this.m_font, Color.black));
                textLst.add(this.createTextInfo("attribute", this.m_font, Color.blue));
                textLst.add(this.createTextInfo(">", this.m_font, Color.black));
                textLst.add(this.createTextInfo(" " + elem.getAttribute("name"), this.m_font, Color.black));
            } else {
                textLst.add(this.createTextInfo(" " + elem.getAttribute("name"), this.m_font, Color.black));
            }
        } else {
            String contentType = elem.getAttribute("contentType");
            if ((schemaType == null || schemaType.equals("")) && contentType != null && contentType.equalsIgnoreCase("any")) {
                Icon icon = this.getXPathNodeIcon(elem);
                iconLst.add(icon);
                String nsValue = XMLHelper.getAttribute((Element)elem, (String)"namespace");
                if (bShowDetails && nsValue != null) {
                    String ns = "{" + nsValue + "} ";
                    textLst.add(this.createTextInfo(ns, this.m_font, Color.lightGray));
                    textLst.add(this.createTextInfo("<", this.m_font, Color.black));
                    textLst.add(this.createTextInfo("any", this.m_font, Color.blue));
                    textLst.add(this.createTextInfo(">", this.m_font, Color.black));
                } else {
                    textLst.add(this.createTextInfo("<", this.m_font, Color.black));
                    textLst.add(this.createTextInfo("any", this.m_font, Color.blue));
                    textLst.add(this.createTextInfo(">", this.m_font, Color.black));
                }
            } else if (!schemaType.equals("")) {
                textLst.add(this.createTextInfo(schemaType, this.m_font, Color.black));
            } else {
                Icon icon = this.getXPathNodeIcon(elem);
                iconLst.add(icon);
                String nodeName = elem.getNodeName();
                textLst.add(this.createTextInfo("<", this.m_font, Color.black));
                textLst.add(this.createTextInfo(nodeName, this.m_font, Color.blue));
                textLst.add(this.createTextInfo(">", this.m_font, Color.black));
            }
        }
    }

    public void paintDecoration(Graphics g, int textStart, int textWidth) {
        if (this.m_bHasError) {
            Rectangle r = new Rectangle(textStart, this.getHeight() - 3, textWidth, 2);
            GraphUtils.paintHorizontalSquiggleLine((Graphics)g, (Rectangle)r);
        }
    }

    public Color getBackground() {
        if (this.m_bSelected) {
            return this.m_bHasFocus ? UIManager.getColor("Tree.selectionBackground") : UNFOCUSED_BACKGROUND;
        }
        return Color.white;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon folderIcon;
        this.m_bHasError = false;
        this.m_bHasFocus = hasFocus;
        this.m_bSelected = selected;
        this.m_iconLst.clear();
        this.m_textLst.clear();
        Icon icon = folderIcon = expanded ? ImageCache.getIcon("application/bpel/folder.png") : ImageCache.getIcon("application/bpel/folder_closed.png");
        if (!(value instanceof DefaultMutableTreeNode)) {
            return this;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node instanceof DummyNode) {
            TextInfo info = this.createTextInfo(" " + BPELStringTranslator.getString("LOADING"), this.m_font, Color.black);
            this.m_iconLst.add(GlobalImageCache.getIcon((String)"hourglass.png"));
            this.m_textLst.add(info);
            return this;
        }
        String toolTip = null;
        Object userObj = node.getUserObject();
        if (userObj instanceof ExplorerTreeNode) {
            String text = userObj.toString();
            TextInfo info = this.createTextInfo(text, this.m_font, Color.black);
            this.m_textLst.add(info);
            ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)userObj;
            boolean bShowDetails = explorerTreeNode.getShowDetails();
            switch (explorerTreeNode.m_type) {
                case 28: {
                    this.renderXPathNode(explorerTreeNode, this.m_textLst, this.m_iconLst, bShowDetails);
                    break;
                }
                case 22: {
                    break;
                }
                case 3: 
                case 9: 
                case 13: 
                case 21: {
                    Object obj = explorerTreeNode.getUserData();
                    if (!(obj instanceof Scope)) break;
                    this.m_textLst.clear();
                    Scope s = (Scope)obj;
                    boolean bEditable = s.isEditable();
                    Color c = bEditable ? Color.black : Color.gray;
                    this.m_textLst.add(this.createTextInfo(explorerTreeNode.m_text, this.m_font, c));
                    this.m_iconLst.add(bEditable ? folderIcon : ImageCache.createDisabledIcon(folderIcon));
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 26: {
                    this.m_textLst.clear();
                    URL url = (URL)explorerTreeNode.m_data;
                    this.m_textLst.add(this.createTextInfo(BPELStringTranslator.getString("PROCESS_WSDL") + " - ", this.m_font, Color.black));
                    this.m_textLst.add(this.createTextInfo(URLFileSystem.getFileName((URL)url), this.m_font, Color.black));
                    this.m_iconLst.add(ImageCache.getIcon("wsdl_node"));
                    break;
                }
                case 7: 
                case 32: {
                    this.m_iconLst.add(folderIcon);
                    break;
                }
                case 16: 
                case 33: {
                    ActivityInfo actInfo = (ActivityInfo)explorerTreeNode.m_data;
                    Activity activity = actInfo.getActivity();
                    this.m_iconLst.add(actInfo.getIcon());
                    if (actInfo.isSensored()) {
                        this.m_iconLst.add(ImageCache.getIcon("activity_sensor_node"));
                    }
                    this.m_bHasError = actInfo.hasWarnings();
                    if (this.m_bHasError) {
                        toolTip = actInfo.getWarning();
                    }
                    this.m_textLst.clear();
                    Color clr = actInfo.isEditable() ? Color.black : Color.gray;
                    TextInfo info1 = new TextInfo();
                    info1.setText(BPELParser.getActivityTypeName((Activity)activity) + " - ");
                    info1.setFont(this.m_font);
                    info1.setColor(clr);
                    this.m_textLst.add(info1);
                    String name = activity.getName();
                    if (name == null) break;
                    TextInfo info2 = new TextInfo();
                    info2.setText(activity.getName());
                    info2.setFont(this.m_font);
                    info2.setColor(clr);
                    this.m_textLst.add(info2);
                    break;
                }
                case 5: {
                    this.m_iconLst.add(ImageCache.getIcon("process_node"));
                    break;
                }
                case 6: {
                    this.m_textLst.clear();
                    Scope s = (Scope)explorerTreeNode.m_data;
                    boolean bEditable = s.isEditable();
                    Color c = bEditable ? Color.black : Color.gray;
                    this.m_textLst.add(this.createTextInfo("Scope - ", this.m_font, c));
                    this.m_textLst.add(this.createTextInfo(s.getName(), this.m_font, c));
                    Icon i = ImageCache.getIcon("scope_node");
                    this.m_iconLst.add(bEditable ? i : ImageCache.createDisabledIcon(i));
                    break;
                }
                case 25: {
                    this.m_textLst.clear();
                    this.m_textLst.add(this.createTextInfo(text, this.m_font, Color.black));
                    this.m_iconLst.add(ImageCache.getIcon("message_part_node"));
                    break;
                }
                case 42: {
                    this.m_textLst.clear();
                    MessagePart p = (MessagePart)explorerTreeNode.m_data;
                    QName qname = p.getQName();
                    if (bShowDetails) {
                        this.m_textLst.add(this.createTextInfo("Part - ", this.m_font, Color.black));
                        this.m_textLst.add(this.createTextInfo("{" + qname.getNamespaceURI() + "} ", this.m_font, Color.black));
                        this.m_textLst.add(this.createTextInfo(qname.getLocalPart(), this.m_font, Color.black));
                    } else {
                        this.m_textLst.add(this.createTextInfo(qname.getLocalPart(), this.m_font, Color.black));
                    }
                    this.m_iconLst.add(ImageCache.getIcon("message_part_node"));
                    break;
                }
                case 41: {
                    this.m_textLst.clear();
                    Message m = (Message)explorerTreeNode.m_data;
                    QName qname = m.getQName();
                    if (bShowDetails) {
                        this.m_textLst.add(this.createTextInfo("Message - ", this.m_font, Color.black));
                        this.m_textLst.add(this.createTextInfo("{" + qname.getNamespaceURI() + "} ", this.m_font, Color.black));
                        this.m_textLst.add(this.createTextInfo(qname.getLocalPart(), this.m_font, Color.black));
                    } else {
                        this.m_textLst.add(this.createTextInfo(qname.getLocalPart(), this.m_font, Color.black));
                    }
                    this.m_iconLst.add(ImageCache.getIcon("message_type_node"));
                    break;
                }
                case 24: {
                    this.m_textLst.clear();
                    if (bShowDetails) {
                        MessageType t = (MessageType)explorerTreeNode.m_data;
                        this.m_textLst.add(this.createTextInfo("{" + t.getNamespace() + "} ", this.m_font, Color.lightGray));
                        this.m_textLst.add(this.createTextInfo(t.getName(), this.m_font, Color.black));
                    } else {
                        this.m_textLst.add(this.createTextInfo(userObj.toString(), this.m_font, Color.lightGray));
                    }
                    this.m_iconLst.add(ImageCache.getIcon("message_type_node"));
                    break;
                }
                case 2: {
                    this.m_textLst.clear();
                    if (bShowDetails) {
                        MessageType t = (MessageType)explorerTreeNode.m_data;
                        this.m_textLst.add(this.createTextInfo("{" + t.getNamespace() + "} ", this.m_font, Color.lightGray));
                        this.m_textLst.add(this.createTextInfo(t.getName(), this.m_font, Color.black));
                    } else {
                        this.m_textLst.add(this.createTextInfo(userObj.toString(), this.m_font, Color.black));
                    }
                    this.m_iconLst.add(ImageCache.getIcon("message_type_node"));
                    break;
                }
                case 27: {
                    this.m_textLst.clear();
                    MessagePart p = (MessagePart)explorerTreeNode.m_data;
                    if (bShowDetails) {
                        QName qname = p.getQName();
                        if (qname != null) {
                            this.m_textLst.add(this.createTextInfo(BPELStringTranslator.getString("PART") + " - ", this.m_font, Color.black));
                            this.m_textLst.add(this.createTextInfo("{" + qname.getNamespaceURI() + "} ", this.m_font, Color.lightGray));
                            this.m_textLst.add(this.createTextInfo(qname.getLocalPart(), this.m_font, Color.lightGray));
                            this.m_textLst.add(this.createTextInfo(" - " + p.getName(), this.m_font, Color.black));
                        }
                    } else {
                        this.m_textLst.add(this.createTextInfo(p.getName(), this.m_font, Color.black));
                    }
                    this.m_iconLst.add(ImageCache.getIcon("message_part_node"));
                    break;
                }
                case 8: {
                    QName qname;
                    this.m_textLst.clear();
                    MessagePart p = (MessagePart)explorerTreeNode.m_data;
                    this.m_textLst.add(this.createTextInfo(p.getName(), this.m_font, Color.black));
                    if (bShowDetails && (qname = p.getQName()) != null) {
                        this.m_textLst.add(this.createTextInfo(" {" + qname.getNamespaceURI() + "} ", this.m_font, Color.blue));
                        this.m_textLst.add(this.createTextInfo(qname.getLocalPart(), this.m_font, Color.blue));
                    }
                    this.m_iconLst.add(ImageCache.getIcon("message_part_node"));
                    break;
                }
                case 12: {
                    break;
                }
                case 4: {
                    this.m_textLst.clear();
                    Variable var = (Variable)explorerTreeNode.m_data;
                    boolean bEditable = var.isEditable();
                    String type = "";
                    if (bShowDetails) {
                        QName qname = var.getMessageType();
                        if (qname != null) {
                            this.m_textLst.add(this.createTextInfo(BPELStringTranslator.getString("MESSAGE_TYPE") + " - ", this.m_font, Color.black));
                            type = BPELModelUtil.getExpandedName((QName)qname);
                        } else {
                            qname = var.getElement();
                            if (qname != null) {
                                this.m_textLst.add(this.createTextInfo(BPELStringTranslator.getString("EDITOR_MSG_PART_TBL_MDL_ELEM") + " - ", this.m_font, Color.black));
                                type = BPELModelUtil.getExpandedName((QName)qname);
                            } else {
                                qname = var.getType();
                                if (qname != null) {
                                    this.m_textLst.add(this.createTextInfo(BPELStringTranslator.getString("SIMPLE_TYPE") + " - ", this.m_font, Color.black));
                                    type = BPELModelUtil.getExpandedName((QName)qname);
                                }
                            }
                        }
                        this.m_textLst.add(this.createTextInfo(type, this.m_font, Color.lightGray));
                        this.m_textLst.add(this.createTextInfo(" - ", this.m_font, Color.black));
                    }
                    Color textClr = bEditable ? Color.black : Color.gray;
                    text = ((Variable)explorerTreeNode.m_data).getName();
                    this.m_textLst.add(this.createTextInfo(text, this.m_font, textClr));
                    boolean bIsSensored = var.getSensors().size() > 0;
                    Icon icon2 = ImageCache.getIcon("variable16");
                    this.m_iconLst.add(bEditable ? icon2 : ImageCache.createDisabledIcon(icon2));
                    if (!bIsSensored) break;
                    this.m_iconLst.add(ImageCache.getIcon("activity_sensor_node"));
                    break;
                }
                case 19: {
                    this.m_textLst.clear();
                    this.m_textLst.add(this.createTextInfo(userObj.toString(), this.m_font, Color.black));
                    if (bShowDetails) {
                        ExplorerTreeNode tnode = (ExplorerTreeNode)userObj;
                        CorrelationSetProperty prop = (CorrelationSetProperty)tnode.m_data;
                        String s = " - " + BPELStringTranslator.getString("TYPE2") + " " + BPELModelUtil.getExpandedName((QName)prop.getType());
                        this.m_textLst.add(this.createTextInfo(s, this.m_font, Color.blue));
                    }
                    this.m_iconLst.add(ImageCache.getIcon("property_node"));
                    break;
                }
                case 20: {
                    this.m_textLst.clear();
                    ExplorerTreeNode tnode = (ExplorerTreeNode)userObj;
                    CorrelationPropertyAlias alias = (CorrelationPropertyAlias)tnode.m_data;
                    Color bg = this.getBackground();
                    Boolean bExpanded = (Boolean)tnode.getData((Object)"EXPANDED");
                    PropertyAliasTreeCellPanel pnl = bExpanded != false ? this.m_expandedPropAliasPnl : this.m_collapsedPropAliasPnl;
                    pnl.setValues(alias);
                    if (selected) {
                        bg = hasFocus ? UIManager.getColor("Tree.selectionBackground") : UNFOCUSED_BACKGROUND;
                    }
                    pnl.setBackground(bg);
                    if (selected) {
                        pnl.getInsidePanel().setBorder(new LineBorder(Color.white));
                    } else {
                        pnl.getInsidePanel().setBorder(new LineBorder(Color.lightGray));
                    }
                    return pnl;
                }
                case 10: {
                    this.m_iconLst.add(ImageCache.getIcon("process_node"));
                    this.m_textLst.clear();
                    this.m_textLst.add(this.createTextInfo(userObj.toString(), this.m_font, Color.black));
                    break;
                }
                case 11: {
                    CorrelationSet set = (CorrelationSet)explorerTreeNode.m_data;
                    boolean bEditable = set.isEditable();
                    Icon icon3 = ImageCache.getIcon("correlation_set_node");
                    this.m_iconLst.add(bEditable ? icon3 : ImageCache.createDisabledIcon(icon3));
                    this.m_textLst.clear();
                    this.m_textLst.add(this.createTextInfo(userObj.toString(), this.m_font, bEditable ? Color.black : Color.gray));
                    break;
                }
                case 14: {
                    ExplorerTreeNode tnode = (ExplorerTreeNode)userObj;
                    PartnerLink link = (PartnerLink)tnode.m_data;
                    boolean bEditable = link.isEditable();
                    Icon img = ImageCache.getIcon("partner_link_node");
                    this.m_iconLst.add(bEditable ? img : ImageCache.createDisabledIcon(img));
                    ValidationReport report = link.getValidationReport(null, false);
                    if (report != null && report.getState() == 1) {
                        this.m_bHasError = true;
                    }
                    this.m_textLst.clear();
                    Color textClr = bEditable ? Color.black : Color.gray;
                    String name = userObj.toString();
                    if (name != null) {
                        this.m_textLst.add(this.createTextInfo(userObj.toString(), this.m_font, textClr));
                    }
                    if (!bShowDetails) break;
                    String s = " - " + BPELStringTranslator.getString("WSDL_FILE") + " " + link.getWSDLLocation();
                    this.m_textLst.add(this.createTextInfo(s, this.m_font, Color.blue));
                    break;
                }
                case 15: {
                    ExplorerTreeNode tnode = (ExplorerTreeNode)userObj;
                    URL url = (URL)tnode.m_data;
                    this.m_textLst.clear();
                    if (bShowDetails) {
                        this.m_textLst.add(this.createTextInfo(url.toExternalForm(), this.m_font, Color.black));
                    } else {
                        this.m_textLst.add(this.createTextInfo(URLFileSystem.getFileName((URL)url), this.m_font, Color.black));
                    }
                    this.m_iconLst.add(ImageCache.getIcon("schema_node"));
                    break;
                }
                case 23: {
                    ExplorerTreeNode tnode = (ExplorerTreeNode)userObj;
                    URL url = (URL)tnode.m_data;
                    this.m_textLst.clear();
                    TextInfo info1 = new TextInfo();
                    info1.setText(URLFileSystem.getFileName((URL)url));
                    if (info1.getText() == null || info1.getText().length() == 0) {
                        info1.setText(url.toString());
                    }
                    info1.setFont(this.m_font);
                    info1.setColor(Color.black);
                    this.m_textLst.add(info1);
                    this.m_iconLst.add(ImageCache.getIcon("wsdl_node"));
                    break;
                }
                case 31: {
                    ExplorerTreeNode tnode = (ExplorerTreeNode)userObj;
                    Exception e = (Exception)tnode.m_data;
                    if (bShowDetails) {
                        return new ExceptionNodeDetailsPanel(tnode.m_text, e.getMessage(), selected, hasFocus);
                    }
                    String s = tnode.m_text;
                    if (s == null) {
                        s = "";
                    }
                    this.m_textLst.clear();
                    this.m_textLst.add(this.createTextInfo("Exception", this.m_font, Color.red));
                    this.m_textLst.add(this.createTextInfo(" - " + s, this.m_font, Color.black));
                    this.m_iconLst.add(ImageCache.getIcon("exception_node"));
                    break;
                }
                case 34: {
                    this.m_textLst.clear();
                    ExplorerTreeNode tnode = (ExplorerTreeNode)userObj;
                    NodeText nt = (NodeText)tnode.m_data;
                    if (bShowDetails) {
                        TextInfo[] texts = nt.m_expandedText;
                        this.m_textLst.addAll(Arrays.asList(texts));
                    } else {
                        TextInfo[] texts = nt.m_compactText;
                        this.m_textLst.addAll(Arrays.asList(texts));
                    }
                    this.m_iconLst.add(SchemaDataSource.ELEMENT_ICON);
                    break;
                }
                case 35: {
                    this.m_textLst.clear();
                    ExplorerTreeNode tnode = (ExplorerTreeNode)userObj;
                    NodeText nt = (NodeText)tnode.m_data;
                    if (bShowDetails) {
                        TextInfo[] texts = nt.m_expandedText;
                        this.m_textLst.addAll(Arrays.asList(texts));
                    } else {
                        TextInfo[] texts = nt.m_compactText;
                        this.m_textLst.addAll(Arrays.asList(texts));
                    }
                    this.m_iconLst.add(SchemaDataSource.COMPLEX_TYPE_ICON);
                    break;
                }
                case 36: {
                    this.m_iconLst.add(ImageCache.getIcon("partner_role_node"));
                    break;
                }
                case 37: {
                    this.m_iconLst.add(ImageCache.getIcon("port_type_node"));
                    break;
                }
                case 38: {
                    this.m_iconLst.add(ImageCache.getIcon("operation_node"));
                    break;
                }
                case 43: {
                    this.m_iconLst.add(ImageCache.getIcon("application/extensions/bind_entity_16x16.png"));
                }
            }
        }
        if (this.m_iconLst.size() == 0) {
            this.m_iconLst.add(folderIcon);
        }
        String tip = this.getTipText();
        this.setText(tip);
        this.setToolTipText(toolTip);
        return this;
    }

    static {
        XML_ELEMENT_ICON = GlobalImageCache.getIcon((String)"element.png");
        XML_CHOICE_ICON = GlobalImageCache.getIcon((String)"xml_choice.gif");
        XML_ANY_ELEMENT_ICON = GlobalImageCache.getIcon((String)"xml_any_element.gif");
        XML_ATTRIBUTE_ICON = GlobalImageCache.getIcon((String)"xml_attribute.gif");
        XML_SEQUENCE_ICON = GlobalImageCache.getIcon((String)"xml_sequence.gif");
        XML_ANY_ATTRIBUTE_ICON = GlobalImageCache.getIcon((String)"xml_any_attribute.gif");
        XML_ANY_ICON = GlobalImageCache.getIcon((String)"xml_any.gif");
        XML_OPT_ATTRIBUTE_ICON = GlobalImageCache.getIcon((String)"xml_optional_attribute.gif");
        XML_OPT_REPEATING_ELEMENT_ICON = GlobalImageCache.getIcon((String)"xml_optional_element.gif");
        XML_REPEATING_ELEMENT_ICON = GlobalImageCache.getIcon((String)"xml_repeating_element.gif");
        XML_OPT_ELEMENT_ICON = GlobalImageCache.getIcon((String)"xml_optional_element.gif");
    }
}

