/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.caches.VariableDocumentCache;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationPropertyAlias;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationSetProperty;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeConstants;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeDataSource;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.DynamicSchemaInfo;
import oracle.tip.tools.ide.common.bpeldesigner.util.BPELModelerUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.ConversionUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Catch;
import oracle.tip.tools.ide.common.bpelparser.iface.CatchAll;
import oracle.tip.tools.ide.common.bpelparser.iface.CompensationHandler;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.CorrelationSet;
import oracle.tip.tools.ide.common.bpelparser.iface.CorrelationSets;
import oracle.tip.tools.ide.common.bpelparser.iface.EventHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.FaultHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.FlowN;
import oracle.tip.tools.ide.common.bpelparser.iface.OnAlarm;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.ProcessEvent;
import oracle.tip.tools.ide.common.bpelparser.iface.ProcessListener;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchCase;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchOtherwise;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.bpelparser.iface.While;
import oracle.tip.tools.ide.common.bpelparser.search.SearchData;
import oracle.tip.tools.ide.common.bpelparser.search.SearchResult;
import oracle.tip.tools.ide.common.bpelparser.search.SearchUtil;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.DropNode;
import oracle.tip.tools.ide.common.graph.model.DroppableBranchNode;
import oracle.tip.tools.ide.common.graph.model.GraphNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.NodeInfo;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.NodeEditor;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.ide.IDE;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ide.bpel.BPELProjectUtil;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.sca.CommonScaUtils;
import oracle.tip.tools.ide.common.ui.ButtonMenu;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.DraggableJTree;
import oracle.tip.tools.ide.common.ui.ImportDialog;
import oracle.tip.tools.ide.common.ui.JTreeCellRendererExtendor;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.WaitPanel;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.MapUtils;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.common.utils.MessageType;
import oracle.tip.tools.ide.common.utils.WSDLMessage;
import oracle.tip.tools.ide.common.utils.WSDLMessageComparator;
import oracle.tip.tools.ide.common.utils.WSDLPartData;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.common.xsdgrammar.SchemaBuilder;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.model.PropertyModel;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationPropertyAliasDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.CorrelationSetPropertyDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PartnerLinkSelectionDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableCreationDialog;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesFilter;
import oracle.tip.tools.ide.pm.bpelgraph.editors.partnerlink.PartnerLinkDialog;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SequenceNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.CatchView;
import oracle.tip.tools.ide.pm.bpelgraph.views.NodeEditorFactory;
import oracle.tip.tools.ide.pm.bpelgraph.views.ProcessView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ScopeView;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.AbstractActivityNodeEditor;
import oracle.tip.tools.ide.pm.gui.explorer.ActivityEditorDialog;
import oracle.tip.tools.ide.pm.gui.explorer.ActivityInfo;
import oracle.tip.tools.ide.pm.gui.explorer.DefaultDoubleClickListener;
import oracle.tip.tools.ide.pm.gui.explorer.DoubleClickListener;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerFilterDialog;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerFilterItem;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeCellRenderer;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeNodeExpander;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeSearchCallback;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeSearchPanel;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeSelectionModel;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeUtil;
import oracle.tip.tools.ide.pm.gui.explorer.MessagePartDialog;
import oracle.tip.tools.ide.pm.gui.explorer.MessageTypeDialog;
import oracle.tip.tools.ide.pm.gui.explorer.OperationDialog;
import oracle.tip.tools.ide.pm.gui.explorer.PLExplorerTreeNode;
import oracle.tip.tools.ide.pm.gui.explorer.ProjectSchemaExplorerTreeNode;
import oracle.tip.tools.ide.pm.gui.explorer.PropertyAliasTreeCellPanelMouseListener;
import oracle.tip.tools.ide.pm.gui.explorer.SchemaImportDialog;
import oracle.tip.tools.ide.pm.gui.explorer.VariableExplorerTreeNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELGraphPanePopupHandlerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import org.w3c.dom.Element;

public class ExplorerTree
extends JPanel
implements ExplorerTreeConstants,
ActionListener,
TreeSelectionListener,
KeyListener,
ProcessListener {
    private static final String LOADING_PANEL = "LOADING_PANEL";
    private static final String TREE_PANEL = "TREE_PANEL";
    private static final String NO_DATA_PANEL = "NO_DATA_PANEL";
    private static final String SHOW_EXPLORER_TREE = "SHOW_EXPLORER_TREE";
    private static final String HIDE_EXPLORER_TREE = "HIDE_EXPLORER_TREE";
    public static final int VARIABLES_MASK = 1;
    public static final int MESSAGE_TYPES_MASK = 2;
    public static final int PARTNER_LINKS_MASK = 4;
    public static final int CORRELATION_SETS_MASK = 8;
    public static final int PROJECT_SCHEMAS_MASK = 16;
    public static final int ACTIVITY_STRUCTURE_MASK = 32;
    public static final int PROPERTIES_MASK = 64;
    public static final int PROPERTY_ALIASES_MASK = 128;
    public static final int SENSOR_ACTIONS_MASK = 256;
    public static final int SENSORS_MASK = 512;
    public static final int SCOPES_MASK = 1024;
    public static final String NODE_EDITED = "NODE_EDITED";
    protected JToolBar m_rightToolBar;
    protected JToolBar m_leftToolBar;
    protected JButton m_searchBtn;
    protected JButton m_addBtn;
    protected JButton m_deleteBtn;
    protected JButton m_editBtn;
    protected JButton m_filterBtn;
    protected JButton m_refreshBtn;
    protected CardPanel m_cardPnl;
    protected CardPanel m_containerCardPnl;
    protected WaitPanel m_waitPanel;
    protected ExplorerTreeSearchPanel m_searchPnl;
    protected JTreeCellRendererExtendor m_extendor;
    protected DraggableJTree m_tree;
    protected BPELGraphPane m_graph;
    protected ButtonMenu m_createBtn;
    protected JCheckBox m_showDetailsCB;
    public DefaultMutableTreeNode m_messageTypeNodes;
    public DefaultMutableTreeNode m_activitiesNode;
    public DefaultMutableTreeNode m_partnerLinksNode;
    public DefaultMutableTreeNode m_variablesNode;
    public DefaultMutableTreeNode m_correlationsNode;
    public DefaultMutableTreeNode m_propertiesNode;
    public DefaultMutableTreeNode m_propertyAliasesNode;
    public DefaultMutableTreeNode m_scopesNode;
    public DefaultMutableTreeNode m_projectSchemasNode;
    protected JPopupMenu m_popup;
    protected JMenuItem m_detailsItem;
    protected JMenuItem m_searchItem;
    protected JMenuItem m_addMenuItem;
    protected JMenuItem m_createMenuItem;
    protected JMenuItem m_removeMenuItem;
    protected JMenuItem m_editMenuItem;
    protected JMenuItem m_expandChildrenMenuItem;
    protected JMenuItem m_refreshMenuItem;
    protected JMenu m_insertBeforeMenu;
    protected JMenu m_insertAfterMenu;
    protected JMenu m_insertIntoMenu;
    protected JMenuItem m_insertIntoInvokeItem;
    protected JMenuItem m_insertIntoAssignItem;
    protected JMenuItem m_insertIntoReplyItem;
    protected JMenuItem m_insertIntoReceiveItem;
    protected JMenuItem m_insertIntoThrowItem;
    protected JMenuItem m_insertIntoTerminateItem;
    protected JMenuItem m_insertIntoTransformItem;
    protected JMenuItem m_insertIntoEmptyItem;
    protected JMenuItem m_insertIntoScopeItem;
    protected JMenuItem m_insertIntoSequenceItem;
    protected JMenuItem m_insertIntoSwitchItem;
    protected JMenuItem m_insertIntoFlowItem;
    protected JMenuItem m_insertIntoFlowNItem;
    protected JMenuItem m_insertIntoPickItem;
    protected JMenuItem m_insertIntoWhileItem;
    protected JMenuItem m_insertIntoWaitItem;
    protected JMenuItem m_insertIntoCompensateItem;
    protected JMenuItem m_insertBeforeInvokeItem;
    protected JMenuItem m_insertBeforeAssignItem;
    protected JMenuItem m_insertBeforeReplyItem;
    protected JMenuItem m_insertBeforeReceiveItem;
    protected JMenuItem m_insertBeforeThrowItem;
    protected JMenuItem m_insertBeforeTransformItem;
    protected JMenuItem m_insertBeforeWaitItem;
    protected JMenuItem m_insertBeforeTerminateItem;
    protected JMenuItem m_insertBeforeEmptyItem;
    protected JMenuItem m_insertBeforeScopeItem;
    protected JMenuItem m_insertBeforeSequenceItem;
    protected JMenuItem m_insertBeforeSwitchItem;
    protected JMenuItem m_insertBeforeFlowItem;
    protected JMenuItem m_insertBeforeFlowNItem;
    protected JMenuItem m_insertBeforePickItem;
    protected JMenuItem m_insertBeforeWhileItem;
    protected JMenuItem m_insertBeforeCompensateItem;
    protected JMenuItem m_insertAfterInvokeItem;
    protected JMenuItem m_insertAfterAssignItem;
    protected JMenuItem m_insertAfterReplyItem;
    protected JMenuItem m_insertAfterReceiveItem;
    protected JMenuItem m_insertAfterThrowItem;
    protected JMenuItem m_insertAfterTerminateItem;
    protected JMenuItem m_insertAfterTransformItem;
    protected JMenuItem m_insertAfterWaitItem;
    protected JMenuItem m_insertAfterEmptyItem;
    protected JMenuItem m_insertAfterScopeItem;
    protected JMenuItem m_insertAfterSequenceItem;
    protected JMenuItem m_insertAfterSwitchItem;
    protected JMenuItem m_insertAfterFlowItem;
    protected JMenuItem m_insertAfterFlowNItem;
    protected JMenuItem m_insertAfterPickItem;
    protected JMenuItem m_insertAfterWhileItem;
    protected JMenuItem m_insertAfterCompensateItem;
    protected JMenuItem m_addCatchBranchMenuItem;
    protected JMenuItem m_exceptionToClipboardItem;
    protected int m_mask = 1023;
    protected Activity m_lastActivity;
    protected boolean m_bIsStructurePane = false;
    protected boolean m_bFireProcessModelChanges = true;
    protected boolean m_updateGUIOnModelChanges = false;
    protected Activity m_activity;
    protected EventListenerList m_doubleClickListenerList = new EventListenerList();
    protected PropertyAliasTreeCellPanelMouseListener m_propAliasMouseListener;
    protected int m_refreshNodeID = -1;
    protected boolean m_bShowSearchPanel;
    protected VariablesFilter m_variablesFilter;
    protected DynamicSchemaInfo m_dynamicSchemaInfo;
    protected boolean m_bShowVariablesFlatMode = false;
    protected boolean m_bAllowObjectEditing = true;
    protected TreeExpansionHandler m_expansionListener;
    protected int m_variableCreationMask = -1;

    public ExplorerTree() {
        this.m_activitiesNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("EDITOR_EXP_ACT_STRU", "Activity Structure"), 22, null));
        this.m_partnerLinksNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("EDITOR_EXP_PL", "Partner Links"), 13, null));
        this.m_variablesNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("EDITOR_EXP_VAR", "Variables"), 0, null));
        this.m_correlationsNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("EDITOR_EXP_CR_SETS", "Correlation Sets"), 21, null));
        this.m_messageTypeNodes = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("COLLAXALAF_MESSAGE_TYPES"), 21, null));
        this.m_propertiesNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("EDITOR_EXP_PROP", "Properties"), 17, null));
        this.m_propertyAliasesNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("EDITOR_EXP_PROP_ALS", "Property Aliases"), 18, null));
        this.m_scopesNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("EDITOR_EXP_PAR_SCO", "Parent Scopes"), 7, null));
        this.m_projectSchemasNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("EDITOR_EXP_PRJ_SCHEMA", "Project Schemas"), 12, null));
        this.addDoubleClickListener(new DefaultDoubleClickListener());
        this.createControls();
        this.layoutControls();
        this.registerPopupMenuInvoker();
    }

    public void setVariableCreationMask(int variableCreationMask) {
        this.m_variableCreationMask = variableCreationMask;
    }

    public boolean getAllowEditing() {
        return this.m_bAllowObjectEditing;
    }

    public void setAllowEditing(boolean bAllowEditing) {
        this.m_bAllowObjectEditing = bAllowEditing;
        this.m_createBtn.setVisible(bAllowEditing);
        this.m_editBtn.setVisible(bAllowEditing);
        this.m_addBtn.setVisible(bAllowEditing);
        this.m_deleteBtn.setVisible(bAllowEditing);
    }

    public void showVariablesFlatMode(boolean bShowFlat) {
        this.m_bShowVariablesFlatMode = bShowFlat;
    }

    public void setDynamicSchemaInfo(DynamicSchemaInfo dynaInfo) {
        this.m_dynamicSchemaInfo = dynaInfo;
    }

    public VariablesFilter getVariablesFilter() {
        return this.m_variablesFilter;
    }

    public void setVariablesFilter(VariablesFilter variablesFilter) {
        this.m_variablesFilter = variablesFilter;
    }

    public DefaultMutableTreeNode getVariablesNode() {
        return this.m_variablesNode;
    }

    public void addDoubleClickListener(DoubleClickListener l) {
        this.m_doubleClickListenerList.add(DoubleClickListener.class, l);
    }

    public void removeDoubleClickListener(DoubleClickListener l) {
        this.m_doubleClickListenerList.remove(DoubleClickListener.class, l);
    }

    public void removeAllDoubleClickListener() {
        Object[] objs = this.m_doubleClickListenerList.getListenerList();
        for (int i = objs.length - 2; i >= 0; i -= 2) {
            if (objs[i] != DoubleClickListener.class) continue;
            DoubleClickListener obj = (DoubleClickListener)objs[i + 1];
            this.removeDoubleClickListener(obj);
        }
    }

    protected void fireDoubleClickEvent(MouseEvent evt) {
        Object[] listeners = this.m_doubleClickListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DoubleClickListener.class) continue;
            ((DoubleClickListener)listeners[i + 1]).onDoubleClick(this, evt);
        }
    }

    public boolean selectVariable(Variable v) {
        for (int i = 0; i < this.m_variablesNode.getChildCount(); ++i) {
            DefaultMutableTreeNode n = this.findNodeOfTypeAndData((DefaultMutableTreeNode)this.m_variablesNode.getChildAt(i), v, 4);
            if (n == null) continue;
            this.selectNode(n);
            return true;
        }
        return false;
    }

    public DefaultMutableTreeNode findNodeOfTypeAndData(DefaultMutableTreeNode rootNode, Object data, int type) {
        if (rootNode == null || data == null) {
            return null;
        }
        Object userObj = rootNode.getUserObject();
        if (!(userObj instanceof ExplorerTreeNode)) {
            return null;
        }
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)userObj;
        if (explorerNode.m_type == type && explorerNode.m_data == data) {
            return rootNode;
        }
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            DefaultMutableTreeNode result = this.findNodeOfTypeAndData((DefaultMutableTreeNode)rootNode.getChildAt(i), data, type);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected List<DefaultMutableTreeNode> findNodesOfType(DefaultMutableTreeNode n, int type) {
        if (n == null) {
            return null;
        }
        ArrayList<DefaultMutableTreeNode> l = new ArrayList<DefaultMutableTreeNode>();
        Object userObj = n.getUserObject();
        if (userObj instanceof ExplorerTreeNode) {
            ExplorerTreeNode explorerNode = (ExplorerTreeNode)userObj;
            if (explorerNode.m_type == type) {
                l.add(n);
            }
        }
        for (int i = 0; i < n.getChildCount(); ++i) {
            List<DefaultMutableTreeNode> retVal = this.findNodesOfType((DefaultMutableTreeNode)n.getChildAt(i), type);
            if (retVal == null) continue;
            l.addAll(retVal);
        }
        return l;
    }

    public Variable getVariableContext() {
        ExplorerTreeNode n = this.getSelectedExplorerTreeNode();
        if (n == null) {
            return null;
        }
        if (n.m_type == 4) {
            return (Variable)n.m_data;
        }
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof DefaultMutableTreeNode)) {
            return null;
        }
        for (DefaultMutableTreeNode currNode = (DefaultMutableTreeNode)obj; currNode != null; currNode = (DefaultMutableTreeNode)currNode.getParent()) {
            Object userObj = currNode.getUserObject();
            if (!(userObj instanceof ExplorerTreeNode)) continue;
            ExplorerTreeNode explorerNode = (ExplorerTreeNode)userObj;
            if (explorerNode.m_type != 4) continue;
            return (Variable)explorerNode.m_data;
        }
        return null;
    }

    public MessagePart getMessagePartContext() {
        ExplorerTreeNode n = this.getSelectedExplorerTreeNode();
        if (n == null) {
            return null;
        }
        if (n.m_type == 27) {
            return (MessagePart)n.m_data;
        }
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof DefaultMutableTreeNode)) {
            return null;
        }
        for (DefaultMutableTreeNode currNode = (DefaultMutableTreeNode)obj; currNode != null; currNode = (DefaultMutableTreeNode)currNode.getParent()) {
            Object userObj = currNode.getUserObject();
            if (!(userObj instanceof ExplorerTreeNode)) continue;
            ExplorerTreeNode explorerNode = (ExplorerTreeNode)userObj;
            if (explorerNode.m_type != 27) continue;
            return (MessagePart)explorerNode.m_data;
        }
        return null;
    }

    public String getSelectedVariableXPath() {
        ExplorerTreeNode n = this.getSelectedExplorerTreeNode();
        if (n == null) {
            return null;
        }
        if (n.m_type == 4) {
            Variable v = (Variable)n.m_data;
            return "/" + v.getName();
        }
        if (n.m_type == 27) {
            String partName;
            MessagePart p = (MessagePart)n.m_data;
            QName qname = p.getQName();
            TreePath path = this.m_tree.getSelectionPath();
            if (path == null) {
                return null;
            }
            Object obj = path.getLastPathComponent();
            if (!(obj instanceof DefaultMutableTreeNode)) {
                return null;
            }
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)obj;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tn.getParent();
            ExplorerTreeNode en = (ExplorerTreeNode)parent.getUserObject();
            Variable v = (Variable)en.m_data;
            if (qname != null && qname.getNamespaceURI() != null) {
                String ns = qname.getNamespaceURI();
                MapperNSResolver resolver = (MapperNSResolver)n.getData((Object)"RESOLVER_KEY");
                String prefix = resolver.resolveNamespaceURI(ns);
                partName = prefix + ":" + p.getName();
            } else {
                partName = p.getName();
            }
            return "/" + v.getName() + "/" + partName;
        }
        if (n.m_type == 28) {
            TreePath path = this.m_tree.getSelectionPath();
            if (path == null) {
                return null;
            }
            Object obj = path.getLastPathComponent();
            if (!(obj instanceof DefaultMutableTreeNode)) {
                return null;
            }
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)obj;
            ExplorerTreeNode explorerNode = (ExplorerTreeNode)tn.getUserObject();
            Element domElem = (Element)explorerNode.m_data;
            if (domElem != null) {
                Object userObj;
                if (!this.checkSupported(domElem)) {
                    return null;
                }
                if (SchemaBuilder.isAllElement((Element)domElem) || SchemaBuilder.isChoiceElement((Element)domElem) || SchemaBuilder.isSequenceElement((Element)domElem)) {
                    return null;
                }
                String xp = MapUtils.getInstanceXPath((Element)domElem);
                if (xp == null) {
                    return null;
                }
                for (DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj; treeNode != null && (userObj = treeNode.getUserObject()) instanceof ExplorerTreeNode; treeNode = (DefaultMutableTreeNode)treeNode.getParent()) {
                    ExplorerTreeNode dataNode = (ExplorerTreeNode)userObj;
                    if (dataNode.m_type == 4) break;
                    if (dataNode.m_type != 27) continue;
                }
                String totalXPath = "";
                if (xp != null) {
                    totalXPath = totalXPath + xp;
                }
                return totalXPath;
            }
        }
        return null;
    }

    public boolean isStructurePane() {
        return this.m_bIsStructurePane;
    }

    public void setStructurePane(boolean bIsStructurePane) {
        this.m_bIsStructurePane = bIsStructurePane;
        this.setUpdateGUIOnModelChanges(this.m_bIsStructurePane);
    }

    public void setUpdateGUIOnModelChanges(boolean bUpdate) {
        this.m_updateGUIOnModelChanges = bUpdate;
    }

    public boolean getUpdateGUIOnModelChanges() {
        return this.m_updateGUIOnModelChanges;
    }

    public void setFireProcessModelChanges(boolean bFireEvents) {
        this.m_bFireProcessModelChanges = bFireEvents;
    }

    public void showToolBar(boolean bShow) {
        this.m_rightToolBar.setVisible(bShow);
        this.m_leftToolBar.setVisible(bShow);
    }

    public void showDetailsCheckBox(boolean bShow) {
        this.m_showDetailsCB.setVisible(bShow);
    }

    public void setMask(int mask) {
        this.m_mask = mask;
    }

    public int getMask() {
        return this.m_mask;
    }

    public boolean getShowBranch(int mask) {
        return (this.m_mask & mask) != 0;
    }

    public void setShowBranch(int mask, boolean bShow) {
        this.m_mask = bShow ? (this.m_mask |= mask) : (this.m_mask &= ~mask);
    }

    public void showRootNode(boolean bShow) {
        this.m_tree.setRootVisible(bShow);
    }

    public void showFilterButton(boolean bShow) {
        this.m_filterBtn.setVisible(bShow);
    }

    public DraggableJTree getTree() {
        return this.m_tree;
    }

    public void refreshNode(int nodeID) {
        DefaultMutableTreeNode treeNode = null;
        switch (nodeID) {
            case 1: {
                treeNode = this.m_messageTypeNodes = this.buildMessageTypeNodes();
                break;
            }
            case 13: {
                this.buildPartnerLinkNodes(null);
                treeNode = this.m_partnerLinksNode;
                break;
            }
            case 22: {
                this.buildActivityNodes();
                treeNode = this.m_activitiesNode;
                break;
            }
            case 17: {
                this.buildPropertiesNode();
                treeNode = this.m_propertiesNode;
                break;
            }
            case 18: {
                this.buildPropertyAliasesNode();
                treeNode = this.m_propertyAliasesNode;
                break;
            }
            case 9: {
                this.buildCorrelationSetsNodes(null);
                treeNode = this.m_correlationsNode;
                break;
            }
            case 0: {
                VariableDocumentCache.clearVariablesCache((URL)this.m_graph.getBPELProject().getBPELFileURL());
                this.buildVariablesNodes(this.m_lastActivity);
                treeNode = this.m_variablesNode;
                break;
            }
            case 12: {
                this.buildSchemasNodes();
                treeNode = this.m_projectSchemasNode;
                break;
            }
        }
        if (treeNode != null) {
            DefaultTreeModel model = (DefaultTreeModel)this.m_tree.getModel();
            model.nodeStructureChanged(treeNode);
            TreePath path = this.getTreePathForNode(treeNode);
            this.m_tree.expandPath(path);
            this.selectNode(treeNode);
            this.setExplorerTreeCellRenderer();
        }
    }

    public void expandNode(int nodeID) {
        DefaultMutableTreeNode treeNode = null;
        switch (nodeID) {
            case 1: {
                treeNode = this.m_messageTypeNodes;
                break;
            }
            case 13: {
                treeNode = this.m_partnerLinksNode;
                break;
            }
            case 22: {
                treeNode = this.m_activitiesNode;
                break;
            }
            case 17: {
                treeNode = this.m_propertiesNode;
                break;
            }
            case 18: {
                treeNode = this.m_propertyAliasesNode;
                break;
            }
            case 9: {
                treeNode = this.m_correlationsNode;
                break;
            }
            case 0: {
                treeNode = this.m_variablesNode;
                break;
            }
        }
        if (treeNode != null) {
            TreePath path = this.getTreePathForNode((DefaultMutableTreeNode)treeNode.getParent());
            GraphUtils.expandTree((JTree)this.m_tree, (TreePath)path, (TreeNode)treeNode);
        }
    }

    public void expandVariableContainerNodes() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                List<DefaultMutableTreeNode> lst = ExplorerTree.this.findNodesOfType(ExplorerTree.this.m_variablesNode, 3);
                for (DefaultMutableTreeNode n : lst) {
                    TreePath path = ExplorerTree.this.getTreePathForNode(n);
                    ExplorerTree.this.m_tree.expandPath(path);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void expandPartnerLinkContainerNodes() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                List<DefaultMutableTreeNode> nodes = ExplorerTree.this.findNodesOfType(ExplorerTree.this.m_partnerLinksNode, 13);
                for (DefaultMutableTreeNode n : nodes) {
                    TreePath path = ExplorerTree.this.getTreePathForNode(n);
                    ExplorerTree.this.m_tree.expandPath(path);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void setGraphPane(BPELGraphPane p) {
        this.m_graph = p;
        Runnable r = this.m_graph == null ? new Runnable(){

            @Override
            public void run() {
                ExplorerTree.this.m_containerCardPnl.show(ExplorerTree.HIDE_EXPLORER_TREE);
                ExplorerTree.this.clearTreeData();
                ExplorerTree.this.updateButtons();
            }
        } : new Runnable(){

            @Override
            public void run() {
                ExplorerTree.this.m_containerCardPnl.show(ExplorerTree.SHOW_EXPLORER_TREE);
            }
        };
        if (r != null) {
            SwingUtilities.invokeLater(r);
        }
    }

    private void clearTreeData() {
        this.m_activitiesNode.removeAllChildren();
        this.m_partnerLinksNode.removeAllChildren();
        this.m_variablesNode.removeAllChildren();
        this.m_correlationsNode.removeAllChildren();
        this.m_messageTypeNodes.removeAllChildren();
        this.m_propertiesNode.removeAllChildren();
        this.m_propertyAliasesNode.removeAllChildren();
        this.m_scopesNode.removeAllChildren();
        this.m_projectSchemasNode.removeAllChildren();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getModel().getRoot();
        this.m_tree.setModel((TreeModel)new DefaultTreeModel(node));
    }

    public BPELGraphPane getGraphPane() {
        return this.m_graph;
    }

    public Object getSelectedNodeData() {
        ExplorerTreeNode n = this.getSelectedExplorerTreeNode();
        if (n == null) {
            return null;
        }
        return n.m_data;
    }

    public ExplorerTreeNode getSelectedExplorerTreeNode() {
        if (this.getSelectedTreeNode() != null) {
            return (ExplorerTreeNode)this.getSelectedTreeNode().getUserObject();
        }
        return null;
    }

    public DefaultMutableTreeNode getSelectedTreeNode() {
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return (DefaultMutableTreeNode)obj;
    }

    protected Activity getSelectedActivity() {
        ExplorerTreeNode n = this.getSelectedExplorerTreeNode();
        if (n != null && n.m_type == 16) {
            ActivityInfo info = (ActivityInfo)n.m_data;
            return info.getActivity();
        }
        return null;
    }

    public int getSelectedNodeType() {
        ExplorerTreeNode n = this.getSelectedExplorerTreeNode();
        if (n == null) {
            return -1;
        }
        return n.m_type;
    }

    public void dereference() {
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        p.removeProcessListener((ProcessListener)this);
    }

    public void loadExplorer(Activity a) throws Exception {
        this.loadExplorer(a, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadExplorer(Activity a, final boolean bSelectRoot) throws Exception {
        ExplorerTree explorerTree = this;
        synchronized (explorerTree) {
            int idx;
            if (this.m_graph == null) {
                return;
            }
            BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
            if (graphModel == null) {
                return;
            }
            Process p = graphModel.getProcess();
            p.removeProcessListener((ProcessListener)this);
            p.addProcessListener((ProcessListener)this);
            URL u = this.m_graph.getBPELProject().getBPELFileURL();
            String fileName = "";
            if (u != null) {
                fileName = Helper.getFileName((URL)u);
            }
            ExplorerTreeNode explorerNode = new ExplorerTreeNode(fileName, 10, (Object)fileName);
            final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(explorerNode);
            this.m_lastActivity = a;
            if ((this.m_mask & 4) != 0) {
                idx = rootNode.getIndex(this.m_partnerLinksNode);
                if (idx == -1) {
                    rootNode.add(this.m_partnerLinksNode);
                }
                this.buildPartnerLinkNodes(a);
            }
            if ((this.m_mask & 1) != 0) {
                idx = rootNode.getIndex(this.m_variablesNode);
                if (idx == -1) {
                    rootNode.add(this.m_variablesNode);
                }
                this.buildVariablesNodes(a);
            }
            if ((this.m_mask & 8) != 0) {
                idx = rootNode.getIndex(this.m_correlationsNode);
                if (idx == -1) {
                    rootNode.add(this.m_correlationsNode);
                }
                this.buildCorrelationSetsNodes(a);
            }
            if ((this.m_mask & 0x20) != 0) {
                idx = rootNode.getIndex(this.m_activitiesNode);
                if (idx == -1) {
                    rootNode.add(this.m_activitiesNode);
                }
                this.buildActivityNodes();
            }
            if ((this.m_mask & 0x40) != 0) {
                idx = rootNode.getIndex(this.m_propertiesNode);
                if (idx == -1) {
                    rootNode.add(this.m_propertiesNode);
                }
                this.buildPropertiesNode();
            }
            if ((this.m_mask & 0x80) != 0) {
                idx = rootNode.getIndex(this.m_propertyAliasesNode);
                if (idx == -1) {
                    rootNode.add(this.m_propertyAliasesNode);
                }
                this.buildPropertyAliasesNode();
            }
            if ((this.m_mask & 2) != 0) {
                this.m_messageTypeNodes = this.buildMessageTypeNodes();
                rootNode.add(this.m_messageTypeNodes);
            }
            if ((this.m_mask & 0x10) != 0) {
                idx = rootNode.getIndex(this.m_projectSchemasNode);
                if (idx == -1) {
                    rootNode.add(this.m_projectSchemasNode);
                }
                this.buildSchemasNodes();
            }
            if ((this.m_mask & 0x400) != 0) {
                idx = rootNode.getIndex(this.m_scopesNode);
                if (idx == -1) {
                    rootNode.add(this.m_scopesNode);
                }
                this.buildParentScopeNodes(a);
            }
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ExplorerTree.this.m_tree.setModel((TreeModel)new DefaultTreeModel(rootNode));
                        ExplorerTree.this.expandRootNode();
                        if (bSelectRoot) {
                            ExplorerTree.this.selectRoot();
                        }
                        ExplorerTree.this.updateButtons();
                    }
                    finally {
                        ExplorerTree.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    public void selectNode(DefaultMutableTreeNode node) {
        final TreePath path = this.getTreePathForNode(node);
        if (path != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    TreeSelectionModel selModel = ExplorerTree.this.m_tree.getSelectionModel();
                    selModel.setSelectionPath(path);
                    ExplorerTree.this.m_tree.scrollPathToVisible(path);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    public void selectRoot() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getModel().getRoot();
        final TreePath path = this.getTreePathForNode(node);
        if (path != null) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    TreeSelectionModel selModel = ExplorerTree.this.m_tree.getSelectionModel();
                    selModel.setSelectionPath(path);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void fireModelChanged(int id, Object data) {
        if (this.m_bFireProcessModelChanges) {
            BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
            Process p = graphModel.getProcess();
            p.fireModelChanged((Object)this, id, data);
        }
    }

    public void selectFirstChild(DefaultMutableTreeNode node) {
        if (node != null) {
            TreePath path;
            if (node.getChildCount() > 0) {
                node = (DefaultMutableTreeNode)node.getChildAt(0);
            }
            if ((path = this.getTreePathForNode(node)) != null) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        TreeSelectionModel selModel = ExplorerTree.this.m_tree.getSelectionModel();
                        selModel.setSelectionPath(path);
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        }
    }

    public DefaultMutableTreeNode getLastChildScope(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode result = this.getLastChildScope(childNode);
            if (result != null) {
                return result;
            }
            ExplorerTreeNode tnode = (ExplorerTreeNode)childNode.getUserObject();
            if (tnode == null || tnode.m_type != 6) continue;
            return childNode;
        }
        return null;
    }

    public DefaultMutableTreeNode getProcessNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            ExplorerTreeNode tnode = (ExplorerTreeNode)childNode.getUserObject();
            if (tnode == null || tnode.m_type != 5) continue;
            return childNode;
        }
        return null;
    }

    public void expandEntireTree() {
        if (SwingUtilities.isEventDispatchThread()) {
            GraphUtils.expandTree((JTree)this.m_tree);
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    GraphUtils.expandTree((JTree)ExplorerTree.this.m_tree);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void expandRootNode() {
        DefaultTreeModel model = (DefaultTreeModel)this.m_tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        TreePath path = this.getTreePathForNode(root);
        if (path != null) {
            this.m_tree.expandPath(path);
        }
    }

    public JTreeCellRendererExtendor getJTreeCellRendererExtendor() {
        return this.m_extendor;
    }

    protected void createControls() {
        this.m_containerCardPnl = new CardPanel();
        this.m_searchPnl = new ExplorerTreeSearchPanel(this);
        this.m_cardPnl = new CardPanel();
        this.m_showDetailsCB = new JCheckBox();
        this.m_showDetailsCB.setEnabled(false);
        BPELStringTranslator.setButton(this.m_showDetailsCB, BPELStringTranslator.getString("EDITOR_EXP_SHOW_DEY_NODE_INFO"));
        this.m_showDetailsCB.addActionListener(this);
        this.m_tree = new MyTree();
        this.m_extendor = new JTreeCellRendererExtendor((JTree)this.m_tree);
        this.m_tree.setRowHeight(0);
        this.m_expansionListener = new TreeExpansionHandler();
        this.m_tree.addTreeExpansionListener((TreeExpansionListener)this.m_expansionListener);
        this.m_cardPnl.add(TREE_PANEL, (Component)GraphUtils.getScrollPane((Component)this.m_tree));
        this.m_waitPanel = new WaitPanel();
        this.m_waitPanel.setText(BPELStringTranslator.getString("EDITOR_REFRESHING"));
        this.m_cardPnl.add(LOADING_PANEL, (Component)this.m_waitPanel);
        this.m_cardPnl.add(NO_DATA_PANEL, (Component)new JPanel());
        this.m_cardPnl.show(TREE_PANEL);
        this.m_tree.setSelectionModel((TreeSelectionModel)new ExplorerTreeSelectionModel());
        this.m_tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ExplorerTree.this.fireDoubleClickEvent(e);
                }
            }
        });
        this.m_tree.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DefaultMutableTreeNode n;
                ExplorerTreeNode explorerNode;
                TreePath p = ExplorerTree.this.m_tree.getPathForLocation(e.getX(), e.getY());
                if (p != null && (explorerNode = (ExplorerTreeNode)(n = (DefaultMutableTreeNode)p.getLastPathComponent()).getUserObject()) != null && explorerNode.hasWarning()) {
                    ExplorerTree.this.m_tree.setToolTipText(explorerNode.getWarning());
                    return;
                }
                ExplorerTree.this.m_tree.setToolTipText(null);
            }
        });
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new ExplorerTreeNode("", 7, null));
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.m_tree.setModel((TreeModel)model);
        TreeSelectionModel selModel = this.m_tree.getSelectionModel();
        selModel.setSelectionMode(1);
        this.m_tree.addKeyListener((KeyListener)this);
        this.m_tree.addTreeSelectionListener((TreeSelectionListener)this);
        this.setExplorerTreeCellRenderer();
        this.m_addMenuItem = new JMenuItem(BPELStringTranslator.getString("EDITOR_EXP_MENU_CREATE"), ImageCache.getIcon("add16"));
        this.m_addMenuItem.addActionListener(this);
        this.m_detailsItem = new JMenuItem(BPELStringTranslator.getString("EDITOR_EXP_TOGGLE_DETAILS"), ImageCache.getIcon("application/bpel/news_view.png"));
        this.m_detailsItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_detailsItem, BPELStringTranslator.getString("EDITOR_EXP_TOGGLE_DETAILS"));
        this.m_searchItem = new JMenuItem(BPELStringTranslator.getString("EDITOR_EXP_SEARCH_BTN") + "...", ImageCache.getIcon("find.png"));
        this.m_searchItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_searchItem, BPELStringTranslator.getString("GRAPHPOPUP_SEARCH"));
        this.m_createMenuItem = new JMenuItem(BPELStringTranslator.getString("EDITOR_EXP_MENU_CREATE"), ImageCache.getIcon("create16"));
        this.m_createMenuItem.addActionListener(this);
        this.m_editMenuItem = new JMenuItem(BPELStringTranslator.getString("EDITOR_EXP_MENU_EDIT"), ImageCache.getIcon("edit16"));
        this.m_editMenuItem.addActionListener(this);
        this.m_removeMenuItem = new JMenuItem(BPELStringTranslator.getString("EDITOR_EXP_MENU_DEL"), ImageCache.getIcon("delete2.png"));
        this.m_removeMenuItem.addActionListener(this);
        this.m_expandChildrenMenuItem = new JMenuItem(BPELStringTranslator.getString("EDITOR_EXP_MENU_EXP_ALL_NODES"), ImageCache.getIcon("expandall16"));
        this.m_expandChildrenMenuItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_expandChildrenMenuItem, BPELStringTranslator.getString("EDITOR_EXP_MENU_EXP_ALL_NODES_M"));
        this.m_refreshMenuItem = new JMenuItem(BPELStringTranslator.getString("REFRESH"), ImageCache.getIcon("refresh16"));
        this.m_refreshMenuItem.addActionListener(this);
        BPELStringTranslator.setButton(this.m_refreshMenuItem, BPELStringTranslator.getString("REFRESH_M"));
        this.m_exceptionToClipboardItem = new JMenuItem(BPELStringTranslator.getString("COPY_TO_CLIPBOARD"), ImageCache.getIcon("clipboard16"));
        this.m_exceptionToClipboardItem.addActionListener(this);
        this.m_insertBeforeMenu = this.createInsertBeforeMenu();
        this.m_insertAfterMenu = this.createInsertAfterMenu();
        this.m_insertIntoMenu = this.createInsertIntoMenu();
        this.m_addCatchBranchMenuItem = new JMenuItem(BPELStringTranslator.getString("ACTIONS_ADD_CATCH_BRANCH"), new ImageIcon(ImageCache.getImage("graph/bpel/catch_16x16.png")));
        this.m_addCatchBranchMenuItem.addActionListener(this);
        this.m_popup = new JPopupMenu();
        this.m_tree.add((Component)this.m_popup);
        this.m_tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ExplorerTree.this.handlePopupTrigger(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ExplorerTree.this.handlePopupTrigger(e);
                }
            }
        });
        this.m_refreshBtn = new JButton(ImageCache.getIcon("refresh16"));
        this.m_refreshBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_EXP_REF_TIP"));
        this.m_refreshBtn.addActionListener(this);
        this.m_refreshBtn.setMnemonic(BPELStringTranslator.getMnemonic("EDITOR_EXP_REF_Mnemonic"));
        this.m_filterBtn = new JButton(ImageCache.getIcon("filter16"));
        this.m_filterBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_EXP_DISP_FILTER"));
        this.m_filterBtn.addActionListener(this);
        this.m_filterBtn.setMnemonic(BPELStringTranslator.getMnemonic("EDITOR_EXP_DISP_FILTER_Mnemonic"));
        this.m_searchBtn = new JButton(ImageCache.getIcon("find.png"));
        this.m_searchBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_EXP_SEARCH_BTN"));
        this.m_searchBtn.addActionListener(this);
        this.m_createBtn = new ButtonMenu("", ImageCache.getIcon("create16"));
        this.m_createBtn.setPadding(2);
        UIHelper.createModelerButton((Icon)ImageCache.getIcon("create16"));
        this.m_createBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_EXP_SEARCH_BTN_TIP") + "...");
        this.m_createBtn.setShowDropDownArrow(false);
        this.m_createBtn.addActionListener((ActionListener)this);
        this.enableCreateButton(false);
        this.m_addBtn = new JButton(ImageCache.getIcon("add16"));
        this.m_addBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_EXP_ADD_BTN_TIP") + "...");
        this.m_addBtn.setMnemonic(BPELStringTranslator.getMnemonic("ADD_BUTTON_TEXT_Mnemonic"));
        this.m_addBtn.addActionListener(this);
        this.m_addBtn.setEnabled(false);
        this.m_deleteBtn = new JButton(ImageCache.getIcon("delete2.png"));
        this.m_deleteBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_EXP_DEL_SEL_NODE_TIP"));
        this.m_deleteBtn.setMnemonic(BPELStringTranslator.getMnemonic("DEL_BUTTON_TEXT_Mnemonic"));
        this.m_deleteBtn.addActionListener(this);
        this.enableDeleteButton(false);
        this.m_editBtn = new JButton(ImageCache.getIcon("edit16"));
        this.m_editBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_EXP_EDIT_SEL_NODE_TIP") + "...");
        this.m_editBtn.setMnemonic(BPELStringTranslator.getMnemonic("EDIT_BUTTON_TEXT_Mnemonic"));
        this.m_editBtn.addActionListener(this);
        this.enableEditButton(false);
        this.m_rightToolBar = new JToolBar();
        this.m_rightToolBar.setBorderPainted(false);
        this.m_rightToolBar.add((Component)this.m_createBtn);
        this.m_rightToolBar.add(this.m_editBtn);
        this.m_rightToolBar.add(this.m_deleteBtn);
        this.m_leftToolBar = new JToolBar();
        this.m_leftToolBar.setBorderPainted(false);
        this.m_leftToolBar.add(this.m_filterBtn);
        this.m_leftToolBar.add(this.m_searchBtn);
        this.m_leftToolBar.add(this.m_refreshBtn);
    }

    public void setExplorerTreeCellRenderer() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (ExplorerTree.this.m_propAliasMouseListener != null) {
                    ExplorerTree.this.getTree().removeMouseListener((MouseListener)ExplorerTree.this.m_propAliasMouseListener);
                    ExplorerTree.this.m_propAliasMouseListener = null;
                }
                ExplorerTreeCellRenderer renderer = new ExplorerTreeCellRenderer(ExplorerTree.this);
                ExplorerTree.this.getTree().setCellRenderer((TreeCellRenderer)((Object)renderer));
                ExplorerTree.this.m_propAliasMouseListener = new PropertyAliasTreeCellPanelMouseListener(renderer.m_expandedPropAliasPnl, renderer.m_collapsedPropAliasPnl, ExplorerTree.this);
                ExplorerTree.this.getTree().addMouseListener((MouseListener)ExplorerTree.this.m_propAliasMouseListener);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    protected JMenuItem installMenuItem(String text, Icon icon, JMenu menu) {
        JMenuItem item = new JMenuItem(text, icon);
        item.addActionListener(this);
        menu.add(item);
        return item;
    }

    protected JMenu createInsertBeforeMenu() {
        JMenu menu = new JMenu(BPELStringTranslator.getString("COLLAXALAF_INSERT_BEFORE"));
        BPELStringTranslator.setButton(menu, BPELStringTranslator.getString("COLLAXALAF_INSERT_BEFORE"));
        JMenu activityMenu = new JMenu(BPELStringTranslator.getString("ACTIVITIES"));
        BPELStringTranslator.setButton(activityMenu, BPELStringTranslator.getString("ACTIVITIES"));
        this.m_insertBeforeAssignItem = this.installMenuItem("Assign", ImageCache.getIcon("assign_node"), activityMenu);
        this.m_insertBeforeCompensateItem = this.installMenuItem("Compensate", ImageCache.getIcon("compensate_node"), activityMenu);
        this.m_insertBeforeEmptyItem = this.installMenuItem("Empty", ImageCache.getIcon("empty_node"), activityMenu);
        this.m_insertBeforeInvokeItem = this.installMenuItem("Invoke", ImageCache.getIcon("invoke_node"), activityMenu);
        this.m_insertBeforeReceiveItem = this.installMenuItem("Receive", ImageCache.getIcon("receive_node"), activityMenu);
        this.m_insertBeforeReplyItem = this.installMenuItem("Reply", ImageCache.getIcon("reply_node"), activityMenu);
        this.m_insertBeforeTerminateItem = this.installMenuItem("Terminate", ImageCache.getIcon("terminate_node"), activityMenu);
        this.m_insertBeforeThrowItem = this.installMenuItem("Throw", ImageCache.getIcon("throw_node"), activityMenu);
        this.m_insertBeforeTransformItem = this.installMenuItem("Transform", ImageCache.getIcon("assign_node"), activityMenu);
        this.m_insertBeforeWaitItem = this.installMenuItem("Wait", ImageCache.getIcon("wait_node"), activityMenu);
        menu.add(activityMenu);
        JMenu structureMenu = new JMenu(BPELStringTranslator.getString("STRUCT_ACTIVITIES"));
        BPELStringTranslator.setButton(structureMenu, BPELStringTranslator.getString("STRUCT_ACTIVITIES"));
        this.m_insertBeforeFlowItem = this.installMenuItem("Flow", ImageCache.getIcon("flow_node"), structureMenu);
        this.m_insertBeforeFlowNItem = this.installMenuItem("FlowN", ImageCache.getIcon("flow_n_node"), structureMenu);
        this.m_insertBeforePickItem = this.installMenuItem("Pick", ImageCache.getIcon("pick_node"), structureMenu);
        this.m_insertBeforeScopeItem = this.installMenuItem("Scope", ImageCache.getIcon("scope_node"), structureMenu);
        this.m_insertBeforeSequenceItem = this.installMenuItem("Sequence", ImageCache.getIcon("sequence_node"), structureMenu);
        this.m_insertBeforeSwitchItem = this.installMenuItem("Switch", ImageCache.getIcon("switch_node"), structureMenu);
        this.m_insertBeforeWhileItem = this.installMenuItem("While", ImageCache.getIcon("while_node"), structureMenu);
        menu.add(structureMenu);
        return menu;
    }

    protected JMenu createInsertAfterMenu() {
        JMenu menu = new JMenu(BPELStringTranslator.getString("COLLAXALAF_INSERT_AFTER"));
        BPELStringTranslator.setButton(menu, BPELStringTranslator.getString("COLLAXALAF_INSERT_AFTER"));
        JMenu activityMenu = new JMenu(BPELStringTranslator.getString("ACTIVITIES"));
        BPELStringTranslator.setButton(activityMenu, BPELStringTranslator.getString("ACTIVITIES"));
        this.m_insertAfterAssignItem = this.installMenuItem("Assign", ImageCache.getIcon("assign_node"), activityMenu);
        this.m_insertAfterCompensateItem = this.installMenuItem("Compensate", ImageCache.getIcon("compensate_node"), activityMenu);
        this.m_insertAfterEmptyItem = this.installMenuItem("Empty", ImageCache.getIcon("empty_node"), activityMenu);
        this.m_insertAfterInvokeItem = this.installMenuItem("Invoke", ImageCache.getIcon("invoke_node"), activityMenu);
        this.m_insertAfterReceiveItem = this.installMenuItem("Receive", ImageCache.getIcon("receive_node"), activityMenu);
        this.m_insertAfterReplyItem = this.installMenuItem("Reply", ImageCache.getIcon("reply_node"), activityMenu);
        this.m_insertAfterTerminateItem = this.installMenuItem("Terminate", ImageCache.getIcon("terminate_node"), activityMenu);
        this.m_insertAfterThrowItem = this.installMenuItem("Throw", ImageCache.getIcon("throw_node"), activityMenu);
        this.m_insertAfterTransformItem = this.installMenuItem("Transform", ImageCache.getIcon("assign_node"), activityMenu);
        this.m_insertAfterWaitItem = this.installMenuItem("Wait", ImageCache.getIcon("wait_node"), activityMenu);
        menu.add(activityMenu);
        JMenu structureMenu = new JMenu(BPELStringTranslator.getString("STRUCT_ACTIVITIES"));
        BPELStringTranslator.setButton(structureMenu, BPELStringTranslator.getString("STRUCT_ACTIVITIES"));
        this.m_insertAfterFlowItem = this.installMenuItem("Flow", ImageCache.getIcon("flow_node"), structureMenu);
        this.m_insertAfterFlowNItem = this.installMenuItem("FlowN", ImageCache.getIcon("flow_n_node"), structureMenu);
        this.m_insertAfterPickItem = this.installMenuItem("Pick", ImageCache.getIcon("pick_node"), structureMenu);
        this.m_insertAfterScopeItem = this.installMenuItem("Scope", ImageCache.getIcon("scope_node"), structureMenu);
        this.m_insertAfterSequenceItem = this.installMenuItem("Sequence", ImageCache.getIcon("sequence_node"), structureMenu);
        this.m_insertAfterSwitchItem = this.installMenuItem("Switch", ImageCache.getIcon("switch_node"), structureMenu);
        this.m_insertAfterWhileItem = this.installMenuItem("While", ImageCache.getIcon("while_node"), structureMenu);
        menu.add(structureMenu);
        return menu;
    }

    protected JMenu createInsertIntoMenu() {
        JMenu menu = new JMenu(BPELStringTranslator.getString("COLLAXALAF_INSERT_INTO"));
        BPELStringTranslator.setButton(menu, BPELStringTranslator.getString("COLLAXALAF_INSERT_INTO"));
        JMenu activityMenu = new JMenu(BPELStringTranslator.getString("ACTIVITIES"));
        BPELStringTranslator.setButton(activityMenu, BPELStringTranslator.getString("ACTIVITIES"));
        this.m_insertIntoAssignItem = this.installMenuItem("Assign", ImageCache.getIcon("assign_node"), activityMenu);
        this.m_insertIntoCompensateItem = this.installMenuItem("Compensate", ImageCache.getIcon("compensate_node"), activityMenu);
        this.m_insertIntoEmptyItem = this.installMenuItem("Empty", ImageCache.getIcon("empty_node"), activityMenu);
        this.m_insertIntoInvokeItem = this.installMenuItem("Invoke", ImageCache.getIcon("invoke_node"), activityMenu);
        this.m_insertIntoReceiveItem = this.installMenuItem("Receive", ImageCache.getIcon("receive_node"), activityMenu);
        this.m_insertIntoReplyItem = this.installMenuItem("Reply", ImageCache.getIcon("reply_node"), activityMenu);
        this.m_insertIntoTerminateItem = this.installMenuItem("Terminate", ImageCache.getIcon("terminate_node"), activityMenu);
        this.m_insertIntoThrowItem = this.installMenuItem("Throw", ImageCache.getIcon("throw_node"), activityMenu);
        this.m_insertIntoTransformItem = this.installMenuItem("Transform", ImageCache.getIcon("assign_node"), activityMenu);
        this.m_insertIntoWaitItem = this.installMenuItem("Wait", ImageCache.getIcon("wait_node"), activityMenu);
        menu.add(activityMenu);
        JMenu structureMenu = new JMenu(BPELStringTranslator.getString("STRUCT_ACTIVITIES"));
        BPELStringTranslator.setButton(structureMenu, BPELStringTranslator.getString("STRUCT_ACTIVITIES"));
        this.m_insertIntoFlowItem = this.installMenuItem("Flow", ImageCache.getIcon("flow_node"), structureMenu);
        this.m_insertIntoFlowNItem = this.installMenuItem("FlowN", ImageCache.getIcon("flow_n_node"), structureMenu);
        this.m_insertIntoPickItem = this.installMenuItem("Pick", ImageCache.getIcon("pick_node"), structureMenu);
        this.m_insertIntoScopeItem = this.installMenuItem("Scope", ImageCache.getIcon("scope_node"), structureMenu);
        this.m_insertIntoSequenceItem = this.installMenuItem("Sequence", ImageCache.getIcon("sequence_node"), structureMenu);
        this.m_insertIntoSwitchItem = this.installMenuItem("Switch", ImageCache.getIcon("switch_node"), structureMenu);
        this.m_insertIntoWhileItem = this.installMenuItem("While", ImageCache.getIcon("while_node"), structureMenu);
        menu.add(structureMenu);
        return menu;
    }

    public void showSearchPanel() {
        this.m_bShowSearchPanel = true;
        this.layoutControls();
        this.invalidate();
        this.validate();
        this.m_searchPnl.m_cardPnl.show("QUERY_PANEL");
        this.m_searchPnl.m_textCombo.requestFocus();
    }

    public void hideSearchPanel() {
        this.m_bShowSearchPanel = false;
        this.layoutControls();
        this.invalidate();
        this.validate();
    }

    protected void layoutControls() {
        this.removeAll();
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)this.m_leftToolBar, (int)0, (int)0, (int)1, (int)1, (int)16, (int)0, (Insets)new Insets(2, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_rightToolBar, (int)1, (int)0, (int)1, (int)1, (int)14, (int)0, (Insets)new Insets(2, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_cardPnl, (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_showDetailsCB, (int)0, (int)2, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        if (this.m_bShowSearchPanel) {
            JSplitPane splitter = UIHelper.getJSplitPane((int)0, (boolean)true);
            splitter.setBorder(null);
            splitter.setTopComponent(p);
            splitter.setBottomComponent(GraphUtils.getScrollPane((Component)this.m_searchPnl));
            splitter.setDividerLocation(250);
            this.m_containerCardPnl.add(SHOW_EXPLORER_TREE, (Component)splitter);
        } else {
            this.m_containerCardPnl.add(SHOW_EXPLORER_TREE, (Component)p);
        }
        JPanel p2 = new JPanel();
        p2.add(new JLabel("No Data Available!"));
        this.m_containerCardPnl.add(HIDE_EXPLORER_TREE, (Component)p2);
        this.m_containerCardPnl.show(SHOW_EXPLORER_TREE);
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_containerCardPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    public void registerPopupMenuInvoker() {
        ActionMap actionMap;
        DraggableJTree component = this.m_tree;
        InputMap inputMap = SwingUtilities.getUIInputMap((JComponent)component, 0);
        if (inputMap == null) {
            inputMap = new ComponentInputMap((JComponent)component);
            SwingUtilities.replaceUIInputMap((JComponent)component, 0, inputMap);
        }
        if ((actionMap = SwingUtilities.getUIActionMap((JComponent)component)) == null) {
            actionMap = new ActionMapUIResource();
            SwingUtilities.replaceUIActionMap((JComponent)component, actionMap);
        }
        inputMap.put(KeyStroke.getKeyStroke(121, 1), "invoke.popupMenu");
        actionMap.put("invoke.popupMenu", new PopupTriggerAction());
    }

    private void addToPopup(JMenuItem menu) {
        if (menu == this.m_createMenuItem || menu == this.m_editMenuItem || menu == this.m_removeMenuItem || menu == this.m_addMenuItem) {
            if (this.getAllowEditing()) {
                this.m_popup.add(menu);
            }
        } else {
            this.m_popup.add(menu);
        }
    }

    protected void handlePopupTrigger(MouseEvent evt) {
        this.m_editMenuItem.setEnabled(false);
        this.m_removeMenuItem.setEnabled(false);
        this.m_insertBeforeMenu.setEnabled(false);
        this.m_insertAfterMenu.setEnabled(false);
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof DefaultMutableTreeNode)) {
            return;
        }
        this.m_popup.removeAll();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
        ExplorerTreeNode n = (ExplorerTreeNode)treeNode.getUserObject();
        String s = this.getNameForID(n.m_type);
        if (Helper.hasValue((String)s)) {
            s = " " + s;
        }
        switch (n.m_type) {
            case 37: {
                this.m_createMenuItem.setEnabled(true);
                this.m_createMenuItem.setText(BPELStringTranslator.getString("CREATE_BUTTON_TEXT") + " Operation" + "...");
                BPELStringTranslator.setButton(this.m_createMenuItem, BPELStringTranslator.getString("CREATE_BUTTON_TEXT") + " Operation" + "...");
                this.addToPopup(this.m_createMenuItem);
                break;
            }
            case 12: {
                this.m_addMenuItem.setEnabled(true);
                this.m_addMenuItem.setText(BPELStringTranslator.getString("EDIT_IMPORT") + " Schema" + "...");
                BPELStringTranslator.setButton(this.m_addMenuItem, BPELStringTranslator.getString("EDIT_IMPORT") + " Schema" + "...");
                this.addToPopup(this.m_addMenuItem);
                break;
            }
            case 3: 
            case 9: 
            case 13: {
                DefaultMutableTreeNode parentTreeNode = (DefaultMutableTreeNode)treeNode.getParent();
                ExplorerTreeNode parentNode = (ExplorerTreeNode)parentTreeNode.getUserObject();
                Object parentData = parentNode.m_data;
                if (!(parentData instanceof Scope)) break;
                Scope scope = (Scope)parentData;
                this.m_createMenuItem.setEnabled(scope.isEditable());
                this.m_createMenuItem.setText(BPELStringTranslator.getString("CREATE_BUTTON_TEXT") + s + "...");
                this.addToPopup(this.m_createMenuItem);
                break;
            }
            case 17: 
            case 18: 
            case 26: {
                this.m_createMenuItem.setEnabled(true);
                this.m_createMenuItem.setText(BPELStringTranslator.getString("CREATE_BUTTON_TEXT") + s + "...");
                this.addToPopup(this.m_createMenuItem);
                break;
            }
            case 20: {
                this.m_removeMenuItem.setEnabled(true);
                this.m_removeMenuItem.setText(BPELStringTranslator.getString("DEL_BUTTON_TEXT") + s);
                this.addToPopup(this.m_removeMenuItem);
                break;
            }
            case 15: {
                this.m_editMenuItem.setEnabled(true);
                this.m_editMenuItem.setText(BPELStringTranslator.getString("EDIT_BUTTON_TEXT") + s + "...");
                this.addToPopup(this.m_editMenuItem);
                this.m_removeMenuItem.setEnabled(true);
                this.m_removeMenuItem.setText(BPELStringTranslator.getString("DEL_BUTTON_TEXT") + s);
                this.addToPopup(this.m_removeMenuItem);
                break;
            }
            case 16: 
            case 33: {
                this.m_insertBeforeMenu.setEnabled(true);
                this.m_insertAfterMenu.setEnabled(true);
                ActivityInfo info = (ActivityInfo)n.m_data;
                this.m_activity = info.getActivity();
                if (this.m_activity == null) break;
                this.createPopUpMenuForActivity(this.m_activity, s);
                break;
            }
            case 30: {
                this.m_insertBeforeMenu.setEnabled(true);
                this.m_insertAfterMenu.setEnabled(true);
                FaultHandlers faultHandlers = (FaultHandlers)n.m_data;
                if (faultHandlers == null) break;
                this.addToPopup(this.m_addCatchBranchMenuItem);
                this.insertSeparatorIfNeeded(this.m_popup);
                break;
            }
            case 31: {
                this.addToPopup(this.m_exceptionToClipboardItem);
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                Variable var = (Variable)n.getUserData();
                boolean bEditable = var.isEditable();
                this.m_editMenuItem.setText(BPELStringTranslator.getString("EDIT_BUTTON_TEXT") + s + "...");
                this.m_editMenuItem.setEnabled(bEditable);
                this.addToPopup(this.m_editMenuItem);
                this.m_removeMenuItem.setText(BPELStringTranslator.getString("DEL_BUTTON_TEXT") + s);
                this.m_removeMenuItem.setEnabled(bEditable);
                this.addToPopup(this.m_removeMenuItem);
                break;
            }
            case 11: {
                CorrelationSet set = (CorrelationSet)n.getUserData();
                boolean bEditable = set.isEditable();
                this.m_editMenuItem.setText(BPELStringTranslator.getString("EDIT_BUTTON_TEXT") + s + "...");
                this.m_editMenuItem.setEnabled(bEditable);
                this.addToPopup(this.m_editMenuItem);
                this.m_removeMenuItem.setText(BPELStringTranslator.getString("DEL_BUTTON_TEXT") + s);
                this.m_removeMenuItem.setEnabled(bEditable);
                this.addToPopup(this.m_removeMenuItem);
                break;
            }
            case 14: {
                PartnerLink link = (PartnerLink)n.getUserData();
                boolean bEditable = link.isEditable();
                this.m_editMenuItem.setText(BPELStringTranslator.getString("EDIT_BUTTON_TEXT") + s + "...");
                this.m_editMenuItem.setEnabled(bEditable);
                this.addToPopup(this.m_editMenuItem);
                this.m_removeMenuItem.setText(BPELStringTranslator.getString("DEL_BUTTON_TEXT") + s);
                this.m_removeMenuItem.setEnabled(bEditable);
                this.addToPopup(this.m_removeMenuItem);
                break;
            }
            case 2: 
            case 8: 
            case 19: {
                this.m_editMenuItem.setEnabled(true);
                this.m_editMenuItem.setText(BPELStringTranslator.getString("EDIT_BUTTON_TEXT") + s + "...");
                this.addToPopup(this.m_editMenuItem);
                this.m_removeMenuItem.setEnabled(true);
                this.m_removeMenuItem.setText(BPELStringTranslator.getString("DEL_BUTTON_TEXT") + s);
                this.addToPopup(this.m_removeMenuItem);
                break;
            }
            case 23: {
                this.m_editMenuItem.setEnabled(true);
                this.m_editMenuItem.setText(BPELStringTranslator.getString("EDIT_BUTTON_TEXT") + s + "...");
                this.addToPopup(this.m_editMenuItem);
                break;
            }
            case 38: {
                this.m_editMenuItem.setEnabled(true);
                this.m_editMenuItem.setText(BPELStringTranslator.getString("EDIT_BUTTON_TEXT") + s + "...");
                this.addToPopup(this.m_editMenuItem);
                this.m_removeMenuItem.setEnabled(true);
                this.m_removeMenuItem.setText(BPELStringTranslator.getString("DEL_BUTTON_TEXT") + s);
                this.addToPopup(this.m_removeMenuItem);
            }
        }
        if (this.isStructurePane() && (n.m_type == 16 || n.m_type == 33)) {
            Activity a;
            Activity activity;
            ArrayList<JMenu> menusToAdd = new ArrayList<JMenu>();
            if (this.canInsertInto(n)) {
                menusToAdd.add(this.m_insertIntoMenu);
            }
            ActivityInfo info = (ActivityInfo)n.m_data;
            if (this.canInsertBeforeAfter(n) && !((activity = (a = info.getActivity()).getParentActivity()) instanceof Process)) {
                boolean bEditable = activity != null && activity.isEditable();
                this.m_insertBeforeMenu.setEnabled(bEditable);
                this.m_insertAfterMenu.setEnabled(bEditable);
                menusToAdd.add(this.m_insertBeforeMenu);
                menusToAdd.add(this.m_insertAfterMenu);
            }
            if (menusToAdd.size() > 0) {
                this.insertSeparatorIfNeeded(this.m_popup);
                for (Component component : menusToAdd) {
                    this.m_popup.add(component);
                }
            }
        }
        this.m_popup.add(this.m_detailsItem);
        if (!treeNode.isLeaf()) {
            this.insertSeparatorIfNeeded(this.m_popup);
            this.m_popup.add(this.m_expandChildrenMenuItem);
        }
        this.insertSeparatorIfNeeded(this.m_popup);
        this.m_popup.add(this.m_searchItem);
        this.insertSeparatorIfNeeded(this.m_popup);
        this.setParentNodeRefreshMenu(treeNode);
        this.m_popup.add(this.m_refreshMenuItem);
        if (this.m_popup.getComponentCount() > 0) {
            this.m_popup.show((Component)this.m_tree, evt.getX(), evt.getY());
        }
    }

    protected void createPopUpMenuForActivity(Activity activity, String s) {
        s = " " + BPELParser.getActivityTypeName((Activity)activity);
        this.m_editMenuItem.setText(BPELStringTranslator.getString("EDIT_BUTTON_TEXT") + s + "...");
        if (activity instanceof Scope) {
            this.m_addCatchBranchMenuItem.setEnabled(activity.isEditable());
            this.m_popup.add(this.m_addCatchBranchMenuItem);
            this.insertSeparatorIfNeeded(this.m_popup);
        } else if (activity instanceof Catch) {
            this.m_removeMenuItem.setEnabled(activity.isEditable());
            this.m_removeMenuItem.setText(BPELStringTranslator.getString("EDITOR_EXP_MENU_DEL_CATCH"));
            this.m_popup.add(this.m_removeMenuItem);
            this.insertSeparatorIfNeeded(this.m_popup);
        }
        this.m_editMenuItem.setEnabled(activity.isEditable());
        this.m_popup.add(this.m_editMenuItem);
    }

    private void insertSeparatorIfNeeded(JPopupMenu popup) {
        Component c;
        if (popup.getComponentCount() > 0 && !((c = popup.getComponent(popup.getComponentCount() - 1)) instanceof JSeparator)) {
            popup.addSeparator();
        }
    }

    private boolean canInsertBeforeAfter(ExplorerTreeNode n) {
        ActivityInfo info = (ActivityInfo)n.m_data;
        Activity a = info.getActivity();
        return !(a instanceof Process) && !(a instanceof CatchAll) && !(a instanceof Catch) && !(a instanceof SwitchCase) && !(a instanceof SwitchOtherwise) && !(a instanceof OnAlarm) && !(a instanceof OnMessage);
    }

    private boolean canInsertInto(ExplorerTreeNode n) {
        ActivityInfo info = (ActivityInfo)n.m_data;
        Activity a = info.getActivity();
        if (a instanceof ContainerActivity) {
            ContainerActivity c = (ContainerActivity)a;
            return c.getActivityList().size() == 0;
        }
        return false;
    }

    private String getNameForID(int id) {
        switch (id) {
            case 16: {
                return BPELStringTranslator.getString("ACTIVITY");
            }
            case 12: {
                return BPELStringTranslator.getString("SCHEMA_KEY_DELETE");
            }
            case 15: {
                return BPELStringTranslator.getString("SCHEMA_KEY_DELETE");
            }
            case 13: 
            case 14: {
                return BPELStringTranslator.getString("PARTNER_LINK");
            }
            case 17: 
            case 19: {
                return BPELStringTranslator.getString("PROPERTY_KEY_DELETE");
            }
            case 18: 
            case 20: {
                return BPELStringTranslator.getString("EDITOR_PTY_ALS_DLG");
            }
            case 1: 
            case 2: 
            case 26: {
                return BPELStringTranslator.getString("MESSAGE_TYPE");
            }
            case 9: 
            case 11: {
                return BPELStringTranslator.getString("EDITOR_COR_SET_DLG");
            }
            case 3: 
            case 4: {
                return BPELStringTranslator.getString("VARIABLE_KEY_DELETE");
            }
            case 8: 
            case 27: {
                return BPELStringTranslator.getString("EDITOR_MSG_PART_DLG");
            }
            case 23: {
                return BPELStringTranslator.getString("WSDL_FILE");
            }
            case 38: {
                return BPELStringTranslator.getString("XXOPERATION");
            }
        }
        return "";
    }

    protected DefaultMutableTreeNode buildPropertyAliasesNode() {
        List<CorrelationPropertyAlias> lst;
        this.m_propertyAliasesNode.removeAllChildren();
        try {
            BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
            lst = mainModel.getPropertyModel().getPropertyAliases();
        }
        catch (Exception e) {
            return this.m_propertyAliasesNode;
        }
        for (CorrelationPropertyAlias alias : lst) {
            this.m_propertyAliasesNode.add(this.buildPropertyAliasNode(alias));
        }
        return this.m_propertyAliasesNode;
    }

    protected DefaultMutableTreeNode buildPropertyAliasNode(CorrelationPropertyAlias alias) {
        ExplorerTreeNode userObj = new ExplorerTreeNode(BPELStringTranslator.getString("EDITOR_PTY_ALS_DLG"), 20, (Object)alias);
        userObj.storeData((Object)"EXPANDED", (Object)Boolean.FALSE);
        return new DefaultMutableTreeNode(userObj);
    }

    protected DefaultMutableTreeNode buildPropertiesNode() {
        this.m_propertiesNode.removeAllChildren();
        try {
            BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
            List<Object> lst = mainModel.getPropertyModel().getProperties();
            for (Object o : lst) {
                CorrelationSetProperty prop = (CorrelationSetProperty)o;
                ExplorerTreeNode userObj = new ExplorerTreeNode(prop.getName(), 19, (Object)prop);
                DefaultMutableTreeNode propNode = new DefaultMutableTreeNode(userObj);
                this.m_propertiesNode.add(propNode);
            }
        }
        catch (Exception e) {
            UIHelper.displayErrorMessage((Component)UIHelper.getFrame((Component)this), (String)(BPELStringTranslator.getString("ERROR_READ_CORR_PROP") + "\n" + e.getMessage()));
        }
        return this.m_propertiesNode;
    }

    protected DefaultMutableTreeNode buildPartnerLinkNodes(Activity a) {
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        this.m_partnerLinksNode.removeAllChildren();
        ExplorerTreeNode userObj = new ExplorerTreeNode(BPELStringTranslator.getString("PROCESS"), 5, (Object)p);
        DefaultMutableTreeNode processNode = new DefaultMutableTreeNode(userObj);
        this.m_partnerLinksNode.add(processNode);
        DefaultMutableTreeNode partnerLinksNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("EDITOR_EXP_PL", "Partner Links"), 13, (Object)p));
        processNode.add(partnerLinksNode);
        PartnerLinks plinks = p.getPartnerLinks();
        if (plinks != null) {
            this.populatePartnerLinksNode(partnerLinksNode, plinks.getPartnerLinks());
        }
        if (a != null) {
            List parentScopes = BPELModelUtil.findAllParentScopes((Activity)a);
            if (a instanceof Scope) {
                parentScopes.add(0, (Scope)a);
            }
            DefaultMutableTreeNode currParent = processNode;
            for (int i = parentScopes.size() - 1; i >= 0; --i) {
                Scope s = (Scope)parentScopes.get(i);
                if (s instanceof Process) continue;
                String txt = "Scope";
                if (s.getName() != null) {
                    txt = txt + " - " + s.getName();
                }
                DefaultMutableTreeNode scopeNode = new DefaultMutableTreeNode(new ExplorerTreeNode(txt, 6, (Object)s));
                DefaultMutableTreeNode scopeSetsNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("COLLAXALAF_PARTNER_LINKS"), 13, (Object)s));
                scopeNode.add(scopeSetsNode);
                PartnerLinks scopeSets = s.getPartnerLinks();
                if (scopeSets != null) {
                    this.populatePartnerLinksNode(scopeSetsNode, scopeSets.getPartnerLinks());
                }
                currParent.add(scopeNode);
                currParent = scopeNode;
            }
        } else {
            this.buildScopeTree(processNode, (Activity)p, false, false, true);
        }
        return this.m_partnerLinksNode;
    }

    protected DefaultMutableTreeNode buildActivityNodes() {
        this.m_activitiesNode.removeAllChildren();
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        ActivityInfo info = new ActivityInfo((Activity)p);
        ExplorerTreeNode explorerNode = new ExplorerTreeNode(BPELStringTranslator.getString("PROCESS"), 16, (Object)info);
        explorerNode.setWarning(info.getWarning());
        DefaultMutableTreeNode processNode = new DefaultMutableTreeNode(explorerNode);
        this.populateChildActivitiesNode(processNode, (ContainerActivity)p);
        this.m_activitiesNode.add(processNode);
        return this.m_activitiesNode;
    }

    protected void populateEventHandlers(DefaultMutableTreeNode parent, EventHandlers eventHandlers) {
        ActivityInfo info;
        if (eventHandlers == null || parent == null) {
            return;
        }
        DefaultMutableTreeNode eventHandlersNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("EVENT_HANDLERS"), 32, (Object)eventHandlers));
        parent.add(eventHandlersNode);
        for (OnAlarm o : eventHandlers.getOnAlarms()) {
            info = new ActivityInfo((Activity)o);
            DefaultMutableTreeNode onAlarmNode = new DefaultMutableTreeNode(new ExplorerTreeNode("OnAlarm", 16, (Object)info));
            eventHandlersNode.add(onAlarmNode);
            this.populateChildActivitiesNode(onAlarmNode, (ContainerActivity)o);
        }
        for (OnAlarm o : eventHandlers.getOnMessages()) {
            info = new ActivityInfo((Activity)o);
            DefaultMutableTreeNode onMessageNode = new DefaultMutableTreeNode(new ExplorerTreeNode("Onmessage", 16, (Object)info));
            eventHandlersNode.add(onMessageNode);
            this.populateChildActivitiesNode(onMessageNode, (ContainerActivity)o);
        }
    }

    protected void populateCompensationHandler(DefaultMutableTreeNode parent, CompensationHandler compHandler) {
        if (compHandler == null || parent == null) {
            return;
        }
        ActivityInfo info = new ActivityInfo((Activity)compHandler);
        DefaultMutableTreeNode compHandlerNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("COMPENSATION_HANDLER"), 33, (Object)info));
        parent.add(compHandlerNode);
        this.populateChildActivitiesNode(compHandlerNode, (ContainerActivity)compHandler);
    }

    protected void populateFaultHandlers(DefaultMutableTreeNode parent, FaultHandlers faultHandlers) {
        CatchAll catchAll;
        if (faultHandlers == null || parent == null) {
            return;
        }
        DefaultMutableTreeNode faultHandlersNode = null;
        List catches = faultHandlers.getCatches();
        if (catches != null) {
            faultHandlersNode = new DefaultMutableTreeNode(new ExplorerTreeNode("FaultHandlers", 30, (Object)faultHandlers));
            parent.add(faultHandlersNode);
            for (Catch o : catches) {
                ActivityInfo info = new ActivityInfo((Activity)o);
                DefaultMutableTreeNode catchNode = new DefaultMutableTreeNode(new ExplorerTreeNode("Catch", 16, (Object)info));
                faultHandlersNode.add(catchNode);
                this.populateChildActivitiesNode(catchNode, (ContainerActivity)o);
            }
        }
        if ((catchAll = faultHandlers.getCatchAll()) != null) {
            if (faultHandlersNode == null) {
                faultHandlersNode = new DefaultMutableTreeNode(new ExplorerTreeNode("FaultHandlers", 7, (Object)faultHandlers));
                parent.add(faultHandlersNode);
            }
            ActivityInfo info = new ActivityInfo((Activity)catchAll);
            DefaultMutableTreeNode catchAllNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("CATCH_ALL"), 16, (Object)info));
            faultHandlersNode.add(catchAllNode);
            this.populateChildActivitiesNode(catchAllNode, (ContainerActivity)catchAll);
        }
    }

    protected void populateChildActivitiesNode(DefaultMutableTreeNode parent, ContainerActivity parentActivity) {
        List activitiesLst = parentActivity.getActivityList();
        if (activitiesLst == null) {
            return;
        }
        for (Activity a : activitiesLst) {
            String txt = BPELModelUtil.getTypeForActivity((Activity)a);
            if (a.getName() != null) {
                txt = txt + " - " + a.getName();
            }
            ActivityInfo info = new ActivityInfo(a);
            ExplorerTreeNode explorerNode = new ExplorerTreeNode(txt, 16, (Object)info);
            explorerNode.setWarning(info.getWarning());
            DefaultMutableTreeNode activityNode = new DefaultMutableTreeNode(explorerNode);
            if (a instanceof ContainerActivity) {
                ContainerActivity c = (ContainerActivity)a;
                this.populateChildActivitiesNode(activityNode, c);
            }
            parent.add(activityNode);
        }
        if (parentActivity instanceof Scope) {
            Scope s = (Scope)parentActivity;
            this.populateFaultHandlers(parent, s.getFaultHandlers());
            this.populateCompensationHandler(parent, s.getCompensationHandler());
            this.populateEventHandlers(parent, s.getEventHandlers());
        }
    }

    protected void buildSchemasNodes() {
        this.m_projectSchemasNode.removeAllChildren();
        BPELProject prj = this.m_graph.getBPELProject();
        List schemaURLS = prj.getProjectSchemaFiles();
        for (URL url : schemaURLS) {
            String s = Helper.getFileName((URL)url);
            ProjectSchemaExplorerTreeNode elementDataSource = new ProjectSchemaExplorerTreeNode(s, 15, url, true, true);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode((Object)elementDataSource);
            node.add((MutableTreeNode)new DummyNode());
            this.m_projectSchemasNode.add(node);
        }
    }

    protected DefaultMutableTreeNode buildMessageTypeNodes() {
        this.m_messageTypeNodes.removeAllChildren();
        BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
        BPELProject bpelProject = mainModel.getBPELProject();
        String processName = bpelProject.getProcessName();
        URL processWSDLURL = bpelProject.getWSDLFileURL(processName);
        ExplorerTreeNode userObj = null;
        WSDLMessageComparator comparator = new WSDLMessageComparator();
        if (!BPELProjectUtil.isEmptyBPELProcess((BPELProject)bpelProject)) {
            userObj = new ExplorerTreeNode(BPELStringTranslator.getString("PROCESS_WSDL_FILES"), 26, (Object)processWSDLURL);
            DefaultMutableTreeNode processWSDLNode = new DefaultMutableTreeNode(userObj);
            this.m_messageTypeNodes.add(processWSDLNode);
            try {
                WSDLMessage[] msg = mainModel.getWSDLModel().getMessages();
                if (msg != null) {
                    Arrays.sort(msg, comparator);
                    for (WSDLMessage wsdlMessage : msg) {
                        MessageType messageType = ConversionUtil.createMessageType((WSDLMessage)wsdlMessage);
                        processWSDLNode.add(this.buildMessageTypeNode(messageType, true));
                    }
                }
            }
            catch (Exception e) {
                ExplorerTreeNode n = new ExplorerTreeNode("Error retrieving messages!", 31, (Object)e);
                processWSDLNode.add(new DefaultMutableTreeNode(n));
            }
        }
        userObj = new ExplorerTreeNode(BPELStringTranslator.getString("PROJ_WSDL_FILES"), 7, null);
        DefaultMutableTreeNode projectWSDLNode = new DefaultMutableTreeNode(userObj);
        this.m_messageTypeNodes.add(projectWSDLNode);
        for (URL u : bpelProject.getProjectWSDLFiles()) {
            if (processWSDLURL.equals(u)) continue;
            userObj = new ExplorerTreeNode(Helper.getFileName((URL)u), 23, (Object)u);
            DefaultMutableTreeNode wsdlNode = new DefaultMutableTreeNode(userObj);
            projectWSDLNode.add(wsdlNode);
            try {
                WSDLMessage[] messages = WSDLUtil.getMessages((URL)u);
                Arrays.sort(messages, comparator);
                for (WSDLMessage message : messages) {
                    wsdlNode.add(this.buildMessageTypeNode(ConversionUtil.createMessageType((WSDLMessage)message), false));
                }
            }
            catch (Exception e) {
                ExplorerTreeNode n = new ExplorerTreeNode("Error retrieving messages!", 31, (Object)e);
                wsdlNode.add(new DefaultMutableTreeNode(n));
            }
        }
        return this.m_messageTypeNodes;
    }

    private DefaultMutableTreeNode buildMessageTypeNode(MessageType t, boolean bEditable) {
        int type = bEditable ? 2 : 24;
        DefaultMutableTreeNode messageNode = new DefaultMutableTreeNode(new ExplorerTreeNode(t.getName(), type, (Object)t));
        List parts = t.getParts();
        for (MessagePart part : parts) {
            type = bEditable ? 8 : 25;
            DefaultMutableTreeNode messagePartNode = new DefaultMutableTreeNode(new ExplorerTreeNode(part.getName(), type, (Object)part));
            messageNode.add(messagePartNode);
        }
        return messageNode;
    }

    protected void buildParentScopeNodes(Activity a) {
        this.m_scopesNode.removeAllChildren();
        DefaultMutableTreeNode currParent = this.m_scopesNode;
        List parentScopes = BPELModelUtil.findAllParentScopes((Activity)a);
        for (int i = parentScopes.size() - 1; i >= 0; --i) {
            Scope s = (Scope)parentScopes.get(i);
            String txt = "Scope";
            if (s.getName() != null) {
                txt = txt + " - " + s.getName();
            }
            DefaultMutableTreeNode scopeNode = new DefaultMutableTreeNode(new ExplorerTreeNode(txt, 6, (Object)s));
            currParent.add(scopeNode);
            currParent = scopeNode;
        }
    }

    protected DefaultMutableTreeNode buildCorrelationSetsNodes(Activity a) {
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process process = graphModel.getProcess();
        this.m_correlationsNode.removeAllChildren();
        ExplorerTreeNode userObj = new ExplorerTreeNode(BPELStringTranslator.getString("PROCESS"), 5, (Object)process);
        DefaultMutableTreeNode processNode = new DefaultMutableTreeNode(userObj);
        this.m_correlationsNode.add(processNode);
        DefaultMutableTreeNode processSetsNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("COLLAXALAF_CORR_SETS"), 9, (Object)process));
        processNode.add(processSetsNode);
        CorrelationSets sets = process.getCorrelationSets();
        if (sets != null) {
            this.populateCorrelationSets(processSetsNode, sets.getCorrelationSets());
        }
        if (a != null) {
            List parentScopes = BPELModelUtil.findAllParentScopes((Activity)a);
            if (a instanceof Scope) {
                parentScopes.add(0, (Scope)a);
            }
            DefaultMutableTreeNode currParent = processNode;
            for (int i = parentScopes.size() - 1; i >= 0; --i) {
                Scope s = (Scope)parentScopes.get(i);
                String txt = "Scope";
                if (s.getName() != null) {
                    txt = txt + " - " + s.getName();
                }
                DefaultMutableTreeNode scopeNode = new DefaultMutableTreeNode(new ExplorerTreeNode(txt, 6, (Object)s));
                DefaultMutableTreeNode scopeSetsNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("COLLAXALAF_CORR_SETS"), 9, (Object)s));
                scopeNode.add(scopeSetsNode);
                CorrelationSets scopeSets = s.getCorrelationSets();
                if (scopeSets != null) {
                    this.populateCorrelationSets(scopeSetsNode, scopeSets.getCorrelationSets());
                }
                currParent.add(scopeNode);
                currParent = scopeNode;
            }
        } else {
            this.buildScopeTree(processNode, (Activity)process, false, true, false);
        }
        return this.m_correlationsNode;
    }

    protected void populatePartnerLinksNode(DefaultMutableTreeNode partnerLinksNode, List<PartnerLink> links) {
        if (links == null) {
            return;
        }
        for (PartnerLink link : links) {
            partnerLinksNode.add(this.buildPartnerLinkNode(link));
        }
    }

    protected DefaultMutableTreeNode buildPartnerLinkNode(PartnerLink pl) {
        PLExplorerTreeNode userObj = new PLExplorerTreeNode(pl.getName(), 14, pl);
        userObj.setGraph(this.m_graph);
        userObj.setPartnerLink(pl);
        DefaultMutableTreeNode n = new DefaultMutableTreeNode((Object)userObj);
        n.add((MutableTreeNode)new DummyNode());
        return n;
    }

    protected void populateCorrelationSets(DefaultMutableTreeNode parentNode, List<CorrelationSet> sets) {
        if (sets == null) {
            return;
        }
        for (CorrelationSet cs : sets) {
            ExplorerTreeNode userObj = new ExplorerTreeNode(cs.getName(), 11, (Object)cs);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(userObj);
            parentNode.add(childNode);
        }
    }

    protected DefaultMutableTreeNode buildVariablesNodes(Activity a) {
        if (this.m_bShowVariablesFlatMode) {
            return this.buildFlatVariablesNodes(a);
        }
        return this.buildScopeVariablesNodes(a);
    }

    protected DefaultMutableTreeNode buildFlatVariablesNodes(Activity a) {
        this.m_variablesNode.removeAllChildren();
        ArrayList varsLst = new ArrayList();
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        List scopes = a != null ? BPELModelUtil.findAllParentScopes((Activity)a) : BPELModelUtil.getAllScopeActivities((Process)p);
        for (Scope scope : scopes) {
            Variables vars = scope.getVariables();
            if (vars == null) continue;
            varsLst.addAll(vars.getVariables());
        }
        if (varsLst.size() > 0) {
            this.populateVariables((Activity)p, this.m_variablesNode, varsLst);
        }
        return this.m_variablesNode;
    }

    protected DefaultMutableTreeNode buildScopeVariablesNodes(Activity a) {
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process process = graphModel.getProcess();
        this.m_variablesNode.removeAllChildren();
        ExplorerTreeNode userObj = new ExplorerTreeNode(BPELStringTranslator.getString("PROCESS"), 5, (Object)process);
        DefaultMutableTreeNode processNode = new DefaultMutableTreeNode(userObj);
        DefaultMutableTreeNode varsContainerNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("COLLAXALAF_VARIABLES"), 3, (Object)process));
        processNode.add(varsContainerNode);
        Variables vars = process.getVariables();
        if (vars != null) {
            this.populateVariables((Activity)process, varsContainerNode, vars.getVariables());
        }
        this.m_variablesNode.add(processNode);
        if (a != null) {
            List parentScopes = BPELModelUtil.findAllParentScopes((Activity)a);
            if (a instanceof Scope) {
                parentScopes.add(0, (Scope)a);
            }
            DefaultMutableTreeNode currParent = processNode;
            for (int i = parentScopes.size() - 1; i >= 0; --i) {
                Scope s = (Scope)parentScopes.get(i);
                if (s instanceof Process) continue;
                String txt = "Scope";
                if (s.getName() != null) {
                    txt = txt + " - " + s.getName();
                }
                DefaultMutableTreeNode scopeNode = new DefaultMutableTreeNode(new ExplorerTreeNode(txt, 6, (Object)s));
                varsContainerNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("COLLAXALAF_VARIABLES"), 3, (Object)s));
                scopeNode.add(varsContainerNode);
                Variables scopeVars = s.getVariables();
                if (scopeVars != null) {
                    this.populateVariables((Activity)s, varsContainerNode, scopeVars.getVariables());
                }
                currParent.add(scopeNode);
                currParent = scopeNode;
            }
        } else {
            this.buildScopeTree(processNode, (Activity)process, true, false, false);
        }
        return this.m_variablesNode;
    }

    protected void buildScopeTree(DefaultMutableTreeNode treeNode, Activity a, boolean bShowVariables, boolean bShowCorrelations, boolean bShowPartnerLinks) {
        if (a instanceof ContainerActivity) {
            ContainerActivity c = (ContainerActivity)a;
            Iterator it = c.getActivities();
            while (it.hasNext()) {
                Activity childActivity = (Activity)it.next();
                if (childActivity instanceof Scope) {
                    DefaultMutableTreeNode setsNode;
                    Scope s = (Scope)childActivity;
                    DefaultMutableTreeNode scopeNode = new DefaultMutableTreeNode(new ExplorerTreeNode("Scope - " + childActivity.getName(), 6, (Object)s));
                    treeNode.add(scopeNode);
                    if (bShowVariables) {
                        DefaultMutableTreeNode varsNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("COLLAXALAF_VARIABLES"), 3, (Object)s));
                        scopeNode.add(varsNode);
                        Variables v = s.getVariables();
                        if (v != null) {
                            this.populateVariables(childActivity, varsNode, v.getVariables());
                        }
                    }
                    if (bShowCorrelations) {
                        setsNode = new DefaultMutableTreeNode(new ExplorerTreeNode(BPELStringTranslator.getString("EDITOR_EXP_CR_SETS"), 9, (Object)s));
                        scopeNode.add(setsNode);
                        CorrelationSets sets = s.getCorrelationSets();
                        if (sets != null) {
                            this.populateCorrelationSets(setsNode, sets.getCorrelationSets());
                        }
                    }
                    if (bShowPartnerLinks) {
                        setsNode = new DefaultMutableTreeNode(new ExplorerTreeNode("PartnerLinks", 13, (Object)s));
                        scopeNode.add(setsNode);
                        PartnerLinks pls = s.getPartnerLinks();
                        if (pls != null) {
                            this.populatePartnerLinksNode(setsNode, pls.getPartnerLinks());
                        }
                    }
                    this.buildScopeTree(scopeNode, childActivity, bShowVariables, bShowCorrelations, bShowPartnerLinks);
                    continue;
                }
                this.buildScopeTree(treeNode, childActivity, bShowVariables, bShowCorrelations, bShowPartnerLinks);
            }
        }
    }

    protected void populateVariables(Activity a, DefaultMutableTreeNode parentNode, List vars) {
        if (vars == null) {
            return;
        }
        Iterator it = vars.iterator();
        BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
        Process p = mainModel.getProcess();
        BPELProject project = mainModel.getBPELProject();
        while (it.hasNext()) {
            Variable v = (Variable)it.next();
            VariablesFilter filter = this.getVariablesFilter();
            if (filter != null && !filter.canDisplayVariable(v)) continue;
            VariableExplorerTreeNode userObj = new VariableExplorerTreeNode(v.getName(), 4, v, mainModel, a);
            if (this.m_dynamicSchemaInfo != null) {
                userObj.storeData("DynaSchema", this.m_dynamicSchemaInfo);
            }
            DefaultMutableTreeNode varNode = new DefaultMutableTreeNode((Object)userObj);
            varNode.add((MutableTreeNode)new DummyNode());
            parentNode.add(varNode);
        }
    }

    protected void enableDeleteButton(boolean bEnable) {
        if (!this.getAllowEditing()) {
            this.m_deleteBtn.setEnabled(false);
        } else {
            this.m_deleteBtn.setEnabled(bEnable);
        }
    }

    protected void enableCreateButton(boolean bEnable) {
        if (!this.getAllowEditing()) {
            this.m_createBtn.setEnabled(false);
        } else {
            this.m_createBtn.setEnabled(bEnable);
        }
    }

    protected void enableEditButton(boolean bEnable) {
        if (!this.getAllowEditing()) {
            this.m_editBtn.setEnabled(false);
        } else {
            this.m_editBtn.setEnabled(bEnable);
        }
    }

    protected void updateButtons() {
        this.m_showDetailsCB.setEnabled(false);
        this.enableCreateButton(false);
        this.m_createBtn.setActions(null);
        this.enableDeleteButton(false);
        this.enableEditButton(false);
        this.m_addBtn.setEnabled(false);
        DefaultMutableTreeNode selTreeNode = this.getSelectedTreeNode();
        ExplorerTreeNode selExplorerNode = this.getSelectedExplorerTreeNode();
        if (selExplorerNode == null) {
            return;
        }
        this.m_showDetailsCB.setEnabled(true);
        this.m_showDetailsCB.setSelected(selExplorerNode.getShowDetails());
        switch (selExplorerNode.m_type) {
            case 12: 
            case 17: 
            case 18: 
            case 26: 
            case 37: {
                this.enableCreateButton(true);
                break;
            }
            case 3: 
            case 9: 
            case 13: {
                DefaultMutableTreeNode parentTreeNode = (DefaultMutableTreeNode)selTreeNode.getParent();
                ExplorerTreeNode parentNode = (ExplorerTreeNode)parentTreeNode.getUserObject();
                Object parentData = parentNode.m_data;
                if (!(parentData instanceof Scope)) break;
                Scope s = (Scope)parentData;
                this.enableCreateButton(s.isEditable());
                break;
            }
            case 23: {
                this.enableEditButton(true);
                break;
            }
            case 16: {
                boolean bEnable = true;
                if (selExplorerNode.m_data instanceof ActivityInfo) {
                    ActivityInfo info = (ActivityInfo)selExplorerNode.m_data;
                    bEnable = info.getActivity().isEditable();
                }
                this.enableEditButton(bEnable);
                break;
            }
            case 20: {
                this.enableDeleteButton(true);
                break;
            }
            case 14: {
                PartnerLink link = (PartnerLink)selExplorerNode.getUserData();
                boolean bEditable = link.isEditable();
                this.enableEditButton(bEditable);
                this.enableDeleteButton(bEditable);
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                Variable var = (Variable)selExplorerNode.getUserData();
                boolean bEditable = var.isEditable();
                this.enableEditButton(bEditable);
                this.enableDeleteButton(bEditable);
                break;
            }
            case 11: {
                CorrelationSet set = (CorrelationSet)selExplorerNode.getUserData();
                boolean bEditable = set.isEditable();
                this.enableEditButton(bEditable);
                this.enableDeleteButton(bEditable);
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 19: 
            case 38: {
                this.enableDeleteButton(true);
                this.enableEditButton(true);
            }
        }
    }

    protected boolean confirmDelete(String title, String msg) {
        return !this.m_graph.getSettings().m_bConfirmDeletions || GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)this), (String)msg, (String)title) == 0;
    }

    protected void deleteSchema(DefaultMutableTreeNode treeNode) {
        ExplorerTreeNode node = (ExplorerTreeNode)treeNode.getUserObject();
        if (!(node.m_data instanceof URL)) {
            return;
        }
        URL schemaURL = (URL)node.m_data;
        boolean bDelete = this.confirmDelete(BPELStringTranslator.formatString("DELETE_GENERIC_TITLE", BPELStringTranslator.getString("SCHEMA_KEY_DELETE")), BPELStringTranslator.formatString("DELETE_GENERIC_MESSAGE", BPELStringTranslator.getString("SCHEMA_KEY_DELETE")));
        if (bDelete) {
            BPELProject prj = this.m_graph.getBPELProject();
            prj.deleteProjectResource(schemaURL);
            this.removeSchemaImportFromProjectWSDL(schemaURL);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
            treeModel.removeNodeFromParent(treeNode);
            this.fireModelChanged(16, null);
        }
    }

    protected void removeSchemaImportFromProjectWSDL(URL wsdlURL) {
        BPELProject prj = this.m_graph.getBPELProject();
        String processName = prj.getProcessName();
        Definition def = prj.getWSDLFileDefinition();
        URL fileURL = prj.getWSDLFileURL(processName);
        try {
            WSDLUtil.removeImportFromWSDL((URL)wsdlURL, (Definition)def, (URL)fileURL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void deleteCorrelationSet(DefaultMutableTreeNode treeNode) {
        ExplorerTreeNode node = (ExplorerTreeNode)treeNode.getUserObject();
        if (!(node.m_data instanceof CorrelationSet)) {
            return;
        }
        boolean bDelete = this.confirmDelete(BPELStringTranslator.formatString("DELETE_GENERIC_TITLE", BPELStringTranslator.getString("CORRELATIONSET_KEY_DELETE")), BPELStringTranslator.formatString("DELETE_GENERIC_MESSAGE", BPELStringTranslator.getString("CORRELATIONSET_KEY_DELETE")));
        if (!bDelete) {
            return;
        }
        CorrelationSet set = (CorrelationSet)node.m_data;
        DefaultMutableTreeNode parentTreeNode = (DefaultMutableTreeNode)treeNode.getParent();
        ExplorerTreeNode parentNode = (ExplorerTreeNode)parentTreeNode.getUserObject();
        Object parentData = parentNode.m_data;
        if (parentData instanceof Scope) {
            Scope s = (Scope)parentData;
            s.getCorrelationSets().deleteCorrelationSet(set);
            if (s.getCorrelationSets().getCorrelationSets().size() == 0) {
                s.deleteCorrelationSets();
            }
            DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
            treeModel.removeNodeFromParent(treeNode);
            this.fireModelChanged(8, s);
        }
    }

    protected void deleteProperty(DefaultMutableTreeNode treeNode) {
        ExplorerTreeNode node = (ExplorerTreeNode)treeNode.getUserObject();
        if (!(node.m_data instanceof CorrelationSetProperty)) {
            return;
        }
        boolean bDelete = this.confirmDelete(BPELStringTranslator.formatString("DELETE_GENERIC_TITLE", BPELStringTranslator.getString("PROPERTY_KEY_DELETE")), BPELStringTranslator.formatString("DELETE_GENERIC_MESSAGE", BPELStringTranslator.getString("PROPERTY_KEY_DELETE")));
        if (!bDelete) {
            return;
        }
        try {
            CorrelationSetProperty p = (CorrelationSetProperty)node.m_data;
            BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
            mainModel.getPropertyModel().deleteProperty(p.getName());
            DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
            treeModel.removeNodeFromParent(treeNode);
            this.fireModelChanged(10, null);
        }
        catch (Exception e) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.formatString("ERROR", e.getMessage()), (int)0);
        }
    }

    protected void deletePropertyAlias(DefaultMutableTreeNode treeNode) {
        ExplorerTreeNode node = (ExplorerTreeNode)treeNode.getUserObject();
        if (!(node.m_data instanceof CorrelationPropertyAlias)) {
            return;
        }
        boolean bDelete = this.confirmDelete(BPELStringTranslator.formatString("DELETE_GENERIC_TITLE", BPELStringTranslator.getString("PROPERTYALIAS_KEY_DELETE")), BPELStringTranslator.formatString("DELETE_GENERIC_MESSAGE", BPELStringTranslator.getString("PROPERTYALIAS_KEY_DELETE")));
        if (!bDelete) {
            return;
        }
        try {
            CorrelationPropertyAlias p = (CorrelationPropertyAlias)node.m_data;
            BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
            mainModel.getPropertyModel().deletePropertyAlias(p);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
            treeModel.removeNodeFromParent(treeNode);
            this.fireModelChanged(12, null);
        }
        catch (Exception e) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.formatString("ERROR", e.getMessage()), (int)0);
        }
    }

    protected void deleteVariable(DefaultMutableTreeNode treeNode) {
        ExplorerTreeNode node = (ExplorerTreeNode)treeNode.getUserObject();
        if (!(node.m_data instanceof Variable)) {
            return;
        }
        Variable v = (Variable)node.m_data;
        DefaultMutableTreeNode parentTreeNode = (DefaultMutableTreeNode)treeNode.getParent();
        ExplorerTreeNode parentNode = (ExplorerTreeNode)parentTreeNode.getUserObject();
        Object parentData = parentNode.m_data;
        if (parentData instanceof Scope) {
            Scope s = (Scope)parentData;
            if (!s.isEditable()) {
                String xpath = BPELModelUtil.getXPathForActivity((Activity)s);
                GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.formatString("ACTIVITY_IS_NOT_EDITABLE", xpath), (int)0);
                return;
            }
            List lst = BPELModelUtil.getReferenceVariableList((Scope)s, (String)v.getName());
            boolean bDelete = lst.size() > 0 ? this.confirmDelete(BPELStringTranslator.formatString("DELETE_GENERIC_TITLE", BPELStringTranslator.getString("VARIABLE_KEY_DELETE")), BPELStringTranslator.formatString("DELETE_GENERIC_MESSAGE", BPELStringTranslator.getString("VARIABLE_KEY_DELETE")) + "\n\nPlease note, " + v.getName() + " is referenced by some activities and it will be deferenced.") : this.confirmDelete(BPELStringTranslator.formatString("DELETE_GENERIC_TITLE", BPELStringTranslator.getString("VARIABLE_KEY_DELETE")), BPELStringTranslator.formatString("DELETE_GENERIC_MESSAGE", BPELStringTranslator.getString("VARIABLE_KEY_DELETE")));
            if (!bDelete) {
                return;
            }
            s.deleteVariable(v);
            lst = BPELModelUtil.dereferenceVariable((Scope)s, (String)v.getName());
            BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
            Process process = graphModel.getProcess();
            BPELModelUtil.validateActivities((Process)process, (List)lst);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
            treeModel.removeNodeFromParent(treeNode);
            this.fireModelChanged(1, s);
        }
    }

    protected void deleteActivity(DefaultMutableTreeNode treeNode) {
        ExplorerTreeNode node = (ExplorerTreeNode)treeNode.getUserObject();
        if (!(node.m_data instanceof ActivityInfo)) {
            return;
        }
        ActivityInfo info = (ActivityInfo)node.m_data;
        Activity activity = info.getActivity();
        if (activity instanceof Catch) {
            this.handleDeleteCatchBranch();
        }
    }

    public TreePath getTreePathForNode(DefaultMutableTreeNode n) {
        DefaultTreeModel model = (DefaultTreeModel)this.m_tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        Vector<DefaultMutableTreeNode> vec = new Vector<DefaultMutableTreeNode>();
        for (TreeNode currNode = n; currNode != null; currNode = currNode.getParent()) {
            vec.add((DefaultMutableTreeNode)currNode);
            if (root == currNode) break;
        }
        Object[] pathObjs = new Object[vec.size()];
        int i = vec.size() - 1;
        int j = 0;
        while (i >= 0) {
            pathObjs[j] = vec.elementAt(i);
            --i;
            ++j;
        }
        if (pathObjs.length > 0) {
            return new TreePath(pathObjs);
        }
        return null;
    }

    protected void handleExpandChildren() {
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof DefaultMutableTreeNode)) {
            return;
        }
        this.showWaitPanel(BPELStringTranslator.getString("EXPANDING_NODES_MSG"));
        final DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    new ExplorerTreeNodeExpander(ExplorerTree.this).expand(treeNode);
                }
                finally {
                    ExplorerTree.this.showTree();
                }
            }
        };
        new Thread(r).start();
    }

    protected void updateNodeDisplay(DefaultMutableTreeNode selNode) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
        treeModel.nodeChanged(selNode);
        this.m_tree.repaint();
        this.updateButtons();
    }

    public void fireNodeStructureChanged(final DefaultMutableTreeNode node) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DefaultTreeModel treeModel = (DefaultTreeModel)ExplorerTree.this.m_tree.getModel();
                treeModel.nodeStructureChanged(node);
                ExplorerTree.this.m_tree.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    protected void handleSearch() {
        this.showSearchPanel();
    }

    public void search(final SearchData data, final DefaultMutableTreeNode node, final ExplorerTreeSearchCallback callback) {
        final ArrayList result = new ArrayList();
        this.showWaitPanel("Searching...");
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ExplorerTree.this.doSearch(data, node, result);
                }
                catch (Throwable throwable) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ExplorerTree.this.showTree();
                            if (callback != null) {
                                callback.searchFinished(data, result);
                            }
                        }
                    };
                    SwingUtilities.invokeLater(r);
                    throw throwable;
                }
                Runnable r = new /* invalid duplicate definition of identical inner class */;
                SwingUtilities.invokeLater(r);
            }
        };
        new Thread(r).start();
    }

    private void doSearch(SearchData data, DefaultMutableTreeNode node, List<DefaultMutableTreeNode> result) {
        Object userObj = node.getUserObject();
        if (userObj instanceof ExplorerTreeNode) {
            ExplorerTreeNode explorer = (ExplorerTreeNode)userObj;
            switch (explorer.m_type) {
                case 4: {
                    Variable v = (Variable)explorer.m_data;
                    SearchResult r = SearchUtil.testVariable((SearchData)data, (String)data.m_searchStr, (Variable)v);
                    if (r == null) break;
                    result.add(node);
                    break;
                }
                case 2: {
                    MessageType msg = (MessageType)explorer.m_data;
                    SearchResult r = SearchUtil.testMessageType((SearchData)data, (String)data.m_searchStr, (MessageType)msg);
                    if (r == null) break;
                    result.add(node);
                    break;
                }
                case 11: {
                    MessageType msg = (CorrelationSet)explorer.m_data;
                    SearchResult r = SearchUtil.testCorrelationSet((SearchData)data, (String)data.m_searchStr, (CorrelationSet)msg);
                    if (r == null) break;
                    result.add(node);
                    break;
                }
                case 14: {
                    PartnerLink plink = (PartnerLink)explorer.m_data;
                    SearchResult r = SearchUtil.testPartnerLink((SearchData)data, (String)data.m_searchStr, (PartnerLink)plink);
                    if (r == null) break;
                    result.add(node);
                    break;
                }
                case 16: {
                    SearchResult r;
                    ActivityInfo info = (ActivityInfo)explorer.m_data;
                    Activity a = info.getActivity();
                    if (a == null || (r = SearchUtil.testActivity((SearchData)data, (String)data.m_searchStr, (Activity)a)) == null) break;
                    result.add(node);
                    break;
                }
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)node.getChildAt(i);
            this.doSearch(data, n, result);
        }
    }

    protected void handleRefresh() {
        this.showWaitPanel(BPELStringTranslator.getString("EDITOR_REFRESHING"));
        this.setCursor(Cursor.getPredefinedCursor(3));
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    if (ExplorerTree.this.m_refreshNodeID != -1) {
                        ExplorerTree.this.refreshNode(ExplorerTree.this.m_refreshNodeID);
                    } else {
                        VariableDocumentCache.clearVariablesCache((URL)ExplorerTree.this.m_graph.getBPELProject().getBPELFileURL());
                        ExplorerTree.this.loadExplorer(ExplorerTree.this.m_lastActivity);
                    }
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            if (ExplorerTree.this.m_refreshNodeID == -1) {
                                ExplorerTree.this.expandEntireTree();
                            }
                            ExplorerTree.this.showTree();
                            ExplorerTree.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    };
                    SwingUtilities.invokeLater(r);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)ExplorerTree.this), (String)BPELStringTranslator.formatString("ERROR", e.getMessage()), (int)0);
                }
            }
        };
        new Thread(r).start();
    }

    public void showTree() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.m_cardPnl.show(TREE_PANEL);
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ExplorerTree.this.m_cardPnl.show(ExplorerTree.TREE_PANEL);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    public void showWaitPanel(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.m_waitPanel.setText(message);
            this.m_cardPnl.show(LOADING_PANEL);
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ExplorerTree.this.m_waitPanel.setText(message);
                    ExplorerTree.this.m_cardPnl.show(ExplorerTree.LOADING_PANEL);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void handleFilter() {
        ExplorerFilterDialog dlg = new ExplorerFilterDialog(GraphUtils.getFrame((Component)this), this);
        ArrayList<ExplorerFilterItem> filter = new ArrayList<ExplorerFilterItem>();
        filter.add(new ExplorerFilterItem(0, this.getShowBranch(1)));
        filter.add(new ExplorerFilterItem(9, this.getShowBranch(8)));
        filter.add(new ExplorerFilterItem(1, this.getShowBranch(2)));
        filter.add(new ExplorerFilterItem(12, this.getShowBranch(16)));
        filter.add(new ExplorerFilterItem(22, this.getShowBranch(32)));
        filter.add(new ExplorerFilterItem(13, this.getShowBranch(4)));
        filter.add(new ExplorerFilterItem(17, this.getShowBranch(64)));
        filter.add(new ExplorerFilterItem(18, this.getShowBranch(128)));
        if (dlg.display(filter) == 0) {
            try {
                this.loadExplorer(this.m_lastActivity);
            }
            catch (Exception e) {
                e.printStackTrace();
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.formatString("ERROR", e.getMessage()), (int)0);
            }
        }
    }

    protected void handleCopyExceptionToClipBoard() {
        ExplorerTreeNode n = this.getSelectedExplorerTreeNode();
        if (n == null || n.m_type != 31) {
            return;
        }
        Exception ex = (Exception)n.m_data;
        if (ex == null) {
            return;
        }
        String s = this.m_showDetailsCB.isSelected() ? "Exception: " + ex.getMessage() : "Exception: " + n.toString();
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        cb.setContents(new StringSelection(s), null);
    }

    protected void handleAddCatchBranch() {
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        DefaultMutableTreeNode treenode = this.getSelectedTreeNode();
        if (treenode != null) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treenode.getParent();
            ExplorerTreeNode n = (ExplorerTreeNode)treenode.getUserObject();
            if (parent != null && n.m_data instanceof FaultHandlers) {
                ExplorerTreeNode pnode = (ExplorerTreeNode)parent.getUserObject();
                ActivityInfo info = (ActivityInfo)pnode.m_data;
                Node fnode = graphModel.getNodeForActivity(info.getActivity());
                this.addCatchBranch(fnode);
            } else {
                Node node = graphModel.getNodeForActivity(this.getSelectedActivity());
                this.addCatchBranch(node);
            }
        }
    }

    protected void createOperation(DefaultMutableTreeNode selNode) {
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof DefaultMutableTreeNode)) {
            return;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
        ExplorerTreeNode n = (ExplorerTreeNode)treeNode.getUserObject();
        Definition def = (Definition)n.getData((Object)"def");
        PortType pt = (PortType)n.m_data;
        URI uri = (URI)n.getData((Object)"uri");
        try {
            def = WSDLUtil.parseWSDLDocument((URI)uri);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        OperationDialog dlg = new OperationDialog(GraphUtils.getFrame((Component)this), def, uri, pt, this.m_graph, false);
        if (dlg.create() == 0) {
            try {
                Operation op = dlg.getOperation();
                Map nsMap = BPELModelerUtil.getWSDLNamespaceMap((URI)uri);
                DefaultMutableTreeNode opNode = ExplorerTreeUtil.buildOperationNode(this.m_graph, selNode, op, nsMap);
                DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
                treeModel.insertNodeInto(opNode, selNode, 0);
                this.m_tree.setSelectionPath(this.getTreePathForNode(opNode));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addCatchBranch(Node node) {
        NodeRenderer r;
        if (node != null && (r = this.m_graph.getNodeRendererForNode(node)) != null) {
            if (r instanceof ProcessView) {
                ProcessView view = (ProcessView)r;
                view.addCatch();
            } else if (r instanceof ScopeView) {
                ScopeView view = (ScopeView)r;
                view.addCatch();
            }
        }
    }

    protected void handleDeleteCatchBranch() {
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Activity activity = this.getSelectedActivity();
        if (activity != null) {
            DefaultMutableTreeNode parent;
            Node node = graphModel.getNodeForActivity(activity);
            NodeRenderer child = this.m_graph.getNodeRendererForNode(node);
            if (node == null) {
                return;
            }
            if (child != null && child instanceof CatchView && (parent = (DefaultMutableTreeNode)this.getSelectedTreeNode().getParent().getParent()) != null) {
                ExplorerTreeNode pnode = (ExplorerTreeNode)parent.getUserObject();
                ActivityInfo info = (ActivityInfo)pnode.m_data;
                Node newnode = graphModel.getNodeForActivity(info.getActivity());
                if (newnode == null) {
                    return;
                }
                NodeRenderer r = this.m_graph.getNodeRendererForNode(newnode);
                if (r != null) {
                    if (r instanceof ProcessView) {
                        ProcessView view = (ProcessView)r;
                        view.deleteCatchView((CatchView)child);
                    } else if (r instanceof ScopeView) {
                        ScopeView view = (ScopeView)r;
                        view.deleteCatchView((CatchView)child);
                    }
                }
            }
        }
    }

    protected void handleEdit() {
        if (!this.getAllowEditing()) {
            return;
        }
        DefaultMutableTreeNode treeNode = this.getSelectedTreeNode();
        ExplorerTreeNode n = this.getSelectedExplorerTreeNode();
        if (n == null) {
            return;
        }
        boolean bEdited = false;
        switch (n.m_type) {
            case 14: {
                bEdited = this.editPartnerLink(treeNode);
                break;
            }
            case 8: {
                bEdited = this.editMessagePart(treeNode);
                break;
            }
            case 19: {
                bEdited = this.editProperty(treeNode);
                break;
            }
            case 4: {
                bEdited = this.editVariable(treeNode);
                break;
            }
            case 2: {
                bEdited = this.editMessageType(treeNode);
                break;
            }
            case 11: {
                bEdited = this.editCorrelationSet(treeNode);
                break;
            }
            case 16: 
            case 33: {
                bEdited = this.editActivity(treeNode);
                break;
            }
            case 15: {
                bEdited = this.editSchema(treeNode);
                break;
            }
            case 23: {
                bEdited = this.editWSDL(treeNode);
                break;
            }
            case 38: {
                bEdited = this.editOperation(treeNode);
                break;
            }
        }
        if (bEdited) {
            this.firePropertyChange(NODE_EDITED, null, treeNode);
        }
    }

    protected void handleDelete() {
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof DefaultMutableTreeNode)) {
            return;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
        ExplorerTreeNode n = (ExplorerTreeNode)treeNode.getUserObject();
        TreeNode parentNode = (TreeNode)path.getParentPath().getLastPathComponent();
        int selectedIndex = -1;
        if (parentNode != null) {
            selectedIndex = parentNode.getIndex(treeNode);
        }
        switch (n.m_type) {
            case 14: {
                this.deletePartnerLink(treeNode);
                break;
            }
            case 15: {
                this.deleteSchema(treeNode);
                break;
            }
            case 19: {
                this.deleteProperty(treeNode);
                break;
            }
            case 20: {
                this.deletePropertyAlias(treeNode);
                break;
            }
            case 4: {
                this.deleteVariable(treeNode);
                break;
            }
            case 2: {
                this.deleteMessageType(treeNode);
                break;
            }
            case 11: {
                this.deleteCorrelationSet(treeNode);
                break;
            }
            case 8: {
                this.deleteMessagePart(treeNode);
                break;
            }
            case 16: {
                this.deleteActivity(treeNode);
                break;
            }
            case 38: {
                this.deleteOperation(treeNode);
                break;
            }
        }
        this.setSelectedChildIndex(path.getParentPath(), selectedIndex);
    }

    private void setSelectedChildIndex(TreePath parentPath, int childIndex) {
        if (childIndex < 0 || parentPath == null) {
            return;
        }
        TreeNode parentNode = (TreeNode)parentPath.getLastPathComponent();
        TreePath finalPath = null;
        int childCount = parentNode.getChildCount();
        if (childCount == 0) {
            finalPath = parentPath;
        } else if (childCount == childIndex) {
            finalPath = parentPath.pathByAddingChild(parentNode.getChildAt(childCount - 1));
        } else if (childCount > childIndex) {
            finalPath = parentPath.pathByAddingChild(parentNode.getChildAt(childIndex));
        }
        this.m_tree.setSelectionPath(finalPath);
    }

    protected void handleAdd() {
        DefaultMutableTreeNode treeNode = this.getSelectedTreeNode();
        ExplorerTreeNode n = this.getSelectedExplorerTreeNode();
        if (n == null) {
            return;
        }
        switch (n.m_type) {
            case 12: {
                this.importSchema(treeNode);
                break;
            }
        }
    }

    protected void handleCreate() {
        DefaultMutableTreeNode treeNode = this.getSelectedTreeNode();
        ExplorerTreeNode n = this.getSelectedExplorerTreeNode();
        if (n == null) {
            return;
        }
        switch (n.m_type) {
            case 12: {
                this.importSchema(treeNode);
                break;
            }
            case 37: {
                this.createOperation(treeNode);
                break;
            }
            case 13: {
                this.createPartnerLink(treeNode);
                break;
            }
            case 3: {
                this.createVariable(treeNode);
                break;
            }
            case 1: 
            case 26: {
                this.createMessageType(treeNode);
                break;
            }
            case 9: {
                this.createCorrelationSet(treeNode);
                break;
            }
            case 17: {
                this.createProperty(treeNode);
                break;
            }
            case 18: {
                this.createPropertyAlias(treeNode);
                break;
            }
        }
    }

    protected void createProperty(DefaultMutableTreeNode selNode) {
        URL plURL;
        BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
        BPELProject prj = mainModel.getBPELProject();
        if (BPELProjectUtil.isEmptyBPELProcess((BPELProject)prj) && (plURL = this.findPartnerLinkForSaving()) == null) {
            return;
        }
        CorrelationSetPropertyDialog dlg = new CorrelationSetPropertyDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        if (dlg.create() != 0) {
            return;
        }
        CorrelationSetProperty p = dlg.getCorrelationSetProperty();
        if (p != null) {
            ArrayList<CorrelationSetProperty> lst = new ArrayList<CorrelationSetProperty>();
            lst.add(p);
            try {
                mainModel.getPropertyModel().saveProperties(lst);
                ExplorerTreeNode userObj = new ExplorerTreeNode(p.getName(), 19, (Object)p);
                DefaultMutableTreeNode propNode = new DefaultMutableTreeNode(userObj);
                DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
                treeModel.insertNodeInto(propNode, selNode, selNode.getChildCount());
                this.m_tree.setSelectionPath(this.getTreePathForNode(propNode));
                this.fireModelChanged(9, null);
            }
            catch (Exception e) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.formatString("ERROR", e.getMessage()), (int)0);
            }
        }
    }

    protected void createPropertyAlias(DefaultMutableTreeNode selectedNode) {
        URL plURL;
        BPELProject prj = this.m_graph.getBPELProject();
        if (BPELProjectUtil.isEmptyBPELProcess((BPELProject)prj) && (plURL = this.findPartnerLinkForSaving()) == null) {
            return;
        }
        CorrelationPropertyAliasDialog dlg = new CorrelationPropertyAliasDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        if (dlg.create() != 0) {
            return;
        }
        CorrelationPropertyAlias alias = dlg.getCorrelationPropertyAlias();
        ArrayList<CorrelationPropertyAlias> lst = new ArrayList<CorrelationPropertyAlias>();
        lst.add(alias);
        try {
            BPELProjectUtil.setPropertyAlias((BPELProject)prj, lst, (Map)dlg.getAllNSNamespaces(), null);
            DefaultMutableTreeNode aliasNode = this.buildPropertyAliasNode(alias);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
            treeModel.insertNodeInto(aliasNode, selectedNode, selectedNode.getChildCount());
            this.m_tree.setSelectionPath(this.getTreePathForNode(aliasNode));
            this.fireModelChanged(11, null);
        }
        catch (Exception e) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.formatString("ERROR", e.getMessage()), (int)0);
        }
    }

    protected URL findPartnerLinkForSaving() {
        Object[] objs;
        BPELGraphModel graphModel;
        Process process;
        Map map;
        String processName;
        BPELProject prj = this.m_graph.getBPELProject();
        URL url = prj.getWSDLFileURL(processName = prj.getProcessName());
        if (Helper.exists((URL)url)) {
            return url;
        }
        String s = (String)prj.getProjectData("PropertyPL");
        if (s != null) {
            try {
                url = new URL(s);
                if (Helper.exists((URL)url)) {
                    return url;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((map = BPELModelerUtil.getWSDLURIsForPartnerLinks((Process)(process = (graphModel = (BPELGraphModel)this.m_graph.getModel()).getProcess()), (DeploymentFile)prj.getDeploymentFile())) == null) {
            if (GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)this), (String)"You must have a WSDL file to save the change.\nDo you want to create a new WSDL file?", (String)"No WSDL File Found For This Process") == 0) {
                url = WSDLUtil.getWSDLFileForEmptyProcess((BPELProject)this.m_graph.getBPELProject());
                prj.storeProjectData("PropertyPL", (Object)url.toString());
                return url;
            }
            return null;
        }
        URL projURL = prj.getProjectURL();
        for (Object name : objs = map.keySet().toArray()) {
            try {
                URI u = (URI)map.get(name);
                if (Helper.isBaseURLFor((URL)projURL, (URL)u.toURL())) continue;
                map.remove(name);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (map.size() == 0) {
            if (GraphUtils.showConfirmDialog((Component)GraphUtils.getFrame((Component)this), (String)"You must have a WSDL file to save the change.\nDo you want to create a new WSDL file?", (String)"No WSDL File Found For This Process") == 0) {
                url = WSDLUtil.getWSDLFileForEmptyProcess((BPELProject)this.m_graph.getBPELProject());
                prj.storeProjectData("PropertyPL", (Object)url.toString());
                return url;
            }
            return null;
        }
        if (map.size() == 1) {
            URI uri = (URI)map.values().iterator().next();
            try {
                url = uri.toURL();
            }
            catch (Exception ex) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)"Invalid URL for the selected partner link.", (int)0);
            }
        } else {
            PartnerLinkSelectionDialog dlg = new PartnerLinkSelectionDialog(GraphUtils.getFrame((Component)this), map, 1);
            if (dlg.select() == 0) {
                url = dlg.getSelectedPartnerLinkURL();
            }
        }
        if (url != null) {
            prj.storeProjectData("PropertyPL", (Object)url.toString());
            try {
                prj.save();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return url;
    }

    protected boolean editPropertyAlias(DefaultMutableTreeNode selectedNode) {
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)selectedNode.getUserObject();
        CorrelationPropertyAlias alias = (CorrelationPropertyAlias)explorerNode.m_data;
        CorrelationPropertyAliasDialog dlg = new CorrelationPropertyAliasDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        if (dlg.edit(alias) != 0) {
            return false;
        }
        this.m_tree.repaint();
        return true;
    }

    protected void createCorrelationSet(DefaultMutableTreeNode treeNode) {
        CorrelationSetDialog dlg;
        CorrelationSets sets;
        List csList = null;
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)treeNode.getUserObject();
        Activity activity = (Activity)explorerNode.m_data;
        if (!activity.isEditable()) {
            String xpath = BPELModelUtil.getXPathForActivity((Activity)activity);
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.formatString("ACTIVITY_IS_NOT_EDITABLE", xpath), (int)0);
            return;
        }
        if (activity instanceof Scope && (sets = ((Scope)activity).getCorrelationSets()) != null) {
            csList = sets.getCorrelationSets();
        }
        if ((dlg = new CorrelationSetDialog(GraphUtils.getFrame((Component)this), this.m_graph)).create(activity, csList) != 0) {
            return;
        }
        CorrelationSet cs = dlg.getCorrelationSet();
        if (cs != null) {
            DefaultMutableTreeNode newNode = null;
            if (activity instanceof Scope) {
                Scope s = (Scope)activity;
                s.addCorrelationSet(cs);
                newNode = new DefaultMutableTreeNode(new ExplorerTreeNode(cs.getName(), 11, (Object)cs));
                this.fireModelChanged(7, s);
            }
            if (newNode != null) {
                DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
                treeModel.insertNodeInto(newNode, treeNode, 0);
                this.m_tree.setSelectionPath(this.getTreePathForNode(newNode));
            }
        }
    }

    protected boolean editActivity(DefaultMutableTreeNode treeNode) {
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)treeNode.getUserObject();
        ActivityInfo info = (ActivityInfo)explorerNode.m_data;
        Activity a = info.getActivity();
        if (!a.isEditable()) {
            String xpath = BPELModelUtil.getXPathForActivity((Activity)a);
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.formatString("ACTIVITY_IS_NOT_EDITABLE", xpath), (int)0);
            return false;
        }
        int id = ModelBuilder.getNodeIDForActivity(a);
        if (id == -1) {
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.getString("ACTIVITY_TYPE_UNKNOWN"));
            return false;
        }
        NodeEditor editor = NodeEditorFactory.getNodeEditor(id);
        if (editor != null) {
            ActivityEditorDialog dlg = new ActivityEditorDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)), (AbstractActivityNodeEditor)editor, a, this.m_graph);
            dlg.display();
            this.updateNodeDisplay(treeNode);
            return true;
        }
        return false;
    }

    protected boolean editSchema(DefaultMutableTreeNode treeNode) {
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)treeNode.getUserObject();
        URL url = (URL)explorerNode.m_data;
        IDE ide = IDEResolver.getIDE();
        try {
            ide.openEditor(url);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean editWSDL(DefaultMutableTreeNode treeNode) {
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)treeNode.getUserObject();
        URL url = (URL)explorerNode.m_data;
        IDE ide = IDEResolver.getIDE();
        try {
            ide.openEditor(url);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean editOperation(DefaultMutableTreeNode treeNode) {
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)treeNode.getUserObject();
        Operation op = (Operation)explorerNode.m_data;
        try {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
            ExplorerTreeNode n = (ExplorerTreeNode)parent.getUserObject();
            Definition def = (Definition)n.getData((Object)"def");
            PortType pt = (PortType)n.m_data;
            URI uri = (URI)n.getData((Object)"uri");
            def = WSDLUtil.parseWSDLDocument((URI)uri);
            OperationDialog dlg = new OperationDialog(GraphUtils.getFrame((Component)this), def, uri, pt, this.m_graph, true);
            if (dlg.edit(op) != 0) {
                return false;
            }
            explorerNode.m_text = dlg.getOperationName();
            explorerNode.m_data = dlg.getOperation();
            this.updateNodeDisplay(treeNode);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean editCorrelationSet(DefaultMutableTreeNode treeNode) {
        CorrelationSets sets;
        List csList = null;
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent().getParent();
        ExplorerTreeNode node = (ExplorerTreeNode)parent.getUserObject();
        Activity activity = (Activity)node.m_data;
        if (activity instanceof Scope && (sets = ((Scope)activity).getCorrelationSets()) != null) {
            csList = sets.getCorrelationSets();
        }
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)treeNode.getUserObject();
        CorrelationSet cs = (CorrelationSet)explorerNode.m_data;
        CorrelationSetDialog dlg = new CorrelationSetDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        if (dlg.edit(cs, csList) != 0) {
            return false;
        }
        explorerNode.m_text = cs.getName();
        this.updateNodeDisplay(treeNode);
        return true;
    }

    protected void deleteOperation(DefaultMutableTreeNode treeNode) {
        boolean bDelete = this.confirmDelete(BPELStringTranslator.formatString("DELETE_GENERIC_TITLE", BPELStringTranslator.getString("MESSAGE_KEY_DELETE")), BPELStringTranslator.formatString("DELETE_GENERIC_MESSAGE", "Operation"));
        if (!bDelete) {
            return;
        }
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)treeNode.getUserObject();
        Operation op = (Operation)explorerNode.m_data;
        if (op != null) {
            try {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
                ExplorerTreeNode n = (ExplorerTreeNode)parent.getUserObject();
                Definition def = (Definition)n.getData((Object)"def");
                PortType pt = (PortType)n.m_data;
                URI uri = (URI)n.getData((Object)"uri");
                List oplst = pt.getOperations();
                oplst.remove(op);
                WSDLUtil.saveWSDLFile((URL)uri.toURL(), (Definition)def);
                DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
                treeModel.removeNodeFromParent(treeNode);
                this.fireModelChanged(27, null);
            }
            catch (Exception e) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)e.getMessage());
            }
        }
    }

    protected void deleteMessageType(DefaultMutableTreeNode treeNode) {
        boolean bDelete = this.confirmDelete(BPELStringTranslator.formatString("DELETE_GENERIC_TITLE", BPELStringTranslator.getString("MESSAGE_KEY_DELETE")), BPELStringTranslator.formatString("DELETE_GENERIC_MESSAGE", BPELStringTranslator.getString("MESSAGE_KEY_DELETE")));
        if (!bDelete) {
            return;
        }
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)treeNode.getUserObject();
        MessageType type = (MessageType)explorerNode.m_data;
        if (type != null) {
            try {
                BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
                mainModel.getWSDLModel().deleteMessage(type.getName());
                DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
                treeModel.removeNodeFromParent(treeNode);
                this.fireModelChanged(14, null);
            }
            catch (Exception e) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)e.getMessage());
            }
        }
    }

    protected void deleteMessagePart(DefaultMutableTreeNode treeNode) {
        boolean bDelete = this.confirmDelete(BPELStringTranslator.formatString("DELETE_GENERIC_TITLE", BPELStringTranslator.getString("MESSAGEPART_KEY_DELETE")), BPELStringTranslator.formatString("DELETE_GENERIC_MESSAGE", BPELStringTranslator.getString("MESSAGEPART_KEY_DELETE")));
        if (!bDelete) {
            return;
        }
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)treeNode.getUserObject();
        MessagePart p = (MessagePart)explorerNode.m_data;
        String oldName = p.getName();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treeNode.getParent();
        ExplorerTreeNode expParentNode = (ExplorerTreeNode)parentNode.getUserObject();
        MessageType msgType = (MessageType)expParentNode.m_data;
        List list = msgType.getParts();
        boolean bFound = false;
        for (int i = 0; i < list.size() && !bFound; ++i) {
            MessagePart mp = (MessagePart)list.get(i);
            if (!oldName.equals(mp.getName())) continue;
            list.remove(i);
            bFound = true;
        }
        if (bFound) {
            try {
                if (bFound) {
                    BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
                    mainModel.getWSDLModel().saveMessageType(msgType);
                }
                DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
                treeModel.removeNodeFromParent(treeNode);
            }
            catch (Exception e) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)e.getMessage(), (int)0);
            }
        }
    }

    protected void createMessageType(DefaultMutableTreeNode messagesNode) {
        MessageTypeDialog dlg = new MessageTypeDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        if (dlg.create() != 0) {
            return;
        }
        try {
            MessageType type = dlg.getMessageType();
            BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
            mainModel.getWSDLModel().saveMessageType(type);
            this.addNamespaceToProcess(type);
            DefaultMutableTreeNode newNode = this.buildMessageTypeNode(type, true);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
            treeModel.insertNodeInto(newNode, messagesNode, messagesNode.getChildCount());
            this.m_tree.setSelectionPath(this.getTreePathForNode(newNode));
            this.fireModelChanged(13, null);
        }
        catch (Exception e) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)e.getMessage(), (int)0);
        }
    }

    protected boolean editMessagePart(DefaultMutableTreeNode selectedNode) {
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)selectedNode.getUserObject();
        MessagePart p = (MessagePart)explorerNode.m_data;
        MessagePartDialog dlg = new MessagePartDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        String oldName = p.getName();
        if (dlg.edit(p) == 0) {
            try {
                boolean bExpand = this.m_tree.isExpanded(this.getTreePathForNode(selectedNode));
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)selectedNode.getParent();
                ExplorerTreeNode expParentNode = (ExplorerTreeNode)parentNode.getUserObject();
                MessageType msgType = (MessageType)expParentNode.m_data;
                List list = msgType.getParts();
                p = dlg.getMessagePart();
                boolean bFound = false;
                for (int i = 0; i < list.size() && !bFound; ++i) {
                    MessagePart mp = (MessagePart)list.get(i);
                    if (!oldName.equals(mp.getName())) continue;
                    bFound = true;
                    list.set(i, p);
                }
                BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
                mainModel.getWSDLModel().saveMessageType(msgType);
                this.addNamespaceToProcess(msgType);
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ExplorerTreeNode(p.getName(), 8, (Object)p));
                DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
                int idx = parentNode.getIndex(selectedNode);
                treeModel.insertNodeInto(newNode, parentNode, idx);
                treeModel.removeNodeFromParent(selectedNode);
                TreePath path = this.getTreePathForNode(newNode);
                this.m_tree.setSelectionPath(path);
                if (bExpand) {
                    this.m_tree.expandPath(path);
                }
                URL bpelURL = this.m_graph.getBPELProject().getBPELFileURL();
                VariableDocumentCache.clearMessagePartsCache((URL)bpelURL, (QName)new QName(msgType.getNamespace(), msgType.getName()));
                return true;
            }
            catch (Exception e) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)e.getMessage(), (int)0);
                return false;
            }
        }
        return false;
    }

    protected boolean editMessageType(DefaultMutableTreeNode selectedNode) {
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)selectedNode.getUserObject();
        MessageType type = (MessageType)explorerNode.m_data;
        String origName = type.getName();
        MessageTypeDialog dlg = new MessageTypeDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        if (dlg.edit(type) == 0) {
            try {
                BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
                WSDLModel wsdlModel = mainModel.getWSDLModel();
                wsdlModel.deleteMessage(origName);
                boolean bExpand = this.m_tree.isExpanded(this.getTreePathForNode(selectedNode));
                wsdlModel.saveMessageType(dlg.getMessageType());
                this.addNamespaceToProcess(dlg.getMessageType());
                DefaultMutableTreeNode newNode = this.buildMessageTypeNode(dlg.getMessageType(), true);
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)selectedNode.getParent();
                DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
                int idx = parentNode.getIndex(selectedNode);
                treeModel.insertNodeInto(newNode, parentNode, idx);
                treeModel.removeNodeFromParent(selectedNode);
                TreePath path = this.getTreePathForNode(newNode);
                this.m_tree.setSelectionPath(path);
                if (bExpand) {
                    this.m_tree.expandPath(path);
                }
                this.fireModelChanged(13, type);
                return true;
            }
            catch (Exception e) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)e.getMessage(), (int)0);
                return false;
            }
        }
        return false;
    }

    protected void importSchema(DefaultMutableTreeNode selNode) {
        SchemaImportDialog dlg = new SchemaImportDialog(GraphUtils.getFrame((Component)this), BPELStringTranslator.getString("IMPORT_SCHEMA"), 0, this.m_graph);
        if (dlg.display() != 0) {
            return;
        }
        try {
            BPELProject prj = this.m_graph.getBPELProject();
            URL xsdDir = prj.getXSDRoot();
            URL schemaURL = CommonScaUtils.handleImportDialog((IDEProject)prj, (Frame)GraphUtils.getFrame((Component)this), (ImportDialog)dlg, (String)"XSD", (URL)xsdDir);
            String protocol = schemaURL.getProtocol();
            if (protocol.startsWith("http")) {
                try {
                    XSDBuilder builder = new XSDBuilder();
                    XMLSchema schema = builder.build(schemaURL);
                    String targetNS = schema.getSchemaTargetNS();
                    BPELProjectUtil.addImportToWSDL((BPELProject)prj, (URL)schemaURL, (String)targetNS);
                    String msg = MessageBundleUtil.getCommonString((String)"TC_SCHEMA_IMPORTED_MSG");
                    String title = MessageBundleUtil.getCommonString((String)"TC_IMPORT_PROJECT_SCHEMA");
                    GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)msg, (String)title, (int)1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dlg.saveWSDLFile();
            prj.refresh();
            ProjectSchemaExplorerTreeNode elementDataSource = new ProjectSchemaExplorerTreeNode(Helper.getFileName((URL)schemaURL), 15, schemaURL, true, true);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
            DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode((Object)elementDataSource);
            schemaNode.add((MutableTreeNode)new DummyNode());
            treeModel.insertNodeInto(schemaNode, selNode, 0);
            this.m_tree.setSelectionPath(this.getTreePathForNode(schemaNode));
            this.fireModelChanged(15, null);
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)this, (Throwable)e);
        }
    }

    protected void createPartnerLink(DefaultMutableTreeNode selNode) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
        ExplorerTreeNode node = (ExplorerTreeNode)parent.getUserObject();
        Scope activity = (Scope)node.m_data;
        PartnerLink link = this.m_graph.createPartnerLink(activity);
        if (link != null && !this.isStructurePane()) {
            ExplorerTreeNode newNode = new ExplorerTreeNode(link.getName(), 14, (Object)link);
            DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
            DefaultMutableTreeNode linkNode = new DefaultMutableTreeNode(newNode);
            treeModel.insertNodeInto(linkNode, selNode, 0);
            this.m_tree.setSelectionPath(this.getTreePathForNode(linkNode));
        }
    }

    protected void deletePartnerLink(DefaultMutableTreeNode selNode) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent().getParent();
        ExplorerTreeNode pnode = (ExplorerTreeNode)parent.getUserObject();
        Scope activity = (Scope)pnode.m_data;
        ExplorerTreeNode node = (ExplorerTreeNode)selNode.getUserObject();
        PartnerLink partnerLink = (PartnerLink)node.m_data;
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        for (PartnerLinkNode n : graphModel.getPartnerLinkNodes()) {
            boolean bDelete;
            PartnerLink linkObj = (PartnerLink)n.getUserObject();
            if (partnerLink != linkObj) continue;
            Node parentNode = n.getParentNode();
            if (parentNode != null && (bDelete = this.confirmDelete(BPELStringTranslator.formatString("DELETE_GENERIC_TITLE", BPELStringTranslator.getString("PARTNER_LINK")), MessageBundleUtil.getCommonString((String)"GRAPHPANE_DEL_PARTNERLINK")))) {
                Process process = graphModel.getProcess();
                activity.deletePartnerLink(partnerLink);
                List list = BPELModelUtil.updatePartnerLinkReference((Scope)activity, (String)linkObj.getName(), null);
                BPELModelUtil.validateActivities((Process)process, (List)list);
                graphModel.deleteNode(parentNode, (Node)n);
                if (!this.isStructurePane()) {
                    DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
                    treeModel.removeNodeFromParent(selNode);
                }
            }
            return;
        }
    }

    protected void createVariable(DefaultMutableTreeNode selNode) {
        QName newQName;
        String processPrefix;
        QName qname;
        Variables vars;
        List varList = null;
        ExplorerTreeNode node = (ExplorerTreeNode)selNode.getUserObject();
        Activity activity = (Activity)node.m_data;
        if (!activity.isEditable()) {
            String xpath = BPELModelUtil.getXPathForActivity((Activity)activity);
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.formatString("ACTIVITY_IS_NOT_EDITABLE", xpath), (int)0);
            return;
        }
        if (activity instanceof Scope && (vars = ((Scope)activity).getVariables()) != null) {
            varList = vars.getVariables();
        }
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        VariableCreationDialog dlg = new VariableCreationDialog(GraphUtils.getFrame((Component)this), this.m_graph, this.m_variableCreationMask);
        if (dlg.create(activity, varList) != 0) {
            return;
        }
        Process process = graphModel.getProcess();
        Variable v = dlg.getVariable();
        if (activity instanceof Scope) {
            Scope s = (Scope)activity;
            s.addVariable(v);
            BPELXmlModel bpelModel = graphModel.getBPELXmlModel();
            VariableExplorerTreeNode userObj = new VariableExplorerTreeNode(v.getName(), 4, v, bpelModel, activity);
            DefaultMutableTreeNode varNode = new DefaultMutableTreeNode((Object)userObj);
            varNode.add((MutableTreeNode)new DummyNode());
            DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
            treeModel.insertNodeInto(varNode, selNode, 0);
            Vector<DefaultMutableTreeNode> vec = new Vector<DefaultMutableTreeNode>();
            for (TreeNode currNode = varNode; currNode != null; currNode = currNode.getParent()) {
                vec.add((DefaultMutableTreeNode)currNode);
            }
            Object[] pathObjs = new TreeNode[vec.size()];
            int i = vec.size() - 1;
            int j = 0;
            while (i >= 0) {
                pathObjs[j] = (TreeNode)vec.elementAt(i);
                --i;
                ++j;
            }
            TreePath path = new TreePath(pathObjs);
            this.m_tree.setSelectionPath(path);
        }
        if ((qname = v.getMessageType()) != null) {
            processPrefix = process.addNamespace(qname.getNamespaceURI());
            newQName = new QName(qname.getNamespaceURI(), qname.getLocalPart(), processPrefix);
            v.setMessageType(newQName);
            this.addNamespaceForParts(process, newQName);
        }
        if ((qname = v.getElement()) != null) {
            processPrefix = process.addNamespace(qname.getNamespaceURI());
            newQName = new QName(qname.getNamespaceURI(), qname.getLocalPart(), processPrefix);
            v.setElement(newQName);
        }
        if ((qname = v.getType()) != null) {
            processPrefix = process.addNamespace(qname.getNamespaceURI());
            newQName = new QName(qname.getNamespaceURI(), qname.getLocalPart(), processPrefix);
            v.setType(newQName);
        }
    }

    protected void addNamespaceForParts(Process process, QName msgQName) {
        BPELProject prj = this.m_graph.getBPELProject();
        List list = BPELModelerUtil.getWSDLFromNamespaceURI((Process)process, (DeploymentFile)prj.getDeploymentFile(), (String)msgQName.getNamespaceURI());
        WSDLPartData[] partData = null;
        if (list != null) {
            for (URI uri : list) {
                try {
                    partData = WSDLUtil.getParts((URI)uri, (String)msgQName.getLocalPart(), (String)msgQName.getNamespaceURI());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (partData == null) continue;
                for (WSDLPartData pd : partData) {
                    process.addNamespace(pd.getTargetNamespace());
                }
                return;
            }
        }
        if ((partData = BPELProjectUtil.getMessagePartData((BPELProject)prj, (String)msgQName.getLocalPart())) != null) {
            for (WSDLPartData pd : partData) {
                process.addNamespace(pd.getTargetNamespace());
            }
        }
    }

    protected boolean editPartnerLink(DefaultMutableTreeNode selNode) {
        PartnerLinkDialog dlg;
        PartnerLinks pls;
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)selNode.getUserObject();
        PartnerLink link = (PartnerLink)explorerNode.m_data;
        List partnerlinksFilter = null;
        Scope scope = BPELModelUtil.getScopeForPartnerLink((Process)graphModel.getProcess(), (PartnerLink)link);
        if (scope != null && (pls = scope.getPartnerLinks()) != null) {
            partnerlinksFilter = pls.getPartnerLinks();
        }
        Iterator<PartnerLinkNode> it = graphModel.getPartnerLinkNodes().iterator();
        PartnerLinkNode node = null;
        while (it.hasNext()) {
            PartnerLinkNode n = it.next();
            if (n.getUserObject() != link) continue;
            node = n;
            break;
        }
        if (node == null) {
            node = new PartnerLinkNode();
        }
        if ((dlg = new PartnerLinkDialog(GraphUtils.getFrame((Component)this), this.m_graph, node)).edit(link, partnerlinksFilter) == 0) {
            explorerNode.m_text = link.getName();
            this.updateNodeDisplay(selNode);
            this.fireModelChanged(25, link);
            return true;
        }
        return false;
    }

    protected boolean editProperty(DefaultMutableTreeNode selNode) {
        CorrelationSetPropertyDialog dlg = new CorrelationSetPropertyDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)selNode.getUserObject();
        CorrelationSetProperty prop = (CorrelationSetProperty)explorerNode.m_data;
        String origName = prop.getName();
        if (dlg.edit(prop) != 0) {
            return false;
        }
        prop = dlg.getCorrelationSetProperty();
        try {
            BPELXmlModel mainModel = this.m_graph.getBPELXmlModel();
            PropertyModel propModel = mainModel.getPropertyModel();
            propModel.removeProperty(origName);
            propModel.saveProperty(prop);
            explorerNode.m_text = prop.getName();
            this.updateNodeDisplay(selNode);
            this.fireModelChanged(9, prop);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)BPELStringTranslator.formatString("ERROR", e.getMessage()), (int)0);
            return false;
        }
    }

    protected boolean editVariable(DefaultMutableTreeNode selNode) {
        Variables vars;
        List varList = null;
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent().getParent();
        ExplorerTreeNode node = (ExplorerTreeNode)parent.getUserObject();
        Activity activity = (Activity)node.m_data;
        if (!activity.isEditable()) {
            String xpath = BPELModelUtil.getXPathForActivity((Activity)activity);
            GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.formatString("ACTIVITY_IS_NOT_EDITABLE", xpath), (int)0);
            return false;
        }
        VariableCreationDialog dlg = new VariableCreationDialog(GraphUtils.getFrame((Component)this), this.m_graph);
        ExplorerTreeNode explorerNode = (ExplorerTreeNode)selNode.getUserObject();
        Variable v = (Variable)explorerNode.m_data;
        String oldName = v.getName();
        if (activity instanceof Scope && (vars = ((Scope)activity).getVariables()) != null) {
            varList = vars.getVariables();
        }
        if (dlg.edit(activity, v, varList) != 0) {
            return false;
        }
        explorerNode.m_text = v.getName();
        this.updateNodeDisplay(selNode);
        this.fireModelChanged(26, v);
        return true;
    }

    public DefaultMutableTreeNode findActivityNode(Activity activity) {
        if (this.m_activitiesNode.getChildCount() > 0) {
            return this.searchActivityNode((DefaultMutableTreeNode)this.m_activitiesNode.getChildAt(0), activity);
        }
        return null;
    }

    private DefaultMutableTreeNode searchActivityNode(DefaultMutableTreeNode root, Activity activity) {
        ActivityInfo info;
        Activity testActivity;
        if (activity == null || root == null) {
            return null;
        }
        ExplorerTreeNode activityNode = (ExplorerTreeNode)root.getUserObject();
        if (activityNode.m_data instanceof ActivityInfo && (testActivity = (info = (ActivityInfo)activityNode.m_data).getActivity()) == activity) {
            return root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = this.searchActivityNode((DefaultMutableTreeNode)root.getChildAt(i), activity);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public DefaultMutableTreeNode findPartnerLinkNode(PartnerLink link) {
        return this.searchForPartnerLinkNode(this.m_partnerLinksNode, link.getName());
    }

    private DefaultMutableTreeNode searchForPartnerLinkNode(DefaultMutableTreeNode root, String name) {
        String linkName = null;
        if (root == null || name == null) {
            return null;
        }
        ExplorerTreeNode partnerLinkNode = (ExplorerTreeNode)root.getUserObject();
        if (partnerLinkNode != null && partnerLinkNode.m_type == 14) {
            PartnerLink pl = (PartnerLink)partnerLinkNode.m_data;
            if (pl != null) {
                linkName = pl.getName();
            }
            if (linkName != null && name.equals(linkName)) {
                return root;
            }
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = this.searchForPartnerLinkNode((DefaultMutableTreeNode)root.getChildAt(i), name);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    protected void addNamespaceToProcess(MessageType type) {
        List parts = type.getParts();
        if (parts == null || parts.size() == 0) {
            return;
        }
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process process = graphModel.getProcess();
        for (MessagePart part : parts) {
            if (part.getQName() == null || part.getQName().getNamespaceURI() == null) continue;
            process.addNamespace(part.getQName().getNamespaceURI());
        }
    }

    protected void handleWSDLFileAdded() {
        if (!this.getUpdateGUIOnModelChanges()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ExplorerTree.this.refreshNode(1);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void handleNodeChanged(final int nodeID) {
        if (!this.getUpdateGUIOnModelChanges()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ExplorerTree.this.refreshNode(nodeID);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected boolean checkActivityInsertionMenu(Object src) {
        boolean bValidate = true;
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process process = graphModel.getProcess();
        if (src == this.m_insertIntoInvokeItem) {
            GraphNode n = ModelBuilder.createGraphNode(100, process, bValidate);
            n.addChildNode((Node)new PortNode(1));
            n.addChildNode((Node)new PortNode(1));
            this.insertActivityInto((Node)n, this.getSelectedActivity());
        } else if (src == this.m_insertIntoAssignItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(109, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoReplyItem) {
            GraphNode n = ModelBuilder.createGraphNode(113, process, bValidate);
            n.addChildNode((Node)new PortNode(1));
            n.addChildNode((Node)new PortNode(1));
            this.insertActivityInto((Node)n, this.getSelectedActivity());
        } else if (src == this.m_insertIntoReceiveItem) {
            GraphNode n = ModelBuilder.createGraphNode(101, process, bValidate);
            n.addChildNode((Node)new PortNode(0));
            n.addChildNode((Node)new PortNode(0));
            this.insertActivityInto((Node)n, this.getSelectedActivity());
        } else if (src == this.m_insertIntoThrowItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(121, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoTerminateItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(118, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoTransformItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(133, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoWaitItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(112, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoEmptyItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(119, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoCompensateItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(120, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoScopeItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(102, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoSequenceItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(103, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoSwitchItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(104, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoFlowItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(108, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoFlowNItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(134, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoPickItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(114, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertIntoWhileItem) {
            this.insertActivityInto((Node)ModelBuilder.createGraphNode(117, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeInvokeItem) {
            GraphNode n = ModelBuilder.createGraphNode(100, process, bValidate);
            n.addChildNode((Node)new PortNode(1));
            n.addChildNode((Node)new PortNode(1));
            this.insertActivityBefore((Node)n, this.getSelectedActivity());
        } else if (src == this.m_insertBeforeAssignItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(109, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeReplyItem) {
            GraphNode n = ModelBuilder.createGraphNode(113, process, bValidate);
            n.addChildNode((Node)new PortNode(1));
            n.addChildNode((Node)new PortNode(1));
            this.insertActivityBefore((Node)n, this.getSelectedActivity());
        } else if (src == this.m_insertBeforeReceiveItem) {
            GraphNode n = ModelBuilder.createGraphNode(101, process, bValidate);
            n.addChildNode((Node)new PortNode(0));
            n.addChildNode((Node)new PortNode(0));
            this.insertActivityBefore((Node)n, this.getSelectedActivity());
        } else if (src == this.m_insertBeforeThrowItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(121, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeTransformItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(133, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeTerminateItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(118, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeWaitItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(112, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeEmptyItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(119, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeCompensateItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(120, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeScopeItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(102, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeSequenceItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(103, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeSwitchItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(104, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeFlowItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(108, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeFlowNItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(134, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforePickItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(114, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertBeforeWhileItem) {
            this.insertActivityBefore((Node)ModelBuilder.createGraphNode(117, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterInvokeItem) {
            GraphNode n = ModelBuilder.createGraphNode(100, process, bValidate);
            n.addChildNode((Node)new PortNode(1));
            n.addChildNode((Node)new PortNode(1));
            this.insertActivityAfter((Node)n, this.getSelectedActivity());
        } else if (src == this.m_insertAfterAssignItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(109, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterReplyItem) {
            GraphNode n = ModelBuilder.createGraphNode(113, process, bValidate);
            n.addChildNode((Node)new PortNode(1));
            n.addChildNode((Node)new PortNode(1));
            this.insertActivityAfter((Node)n, this.getSelectedActivity());
        } else if (src == this.m_insertAfterReceiveItem) {
            GraphNode n = ModelBuilder.createGraphNode(101, process, bValidate);
            n.addChildNode((Node)new PortNode(0));
            n.addChildNode((Node)new PortNode(0));
            this.insertActivityAfter((Node)n, this.getSelectedActivity());
        } else if (src == this.m_insertAfterThrowItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(121, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterTerminateItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(118, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterTransformItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(133, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterWaitItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(112, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterEmptyItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(119, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterCompensateItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(120, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterScopeItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(102, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterSequenceItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(103, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterSwitchItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(104, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterFlowItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(108, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterFlowNItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(134, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterPickItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(114, process, bValidate), this.getSelectedActivity());
        } else if (src == this.m_insertAfterWhileItem) {
            this.insertActivityAfter((Node)ModelBuilder.createGraphNode(117, process, bValidate), this.getSelectedActivity());
        }
        return false;
    }

    protected void insertActivityAfter(Node newNode, Activity a) {
        if (a == null || newNode == null) {
            return;
        }
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Node graphNode = graphModel.getNodeForActivity(a);
        if (graphNode != null) {
            Node parentNode = graphNode.getParentNode();
            ContainerActivity parentActivity = (ContainerActivity)parentNode.getUserObject();
            if (!parentActivity.isEditable()) {
                String xpath = BPELModelUtil.getXPathForActivity((Activity)parentActivity);
                GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.formatString("ACTIVITY_IS_NOT_EDITABLE", xpath), (int)0);
                return;
            }
            ArrayList childLst = new ArrayList();
            childLst.addAll(parentActivity.getActivityList());
            int index = childLst.indexOf(a);
            DroppableBranchNode droppableParent = (DroppableBranchNode)parentNode;
            int selectedIndex = parentNode.indexOf(graphNode);
            if (selectedIndex == -1 || selectedIndex == parentNode.getChildCount() - 1) {
                return;
            }
            Node prevNode = parentNode.getChildNode(selectedIndex + 1);
            if (prevNode.getNodeType() != 0) {
                return;
            }
            Activity activity = (Activity)newNode.getUserObject();
            for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
                BPELGraphPanePopupHandlerPlugin popupPlugin = plugin.getBPELGraphPanePopupHandlerPlugin();
                if (popupPlugin == null || popupPlugin.canInsertActivity(this.m_graph, (Activity)parentActivity, activity)) continue;
                return;
            }
            if (!this.sequenceNeeded(parentNode, newNode, index + 1)) {
                try {
                    parentActivity.insertActivity(selectedIndex / 2 + 1, activity);
                }
                catch (Exception e) {
                    GraphUtils.displayError((Component)this, (Throwable)e);
                    return;
                }
                graphModel.insertChildNode((Node)droppableParent, newNode, selectedIndex + 1);
            }
        }
    }

    protected boolean sequenceNeeded(Node parentGraphNode, Node newNode, int index) {
        DefaultMutableTreeNode parentJTreeNode = (DefaultMutableTreeNode)this.getSelectedTreeNode().getParent();
        ContainerActivity parentActivity = (ContainerActivity)parentGraphNode.getUserObject();
        Activity newActivity = (Activity)newNode.getUserObject();
        boolean bInsert = false;
        if (parentActivity instanceof FlowN) {
            bInsert = true;
        } else if (parentActivity instanceof Scope) {
            bInsert = true;
        } else if (parentActivity instanceof OnMessage) {
            bInsert = true;
        } else if (parentActivity instanceof OnMessage) {
            bInsert = true;
        } else if (parentActivity instanceof OnAlarm) {
            bInsert = true;
        } else if (parentActivity instanceof While) {
            bInsert = true;
        } else if (parentActivity instanceof Catch) {
            bInsert = true;
        } else if (parentActivity instanceof CatchAll) {
            bInsert = true;
        } else if (parentActivity instanceof SwitchCase) {
            bInsert = true;
        }
        if (bInsert) {
            List oldList = parentActivity.getActivityList();
            if (oldList.size() != 1) {
                return false;
            }
            ArrayList<Activity> childLst = new ArrayList<Activity>();
            childLst.addAll(oldList);
            if (index >= 0) {
                childLst.add(index, newActivity);
            } else {
                childLst.add(0, newActivity);
            }
            Process p = ((BPELGraphModel)this.m_graph.getModel()).getProcess();
            Sequence seqImpl = (Sequence)BPELParser.createImplementation(Sequence.class);
            seqImpl.createDOMElement(p.getDOMElement().getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            seqImpl.setName(BPELModelUtil.generateUniqueName((Process)p, (String)"Sequence", Sequence.class));
            try {
                for (Activity oldActivity : oldList) {
                    parentActivity.deleteActivity(oldActivity);
                }
                if (childLst != null) {
                    for (Activity childActivity : childLst) {
                        seqImpl.addActivity(childActivity);
                    }
                }
                parentActivity.addActivity((Activity)seqImpl);
            }
            catch (Exception e) {
                GraphUtils.displayError((Component)this, (Throwable)e);
                return false;
            }
            ArrayList<Node> currentChildGraphNodes = new ArrayList<Node>();
            for (Node n : parentGraphNode.getChildren()) {
                if (n instanceof DropNode) continue;
                currentChildGraphNodes.add(n);
            }
            SequenceNode seqNode = (SequenceNode)ModelBuilder.createGraphNode(103, p, true);
            seqNode.setUserObject(seqImpl);
            if (parentGraphNode instanceof DroppableBranchNode) {
                ((DroppableBranchNode)parentGraphNode).clearChildren();
                ((DroppableBranchNode)parentGraphNode).addToEndOfBranch((Node)seqNode);
            } else {
                System.err.println("ERROR: Parent is not DroppableBranchNode!!");
            }
            Iterator activityIt = seqImpl.getActivities();
            while (activityIt.hasNext()) {
                Activity a = (Activity)activityIt.next();
                Iterator graphNodeIt = currentChildGraphNodes.iterator();
                Node activityGraphNode = null;
                while (graphNodeIt.hasNext()) {
                    Node node = (Node)graphNodeIt.next();
                    if (a != node.getUserObject()) continue;
                    activityGraphNode = node;
                    break;
                }
                if (activityGraphNode == null) {
                    int nodeID = ModelBuilder.getNodeIDForActivity(a);
                    activityGraphNode = ModelBuilder.createGraphNode(nodeID, p, true);
                    activityGraphNode.setUserObject((Object)a);
                }
                if (activityGraphNode == null) continue;
                seqNode.addToEndOfBranch(activityGraphNode);
            }
            BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
            graphModel.fireGraphNodesInserted(parentGraphNode, new NodeInfo[0]);
            parentJTreeNode.removeAllChildren();
            this.populateChildActivitiesNode(parentJTreeNode, parentActivity);
            this.fireNodeStructureChanged(parentJTreeNode);
            return true;
        }
        return false;
    }

    protected void insertActivityInto(Node newNode, Activity a) {
        if (a == null || newNode == null) {
            return;
        }
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Node graphNode = graphModel.getNodeForActivity(a);
        if (graphNode != null) {
            if (!(graphNode instanceof DroppableBranchNode)) {
                return;
            }
            DroppableBranchNode droppableParent = (DroppableBranchNode)graphNode;
            ContainerActivity parentActivity = (ContainerActivity)droppableParent.getUserObject();
            if (!parentActivity.isEditable()) {
                String xpath = BPELModelUtil.getXPathForActivity((Activity)parentActivity);
                GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.formatString("ACTIVITY_IS_NOT_EDITABLE", xpath), (int)0);
                return;
            }
            try {
                Activity activity = (Activity)newNode.getUserObject();
                for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
                    BPELGraphPanePopupHandlerPlugin popupPlugin = plugin.getBPELGraphPanePopupHandlerPlugin();
                    if (popupPlugin == null || popupPlugin.canInsertActivity(this.m_graph, (Activity)parentActivity, activity)) continue;
                    return;
                }
                parentActivity.insertActivity(0, activity);
            }
            catch (Exception e) {
                GraphUtils.displayError((Component)this, (Throwable)e);
                return;
            }
            graphModel.insertChildNode((Node)droppableParent, newNode, 0);
        }
    }

    protected void insertActivityBefore(Node newNode, Activity a) {
        if (a == null || newNode == null) {
            return;
        }
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Node graphNode = graphModel.getNodeForActivity(a);
        if (graphNode != null) {
            Node parentNode = graphNode.getParentNode();
            ContainerActivity parentActivity = (ContainerActivity)parentNode.getUserObject();
            if (!parentActivity.isEditable()) {
                String xpath = BPELModelUtil.getXPathForActivity((Activity)parentActivity);
                GraphUtils.displayMessage((Component)this, (String)BPELStringTranslator.formatString("ACTIVITY_IS_NOT_EDITABLE", xpath), (int)0);
                return;
            }
            ArrayList childLst = new ArrayList();
            childLst.addAll(parentActivity.getActivityList());
            int index = childLst.indexOf(a);
            int selectedIndex = parentNode.indexOf(graphNode);
            if (selectedIndex < 1) {
                return;
            }
            Node prevNode = parentNode.getChildNode(selectedIndex - 1);
            if (prevNode.getNodeType() != 0) {
                return;
            }
            Activity activity = (Activity)newNode.getUserObject();
            for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
                BPELGraphPanePopupHandlerPlugin popupPlugin = plugin.getBPELGraphPanePopupHandlerPlugin();
                if (popupPlugin == null || popupPlugin.canInsertActivity(this.m_graph, (Activity)parentActivity, activity)) continue;
                return;
            }
            if (!this.sequenceNeeded(parentNode, newNode, index - 1)) {
                try {
                    parentActivity.insertActivity(selectedIndex / 2, activity);
                }
                catch (Exception e) {
                    GraphUtils.displayError((Component)this, (Throwable)e);
                    return;
                }
                graphModel.insertChildNode(parentNode, newNode, selectedIndex - 1);
            }
        }
    }

    protected boolean checkSupported(Element elem) {
        boolean isAnyElement = !SchemaBuilder.isAttributeElement((Element)elem) && SchemaBuilder.isAnyContent((Element)elem);
        boolean isAnyAttribute = SchemaBuilder.isAttributeElement((Element)elem) && SchemaBuilder.isAnyContent((Element)elem);
        boolean isAnyType = SchemaBuilder.isAnyType((Element)elem);
        if (isAnyType) {
            QName qname = new QName(elem.getAttribute("namespace"), elem.getAttribute("localName"));
            if (this.m_dynamicSchemaInfo != null && this.m_dynamicSchemaInfo.getAnyTypeQName() != null && qname.equals(this.m_dynamicSchemaInfo.getAnyTypeQName())) {
                isAnyType = false;
            }
        }
        boolean isAttributeElement = SchemaBuilder.isAttributeElement((Element)elem);
        boolean bNotSupported = isAnyElement || isAnyAttribute || isAnyType && !isAttributeElement;
        return !bNotSupported;
    }

    private void setParentNodeRefreshMenu(DefaultMutableTreeNode treenode) {
        this.m_refreshNodeID = -1;
        if (treenode != null) {
            if (treenode.isRoot()) {
                this.m_refreshMenuItem.setText(BPELStringTranslator.getString("REFRESH"));
                return;
            }
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treenode.getParent();
            if (parentNode != null && !parentNode.isRoot()) {
                this.setRefreshMenu(parentNode);
            } else {
                this.setRefreshMenu(treenode);
            }
        }
    }

    private void setRefreshMenu(DefaultMutableTreeNode treeNode) {
        while (treeNode != null) {
            if (treeNode == this.m_messageTypeNodes) {
                this.m_refreshNodeID = 1;
                this.m_refreshMenuItem.setText(BPELStringTranslator.getString("REFRESH_MESSAGE_TYPES"));
                BPELStringTranslator.setButton(this.m_refreshMenuItem, BPELStringTranslator.getString("REFRESH_MESSAGE_TYPES"));
            } else if (treeNode == this.m_activitiesNode) {
                this.m_refreshNodeID = 22;
                this.m_refreshMenuItem.setText(BPELStringTranslator.getString("REFRESH_ACTIVITY_STRUCTURE"));
                BPELStringTranslator.setButton(this.m_refreshMenuItem, BPELStringTranslator.getString("REFRESH_ACTIVITY_STRUCTURE"));
            } else if (treeNode == this.m_partnerLinksNode) {
                this.m_refreshNodeID = 13;
                this.m_refreshMenuItem.setText(BPELStringTranslator.getString("REFRESH_PARTNER_LINKS"));
                BPELStringTranslator.setButton(this.m_refreshMenuItem, BPELStringTranslator.getString("REFRESH_PARTNER_LINKS"));
            } else if (treeNode == this.m_variablesNode) {
                this.m_refreshNodeID = 0;
                this.m_refreshMenuItem.setText(BPELStringTranslator.getString("REFRESH_VARIABLES"));
                BPELStringTranslator.setButton(this.m_refreshMenuItem, BPELStringTranslator.getString("REFRESH_VARIABLES"));
            } else if (treeNode == this.m_correlationsNode) {
                this.m_refreshNodeID = 9;
                this.m_refreshMenuItem.setText(BPELStringTranslator.getString("REFRESH_CORRELATION_SETS"));
                BPELStringTranslator.setButton(this.m_refreshMenuItem, BPELStringTranslator.getString("REFRESH_CORRELATION_SETS"));
            } else if (treeNode == this.m_propertiesNode) {
                this.m_refreshNodeID = 17;
                this.m_refreshMenuItem.setText(BPELStringTranslator.getString("REFRESH_PROPERTIES"));
                BPELStringTranslator.setButton(this.m_refreshMenuItem, BPELStringTranslator.getString("REFRESH_PROPERTIES"));
            } else if (treeNode == this.m_propertyAliasesNode) {
                this.m_refreshNodeID = 18;
                this.m_refreshMenuItem.setText(BPELStringTranslator.getString("REFRESH_PROPERTY_ALIASES"));
                BPELStringTranslator.setButton(this.m_refreshMenuItem, BPELStringTranslator.getString("REFRESH_PROPERTY_ALIASES"));
            } else if (treeNode == this.m_projectSchemasNode) {
                this.m_refreshNodeID = 12;
                this.m_refreshMenuItem.setText(BPELStringTranslator.getString("REFRESH_PROJECT_SCHEMAS"));
                BPELStringTranslator.setButton(this.m_refreshMenuItem, BPELStringTranslator.getString("REFRESH_PROJECT_SCHEMAS"));
            }
            treeNode = (DefaultMutableTreeNode)treeNode.getParent();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.handleKeyEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    protected void handleKeyEvent(KeyEvent e) {
        int code;
        Object src = e.getSource();
        if (src == this.m_tree && (code = e.getKeyCode()) == 127 && this.getAllowEditing()) {
            this.handleDelete();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (this.checkActivityInsertionMenu(src)) {
            return;
        }
        if (src == this.m_createBtn || src == this.m_createMenuItem) {
            this.handleCreate();
        } else if (src == this.m_addBtn || src == this.m_addMenuItem) {
            this.handleAdd();
        } else if (src == this.m_showDetailsCB) {
            ExplorerTreeNode explorerNode = this.getSelectedExplorerTreeNode();
            if (explorerNode.m_type == 20) {
                explorerNode.storeData((Object)"EXPANDED", (Object)this.m_showDetailsCB.isSelected());
            }
            explorerNode.setShowDetails(this.m_showDetailsCB.isSelected());
            this.setExplorerTreeCellRenderer();
        } else if (src == this.m_detailsItem) {
            this.m_showDetailsCB.doClick();
        } else if (src == this.m_deleteBtn || src == this.m_removeMenuItem) {
            this.handleDelete();
        } else if (src == this.m_editBtn || src == this.m_editMenuItem) {
            this.handleEdit();
        } else if (src == this.m_filterBtn) {
            this.handleFilter();
        } else if (src == this.m_refreshBtn) {
            this.m_refreshNodeID = -1;
            this.handleRefresh();
        } else if (src == this.m_expandChildrenMenuItem) {
            this.handleExpandChildren();
        } else if (src == this.m_refreshMenuItem) {
            this.handleRefresh();
        } else if (src == this.m_searchBtn || src == this.m_searchItem) {
            this.handleSearch();
        } else if (src == this.m_addCatchBranchMenuItem) {
            this.handleAddCatchBranch();
        } else if (src == this.m_exceptionToClipboardItem) {
            this.handleCopyExceptionToClipBoard();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object src = e.getSource();
        if (src == this.m_tree) {
            this.updateButtons();
        }
    }

    public void modelChanged(ProcessEvent evt) {
        if (evt.getSource() == this) {
            return;
        }
        switch (evt.getID()) {
            case 17: {
                this.handleWSDLFileAdded();
                break;
            }
            case 15: 
            case 16: {
                this.handleNodeChanged(12);
                break;
            }
            case 0: 
            case 1: {
                this.handleNodeChanged(0);
                break;
            }
            case 7: 
            case 8: {
                this.handleNodeChanged(9);
                break;
            }
            case 9: 
            case 10: {
                this.handleNodeChanged(17);
                break;
            }
            case 11: 
            case 12: {
                this.handleNodeChanged(18);
                break;
            }
        }
    }

    class MyTree
    extends DraggableJTree {
        MyTree() {
        }

        public String getSelectedValue() {
            ExplorerTreeNode data = ExplorerTree.this.getSelectedExplorerTreeNode();
            if (data != null) {
                return data.m_text;
            }
            return "";
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (!ExplorerTree.this.getAllowEditing()) {
                Rectangle bounds = this.getVisibleRect();
                GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)bounds, (Color)new Color(192, 192, 192), (float)0.35f);
            }
        }
    }

    class PopupTriggerAction
    extends AbstractAction {
        PopupTriggerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = ExplorerTree.this.m_tree.getSelectionPath();
            if (path != null) {
                Rectangle r = ExplorerTree.this.m_tree.getPathBounds(path);
                ExplorerTree.this.handlePopupTrigger(new MouseEvent(ExplorerTree.this, 0, 0L, 64, r.x, r.y, 1, true, 0));
            }
        }
    }

    class TreeExpansionHandler
    implements TreeExpansionListener {
        TreeExpansionHandler() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            DefaultMutableTreeNode parentNode;
            ExplorerTreeNode explorerTreeNode;
            Object node = event.getPath().getLastPathComponent();
            if (node instanceof DefaultMutableTreeNode && (explorerTreeNode = (ExplorerTreeNode)(parentNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof ExplorerTreeDataSource) {
                final ExplorerTreeDataSource ds = (ExplorerTreeDataSource)explorerTreeNode;
                if (parentNode.getChildCount() > 0 && parentNode.getChildAt(0) instanceof DummyNode) {
                    Thread runner = new Thread(){

                        @Override
                        public void run() {
                            parentNode.removeAllChildren();
                            DefaultMutableTreeNode[] nodes = ds.getChildNodes();
                            if (nodes != null) {
                                for (DefaultMutableTreeNode node : nodes) {
                                    parentNode.add(node);
                                }
                            }
                            ExplorerTree.this.fireNodeStructureChanged(parentNode);
                        }
                    };
                    runner.start();
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

