/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.pm.gui.explorer.ActivityInfo;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeCellRenderer;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeSearchResult;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ExplorerSearchResultCellRenderer
extends JLabel
implements ListCellRenderer {
    protected Font m_font = UIManager.getFont("Tree.font");
    protected Font m_boldFont = new Font(this.m_font.getFontName(), 1, this.m_font.getSize());

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String s = "";
        if (value != null) {
            s = value.toString();
        }
        this.setText(s);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setOpaque(true);
        if (value instanceof ExplorerTreeSearchResult) {
            ExplorerTreeSearchResult r = (ExplorerTreeSearchResult)value;
            DefaultMutableTreeNode n = r.getTreeNode();
            ExplorerTreeNode explorerNode = (ExplorerTreeNode)n.getUserObject();
            switch (explorerNode.m_type) {
                case 14: {
                    this.setIcon(ImageCache.getIcon("partner_link_node"));
                    break;
                }
                case 4: {
                    this.setIcon(ImageCache.getIcon("variable16"));
                    break;
                }
                case 2: {
                    this.setIcon(ImageCache.getIcon("message_type_node"));
                    break;
                }
                case 11: {
                    this.setIcon(ImageCache.getIcon("correlation_set_node"));
                    break;
                }
                case 16: {
                    ActivityInfo info = (ActivityInfo)explorerNode.m_data;
                    Activity a = info.getActivity();
                    this.setIcon(ExplorerTreeCellRenderer.getActivityIcon(a));
                    break;
                }
                default: {
                    this.setIcon(ImageCache.getIcon("find.png"));
                }
            }
        }
        return this;
    }
}

