/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import javax.swing.Icon;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ExplorerFilterItem {
    protected int m_type;
    protected Boolean m_value;

    public ExplorerFilterItem(int type, Boolean value) {
        this.m_type = type;
        this.m_value = value;
    }

    public Icon getIcon() {
        switch (this.m_type) {
            case 0: {
                return ImageCache.getIcon("variable16");
            }
            case 1: {
                return ImageCache.getIcon("messagetype16");
            }
            case 12: {
                return ImageCache.getIcon("schema_node");
            }
            case 17: {
                return ImageCache.getIcon("property_node");
            }
            case 18: {
                return ImageCache.getIcon("property_alias_node");
            }
            case 9: {
                return ImageCache.getIcon("correlation_set_node");
            }
            case 22: {
                return ImageCache.getIcon("bpel_structure_node");
            }
            case 13: {
                return ImageCache.getIcon("partner_link_node");
            }
        }
        return null;
    }

    public String getName() {
        switch (this.m_type) {
            case 0: {
                return BPELStringTranslator.getString("EDITOR_EXP_VAR", "Variables");
            }
            case 1: {
                return BPELStringTranslator.getString("COLLAXALAF_MESSAGE_TYPES", "Message Types");
            }
            case 12: {
                return BPELStringTranslator.getString("EDITOR_EXP_PRJ_SCHEMA", "Project Schemas");
            }
            case 17: {
                return BPELStringTranslator.getString("EDITOR_EXP_PROP", "Properties");
            }
            case 18: {
                return BPELStringTranslator.getString("EDITOR_EXP_PROP_ALS", "Property Aliases");
            }
            case 9: {
                return BPELStringTranslator.getString("EDITOR_EXP_CR_SETS", "Correlation Sets");
            }
            case 22: {
                return BPELStringTranslator.getString("EDITOR_EXP_ACT_STRU", "Activity Structure");
            }
            case 13: {
                return BPELStringTranslator.getString("EDITOR_EXP_PL", "Partner Links");
            }
        }
        return " ";
    }

    public int getMask() {
        switch (this.m_type) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 12: {
                return 16;
            }
            case 17: {
                return 64;
            }
            case 18: {
                return 128;
            }
            case 9: {
                return 8;
            }
            case 22: {
                return 32;
            }
            case 13: {
                return 4;
            }
        }
        return -1;
    }

    public int getType() {
        return this.m_type;
    }

    public Boolean getValue() {
        return this.m_value;
    }

    public void setValue(Boolean value) {
        this.m_value = value;
    }
}

