/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CheckBoxCellRenderer;
import oracle.tip.tools.ide.common.ui.SortableTable;
import oracle.tip.tools.ide.common.ui.SortedTableHeaderRenderer;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerFilterItem;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerFilterTableModel;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTree;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ExplorerFilterDialog
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected JTable m_table;
    protected ExplorerTree m_explorerTree;
    protected int m_retVal = 1;
    protected List m_filter;

    public ExplorerFilterDialog(JFrame f, ExplorerTree explorer) {
        super(f, BPELStringTranslator.getString("EDITOR_EXP_FILTER_DLG"), true);
        this.m_explorerTree = explorer;
        this.createAndLayoutControls();
    }

    public int display(List filter) {
        this.m_filter = filter;
        this.loadTable();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void loadTable() {
        ExplorerFilterTableModel model = (ExplorerFilterTableModel)((Object)this.m_table.getModel());
        for (ExplorerFilterItem item : this.m_filter) {
            model.getData().addElement(item);
        }
        model.refresh();
    }

    protected void createAndLayoutControls() {
        ExplorerFilterTableModel model = new ExplorerFilterTableModel();
        this.m_table = new JTable((TableModel)((Object)model));
        this.m_table.setRowHeight(18);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        SortableTable st = new SortableTable(){

            public void sortColumn(int col, boolean bAscending) {
                ExplorerFilterDialog.this.sortTable(col, bAscending);
            }

            public JTable getJTable() {
                return ExplorerFilterDialog.this.m_table;
            }

            public int getSortingColumn() {
                return 1;
            }

            public boolean getSortAscending() {
                return true;
            }
        };
        SortedTableHeaderRenderer header = new SortedTableHeaderRenderer(st);
        TableColumnModel colModel = this.m_table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            col.setHeaderRenderer((TableCellRenderer)header);
            if (i == 0) {
                col.setMinWidth(30);
                col.setMaxWidth(30);
                col.setCellRenderer(new ImageColumnTableCellRenderer());
            } else if (i == 2) {
                col.setCellRenderer((TableCellRenderer)new CheckBoxCellRenderer());
                JCheckBox cb = new JCheckBox();
                cb.setHorizontalAlignment(0);
                col.setCellEditor(new DefaultCellEditor(cb));
            }
            col.setPreferredWidth(120);
        }
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)GraphUtils.getScrollPane((Component)this.m_table), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(10, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(330, 285);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void sortTable(int col, final boolean bAscending) {
        if (col == 1 || col == 0) {
            ExplorerFilterTableModel model = (ExplorerFilterTableModel)((Object)this.m_table.getModel());
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    ExplorerFilterItem d1 = (ExplorerFilterItem)o1;
                    ExplorerFilterItem d2 = (ExplorerFilterItem)o2;
                    String s1 = d1.getName();
                    String s2 = d2.getName();
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        } else if (col == 2) {
            ExplorerFilterTableModel model = (ExplorerFilterTableModel)((Object)this.m_table.getModel());
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    ExplorerFilterItem d1 = (ExplorerFilterItem)o1;
                    ExplorerFilterItem d2 = (ExplorerFilterItem)o2;
                    String s1 = Boolean.toString(d1.getValue());
                    String s2 = Boolean.toString(d2.getValue());
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        }
    }

    protected void handleOK() {
        ExplorerFilterTableModel model = (ExplorerFilterTableModel)((Object)this.m_table.getModel());
        Vector v = model.getData();
        for (int i = 0; i < v.size(); ++i) {
            ExplorerFilterItem item = (ExplorerFilterItem)v.elementAt(i);
            this.m_explorerTree.setShowBranch(item.getMask(), item.getValue());
        }
        this.m_explorerTree.fireNodeStructureChanged((DefaultMutableTreeNode)this.m_explorerTree.getTree().getModel().getRoot());
        this.m_retVal = 0;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }

    public class ImageColumnTableCellRenderer
    extends DefaultTableCellRenderer {
        public ImageColumnTableCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setText("");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof ExplorerFilterItem) {
                ExplorerFilterItem item = (ExplorerFilterItem)value;
                this.setIcon(item.getIcon());
            }
            return this;
        }
    }
}

