/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;

public class CheckBoxTreeCellRendererPanel
extends JPanel {
    protected JCheckBox m_checkBox;
    protected List m_iconLst;
    protected List m_textInfoLst;
    protected int m_iconSpace = 3;
    protected int m_checkBoxSpacing = 3;
    protected int m_insets = 1;
    protected int m_textXStart = 0;
    protected int m_iconToTextSpace = 3;
    protected boolean m_bSelected = false;
    protected boolean m_bHasFocus = false;
    protected Color m_bgColor = Color.white;

    public CheckBoxTreeCellRendererPanel() {
        this.setBackground(Color.white);
        this.m_checkBox = new JCheckBox();
        this.m_checkBox.setMargin(new Insets(0, 0, 0, 2));
        this.m_checkBox.setOpaque(false);
        this.m_checkBox.setSelected(true);
        this.setLayout(null);
        this.add(this.m_checkBox);
    }

    public void setHasFocus(boolean bHasFocus) {
        this.m_bHasFocus = bHasFocus;
    }

    public void setSelected(boolean bSelected) {
        this.m_bSelected = bSelected;
    }

    public void updateBackground() {
        Color bgClr = Color.white;
        if (this.m_bSelected) {
            bgClr = this.m_bHasFocus ? UIManager.getColor("Tree.selectionBackground") : Color.cyan;
        }
        this.m_bgColor = bgClr;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Rectangle r = this.m_checkBox.getBounds();
        g.setColor(this.m_bgColor);
        g.fillRect(this.m_textXStart - this.m_iconToTextSpace, 0, this.getWidth() - this.m_textXStart + this.m_iconToTextSpace, this.getHeight());
        int x = r.x + r.width + this.m_checkBoxSpacing;
        for (Icon icon : this.m_iconLst) {
            if (icon == null) {
                return;
            }
            int iconHeight = icon.getIconHeight();
            int yOffset = Math.max(0, (this.getHeight() - iconHeight) / 2);
            icon.paintIcon(this, g, x, yOffset);
            x += icon.getIconWidth();
            x += this.m_iconSpace;
        }
        x += this.m_iconToTextSpace;
        for (TextInfo info : this.m_textInfoLst) {
            if (info.getText() == null || info.getText().length() == 0) continue;
            g.setFont(info.getFont());
            Color c = this.m_bSelected ? (this.m_bHasFocus ? UIManager.getColor("Tree.selectionForeground") : Color.black) : info.getColor();
            g.setColor(c);
            int strWidth = GraphUtils.getStringWidth((Font)info.getFont(), (String)info.getText());
            int yOffset = Math.max(0, (this.getHeight() - GraphUtils.getFontHeight((Font)info.getFont())) / 2);
            g.drawString(info.getText(), x, GraphUtils.getFontAscent((Font)info.getFont()) + yOffset);
            x += strWidth;
        }
    }

    @Override
    public void doLayout() {
        Dimension d = this.m_checkBox.getPreferredSize();
        this.m_checkBox.setBounds(this.m_insets, this.m_insets, d.width, d.height);
        this.m_textXStart = this.m_insets + d.width;
        int h = d.height;
        for (Icon icon : this.m_iconLst) {
            if (icon == null) continue;
            this.m_textXStart += icon.getIconWidth() + this.m_iconSpace;
            h = Math.max(h, icon.getIconHeight());
        }
        this.m_textXStart += this.m_iconSpace + this.m_iconToTextSpace;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.m_checkBox.getPreferredSize();
        int w = d.width + this.m_checkBoxSpacing;
        int h = d.height;
        for (Icon icon : this.m_iconLst) {
            if (icon == null) continue;
            w += icon.getIconWidth();
            w += this.m_iconSpace;
            h = Math.max(h, icon.getIconHeight());
        }
        w += this.m_iconToTextSpace;
        for (TextInfo info : this.m_textInfoLst) {
            if (!Helper.hasValue((String)info.getText())) continue;
            int strWidth = GraphUtils.getStringWidth((Font)info.getFont(), (String)info.getText());
            w += strWidth;
            h = Math.max(h, GraphUtils.getFontHeight((Font)info.getFont()));
        }
        return new Dimension(2 * this.m_insets + w, 2 * this.m_insets + h);
    }

    public List getIconLst() {
        return this.m_iconLst;
    }

    public void setIconLst(List iconLst) {
        this.m_iconLst = iconLst;
    }

    public List getTextInfoLst() {
        return this.m_textInfoLst;
    }

    public void setTextInfoLst(List textInfoLst) {
        this.m_textInfoLst = textInfoLst;
    }

    public JCheckBox getCheckBox() {
        return this.m_checkBox;
    }

    public void setCheckBox(JCheckBox checkBox) {
        this.m_checkBox = checkBox;
    }
}

