/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import javax.swing.Icon;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ActivityInfo {
    protected Activity m_activity;
    protected ValidationReport m_validationReport;
    protected Icon m_icon;
    protected boolean m_bEditable;

    public ActivityInfo(Activity a) {
        this.m_activity = a;
        this.m_validationReport = this.generateValidationReport(a);
        this.m_bEditable = a.isEditable();
        this.m_icon = ExplorerTreeCellRenderer.getActivityIcon(a);
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public String getWarning() {
        if (this.hasWarnings()) {
            return "<html><body><b>" + BPELStringTranslator.getString("WARNING") + "</b>" + this.m_validationReport.toString() + "</body></html>";
        }
        return null;
    }

    public boolean hasWarnings() {
        return this.m_validationReport != null && (this.m_validationReport.hasErrors() || this.m_validationReport.hasWarnings());
    }

    public Activity getActivity() {
        return this.m_activity;
    }

    public void setActivity(Activity activity) {
        this.m_activity = activity;
    }

    public boolean isSensored() {
        return this.m_activity.getSensors().size() > 0;
    }

    private ValidationReport generateValidationReport(Activity a) {
        this.m_validationReport = null;
        Process process = BPELModelUtil.getParentProcess((Activity)a);
        if (process != null) {
            return a.getValidationReport(new ValidationContext(process), false);
        }
        return null;
    }
}

