/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.event.NodeEditorListener;
import oracle.tip.tools.ide.common.graph.model.GraphNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.AbstractActivityNodeEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.ApplyCancelPanel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;

public class ActivityEditorDialog
extends BPELBaseDialog
implements NodeEditorListener {
    protected AbstractActivityNodeEditor m_nodeEditor;
    protected Component m_comp;
    protected BPELGraphPane m_graph;
    protected Activity m_activity;

    public ActivityEditorDialog(JFrame f, AbstractActivityNodeEditor nodeEditor, Activity a, BPELGraphPane graph) {
        super(f, "", true);
        String title = "Editing " + BPELParser.getActivityTypeName((Activity)a);
        if (Helper.hasValue((String)a.getName())) {
            title = title + " - " + a.getName();
        }
        this.setTitle(title);
        this.m_activity = a;
        this.m_graph = graph;
        this.m_nodeEditor = nodeEditor;
        this.m_nodeEditor.addNodeEditorListener(this);
        this.layoutControls();
    }

    protected void handleCancel() {
        this.dispose();
    }

    public void display() {
        this.m_nodeEditor.loadData();
        this.setVisible(true);
    }

    protected void layoutControls() {
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        GraphNode node = ModelBuilder.createGraphNode(ModelBuilder.getNodeIDForActivity(this.m_activity), model.getProcess(), true);
        node.setUserObject((Object)this.m_activity);
        this.m_comp = this.m_nodeEditor.getNodeEditorComponent((GraphPane)this.m_graph, (Node)node);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)c, (Component)this.m_comp, (int)0, (int)0, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        this.setSize(this.m_nodeEditor.getPreferredEditorSize());
        this.setLocationRelativeTo(this.getParent());
    }

    public void editingStopped(ChangeEvent e) {
        this.dispose();
    }

    protected void helpInvoked() {
        if (this.m_comp != null && this.m_comp instanceof ApplyCancelPanel) {
            ((ApplyCancelPanel)this.m_comp).handleHelp();
        } else {
            super.helpInvoked();
        }
    }

    public void editingCanceled(ChangeEvent e) {
        this.dispose();
    }
}

