/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.explorer;

import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchCase;
import oracle.tip.tools.ide.common.bpelparser.iface.SwitchOtherwise;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.ActivityInfo;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;

public class ActivityBrowser
extends ExplorerTreeDialog {
    public ActivityBrowser(JFrame f, BPELGraphPane graph) {
        super(f, BPELStringTranslator.getString("EDITOR_ACT_BROWSER"), graph, 32);
    }

    public Activity getSelectedActivity() {
        Object obj = this.m_processExplorer.getExplorerTree().getSelectedNodeData();
        if (obj instanceof ActivityInfo) {
            ActivityInfo info = (ActivityInfo)obj;
            return info.getActivity();
        }
        return null;
    }

    @Override
    protected void createControls() {
        super.createControls();
        this.m_okBtn.setVisible(true);
        this.m_okBtn.setEnabled(false);
        this.m_processExplorer.getExplorerTree().showToolBar(false);
        this.m_processExplorer.getExplorerTree().showDetailsCheckBox(false);
        this.m_processExplorer.getExplorerTree().getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object obj = ActivityBrowser.this.m_processExplorer.getExplorerTree().getSelectedNodeData();
                ActivityBrowser.this.m_okBtn.setEnabled(false);
                if (obj instanceof ActivityInfo) {
                    ActivityInfo info = (ActivityInfo)obj;
                    if (info.m_activity instanceof Process) {
                        return;
                    }
                    if (info.m_activity instanceof SwitchCase) {
                        return;
                    }
                    if (info.m_activity instanceof SwitchOtherwise) {
                        return;
                    }
                    ActivityBrowser.this.m_okBtn.setEnabled(info.m_activity != null);
                }
            }
        });
    }

    @Override
    protected void helpInvoked() {
        HelpSystem.showHelp((Window)((Object)this), this.m_processExplorer, "bpmjdev_activity_browser");
    }
}

