/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.xpathselection;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.AbstractActivityNodeEditor;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.tx.gui.tree.MapperTree;
import oracle.tip.tools.ide.tx.gui.tree.MapperTreeNode;
import oracle.tip.tools.ide.tx.gui.tree.TreePanel;
import oracle.tip.tools.ide.tx.gui.util.GUIUtils;
import org.w3c.dom.Document;

public class XPathSelectionDialog
extends BPELBaseDialog
implements ActionListener,
PropertyChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected int m_retVal = 1;
    protected Document m_doc;
    protected TreePanel m_treePanel;
    protected BPELGraphPane m_graph;

    public XPathSelectionDialog(JFrame f, BPELGraphPane graph, Document doc) {
        super(f, BPELStringTranslator.getString("SELECT_XPATH"), true);
        this.m_graph = graph;
        this.m_doc = doc;
        this.createControls();
        this.layoutControls();
        this.loadControls(null);
    }

    protected void loadControls(String xPath) {
        this.m_treePanel.openDocument("", "", this.m_doc);
        this.m_treePanel.addPropertyChangeListener((PropertyChangeListener)this);
        MapperTree tree = this.m_treePanel.getTree();
        if (tree != null) {
            tree.setRootVisible(false);
        }
        this.updateButtons(false);
    }

    protected void createControls() {
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        this.m_treePanel = new TreePanel(1, null);
        JScrollPane sp = this.m_treePanel.getScrollPane();
        JScrollPane scroller = new JScrollPane();
        sp.setBorder(scroller.getBorder());
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_treePanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(AbstractActivityNodeEditor.PREF_DIM);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    public int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    public String getSelectedXPath() {
        if (this.m_treePanel == null || this.m_treePanel.getMapperTree() == null) {
            return null;
        }
        TreePath currentSelection = this.m_treePanel.getMapperTree().getSelectionPath();
        if (currentSelection != null) {
            MapperTreeNode mapperNode = (MapperTreeNode)currentSelection.getLastPathComponent();
            return GUIUtils.getCleanXPath((MapperTreeNode)mapperNode);
        }
        return null;
    }

    protected void updateButtons(boolean b) {
        this.m_okBtn.setEnabled(b);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name != null && "m_tree_node_selected".equals(name)) {
            this.updateButtons(true);
        }
    }
}

