/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.variablexpathbuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeDataSource;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.BpelNSResolver;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.NSResolverSource;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.utils.MapUtils;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.XPathScrollPane;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTree;
import oracle.tip.tools.ide.pm.gui.explorer.ProcessExplorer;
import oracle.tip.tools.ide.pm.gui.explorer.VariableMessagePartExplorerTreeNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VariableXPathBuilderPanel
extends JPanel
implements TreeSelectionListener,
NSResolverSource {
    public static final String TREE_SELECTION_OCCURRED = "TREE_SELECTION_OCCURRED";
    protected JLabel m_xpathLbl;
    protected JScrollPane m_xpathScrollPane;
    protected ProcessExplorer m_processExplorer;
    protected BPELGraphPane m_graph;
    protected XPathEditorPane m_xpathBuilder;
    protected NamespaceResolver m_nsResolver;

    protected VariableXPathBuilderPanel() {
    }

    public VariableXPathBuilderPanel(BPELGraphPane graph) {
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
        this.updateControls();
    }

    public Document getUIDOM() {
        ExplorerTreeNode n = this.m_processExplorer.getExplorerTree().getSelectedExplorerTreeNode();
        if (n != null && n.m_type == 28) {
            return (Document)n.getData((Object)"UI_DOM_KEY");
        }
        return null;
    }

    public void load(Activity a) throws Exception {
        final ExplorerTree tree = this.m_processExplorer.getExplorerTree();
        tree.loadExplorer(a, false);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                tree.expandVariableContainerNodes();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void selectVariable(String varName, Activity a) {
        BPELGraphPane graph = this.m_processExplorer.getExplorerTree().getGraphPane();
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process p = model.getProcess();
        List parentScopes = BPELModelUtil.getParentScopes((Activity)a);
        Variable var = BPELModelUtil.findVariable((ValidationContext)new ValidationContext(p), (List)parentScopes, (String)varName);
        this.m_processExplorer.getExplorerTree().selectVariable(var);
    }

    public void setXPath(String s) {
        this.m_xpathBuilder.setText(s);
    }

    public boolean selectVariableXPathNode(String varName, List qnames, Activity a) {
        BPELGraphPane graph = this.m_processExplorer.getExplorerTree().getGraphPane();
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process p = model.getProcess();
        List parentScopes = BPELModelUtil.getParentScopes((Activity)a);
        Variable var = BPELModelUtil.findVariable((ValidationContext)new ValidationContext(p), (List)parentScopes, (String)varName);
        ExplorerTree tree = this.m_processExplorer.getExplorerTree();
        DefaultMutableTreeNode varTreeNode = tree.findNodeOfTypeAndData(tree.m_variablesNode, var, 4);
        if (varTreeNode == null) {
            return false;
        }
        int childCnt = varTreeNode.getChildCount();
        if (childCnt == 1 && varTreeNode.getChildAt(0) instanceof DummyNode) {
            Object userObj = varTreeNode.getUserObject();
            if (userObj instanceof ExplorerTreeDataSource) {
                ExplorerTreeDataSource ds = (ExplorerTreeDataSource)userObj;
                DefaultMutableTreeNode[] children = ds.getChildNodes();
                DefaultMutableTreeNode dummyNode = (DefaultMutableTreeNode)varTreeNode.getChildAt(0);
                dummyNode.removeFromParent();
                DefaultMutableTreeNode xpathNode = null;
                for (int i = 0; i < children.length; ++i) {
                    DefaultMutableTreeNode child = children[i];
                    varTreeNode.add(child);
                    if (xpathNode != null) continue;
                    xpathNode = this.resolveXPathNode(child, qnames);
                }
                tree.fireNodeStructureChanged(varTreeNode);
                if (xpathNode != null) {
                    tree.selectNode(xpathNode);
                    return true;
                }
            }
        } else {
            for (int i = 0; i < childCnt; ++i) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)varTreeNode.getChildAt(i);
                Object userObj = n.getUserObject();
                if (!(userObj instanceof ExplorerTreeNode)) continue;
                ExplorerTreeNode explorerNode = (ExplorerTreeNode)userObj;
                if (explorerNode.m_type != 28) continue;
            }
        }
        return false;
    }

    protected DefaultMutableTreeNode resolveXPathNode(DefaultMutableTreeNode treeNode, List qnames) {
        if (qnames == null) {
            return null;
        }
        DefaultMutableTreeNode lastMatch = null;
        DefaultMutableTreeNode[] searchNodes = new DefaultMutableTreeNode[]{treeNode};
        for (QName qname : qnames) {
            DefaultMutableTreeNode n = this.findQNameNode(searchNodes, qname);
            if (n == null) {
                return lastMatch;
            }
            lastMatch = n;
            searchNodes = new DefaultMutableTreeNode[lastMatch.getChildCount()];
            for (int i = 0; i < lastMatch.getChildCount(); ++i) {
                searchNodes[i] = (DefaultMutableTreeNode)lastMatch.getChildAt(i);
            }
        }
        return lastMatch;
    }

    protected DefaultMutableTreeNode findQNameNode(DefaultMutableTreeNode[] searchNodes, QName qname) {
        String local = qname.getLocalPart();
        for (int i = 0; i < searchNodes.length; ++i) {
            DefaultMutableTreeNode searchNode = searchNodes[i];
            Object userObj = searchNode.getUserObject();
            if (!(userObj instanceof ExplorerTreeNode)) continue;
            ExplorerTreeNode explorerNode = (ExplorerTreeNode)userObj;
            if (explorerNode.m_type != 28) continue;
            Element elem = (Element)explorerNode.m_data;
            String ns = elem.getAttribute("namespace");
            String localName = elem.getAttribute("localName");
            if (localName != null && localName.equals(local) && ns != null && ns.equalsIgnoreCase(qname.getNamespaceURI())) {
                return searchNode;
            }
            String schemaType = elem.getAttribute("schemaType");
            if (schemaType == null || !schemaType.equalsIgnoreCase("xsd:choice") && !schemaType.equalsIgnoreCase("xsd:sequence") && !schemaType.equalsIgnoreCase("xsd:all")) continue;
            DefaultMutableTreeNode[] nweSearchNodes = null;
            nweSearchNodes = new DefaultMutableTreeNode[searchNode.getChildCount()];
            for (int k = 0; k < searchNode.getChildCount(); ++k) {
                nweSearchNodes[k] = (DefaultMutableTreeNode)searchNode.getChildAt(k);
            }
            DefaultMutableTreeNode node = this.findQNameNode(nweSearchNodes, qname);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public boolean selectVariablePart(String varName, String partName, Activity a, String xpath) {
        BPELGraphPane graph = this.m_processExplorer.getExplorerTree().getGraphPane();
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process p = model.getProcess();
        List parentScopes = BPELModelUtil.getParentScopes((Activity)a);
        Variable var = BPELModelUtil.findVariable((ValidationContext)new ValidationContext(p), (List)parentScopes, (String)varName);
        ExplorerTree tree = this.m_processExplorer.getExplorerTree();
        DefaultMutableTreeNode varTreeNode = tree.findNodeOfTypeAndData(tree.m_variablesNode, var, 4);
        if (varTreeNode != null) {
            int childCnt = varTreeNode.getChildCount();
            if (childCnt == 1 && varTreeNode.getChildAt(0) instanceof DummyNode) {
                Object userObj = varTreeNode.getUserObject();
                if (userObj instanceof ExplorerTreeDataSource) {
                    ExplorerTreeDataSource ds = (ExplorerTreeDataSource)userObj;
                    DefaultMutableTreeNode[] children = ds.getChildNodes();
                    DefaultMutableTreeNode dummyNode = (DefaultMutableTreeNode)varTreeNode.getChildAt(0);
                    dummyNode.removeFromParent();
                    DefaultMutableTreeNode partNode = null;
                    DefaultMutableTreeNode xpathNode = null;
                    for (int i = 0; i < children.length; ++i) {
                        List l;
                        DefaultMutableTreeNode childNode;
                        ExplorerTreeNode explorerNode;
                        Document doc;
                        VariableMessagePartExplorerTreeNode src;
                        DefaultMutableTreeNode[] childNodes;
                        MessagePart part;
                        Object obj;
                        DefaultMutableTreeNode child = children[i];
                        varTreeNode.add(child);
                        if (partNode != null || !((obj = child.getUserObject()) instanceof ExplorerTreeNode)) continue;
                        ExplorerTreeNode tn = (ExplorerTreeNode)obj;
                        if (tn.m_type == 27 && (part = (MessagePart)tn.m_data).getName().equals(partName)) {
                            partNode = child;
                        }
                        if (partNode == null || xpath == null || !(obj instanceof VariableMessagePartExplorerTreeNode) || (childNodes = (src = (VariableMessagePartExplorerTreeNode)((Object)obj)).getChildNodes()) == null || childNodes.length <= 0 || (doc = (Document)(explorerNode = (ExplorerTreeNode)(childNode = childNodes[0]).getUserObject()).getData((Object)"UI_DOM_KEY")) == null || (l = MapUtils.getElementsByInstanceXPath((Document)doc, (String)xpath)).size() != 1) continue;
                        partNode.removeAllChildren();
                        for (int j = 0; j < childNodes.length; ++j) {
                            DefaultMutableTreeNode node = childNodes[j];
                            partNode.add(node);
                        }
                        xpathNode = this.getTreeNodeForElement(childNodes, (Element)l.get(0));
                    }
                    tree.fireNodeStructureChanged(varTreeNode);
                    if (xpathNode != null) {
                        tree.selectNode(xpathNode);
                        return true;
                    }
                    if (partNode != null) {
                        tree.selectNode(partNode);
                        return true;
                    }
                }
            } else {
                for (int i = 0; i < childCnt; ++i) {
                    MessagePart part;
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)varTreeNode.getChildAt(i);
                    Object userObj = n.getUserObject();
                    if (!(userObj instanceof ExplorerTreeNode)) continue;
                    ExplorerTreeNode explorerNode = (ExplorerTreeNode)userObj;
                    if (explorerNode.m_type != 27 || !(part = (MessagePart)explorerNode.m_data).getName().equals(partName)) continue;
                    tree.selectNode(n);
                    return true;
                }
            }
        }
        return false;
    }

    protected DefaultMutableTreeNode getTreeNodeForElement(DefaultMutableTreeNode[] childNodes, Element elem) {
        DefaultMutableTreeNode childNode;
        int i;
        for (i = 0; i < childNodes.length; ++i) {
            childNode = childNodes[i];
            Object userObj = childNode.getUserObject();
            if (!(userObj instanceof ExplorerTreeNode)) continue;
            ExplorerTreeNode explorerNode = (ExplorerTreeNode)userObj;
            if (explorerNode.m_type != 28 || explorerNode.m_data != elem) continue;
            return childNode;
        }
        for (i = 0; i < childNodes.length; ++i) {
            childNode = childNodes[i];
            for (int j = 0; j < childNode.getChildCount(); ++j) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)childNode.getChildAt(j);
                DefaultMutableTreeNode result = this.getTreeNodeForElement(new DefaultMutableTreeNode[]{n}, elem);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public ProcessExplorer getProcessExplorer() {
        return this.m_processExplorer;
    }

    public Variable getVariable() {
        return this.m_processExplorer.getExplorerTree().getVariableContext();
    }

    public MessagePart getPart() {
        return this.m_processExplorer.getExplorerTree().getMessagePartContext();
    }

    public String getXPath() {
        return this.m_xpathBuilder.getText();
    }

    protected void createControls() {
        this.m_xpathLbl = new JLabel();
        BPELStringTranslator.setLabel(this.m_xpathLbl, (Component)this.m_xpathBuilder, "&XPath:");
        this.m_xpathBuilder = new XPathEditorPane(2);
        this.m_xpathScrollPane = new XPathScrollPane((Component)this.m_xpathBuilder, 21, 31);
        this.m_xpathBuilder.setEditable(true);
        this.m_processExplorer = new ProcessExplorer();
        ExplorerTree tree = this.m_processExplorer.getExplorerTree();
        tree.setMask(1);
        tree.showFilterButton(false);
        tree.showRootNode(false);
        tree.showToolBar(false);
        tree.getTree().getSelectionModel().addTreeSelectionListener(this);
        this.m_processExplorer.setGraphPane(this.m_graph);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)this.m_processExplorer, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_xpathLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_xpathScrollPane, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    protected void setXPathEnabled(boolean bEnable) {
        this.m_xpathLbl.setEnabled(bEnable);
        this.m_xpathBuilder.setForeground(bEnable ? Color.black : Color.lightGray);
        this.m_xpathScrollPane.setBorder(new LineBorder(bEnable ? Color.black : Color.lightGray));
        this.m_xpathBuilder.setEnabled(bEnable);
    }

    protected void updateControls() {
        this.setXPathEnabled(false);
        ExplorerTreeNode n = this.m_processExplorer.getExplorerTree().getSelectedExplorerTreeNode();
        if (n != null) {
            ExplorerTree tree = this.m_processExplorer.getExplorerTree();
            if (n.m_type == 28) {
                Document uiDOM = (Document)n.getData((Object)"UI_DOM_KEY");
                this.m_nsResolver = (MapperNSResolver)n.getData((Object)"RESOLVER_KEY");
                if (uiDOM != null && this.m_nsResolver != null) {
                    this.m_xpathBuilder.initializeEditorPane(uiDOM, "", this.m_nsResolver);
                }
                this.setXPathEnabled(true);
                String xpath = tree.getSelectedVariableXPath();
                if (Helper.hasValue((String)xpath)) {
                    this.m_xpathBuilder.setText(xpath);
                    this.m_xpathBuilder.setToolTipText(xpath);
                }
            } else if (n.m_type == 27) {
                this.setXPathEnabled(true);
                this.m_xpathBuilder.setText("");
                this.m_xpathBuilder.setToolTipText("");
            } else if (n.m_type == 4) {
                this.setXPathEnabled(true);
                this.m_xpathBuilder.setText("");
                this.m_xpathBuilder.setToolTipText("");
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.updateControls();
        this.firePropertyChange(TREE_SELECTION_OCCURRED, null, this);
    }

    public NamespaceResolver getNSResolver() {
        return this.m_nsResolver;
    }

    public void setNSResolver(NamespaceResolver nsResolver) {
        this.m_nsResolver = nsResolver;
    }

    public void saveCachedNS() {
        BpelNSResolver.saveCachedNS((NSResolverSource)this);
    }
}

