/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.variablexpathbuilder;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.utils.MessagePart;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.variablexpathbuilder.VariableXPathBuilderPanel;
import oracle.tip.tools.ide.pm.gui.dialogs.variablexpathbuilder.VariableXPathBuilderValidator;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import org.w3c.dom.Document;

public class VariableXPathBuilder
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected int m_retVal = 1;
    protected BPELGraphPane m_graph;
    protected VariableXPathBuilderPanel m_builderPanel;
    protected VariableXPathBuilderValidator m_validator;

    public VariableXPathBuilder(JFrame f, BPELGraphPane graph) {
        super(f, BPELStringTranslator.getString("VARIABLE_XPATH_BUILDER"), true);
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
        this.updateControls();
    }

    public VariableXPathBuilderPanel getBuilderPanel() {
        return this.m_builderPanel;
    }

    public VariableXPathBuilderValidator getValidator() {
        return this.m_validator;
    }

    public void setValidator(VariableXPathBuilderValidator validator) {
        this.m_validator = validator;
    }

    public void enableVariableEditing(boolean bEnable) {
        this.m_builderPanel.getProcessExplorer().getExplorerTree().setAllowEditing(bEnable);
    }

    public Document getUIDOM() {
        return this.m_builderPanel.getUIDOM();
    }

    public Variable getVariable() {
        return this.m_builderPanel.getVariable();
    }

    public MessagePart getPart() {
        return this.m_builderPanel.getPart();
    }

    public String getXPath() {
        return this.m_builderPanel.getXPath();
    }

    public int display(final Activity a) {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    VariableXPathBuilder.this.m_builderPanel.load(a);
                }
                catch (Exception e) {
                    GraphUtils.displayMessage((Component)((Object)VariableXPathBuilder.this), (String)e.getMessage(), (int)0);
                }
                finally {
                    VariableXPathBuilder.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createControls() {
        this.m_builderPanel = new VariableXPathBuilderPanel(this.m_graph);
        this.m_builderPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String s = evt.getPropertyName();
                if (s.equals("TREE_SELECTION_OCCURRED")) {
                    VariableXPathBuilder.this.updateControls();
                }
            }
        });
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void updateControls() {
        Variable v = this.m_builderPanel.getVariable();
        if (v == null) {
            this.m_okBtn.setEnabled(false);
            return;
        }
        this.m_okBtn.setEnabled(true);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_builderPanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)2, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 10, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 480);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            if (this.m_validator != null) {
                try {
                    this.m_validator.validate(this.getVariable(), this.getPart(), this.getXPath());
                }
                catch (Exception e1) {
                    GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)e1.getMessage(), (int)2);
                    return;
                }
            }
            this.m_builderPanel.saveCachedNS();
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void helpInvoked() {
        this.handleHelp(this.m_builderPanel);
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }
}

