/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTree;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ValidationFlatViewTreeCellRenderer
extends ExplorerTreeCellRenderer {
    public static final String ICON_LIST_KEY = "ICON_LIST_KEY";
    public static final String TEXTINFO_LIST_KEY = "TEXTINFO_LIST_KEY";

    public ValidationFlatViewTreeCellRenderer(ExplorerTree explorerTree) {
        super(explorerTree);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon folderIcon;
        this.m_bHasError = false;
        this.m_bHasFocus = hasFocus;
        this.m_bSelected = selected;
        this.m_iconLst.clear();
        this.m_textLst.clear();
        Icon icon = folderIcon = expanded ? ImageCache.getIcon("folder_open_node") : ImageCache.getIcon("folder_close_node");
        if (!(value instanceof DefaultMutableTreeNode)) {
            return this;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObj = node.getUserObject();
        if (userObj instanceof ExplorerTreeNode) {
            String text = userObj.toString();
            TextInfo info = this.createTextInfo(text, this.m_font, Color.black);
            this.m_textLst.add(info);
            ExplorerTreeNode tn = (ExplorerTreeNode)userObj;
            switch (tn.m_type) {
                case 30: 
                case 32: 
                case 33: {
                    this.m_iconLst.add(folderIcon);
                    break;
                }
                case 16: {
                    this.m_textLst.clear();
                    List l = (List)tn.getData((Object)TEXTINFO_LIST_KEY);
                    if (l != null) {
                        this.m_textLst.addAll(l);
                    }
                    if ((l = (List)tn.getData((Object)ICON_LIST_KEY)) == null) break;
                    this.m_iconLst.addAll(l);
                    break;
                }
                case 14: {
                    ExplorerTreeNode tnode = (ExplorerTreeNode)userObj;
                    PartnerLink link = (PartnerLink)tnode.m_data;
                    this.m_iconLst.add(ImageCache.getIcon("partner_link_node"));
                    ValidationReport report = link.getValidationReport(null, false);
                    if (report != null && report.getState() == 1) {
                        this.m_bHasError = true;
                    }
                    this.m_textLst.clear();
                    TextInfo info1 = this.createTextInfo(BPELStringTranslator.getString("EDITOR_VALID_EXP_PL"), this.m_font, Color.black);
                    this.m_textLst.add(info1);
                    String name = userObj.toString();
                    if (name == null) break;
                    TextInfo info2 = this.createTextInfo(userObj.toString(), this.m_boldFont, Color.black);
                    this.m_textLst.add(info2);
                }
            }
        }
        if (this.m_iconLst.size() == 0) {
            this.m_iconLst.add(folderIcon);
        }
        return this;
    }
}

