/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.common.bpeldesigner.models.explorer.ExplorerTreeNode;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.CompensationHandler;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.EventHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.FaultHandlers;
import oracle.tip.tools.ide.common.bpelparser.iface.Handler;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReportItem;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidatorCallback;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser.ValidationBrowser;
import oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser.ValidationBrowserPanel;
import oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser.ValidationFlatViewTreeCellRenderer;
import oracle.tip.tools.ide.pm.gui.explorer.ActivityInfo;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTree;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeCellRenderer;
import oracle.tip.tools.ide.pm.gui.explorer.ProcessExplorer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ValidationExplorer
extends JPanel
implements ActionListener,
ValidatorCallback {
    protected JTree m_tree;
    protected ToolBar m_toolBar;
    protected JButton m_treeBtn;
    protected JButton m_flatBtn;
    protected JButton m_searchBtn;
    protected JButton m_validateBtn;
    protected ProcessExplorer m_processExplorer;
    protected BPELGraphPane m_graph;
    protected DefaultMutableTreeNode m_root;
    protected Validatable m_activity;
    protected JLabel m_errorsCntLbl;
    protected JLabel m_warningsCntLbl;
    protected ValidationBrowserPanel m_browser;
    protected DefaultTreeModel m_model;
    protected boolean m_isTree = true;
    protected int m_errorCnt = 0;
    protected int m_warningCnt = 0;
    protected Font m_font = UIManager.getFont("Tree.font");
    protected Font m_boldFont = this.m_font.deriveFont(1);
    protected Font m_italicFont = this.m_font.deriveFont(2);

    public ValidationExplorer(ValidationBrowserPanel browser, BPELGraphPane p, Validatable activity) {
        this.m_browser = browser;
        this.m_graph = p;
        this.m_activity = activity;
        this.createControls();
        this.layoutControls();
    }

    public void enableUserInput(boolean bEnable) {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof ValidationBrowser); c = c.getParent()) {
        }
        if (c instanceof ValidationBrowser) {
            ValidationBrowser b = (ValidationBrowser)((Object)c);
            b.enableUserInput(bEnable);
        }
    }

    public JTree getTree() {
        return this.m_tree;
    }

    public void showToolBar(boolean bShow) {
        this.m_toolBar.setVisible(bShow);
    }

    public ExplorerTreeNode getSelectedExplorerTreeNode() {
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)obj;
        return (ExplorerTreeNode)treeNode.getUserObject();
    }

    public int getSelectedNodeType() {
        ExplorerTreeNode n = this.getSelectedExplorerTreeNode();
        if (n == null) {
            return -1;
        }
        return n.m_type;
    }

    public Object getSelectedNodeData() {
        ExplorerTreeNode n = this.getSelectedExplorerTreeNode();
        if (n == null) {
            return null;
        }
        return n.m_data;
    }

    protected void createControls() {
        this.m_treeBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("directorytreeview16"));
        this.m_treeBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_VALID_EXP_VIEW_ACT_H"));
        this.m_treeBtn.addActionListener(this);
        this.m_treeBtn.setEnabled(false);
        this.m_treeBtn.setMnemonic(BPELStringTranslator.getMnemonic("EDITOR_VALID_EXP_VIEW_ACT_H_Mnemonic"));
        this.m_flatBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("flat_view16"));
        this.m_flatBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_VALID_EXP_FLAT_ACT_H"));
        this.m_flatBtn.addActionListener(this);
        this.m_flatBtn.setMnemonic(BPELStringTranslator.getMnemonic("EDITOR_VALID_EXP_FLAT_ACT_H_Mnemonic"));
        this.m_searchBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("find.png"));
        this.m_searchBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_EXP_SEARCH_BTN"));
        this.m_searchBtn.addActionListener(this);
        this.m_toolBar = new ToolBar();
        this.m_toolBar.setBorderInsets(new Insets(0, 0, 0, 0));
        this.m_toolBar.add((Component)this.m_searchBtn);
        this.m_toolBar.add((Component)this.m_treeBtn);
        this.m_toolBar.add((Component)this.m_flatBtn);
        this.m_processExplorer = new ProcessExplorer();
        ExplorerTree explorerTree = this.m_processExplorer.getExplorerTree();
        this.m_processExplorer.getExplorerTree().showToolBar(false);
        if (this.m_activity == null) {
            explorerTree.setMask(36);
        } else if (this.m_activity instanceof PartnerLink) {
            explorerTree.setMask(4);
        } else {
            explorerTree.setMask(32);
        }
        explorerTree.showFilterButton(false);
        explorerTree.showRootNode(false);
        explorerTree.showDetailsCheckBox(false);
        this.m_processExplorer.setGraphPane(this.m_graph);
        this.m_tree = this.m_processExplorer.getExplorerTree().getTree();
        this.m_root = new DefaultMutableTreeNode(new ExplorerTreeNode("", 7, null));
        this.m_errorsCntLbl = new JLabel(" ");
        this.m_warningsCntLbl = new JLabel(" ");
        this.m_validateBtn = new JButton(BPELStringTranslator.getString("EDITOR_VALID_EXP_VAL"));
        BPELStringTranslator.setButton(this.m_validateBtn, BPELStringTranslator.getString("EDITOR_VALID_EXP_VAL_RES"));
        this.m_validateBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_VALID_EXP_RUN_VAL"));
        this.m_validateBtn.addActionListener(this);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        JPanel statusPnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)statusPnl, (Component)this.m_errorsCntLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)statusPnl, (Component)this.m_warningsCntLbl, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)statusPnl, (Component)this.m_validateBtn, (int)2, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)this, (Component)new JLabel(BPELStringTranslator.getString("EDITOR_VALID_EXP_ACTS")), (int)0, (int)0, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)this, (Component)this.m_toolBar, (int)0, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(2, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)this, (Component)this.m_processExplorer, (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        UIHelper.addComponent((Container)this, (Component)statusPnl, (int)0, (int)2, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    public void loadExplorer(Validatable a) {
        if (this.m_isTree) {
            this.m_processExplorer.getExplorerTree().setExplorerTreeCellRenderer();
            this.loadTreeExplorer(a);
        } else {
            this.m_tree.setCellRenderer((TreeCellRenderer)((Object)new ValidationFlatViewTreeCellRenderer(this.m_processExplorer.getExplorerTree())));
            this.loadFlatExplorer(a);
        }
        this.validateProcess();
        this.startFocusTimer();
    }

    protected void startFocusTimer() {
        ActionListener lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidationExplorer.this.m_validateBtn.requestFocus();
            }
        };
        Timer t = new Timer(300, lst);
        t.setRepeats(false);
        t.start();
    }

    public void loadFlatExplorer(Validatable a) {
        this.m_root.removeAllChildren();
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        try {
            if (a != null) {
                if (a instanceof Activity) {
                    ArrayList activityLst = new ArrayList();
                    BPELModelUtil.retrieveAllActivities((Activity)((Activity)a), activityLst);
                    this.addErrorChildActivities(this.m_root, activityLst, p);
                } else if (a instanceof PartnerLink) {
                    this.buildInvalidPartnerLinkNodes(a);
                }
            } else {
                this.addAllErrorActivities(this.m_root, BPELModelUtil.getAllActivities((Scope)p), p);
            }
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    ValidationExplorer.this.m_tree.setModel(new DefaultTreeModel(ValidationExplorer.this.m_root));
                    ValidationExplorer.this.m_tree.setRootVisible(false);
                    ValidationExplorer.this.m_processExplorer.getExplorerTree().expandEntireTree();
                    if (ValidationExplorer.this.m_root.getChildCount() > 0) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)ValidationExplorer.this.m_root.getFirstChild();
                        ValidationExplorer.this.m_processExplorer.getExplorerTree().selectNode(node);
                    }
                }
            };
            SwingUtilities.invokeLater(runner);
        }
        catch (Exception e) {
            e.printStackTrace();
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)this), (String)("ERROR:" + e.getMessage()), (int)0);
        }
    }

    protected void addErrorChildActivities(DefaultMutableTreeNode root, List activityLst, Process p) {
        for (Activity activity : activityLst) {
            ValidationReport report = activity.getValidationReport(new ValidationContext(p), false);
            if (report == null || report.getState() != 1) continue;
            String txt = BPELModelUtil.getTypeForActivity((Activity)activity);
            if (activity.getName() != null) {
                txt = txt + " - " + activity.getName();
            }
            ActivityInfo info = new ActivityInfo(activity);
            ExplorerTreeNode explorerNode = new ExplorerTreeNode(txt, 16, (Object)info);
            explorerNode.storeData((Object)"ICON_LIST_KEY", (Object)this.createActivityIcons(activity));
            explorerNode.storeData((Object)"TEXTINFO_LIST_KEY", (Object)this.createActivityTextInfo(activity));
            ResultData data = this.buildTreeNodeForActivity(activity, this.m_root);
            if (data.m_bExistingNode || data.m_node == null) continue;
            this.m_root.add(data.m_node);
        }
    }

    protected TextInfo createTextInfo(String s, Font f, Color c) {
        TextInfo info = new TextInfo();
        info.setText(s);
        info.setFont(f);
        info.setColor(c);
        return info;
    }

    protected List createActivityIcons(Activity a) {
        ArrayList<Icon> iconLst = new ArrayList<Icon>();
        iconLst.add(ExplorerTreeCellRenderer.getActivityIcon(a));
        BPELGraphModel graphModel = (BPELGraphModel)this.m_processExplorer.getExplorerTree().getGraphPane().getModel();
        Process p = graphModel.getProcess();
        ValidationReport report = a.getValidationReport(new ValidationContext(p), false);
        if (report != null && report.getState() == 1) {
            iconLst.add(ImageCache.getIcon("warning16_node"));
        }
        return iconLst;
    }

    protected List getXPathForActivity(Activity a) {
        ArrayList textInfoLst = new ArrayList();
        if (a == null) {
            return textInfoLst;
        }
        ArrayList<TextInfo> lst = new ArrayList<TextInfo>();
        for (Activity parent = a.getParentActivity(); parent != null; parent = parent.getParentActivity()) {
            TextInfo info = new TextInfo();
            if (parent.getName() != null) {
                info.setText(parent.getName());
                info.setFont(this.m_boldFont);
            } else {
                info.setText(BPELParser.getActivityTypeName((Activity)parent));
                info.setFont(this.m_italicFont);
            }
            info.setColor(Color.black);
            lst.add(info);
        }
        if (lst != null && lst.size() > 0) {
            for (int i = lst.size() - 1; i >= 0; --i) {
                textInfoLst.add(lst.get(i));
                textInfoLst.add(this.createTextInfo("/", this.m_font, Color.black));
            }
        }
        TextInfo info2 = new TextInfo();
        if (a.getName() != null) {
            info2.setText(a.getName());
            info2.setFont(this.m_boldFont);
        } else {
            info2.setText(BPELParser.getActivityTypeName((Activity)a));
            info2.setFont(this.m_italicFont);
        }
        info2.setColor(Color.black);
        textInfoLst.add(info2);
        textInfoLst.add(this.createTextInfo("/", this.m_font, Color.black));
        return textInfoLst;
    }

    protected List getParentXPath(Activity a) {
        ArrayList textInfoLst = new ArrayList();
        if (a == null) {
            return textInfoLst;
        }
        Activity lastParent = a;
        Activity parent = a.getParentActivity();
        ArrayList<TextInfo> lst = new ArrayList<TextInfo>();
        while (true) {
            if (parent == null) {
                Activity pa;
                Handler h;
                if (lastParent instanceof Handler) {
                    h = (Handler)lastParent;
                    pa = h.getHandlerParentActivity();
                    if (pa != null) {
                        parent = pa;
                        lastParent = pa;
                    }
                } else if (lastParent != null && (h = lastParent.getParentHandler()) != null && (pa = h.getHandlerParentActivity()) != null) {
                    parent = pa;
                    lastParent = pa;
                }
            }
            if (parent == null) break;
            TextInfo info = new TextInfo();
            if (parent.getName() != null) {
                info.setText(parent.getName());
                info.setFont(this.m_boldFont);
            } else {
                info.setText(BPELParser.getActivityTypeName((Activity)parent));
                info.setFont(this.m_italicFont);
            }
            info.setColor(Color.black);
            lst.add(info);
            lastParent = parent;
            parent = parent.getParentActivity();
        }
        if (lst != null && lst.size() > 0) {
            for (int i = lst.size() - 1; i >= 0; --i) {
                textInfoLst.add(lst.get(i));
                textInfoLst.add(this.createTextInfo("/", this.m_font, Color.black));
            }
        }
        TextInfo info2 = new TextInfo();
        if (a.getName() != null) {
            info2.setText(a.getName());
            info2.setFont(this.m_boldFont);
        } else {
            info2.setText(BPELParser.getActivityTypeName((Activity)a));
            info2.setFont(this.m_italicFont);
        }
        info2.setColor(Color.black);
        textInfoLst.add(info2);
        textInfoLst.add(this.createTextInfo("/", this.m_font, Color.black));
        return textInfoLst;
    }

    protected List createActivityTextInfo(Activity a) {
        ArrayList<TextInfo> textInfoLst = new ArrayList<TextInfo>();
        if (a == null) {
            return textInfoLst;
        }
        Activity parent = a.getParentActivity();
        textInfoLst.addAll(this.getXPathForActivity(parent));
        TextInfo info2 = new TextInfo();
        if (a.getName() != null) {
            info2.setText(a.getName());
            info2.setFont(this.m_boldFont);
        } else {
            info2.setText(BPELParser.getActivityTypeName((Activity)a));
            info2.setFont(this.m_italicFont);
        }
        info2.setColor(Color.red);
        textInfoLst.add(info2);
        return textInfoLst;
    }

    protected void addAllErrorActivities(DefaultMutableTreeNode root, List activityLst, Process p) {
        for (Activity activity : activityLst) {
            ValidationReport report = activity.getValidationReport(new ValidationContext(p), false);
            if (report == null || report.getState() != 1) continue;
            String txt = BPELModelUtil.getTypeForActivity((Activity)activity);
            if (activity.getName() != null) {
                txt = txt + " - " + activity.getName();
            }
            ActivityInfo info = new ActivityInfo(activity);
            ExplorerTreeNode explorerNode = new ExplorerTreeNode(txt, 16, (Object)info);
            explorerNode.storeData((Object)"ICON_LIST_KEY", (Object)this.createActivityIcons(activity));
            explorerNode.storeData((Object)"TEXTINFO_LIST_KEY", (Object)this.createActivityTextInfo(activity));
            ResultData data = this.buildTreeNodeForActivity(activity, this.m_root);
            if (data.m_bExistingNode || data.m_node == null) continue;
            this.m_root.add(data.m_node);
        }
        PartnerLinks links = p.getPartnerLinks();
        if (links != null) {
            for (PartnerLink pl : links.getPartnerLinks()) {
                String txt = pl.getName();
                ValidationReport report = pl.getValidationReport(new ValidationContext(p), false);
                if (report == null || report.getState() != 1) continue;
                DefaultMutableTreeNode linkNode = new DefaultMutableTreeNode(new ExplorerTreeNode(txt, 14, (Object)pl));
                this.m_root.add(linkNode);
            }
        }
    }

    protected void loadTreeExplorer(final Validatable a) {
        Runnable runner;
        DefaultMutableTreeNode node = null;
        this.m_processExplorer.loadExplorer(null);
        if (a != null) {
            node = a instanceof PartnerLink ? this.m_processExplorer.getExplorerTree().findPartnerLinkNode((PartnerLink)a) : this.m_processExplorer.getExplorerTree().findActivityNode((Activity)a);
        }
        if (node != null) {
            final DefaultMutableTreeNode rootNode = node;
            runner = new Runnable(){

                @Override
                public void run() {
                    ValidationExplorer.this.m_tree.setModel(new DefaultTreeModel(rootNode));
                    ValidationExplorer.this.m_tree.setRootVisible(true);
                    if (a != null && a instanceof PartnerLink) {
                        ValidationExplorer.this.m_processExplorer.getExplorerTree().getTree().collapseRow(0);
                    } else {
                        ValidationExplorer.this.m_processExplorer.getExplorerTree().expandEntireTree();
                    }
                    ValidationExplorer.this.m_processExplorer.getExplorerTree().selectRoot();
                }
            };
        } else {
            runner = new Runnable(){

                @Override
                public void run() {
                    ValidationExplorer.this.m_tree.setRootVisible(false);
                    DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)ValidationExplorer.this.m_tree.getModel().getRoot();
                    ValidationExplorer.this.m_processExplorer.getExplorerTree().expandEntireTree();
                    ValidationExplorer.this.m_processExplorer.getExplorerTree().selectFirstChild((DefaultMutableTreeNode)rootNode.getFirstChild());
                }
            };
        }
        SwingUtilities.invokeLater(runner);
    }

    protected DefaultMutableTreeNode buildInvalidActivityNodes(Activity a) {
        this.m_root.removeAllChildren();
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        if (a != null) {
            ValidationReport report;
            String txt = BPELModelUtil.getTypeForActivity((Activity)a);
            if (a.getName() != null) {
                txt = txt + " - " + a.getName();
            }
            if ((report = a.getValidationReport(new ValidationContext(p), false)) != null && report.getState() == 1) {
                DefaultMutableTreeNode activityNode = new DefaultMutableTreeNode(new ExplorerTreeNode(txt, 16, (Object)new ActivityInfo(a)));
                this.m_root.add(activityNode);
                if (a instanceof ContainerActivity) {
                    ContainerActivity c = (ContainerActivity)a;
                    this.populateChildActivitiesNode(p, this.m_root, c);
                }
            }
        }
        return this.m_root;
    }

    protected DefaultMutableTreeNode buildInvalidPartnerLinkNodes(Validatable pl) {
        this.m_root.removeAllChildren();
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        if (pl instanceof PartnerLink) {
            String txt = ((PartnerLink)pl).getName();
            ValidationReport report = pl.getValidationReport(new ValidationContext(p), false);
            if (report != null && report.getState() == 1) {
                DefaultMutableTreeNode linkNode = new DefaultMutableTreeNode(new ExplorerTreeNode(txt, 14, (Object)pl));
                this.m_root.add(linkNode);
            }
        }
        return this.m_root;
    }

    protected void populateChildActivitiesNode(Process p, DefaultMutableTreeNode parent, ContainerActivity parentActivity) {
        List activitiesLst = parentActivity.getActivityList();
        if (activitiesLst == null) {
            return;
        }
        for (Activity a : activitiesLst) {
            String txt = BPELModelUtil.getTypeForActivity((Activity)a);
            if (a.getName() != null) {
                txt = txt + " - " + a.getName();
            }
            ActivityInfo info = new ActivityInfo(a);
            ValidationReport report = a.getValidationReport(new ValidationContext(p), false);
            if (report != null && report.getState() == 1) {
                DefaultMutableTreeNode activityNode = new DefaultMutableTreeNode(new ExplorerTreeNode(txt, 16, (Object)info));
                parent.add(activityNode);
            }
            if (!(a instanceof ContainerActivity)) continue;
            ContainerActivity c = (ContainerActivity)a;
            this.populateChildActivitiesNode(p, parent, c);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_treeBtn) {
            this.m_isTree = true;
            this.m_processExplorer.getExplorerTree().setExplorerTreeCellRenderer();
            this.m_flatBtn.setEnabled(true);
            this.m_treeBtn.setEnabled(false);
            this.enableUserInput(false);
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ValidationExplorer.this.loadTreeExplorer(ValidationExplorer.this.m_activity);
                    }
                    finally {
                        ValidationExplorer.this.enableUserInput(true);
                    }
                }
            };
            new Thread(r).start();
        } else if (src == this.m_flatBtn) {
            this.m_isTree = false;
            this.m_tree.setCellRenderer((TreeCellRenderer)((Object)new ValidationFlatViewTreeCellRenderer(this.m_processExplorer.getExplorerTree())));
            this.m_treeBtn.setEnabled(true);
            this.m_flatBtn.setEnabled(false);
            this.enableUserInput(false);
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ValidationExplorer.this.loadFlatExplorer(ValidationExplorer.this.m_activity);
                    }
                    finally {
                        ValidationExplorer.this.enableUserInput(true);
                    }
                }
            };
            new Thread(r).start();
        } else if (src == this.m_validateBtn) {
            this.validateProcess();
        } else if (src == this.m_searchBtn) {
            this.m_processExplorer.getExplorerTree().showSearchPanel();
        }
    }

    public void clear() {
        this.m_errorCnt = 0;
        this.m_warningCnt = 0;
        this.setErrorCountLabel();
        this.setWarningCountLabel();
    }

    protected void setErrorCountLabel() {
        String text = "" + this.m_errorCnt;
        while (text.length() < 3) {
            text = text + " ";
        }
        this.m_errorsCntLbl.setText(BPELStringTranslator.formatString("EDITOR_VALID_EXP_ERRORS", text));
        Rectangle r = this.m_errorsCntLbl.getBounds();
        r.width += 10;
        this.m_errorsCntLbl.paintImmediately(r);
    }

    protected void setWarningCountLabel() {
        String text = "" + this.m_warningCnt;
        while (text.length() < 3) {
            text = text + " ";
        }
        this.m_warningsCntLbl.setText(BPELStringTranslator.formatString("EDITOR_VALID_EXP_WARNS", text));
        Rectangle r = this.m_warningsCntLbl.getBounds();
        r.width += 10;
        this.m_warningsCntLbl.paintImmediately(r);
    }

    protected synchronized void updateLabels(ValidationReport report) {
        List items = report.getReportDetails();
        if (items == null) {
            return;
        }
        for (ValidationReportItem item : items) {
            if (item.getType() == 0) {
                ++this.m_errorCnt;
                continue;
            }
            if (item.getType() != 1) continue;
            ++this.m_warningCnt;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ValidationExplorer.this.setErrorCountLabel();
                ValidationExplorer.this.setWarningCountLabel();
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void validateProcess() {
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        if (model == null) {
            return;
        }
        final Process process = model.getProcess();
        final ValidationContext ct = new ValidationContext(process);
        this.enableUserInput(false);
        final ValidationExplorer callback = this;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ValidationExplorer.this.m_activity == null) {
                        BPELModelUtil.validateProcess((Process)process, (ValidatorCallback)callback);
                    } else {
                        ValidationExplorer.this.m_errorCnt = 0;
                        ValidationExplorer.this.m_warningCnt = 0;
                        if (ValidationExplorer.this.m_activity instanceof Activity) {
                            BPELModelUtil.validateActivity((Activity)((Activity)ValidationExplorer.this.m_activity), (ValidationContext)ct, (ValidatorCallback)callback);
                        } else if (ValidationExplorer.this.m_activity instanceof PartnerLink) {
                            ValidationExplorer.this.validatePartnerLink((PartnerLink)ValidationExplorer.this.m_activity, ct, callback);
                        }
                    }
                }
                finally {
                    ValidationExplorer.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    public void validatePartnerLink(PartnerLink a, ValidationContext ct, ValidatorCallback callback) {
        ValidationReport report = a.getValidationReport(ct, true);
        if (callback != null) {
            callback.validated((Validatable)a, report);
        }
    }

    protected void forceGraphLayout() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ValidationExplorer.this.m_graph.forceImmediateLayout();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected boolean isHandlerNode(Handler h, DefaultMutableTreeNode node) {
        Object userObj = node.getUserObject();
        if (userObj instanceof ExplorerTreeNode) {
            ExplorerTreeNode tn = (ExplorerTreeNode)userObj;
            switch (tn.m_type) {
                case 30: {
                    return tn.m_data == h;
                }
                case 32: {
                    return tn.m_data == h;
                }
                case 33: {
                    ActivityInfo info = (ActivityInfo)tn.m_data;
                    return info != null && info.getActivity() == h;
                }
            }
        }
        return false;
    }

    protected DefaultMutableTreeNode searchHandlerNode(Handler h, DefaultMutableTreeNode root) {
        if (h == null || root == null) {
            return null;
        }
        if (this.isHandlerNode(h, root)) {
            return root;
        }
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            if (this.isHandlerNode(h, node)) {
                return node;
            }
            DefaultMutableTreeNode result = this.searchHandlerNode(h, node);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected DefaultMutableTreeNode getParentXPathNode(Activity a) {
        String txt = BPELModelUtil.getTypeForActivity((Activity)a);
        if (a.getName() != null) {
            txt = txt + " - " + a.getName();
        }
        ActivityInfo info = new ActivityInfo(a);
        ExplorerTreeNode explorerNode = new ExplorerTreeNode(txt, 16, (Object)info);
        explorerNode.storeData((Object)"ICON_LIST_KEY", (Object)this.createActivityIcons(a));
        explorerNode.storeData((Object)"TEXTINFO_LIST_KEY", (Object)this.getParentXPath(a));
        return new DefaultMutableTreeNode(explorerNode);
    }

    protected ResultData buildTreeNodeForActivity(Activity a, DefaultMutableTreeNode root) {
        Handler h = BPELModelUtil.getParentHandler((Activity)a);
        if (h == null) {
            DefaultMutableTreeNode activityPathNode = this.getParentXPathNode(a);
            ExplorerTreeNode tn = (ExplorerTreeNode)activityPathNode.getUserObject();
            tn.storeData((Object)"ICON_LIST_KEY", (Object)this.createActivityIcons(a));
            tn.storeData((Object)"TEXTINFO_LIST_KEY", (Object)this.createActivityTextInfo(a));
            ResultData result = new ResultData();
            result.m_bExistingNode = false;
            result.m_node = activityPathNode;
            return result;
        }
        DefaultMutableTreeNode activityPathNode = this.getParentXPathNode(a);
        ExplorerTreeNode tn = (ExplorerTreeNode)activityPathNode.getUserObject();
        tn.storeData((Object)"ICON_LIST_KEY", (Object)this.createActivityIcons(a));
        tn.storeData((Object)"TEXTINFO_LIST_KEY", (Object)this.createActivityTextInfo(a));
        DefaultMutableTreeNode handlerNode = this.searchHandlerNode(h, root);
        if (handlerNode != null) {
            handlerNode.add(activityPathNode);
            ResultData result = new ResultData();
            result.m_bExistingNode = true;
            result.m_node = handlerNode;
            return result;
        }
        ResultData result = new ResultData();
        result.m_bExistingNode = false;
        ExplorerTreeNode explorerNode = null;
        if (h instanceof FaultHandlers) {
            explorerNode = new ExplorerTreeNode("FaultHandlers", 30, (Object)h);
        } else if (h instanceof EventHandlers) {
            explorerNode = new ExplorerTreeNode(BPELStringTranslator.getString("EVENT_HANDLERS"), 32, (Object)h);
        } else if (h instanceof CompensationHandler) {
            explorerNode = new ExplorerTreeNode(BPELStringTranslator.getString("COMPENSATION_HANDLER"), 33, (Object)new ActivityInfo((Activity)((CompensationHandler)h)));
        }
        handlerNode = new DefaultMutableTreeNode(explorerNode);
        handlerNode.add(activityPathNode);
        Activity parentActivity = h.getHandlerParentActivity();
        DefaultMutableTreeNode parentNode = this.searchForActivityNode(parentActivity, root);
        if (parentNode == null) {
            parentNode = this.getParentXPathNode(parentActivity);
        } else {
            result.m_bExistingNode = true;
        }
        parentNode.add(handlerNode);
        result.m_node = parentNode;
        return result;
    }

    protected DefaultMutableTreeNode searchForActivityNode(Activity a, DefaultMutableTreeNode root) {
        if (a == null || root == null) {
            return null;
        }
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Activity activity;
            ActivityInfo info;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            ExplorerTreeNode tn = (ExplorerTreeNode)node.getUserObject();
            if (tn.m_type == 16 && (info = (ActivityInfo)tn.m_data) != null && (activity = info.getActivity()) == a) {
                return node;
            }
            DefaultMutableTreeNode result = this.searchForActivityNode(a, node);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void validated(Validatable validatedObj, ValidationReport report) {
        if (validatedObj == null || report == null) {
            return;
        }
        if (report.getState() == 0) {
            return;
        }
        this.updateLabels(report);
    }

    public void finish() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ValidationExplorer.this.setErrorCountLabel();
                ValidationExplorer.this.setWarningCountLabel();
                if (ValidationExplorer.this.m_browser != null) {
                    ValidationExplorer.this.m_browser.setStatusMessage(BPELStringTranslator.getString("EDITOR_VALID_EXP_VAL_DONE"));
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public boolean isValidationCanceled() {
        return false;
    }

    public void statusMessage(String msg) {
        if (this.m_browser != null) {
            this.m_browser.setStatusMessage(msg);
        }
    }

    public void start() {
        this.clear();
        if (this.m_browser != null) {
            this.m_browser.setStatusMessage(BPELStringTranslator.getString("EDITOR_VALID_EXP_VALING"));
        }
    }

    class ResultData {
        public boolean m_bExistingNode = false;
        public DefaultMutableTreeNode m_node;

        ResultData() {
        }
    }
}

