/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser;

import ice.storm.ContentLoader;
import ice.storm.StormBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLEditorKit;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReportItem;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser.ValidationExplorer;
import oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser.ValidationReportItemImageCellRenderer;
import oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser.ValidationReportItemTableModel;
import oracle.tip.tools.ide.pm.gui.explorer.ActivityInfo;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ValidationBrowserPanel
extends JPanel
implements PropertyChangeListener {
    public static final String VIEWPORT_NAME = "bpel-viewport";
    protected JButton m_closeBtn;
    protected JButton m_helpBtn;
    protected JTable m_table;
    protected Validatable m_activity;
    protected JTree m_tree;
    protected BPELGraphPane m_graph;
    protected JEditorPane m_detailsPane;
    protected JButton m_validateBtn;
    protected ValidationExplorer m_validationExplorer;
    protected JLabel m_statusLbl;
    protected StormBase m_iceBrowser;

    public ValidationBrowserPanel(BPELGraphPane graph, Validatable activity) {
        this.m_graph = graph;
        this.m_activity = activity;
        this.createControls();
        this.layoutControls();
        this.clearHTML();
    }

    public BPELGraphPane getGraphPane() {
        return this.m_graph;
    }

    protected void createControls() {
        this.m_iceBrowser = new StormBase();
        this.m_iceBrowser.setComponentToolkitName("swing");
        this.m_statusLbl = new JLabel(BPELStringTranslator.getString("EDITOR_VALID_BWS_READY", "Ready"));
        this.m_validateBtn = new JButton(BPELStringTranslator.getString("EDITOR_VALID_BWS_VAL", "Validate"));
        BPELStringTranslator.setButton(this.m_validateBtn, BPELStringTranslator.getString("EDITOR_VALID_BWS_VAL", "*&Validate"));
        this.m_validateBtn.setToolTipText(BPELStringTranslator.getString("EDITOR_VALID_BWS_VAL_TIP", "Validate BPEL Process"));
        this.m_detailsPane = new JEditorPane();
        this.m_detailsPane.setEditorKit(new HTMLEditorKit());
        this.m_detailsPane.setEditable(false);
        this.m_validationExplorer = new ValidationExplorer(this, this.m_graph, this.m_activity);
        this.m_validationExplorer.showToolBar(true);
        this.m_tree = this.m_validationExplorer.getTree();
        this.m_tree.addTreeSelectionListener(new TreeNodeSelectionListener());
        this.m_validationExplorer.m_processExplorer.getExplorerTree().addPropertyChangeListener(this);
        ValidationReportItemTableModel model = new ValidationReportItemTableModel();
        Vector vec = new Vector();
        model.setData(vec);
        this.m_table = new JTable((TableModel)((Object)model));
        this.m_table.setSelectionMode(0);
        TableColumnModel colModel = this.m_table.getColumnModel();
        colModel.getColumn(0).setMinWidth(30);
        colModel.getColumn(0).setMaxWidth(30);
        colModel.getColumn(0).setCellRenderer(new ValidationReportItemImageCellRenderer());
        colModel.getColumn(1).setPreferredWidth(40);
        colModel.getColumn(1).setWidth(40);
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ValidationBrowserPanel.this.handleTableSelection();
            }
        });
    }

    protected void handleTableSelection() {
        int row = this.m_table.getSelectedRow();
        if (row == -1) {
            return;
        }
        ValidationReportItemTableModel model = (ValidationReportItemTableModel)((Object)this.m_table.getModel());
        ValidationReportItem item = (ValidationReportItem)model.getRowData(row);
        String s = item.getDetailedDescription();
        if (s == null) {
            s = "";
        }
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        ContentLoader loader = new ContentLoader(null, null, (InputStream)is, "text/html");
        this.m_iceBrowser.renderContentFully(loader, VIEWPORT_NAME);
    }

    public void setStatusMessage(final String msg) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ValidationBrowserPanel.this.m_statusLbl.setText(msg);
                ValidationBrowserPanel.this.m_statusLbl.paintImmediately(ValidationBrowserPanel.this.m_statusLbl.getBounds());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        JScrollPane sp = GraphUtils.getScrollPane((Component)this.m_table);
        JLabel errorsLbl = new JLabel();
        BPELStringTranslator.setLabel(errorsLbl, this.m_table, BPELStringTranslator.getString("EDITOR_VALID_BWS_VAL_ERR_WARN"));
        JLabel detailsLbl = new JLabel();
        BPELStringTranslator.setLabel(detailsLbl, this.m_table, BPELStringTranslator.getString("EDITOR_VALID_BWS_VAL_PBM_SOL"));
        JLabel structureLbl = new JLabel();
        BPELStringTranslator.setLabel(structureLbl, this.m_validationExplorer, BPELStringTranslator.getString("EDITOR_VALID_BWS_VAL_ACT_STRUC"));
        JPanel topPnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)topPnl, (Component)errorsLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(8, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)topPnl, (Component)sp, (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(2, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        JPanel botPnl = new JPanel(new GridBagLayout());
        JPanel icePanel = new JPanel();
        this.m_iceBrowser.setContainer((Container)icePanel, VIEWPORT_NAME);
        icePanel.setBorder(new LineBorder(Color.cyan.darker()));
        GraphUtils.addComponent((Container)botPnl, (Component)detailsLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)botPnl, (Component)new JScrollPane(icePanel), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(2, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        JSplitPane splitter = UIHelper.getJSplitPane((int)0, (boolean)true);
        splitter.setBorder(null);
        splitter.setDividerLocation(140);
        splitter.setTopComponent(topPnl);
        splitter.setBottomComponent(botPnl);
        JPanel explorerPnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)explorerPnl, (Component)this.m_validationExplorer, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 5, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        JPanel p = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)splitter, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 4, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        JSplitPane mainSplitter = UIHelper.getJSplitPane((int)1, (boolean)true);
        mainSplitter.setLeftComponent(explorerPnl);
        mainSplitter.setRightComponent(p);
        mainSplitter.setBorder(null);
        mainSplitter.setDividerLocation(300);
        JPanel statusPnl = new JPanel(new GridBagLayout());
        statusPnl.setBorder(new EtchedBorder(1));
        GraphUtils.addComponent((Container)statusPnl, (Component)this.m_statusLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(2, 2, 2, 2), (int)0, (int)0, (double)0.1, (double)1.0);
        JPanel mainPnl = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)mainPnl, (Component)mainSplitter, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.1, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)mainPnl, (int)0, (int)0, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)statusPnl, (int)0, (int)2, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    private void clearHTML() {
        String s = "<html><body bgcolor=white></body></html>";
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        ContentLoader loader = new ContentLoader(null, null, (InputStream)is, "text/html");
        this.m_iceBrowser.renderContentFully(loader, VIEWPORT_NAME);
    }

    public void loadControls() {
        this.m_validationExplorer.loadExplorer(this.m_activity);
    }

    private void updateSelectedActivity() {
        this.m_activity = null;
        int id = this.m_validationExplorer.getSelectedNodeType();
        if (id == 16) {
            ActivityInfo info = (ActivityInfo)this.m_validationExplorer.getSelectedNodeData();
            this.m_activity = info.getActivity();
        } else if (id == 14) {
            this.m_activity = (Validatable)this.m_validationExplorer.getSelectedNodeData();
        }
    }

    private void handleActivitySelection() {
        this.updateSelectedActivity();
        ValidationReportItemTableModel model = (ValidationReportItemTableModel)((Object)this.m_table.getModel());
        model.setData(new Vector(0));
        if (this.m_activity != null) {
            BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
            ValidationReport r = this.m_activity.getValidationReport(new ValidationContext(graphModel.getProcess()), false);
            if (r == null) {
                r = this.m_activity.getValidationReport(new ValidationContext(graphModel.getProcess()), true);
            }
            if (r != null) {
                List details = r.getReportDetails();
                Vector vec = new Vector();
                if (details != null) {
                    vec.addAll(details);
                }
                model.setData(vec);
                if (model.getRowCount() > 0) {
                    Runnable runner = new Runnable(){

                        @Override
                        public void run() {
                            ValidationBrowserPanel.this.m_table.getSelectionModel().setSelectionInterval(0, 0);
                        }
                    };
                    SwingUtilities.invokeLater(runner);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("NODE_EDITED")) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.clearHTML();
                this.handleActivitySelection();
            } else {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        ValidationBrowserPanel.this.clearHTML();
                        ValidationBrowserPanel.this.handleActivitySelection();
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        }
    }

    class TreeNodeSelectionListener
    implements TreeSelectionListener {
        TreeNodeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ValidationBrowserPanel.this.clearHTML();
            ValidationBrowserPanel.this.setCursor(Cursor.getPredefinedCursor(3));
            Thread runner = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ValidationBrowserPanel.this.handleActivitySelection();
                    }
                    finally {
                        ValidationBrowserPanel.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            };
            runner.start();
        }
    }
}

