/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.DialogCancelListener;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser.ValidationBrowserPanel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ValidationBrowser
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final String VIEWPORT_NAME = "bpel-viewport";
    protected JButton m_closeBtn;
    protected JButton m_helpBtn;
    protected Validatable m_activity;
    protected BPELGraphPane m_graph;
    protected ValidationBrowserPanel m_panel;
    protected int m_retVal = 0;

    public ValidationBrowser(JFrame f, BPELGraphPane graph, Validatable activity) {
        super(f, BPELStringTranslator.getString("EDITOR_VALID_BWS"), true);
        this.m_graph = graph;
        this.m_activity = activity;
        this.createControls();
        this.layoutControls();
        this.attachHelpListener();
        UIHelper.attachDialogCancelListener((JDialog)((Object)this), (DialogCancelListener)this);
    }

    public int display() {
        this.loadControls();
        this.setVisible(true);
        return this.m_retVal;
    }

    public void setStatusMessage(String msg) {
        this.m_panel.setStatusMessage(msg);
    }

    protected void createControls() {
        this.m_panel = new ValidationBrowserPanel(this.m_graph, this.m_activity);
        this.m_closeBtn = new JButton();
        BPELStringTranslator.setButton(this.m_closeBtn, BPELStringTranslator.getString("EDITOR_VALID_BWS_CLOSE", "&Close"));
        this.m_closeBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES", "&Help"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_closeBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)c, (Component)this.m_panel, (int)0, (int)0, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)1, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 5, 10, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_closeBtn) {
            this.handleClose();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void handleClose() {
        this.m_retVal = 0;
        this.dispose();
    }

    protected void helpInvoked() {
        HelpSystem help = HelpSystem.getHelpSystem();
        help.registerClientWindow((Window)((Object)this));
        help.goTo("bpmjdev_valid_browser");
        help.unregisterClientWindow((Window)((Object)this));
    }

    protected void attachHelpListener() {
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                ValidationBrowser.this.helpInvoked();
            }
        };
        JRootPane rootPane = this.getRootPane();
        KeyStroke f1 = KeyStroke.getKeyStroke(112, 0, false);
        rootPane.getInputMap(2).put(f1, "F1_KEY");
        rootPane.getActionMap().put("F1_KEY", f1Action);
    }

    protected void loadControls() {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ValidationBrowser.this.m_panel.loadControls();
                }
                finally {
                    ValidationBrowser.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected void handleCancel() {
        this.handleClose();
    }
}

