/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpelparser.search.SearchData;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CheckBoxCellRenderer;
import oracle.tip.tools.ide.common.ui.ComponentBorderPane;
import oracle.tip.tools.ide.common.ui.SortableTable;
import oracle.tip.tools.ide.common.ui.SortedTableHeaderRenderer;
import oracle.tip.tools.ide.common.ui.TableLabelCellRenderer;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.search.SearchActivityTableData;
import oracle.tip.tools.ide.pm.gui.dialogs.search.SearchActivityTableDataCellRenderer;
import oracle.tip.tools.ide.pm.gui.dialogs.search.SearchActivityTableModel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class SearchDialog
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected JButton m_selectAllBtn;
    protected JButton m_deselectAllBtn;
    protected JCheckBox m_matchCaseCB;
    protected JCheckBox m_wholeWordCB;
    protected JCheckBox m_expressionClausesCB;
    protected JComboBox m_textField;
    protected BPELGraphPane m_graph;
    protected JCheckBox m_typeSearchCB;
    protected JTable m_typeTable;
    protected int m_retVal = 1;
    protected SearchData m_data;

    public SearchDialog(JFrame f, BPELGraphPane graph) {
        super(f, BPELStringTranslator.getString("SEARCH_SEARCH_DIAGRAM"), true);
        this.m_graph = graph;
        this.createAndLayoutControls();
        this.attachEnterKeyListener();
        this.enableSearchTypes();
    }

    public int display() {
        this.load();
        this.m_textField.requestFocus();
        this.setVisible(true);
        return this.m_retVal;
    }

    public SearchData getData() {
        return this.m_data;
    }

    protected void attachEnterKeyListener() {
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                SearchDialog.this.handleOK();
            }
        };
        JRootPane rootPane = this.getRootPane();
        KeyStroke f1 = KeyStroke.getKeyStroke(10, 0, false);
        rootPane.getInputMap(2).put(f1, "ENTER_KEY");
        rootPane.getActionMap().put("ENTER_KEY", f1Action);
    }

    protected void load() {
        if (this.m_data == null) {
            return;
        }
        this.m_textField.getEditor().setItem(this.m_data.m_searchStr);
        this.m_matchCaseCB.setSelected(this.m_data.m_bMatchCase);
        this.m_wholeWordCB.setSelected(this.m_data.m_bWholeWord);
        this.enableSearchTypes();
    }

    protected void createAndLayoutControls() {
        this.m_textField = new JComboBox(new DefaultComboBoxModel());
        this.m_textField.setEditable(true);
        this.m_okBtn = new JButton("Search");
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("SEARCH_SEARCH_BTN"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.createSearchPanel(), (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row, (int)1, (int)1, (int)14, (int)0, (Insets)new Insets(10, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(410, 360);
        this.setLocationRelativeTo(this.getParent());
    }

    protected JPanel createOptionsPanel() {
        this.m_matchCaseCB = new JCheckBox();
        this.m_matchCaseCB.setHorizontalAlignment(0);
        BPELStringTranslator.setButton(this.m_matchCaseCB, BPELStringTranslator.getString("COLLAXALAF_TEXT_MATCH_CASE"));
        this.m_wholeWordCB = new JCheckBox();
        BPELStringTranslator.setButton(this.m_wholeWordCB, BPELStringTranslator.getString("COLLAXALAF_TEXT_WHOLE_WORD"));
        this.m_wholeWordCB.setHorizontalAlignment(0);
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(new TitledBorder(BPELStringTranslator.getString("COLLAXALAF_TEXT_OPTIONS")));
        int row = 0;
        GraphUtils.addComponent((Container)p, (Component)this.m_matchCaseCB, (int)0, (int)row, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_wholeWordCB, (int)1, (int)row, (int)1, (int)1, (int)10, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        return p;
    }

    protected JPanel createSearchTypesPanel() {
        ToolBar tb = new ToolBar();
        tb.setBorderInsets(new Insets(0, 0, 0, 0));
        this.m_selectAllBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("table_selectall.png"));
        this.m_selectAllBtn.setToolTipText(BPELStringTranslator.getString("SEARCH_SELECT_ALL", "Select All"));
        this.m_selectAllBtn.addActionListener(this);
        this.m_deselectAllBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("table_selectnone.png"));
        this.m_deselectAllBtn.setToolTipText(BPELStringTranslator.getString("SEARCH_DESELECT_ALL", "Deselect All"));
        this.m_deselectAllBtn.addActionListener(this);
        tb.add((Component)this.m_selectAllBtn);
        tb.add((Component)this.m_deselectAllBtn);
        Vector<SearchActivityTableData> v = new Vector<SearchActivityTableData>();
        v.addElement(new SearchActivityTableData(9));
        v.addElement(new SearchActivityTableData(22));
        v.addElement(new SearchActivityTableData(23));
        v.addElement(new SearchActivityTableData(20));
        v.addElement(new SearchActivityTableData(19));
        v.addElement(new SearchActivityTableData(8));
        v.addElement(new SearchActivityTableData(29));
        v.addElement(new SearchActivityTableData(0));
        v.addElement(new SearchActivityTableData(28));
        v.addElement(new SearchActivityTableData(11));
        v.addElement(new SearchActivityTableData(14));
        v.addElement(new SearchActivityTableData(1));
        v.addElement(new SearchActivityTableData(13));
        v.addElement(new SearchActivityTableData(2));
        v.addElement(new SearchActivityTableData(3));
        v.addElement(new SearchActivityTableData(4));
        v.addElement(new SearchActivityTableData(18));
        v.addElement(new SearchActivityTableData(21));
        v.addElement(new SearchActivityTableData(27));
        v.addElement(new SearchActivityTableData(12));
        v.addElement(new SearchActivityTableData(17));
        SearchActivityTableModel model = new SearchActivityTableModel();
        model.setData(v);
        this.m_typeTable = new JTable((TableModel)((Object)model));
        SortableTable st = new SortableTable(){

            public void sortColumn(int col, boolean bAscending) {
                SearchDialog.this.sortTable(col, bAscending);
            }

            public JTable getJTable() {
                return SearchDialog.this.m_typeTable;
            }

            public int getSortingColumn() {
                return 1;
            }

            public boolean getSortAscending() {
                return true;
            }
        };
        SortedTableHeaderRenderer header = new SortedTableHeaderRenderer(st);
        TableLabelCellRenderer r = new TableLabelCellRenderer();
        r.setHorizontalAlignment(0);
        TableColumnModel colModel = this.m_typeTable.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            col.setHeaderRenderer((TableCellRenderer)header);
            if (i == 0) {
                col.setMinWidth(30);
                col.setMaxWidth(30);
                col.setCellRenderer(new SearchActivityTableDataCellRenderer());
                continue;
            }
            if (i == 2) {
                col.setCellRenderer((TableCellRenderer)new CheckBoxCellRenderer());
                JCheckBox cb = new JCheckBox();
                cb.setHorizontalAlignment(0);
                col.setCellEditor(new DefaultCellEditor(cb));
                col.setPreferredWidth(120);
                continue;
            }
            col.setCellRenderer((TableCellRenderer)r);
            col.setPreferredWidth(120);
        }
        this.m_typeTable.getTableHeader().setReorderingAllowed(false);
        JPanel p = new JPanel(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)p, (Component)tb, (int)0, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)GraphUtils.getScrollPane((Component)this.m_typeTable), (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        this.m_typeSearchCB = new JCheckBox(BPELStringTranslator.getString("COLLAXALAF_TEXT_SPECIFY_TYPES_TO_SEARCH"), true);
        this.m_typeSearchCB.setFont(UIManager.getFont("TitledBorder.font"));
        this.m_typeSearchCB.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.m_typeSearchCB.addActionListener(this);
        this.m_typeSearchCB.doClick();
        return new ComponentBorderPane((JComponent)this.m_typeSearchCB, (JComponent)p);
    }

    protected void sortTable(int col, final boolean bAscending) {
        if (col == 1 || col == 0) {
            SearchActivityTableModel model = (SearchActivityTableModel)((Object)this.m_typeTable.getModel());
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    SearchActivityTableData d1 = (SearchActivityTableData)o1;
                    SearchActivityTableData d2 = (SearchActivityTableData)o2;
                    String s1 = d1.getTypeName();
                    String s2 = d2.getTypeName();
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        } else if (col == 2) {
            SearchActivityTableModel model = (SearchActivityTableModel)((Object)this.m_typeTable.getModel());
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    SearchActivityTableData d1 = (SearchActivityTableData)o1;
                    SearchActivityTableData d2 = (SearchActivityTableData)o2;
                    String s1 = Boolean.toString(d1.getSearch());
                    String s2 = Boolean.toString(d2.getSearch());
                    System.out.println(s1 + "  " + s2);
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        }
    }

    protected JPanel createSearchPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        int row = 0;
        JLabel searchLbl = new JLabel();
        BPELStringTranslator.setLabel(searchLbl, this.m_textField, BPELStringTranslator.getString("SEARCH_SEARCH_FOR", "S&earch For:"));
        GraphUtils.addComponent((Container)p, (Component)searchLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_textField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.createOptionsPanel(), (int)0, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.createSearchTypesPanel(), (int)0, (int)row, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        } else if (src == this.m_selectAllBtn) {
            this.selectAll(true);
        } else if (src == this.m_deselectAllBtn) {
            this.selectAll(false);
        } else if (src == this.m_typeSearchCB) {
            this.enableSearchTypes();
        }
    }

    protected void enableSearchTypes() {
        boolean bEnable = this.m_typeSearchCB.isSelected();
        this.m_typeTable.setEnabled(bEnable);
        this.m_selectAllBtn.setEnabled(bEnable);
        this.m_deselectAllBtn.setEnabled(bEnable);
    }

    protected void selectAll(boolean bSelect) {
        SearchActivityTableModel model = (SearchActivityTableModel)((Object)this.m_typeTable.getModel());
        for (SearchActivityTableData data : model.getData()) {
            data.setSearch(bSelect);
        }
        model.refresh();
    }

    protected void handleOK() {
        this.m_data = new SearchData();
        this.m_data.m_bSearchInvoke = true;
        this.m_data.m_bSearchReply = true;
        this.m_data.m_bSearchReceive = true;
        this.m_data.m_bSearchScope = true;
        this.m_data.m_bSearchAssign = true;
        this.m_data.m_bSearchTransform = true;
        this.m_data.m_bSearchSequence = true;
        this.m_data.m_bSearchCompensate = true;
        this.m_data.m_bSearchWait = true;
        this.m_data.m_bSearchJavaEmbed = true;
        this.m_data.m_bSearchPartnerLink = true;
        this.m_data.m_bSearchEmpty = true;
        this.m_data.m_bSearchOnAlarm = true;
        this.m_data.m_bSearchOnMessage = true;
        this.m_data.m_bSearchCatch = true;
        this.m_data.m_bSearchCatchAll = true;
        this.m_data.m_bSearchCompensationHandler = true;
        this.m_data.m_bSearchExpressions = true;
        this.m_data.m_bSearchTerminate = true;
        this.m_data.m_bSearchWhile = true;
        this.m_data.m_bSearchThrow = true;
        this.m_data.m_bSearchSwitch = true;
        this.m_data.m_bSearchPick = true;
        this.m_data.m_bSearchFlowN = true;
        this.m_data.m_bSearchFlow = true;
        this.m_data.m_searchStr = this.m_textField.getSelectedItem().toString();
        if (this.m_data.m_searchStr != null) {
            boolean bAdd = true;
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_textField.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                String s = (String)model.getElementAt(i);
                if (!s.equals(this.m_data.m_searchStr)) continue;
                bAdd = false;
                break;
            }
            if (bAdd) {
                model.addElement(this.m_data.m_searchStr);
            }
        }
        this.m_data.m_bMatchCase = this.m_matchCaseCB.isSelected();
        this.m_data.m_bWholeWord = this.m_wholeWordCB.isSelected();
        if (this.m_typeSearchCB.isSelected()) {
            SearchActivityTableModel model = (SearchActivityTableModel)((Object)this.m_typeTable.getModel());
            for (SearchActivityTableData data : model.getData()) {
                switch (data.getType()) {
                    case 9: {
                        this.m_data.m_bSearchAssign = data.getSearch();
                        break;
                    }
                    case 22: {
                        this.m_data.m_bSearchCatch = data.getSearch();
                        break;
                    }
                    case 23: {
                        this.m_data.m_bSearchCatchAll = data.getSearch();
                        break;
                    }
                    case 20: {
                        this.m_data.m_bSearchCompensate = data.getSearch();
                        break;
                    }
                    case 19: {
                        this.m_data.m_bSearchEmpty = data.getSearch();
                        break;
                    }
                    case 8: {
                        this.m_data.m_bSearchFlow = data.getSearch();
                        break;
                    }
                    case 29: {
                        this.m_data.m_bSearchFlowN = data.getSearch();
                        break;
                    }
                    case 0: {
                        this.m_data.m_bSearchInvoke = data.getSearch();
                        break;
                    }
                    case 28: {
                        this.m_data.m_bSearchJavaEmbed = data.getSearch();
                        break;
                    }
                    case 11: {
                        this.m_data.m_bSearchPartnerLink = data.getSearch();
                        break;
                    }
                    case 14: {
                        this.m_data.m_bSearchPick = data.getSearch();
                        break;
                    }
                    case 4: {
                        this.m_data.m_bSearchSwitch = data.getSearch();
                        break;
                    }
                    case 2: {
                        this.m_data.m_bSearchScope = data.getSearch();
                        break;
                    }
                    case 3: {
                        this.m_data.m_bSearchSequence = data.getSearch();
                        break;
                    }
                    case 18: {
                        this.m_data.m_bSearchTerminate = data.getSearch();
                        break;
                    }
                    case 21: {
                        this.m_data.m_bSearchThrow = data.getSearch();
                        break;
                    }
                    case 17: {
                        this.m_data.m_bSearchWhile = data.getSearch();
                        break;
                    }
                    case 27: {
                        this.m_data.m_bSearchTransform = data.getSearch();
                        break;
                    }
                    case 1: {
                        this.m_data.m_bSearchReceive = data.getSearch();
                        break;
                    }
                    case 12: {
                        this.m_data.m_bSearchWait = data.getSearch();
                        break;
                    }
                    case 13: {
                        this.m_data.m_bSearchReply = data.getSearch();
                        break;
                    }
                }
            }
        }
        this.m_retVal = 0;
        this.setVisible(false);
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.setVisible(false);
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }
}

