/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.fault;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.fault.FaultDataPanel;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class FaultDialog
extends BPELBaseDialog
implements ActionListener,
PropertyChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private JButton m_okBtn;
    private JButton m_cancelBtn;
    protected FaultDataPanel m_faultPanel;
    protected Definition m_def;
    protected BPELGraphPane m_graph;
    protected int m_retVal = 1;
    protected boolean m_bEditing = false;
    protected List<Fault> m_faultNameFilter;

    public FaultDialog(JFrame f, Definition def, BPELGraphPane graph) {
        super(f, BPELStringTranslator.getString("FAULT"), true);
        this.m_def = def;
        this.m_graph = graph;
        this.createAndLayoutControls();
        this.updateButtons();
    }

    public void setFault(Fault data) {
        this.m_faultPanel.setFault(data);
    }

    public Fault getFault() {
        return this.m_faultPanel.getFault();
    }

    public void saveToModel() {
        this.m_faultPanel.saveToModel();
    }

    public int create(List<Fault> faultNameFilter) {
        this.m_bEditing = false;
        this.m_faultNameFilter = faultNameFilter;
        this.setTitle(BPELStringTranslator.getString("ADD_FAULT", "Add Fault"));
        return this.display();
    }

    public int edit(List<Fault> faultNameFilter, Fault data) {
        this.m_bEditing = true;
        this.m_faultNameFilter = faultNameFilter;
        this.setFault(data);
        this.setTitle(BPELStringTranslator.getString("EDIT_FAULT") + " - " + data.getName());
        return this.display();
    }

    private int display() {
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void createAndLayoutControls() {
        this.m_faultPanel = new FaultDataPanel(this.m_def, this.m_graph);
        this.m_faultPanel.addPropertyChangeListener(this);
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_faultPanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 5, 5, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(330, 130);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.m_faultPanel.isDataValid());
    }

    protected boolean isValidData() {
        if (!this.m_bEditing) {
            if (!BPELModelUtil.isUniqueFaultName(this.m_faultNameFilter, (String)this.m_faultPanel.getFaultName())) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)"Fault name already exists!");
                return false;
            }
        } else {
            String origName = this.m_faultPanel.getFault().getName();
            String newName = this.m_faultPanel.getFaultName();
            if (newName == null || newName.length() == 0) {
                return false;
            }
            if (newName.equalsIgnoreCase(origName)) {
                return true;
            }
            if (!BPELModelUtil.isUniqueFaultName(this.m_faultNameFilter, (String)newName)) {
                GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this)), (String)"Fault name already exists!");
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOk();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        }
    }

    protected void handleOk() {
        if (!this.isValidData()) {
            return;
        }
        this.saveToModel();
        this.m_retVal = 0;
        this.dispose();
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object src = evt.getSource();
        if (src == this.m_faultPanel) {
            this.updateButtons();
        }
    }

    protected void handleEnterKey() {
        this.handleOk();
    }
}

