/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.fault;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooserListener;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorer;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.ui.DoubleClickListener;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.MessageTypeDataSource;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class FaultDataPanel
extends JPanel
implements ActionListener {
    public static final String NAME_CHANGED = "NAME_CHANGED";
    public static final String MESSAGE_CHANGED = "MESSAGE_CHANGED";
    public static final String TYPE_SELECTED = "TYPE_SELECTED";
    protected JTextField m_faultNameField;
    protected JTextField m_faultMessageField;
    protected JButton m_faultBrowseBtn;
    protected QName m_faultMsg;
    protected Fault m_fault;
    protected Definition m_def;
    protected BPELGraphPane m_graph;
    protected TreeExplorerDataSource m_messageTypeDataSource;
    protected TypeObject m_messageTypeTypeObject;

    public FaultDataPanel(Definition def, BPELGraphPane graph) {
        this.m_def = def;
        this.m_graph = graph;
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        Process p = graphModel.getProcess();
        this.m_messageTypeDataSource = new MessageTypeDataSource(p, this.m_graph.getBPELProject());
        this.createControls();
        this.layoutControls();
    }

    public boolean isDataValid() {
        String name = this.m_faultNameField.getText();
        String message = this.m_faultMessageField.getText();
        if (name == null || name.length() == 0) {
            return false;
        }
        return message != null && message.length() != 0;
    }

    public void setFault(Fault fault) {
        this.m_fault = fault;
        if (this.m_fault != null) {
            this.m_faultNameField.setText(this.m_fault.getName());
            this.m_faultMessageField.setText(this.m_fault.getMessage().getQName().toString());
        }
    }

    public Fault getFault() {
        return this.m_fault;
    }

    public String getFaultName() {
        return this.m_faultNameField.getText().trim();
    }

    public Fault saveToModel() {
        Message msg;
        String name;
        if (this.m_fault == null) {
            this.m_fault = this.m_def.createFault();
        }
        if ((name = this.m_faultNameField.getText()) != null) {
            this.m_fault.setName(name.trim());
        }
        if ((msg = this.m_def.getMessage(this.m_faultMsg)) != null) {
            this.m_fault.setMessage(msg);
        }
        return this.m_fault;
    }

    protected void createControls() {
        this.m_faultNameField = new JTextField();
        this.m_faultNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FaultDataPanel.this.firePropertyChange(FaultDataPanel.NAME_CHANGED, null, FaultDataPanel.this.m_faultNameField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FaultDataPanel.this.firePropertyChange(FaultDataPanel.NAME_CHANGED, null, FaultDataPanel.this.m_faultNameField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FaultDataPanel.this.firePropertyChange(FaultDataPanel.NAME_CHANGED, null, FaultDataPanel.this.m_faultNameField.getText());
            }
        });
        this.m_faultMessageField = new JTextField();
        this.m_faultMessageField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FaultDataPanel.this.firePropertyChange(FaultDataPanel.MESSAGE_CHANGED, null, FaultDataPanel.this.m_faultMessageField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FaultDataPanel.this.firePropertyChange(FaultDataPanel.MESSAGE_CHANGED, null, FaultDataPanel.this.m_faultMessageField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FaultDataPanel.this.firePropertyChange(FaultDataPanel.MESSAGE_CHANGED, null, FaultDataPanel.this.m_faultMessageField.getText());
            }
        });
        this.m_faultBrowseBtn = UIHelper.createBrowseButton((String)MessageBundleUtil.getCommonString((String)"TOP_BROWSE_XML_SCHEMA_TYPES", (String)"Browse XML Schema Types..."));
        this.m_faultBrowseBtn.addActionListener(this);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        JLabel nameLbl = new JLabel();
        BPELStringTranslator.setLabel(nameLbl, this.m_faultNameField, BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JLabel messageLbl = new JLabel();
        BPELStringTranslator.setLabel(messageLbl, this.m_faultMessageField, BPELStringTranslator.getString("MESSAGE_M", "&Message:"));
        ToolBar faultTB = new ToolBar();
        faultTB.add((Component)this.m_faultBrowseBtn);
        int row = 0;
        GraphUtils.addComponent((Container)this, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_faultNameField, (int)1, (int)row++, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)messageLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)this, (Component)this.m_faultMessageField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 0, 5, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)this, (Component)faultTB, (int)2, (int)row++, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
    }

    protected void handleMessageTypeBrowse() {
        final TypeChooser chooser = new TypeChooser(UIHelper.getFrame((Component)this));
        TypeChooserListener listener = new TypeChooserListener(){

            public void typeSelectionOccurred() {
                chooser.getOkButton().setEnabled(false);
                TypeObject to = chooser.getTypeObject();
                if (to != null) {
                    chooser.getOkButton().setEnabled(to.getType() == 3);
                }
            }
        };
        chooser.setTypeChooserListener(listener);
        TypeExplorer explorer = chooser.getTypeExplorer();
        explorer.removeAllDoubleClickListener();
        DoubleClickListener lst = new DoubleClickListener(){

            public void onDoubleClick(Object src) {
                TypeObject to = chooser.getTypeObject();
                if (to != null && to.getType() == 3) {
                    chooser.handleOK();
                }
            }
        };
        explorer.addDoubleClickListener(lst);
        if (chooser.display(this.m_messageTypeDataSource) == 0) {
            this.m_messageTypeTypeObject = chooser.getTypeObject();
            this.m_faultMsg = this.m_messageTypeTypeObject.getQName();
            this.m_faultMessageField.setText(this.m_messageTypeTypeObject.getQName().toString());
            this.firePropertyChange(TYPE_SELECTED, null, this.m_messageTypeTypeObject.getQName());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_faultBrowseBtn) {
            this.handleMessageTypeBrowse();
        }
    }
}

