/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesFilter;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.variable.VariableChooserValidator;
import oracle.tip.tools.ide.pm.gui.explorer.DoubleClickListener;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTree;
import oracle.tip.tools.ide.pm.gui.explorer.ProcessExplorer;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class VariableChooser
extends BPELBaseDialog
implements ActionListener,
TreeSelectionListener,
DoubleClickListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected ProcessExplorer m_processExplorer;
    protected BPELGraphPane m_graph;
    protected VariableChooserValidator m_validator;
    protected Activity m_selectedActivity;
    protected VariablesFilter m_variablesFilter = null;
    protected int m_retVal = 1;

    public VariableChooser(JFrame f, BPELGraphPane graph, Activity activity) {
        this(f, graph, activity, null);
    }

    public VariableChooser(JFrame f, BPELGraphPane graph, Activity activity, VariablesFilter filter) {
        super(f, BPELStringTranslator.getString("EDITOR_VAR_CHOOSER_DLG"), true);
        this.m_graph = graph;
        this.m_selectedActivity = activity;
        this.m_variablesFilter = filter;
        this.createControls();
        this.layoutControls();
    }

    public VariableChooserValidator getValidator() {
        return this.m_validator;
    }

    public void setValidator(VariableChooserValidator validator) {
        this.m_validator = validator;
    }

    public Variable getSelectedVariable() {
        Object data = this.m_processExplorer.getExplorerTree().getSelectedNodeData();
        if (data instanceof Variable) {
            return (Variable)data;
        }
        return null;
    }

    protected void createControls() {
        this.m_processExplorer = new ProcessExplorer();
        this.m_processExplorer.getExplorerTree().removeAllDoubleClickListener();
        this.m_processExplorer.getExplorerTree().addDoubleClickListener(this);
        this.m_processExplorer.getExplorerTree().setMask(1);
        this.m_processExplorer.getExplorerTree().showFilterButton(false);
        this.m_processExplorer.getExplorerTree().showRootNode(false);
        this.m_processExplorer.getExplorerTree().setVariablesFilter(this.m_variablesFilter);
        this.m_processExplorer.setGraphPane(this.m_graph);
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_processExplorer, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 480);
        this.setLocationRelativeTo(this.getParent());
    }

    public int display() {
        this.loadControls();
        this.updateButtons();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void loadControls() {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    VariableChooser.this.m_processExplorer.loadExplorer(VariableChooser.this.m_selectedActivity);
                    ExplorerTree tree = VariableChooser.this.m_processExplorer.getExplorerTree();
                    tree.getTree().getSelectionModel().addTreeSelectionListener(VariableChooser.this);
                    tree.expandVariableContainerNodes();
                    DefaultMutableTreeNode scopeNode = tree.getLastChildScope(tree.m_variablesNode);
                    if (scopeNode != null) {
                        tree.selectFirstChild(scopeNode);
                    } else {
                        DefaultMutableTreeNode processNode = tree.getProcessNode(tree.m_variablesNode);
                        if (processNode != null) {
                            tree.selectFirstChild(processNode);
                        }
                    }
                }
                finally {
                    VariableChooser.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.getSelectedVariable() != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            VariableChooserValidator v = this.getValidator();
            if (v != null && !v.validate(this)) {
                return;
            }
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.handleHelp((Component)((Object)this));
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.updateButtons();
    }

    @Override
    public void onDoubleClick(ExplorerTree tree, MouseEvent e) {
        if (this.m_okBtn.isEnabled()) {
            this.m_okBtn.doClick();
        }
    }
}

