/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.choosers.scope;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Catch;
import oracle.tip.tools.ide.common.bpelparser.iface.CatchAll;
import oracle.tip.tools.ide.common.bpelparser.iface.Compensate;
import oracle.tip.tools.ide.common.bpelparser.iface.CompensationHandler;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Handler;
import oracle.tip.tools.ide.common.bpelparser.iface.OnAlarm;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.ProcessExplorer;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ScopeChooser
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected ProcessExplorer m_processExplorer;
    protected int m_retVal = 0;
    protected Activity m_selectedActivity;
    protected BPELGraphPane m_graph;

    public ScopeChooser(JFrame f, BPELGraphPane graph, Activity a) {
        super(f, BPELStringTranslator.getString("EDITOR_SCOPE_CHOOSER"), true);
        this.m_selectedActivity = a;
        if (this.m_selectedActivity instanceof Compensate) {
            Activity enclosingScope = null;
            for (Activity currActivity = this.m_selectedActivity.getParentActivity(); currActivity != null; currActivity = currActivity.getParentActivity()) {
                Handler handler;
                if (currActivity instanceof CompensationHandler) {
                    enclosingScope = ((CompensationHandler)currActivity).getHandlerParentActivity();
                } else if ((currActivity instanceof Catch || currActivity instanceof CatchAll || currActivity instanceof OnMessage || currActivity instanceof OnAlarm) && (handler = currActivity.getParentHandler()) != null) {
                    enclosingScope = handler.getHandlerParentActivity();
                }
                if (enclosingScope != null) break;
            }
            System.err.println("enclosingScope=" + enclosingScope.getName());
            if (enclosingScope != null) {
                List l = this.findFirstLevelScopes(enclosingScope);
                for (Activity o : l) {
                    System.err.println("Found scope = " + o.getName());
                }
            }
        }
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
    }

    List findFirstLevelScopes(Activity a) {
        ArrayList<Activity> l = new ArrayList<Activity>();
        if (a instanceof ContainerActivity) {
            ContainerActivity con = (ContainerActivity)a;
            Iterator it = con.getActivities();
            while (it.hasNext()) {
                Activity child = (Activity)it.next();
                if (child instanceof Scope) {
                    l.add(child);
                    continue;
                }
                List lst = this.findFirstLevelScopes(child);
                if (lst.size() <= 0) continue;
                l.addAll(lst);
            }
        }
        return l;
    }

    public Scope getSelectedScope() {
        Object data = this.m_processExplorer.getExplorerTree().getSelectedNodeData();
        if (data instanceof Scope) {
            return (Scope)data;
        }
        return null;
    }

    protected void createControls() {
        this.m_processExplorer = new ProcessExplorer();
        this.m_processExplorer.getExplorerTree().showToolBar(false);
        this.m_processExplorer.getExplorerTree().showDetailsCheckBox(false);
        this.m_processExplorer.getExplorerTree().setMask(1024);
        this.m_processExplorer.getExplorerTree().showFilterButton(false);
        this.m_processExplorer.getExplorerTree().showRootNode(false);
        this.m_processExplorer.getExplorerTree().getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ScopeChooser.this.updateButtons();
            }
        });
        this.m_processExplorer.setGraphPane(this.m_graph);
        this.m_okBtn = new JButton();
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.getSelectedScope() != null);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_processExplorer, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)1, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 480);
        this.setLocationRelativeTo(this.getParent());
    }

    public int display() {
        this.loadControls();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void loadControls() {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ScopeChooser.this.m_processExplorer.loadExplorer(ScopeChooser.this.m_selectedActivity);
                Runnable swingRunner = new Runnable(){

                    @Override
                    public void run() {
                        ScopeChooser.this.m_processExplorer.getExplorerTree().expandEntireTree();
                        ScopeChooser.this.enableUserInput(true);
                    }
                };
                SwingUtilities.invokeLater(swingRunner);
            }
        };
        new Thread(r).start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }
}

