/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.choosers.partnerlink;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.partnerlink.PartnerLinkChooserValidator;
import oracle.tip.tools.ide.pm.gui.explorer.DoubleClickListener;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTree;
import oracle.tip.tools.ide.pm.gui.explorer.ProcessExplorer;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class PartnerLinkChooser
extends BPELBaseDialog
implements ActionListener,
TreeSelectionListener,
DoubleClickListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected ProcessExplorer m_processExplorer;
    protected int m_retVal = 1;
    protected PartnerLinkChooserValidator m_validator;
    protected Activity m_selectedActivity;
    protected BPELGraphPane m_graph;

    public PartnerLinkChooser(JFrame f, BPELGraphPane graph, Activity activity) {
        super(f, BPELStringTranslator.getString("EDITOR_PL_CHOOSER_DLG"), true);
        this.m_graph = graph;
        this.m_selectedActivity = activity;
        this.createControls();
        this.layoutControls();
    }

    public PartnerLinkChooserValidator getValidator() {
        return this.m_validator;
    }

    public void setValidator(PartnerLinkChooserValidator validator) {
        this.m_validator = validator;
    }

    public PartnerLink getSelectedPartnerLink() {
        Object data = this.m_processExplorer.getExplorerTree().getSelectedNodeData();
        if (data instanceof PartnerLink) {
            return (PartnerLink)data;
        }
        return null;
    }

    protected void createControls() {
        this.m_processExplorer = new ProcessExplorer();
        this.m_processExplorer.getExplorerTree().removeAllDoubleClickListener();
        this.m_processExplorer.getExplorerTree().addDoubleClickListener(this);
        this.m_processExplorer.getExplorerTree().setMask(4);
        this.m_processExplorer.getExplorerTree().showFilterButton(false);
        this.m_processExplorer.getExplorerTree().showRootNode(false);
        this.m_processExplorer.setGraphPane(this.m_graph);
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_processExplorer, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 480);
        this.setLocationRelativeTo(this.getParent());
    }

    public int display() {
        this.loadControls();
        this.updateButtons();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void loadControls() {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PartnerLinkChooser.this.m_processExplorer.loadExplorer(PartnerLinkChooser.this.m_selectedActivity);
                    ExplorerTree tree = PartnerLinkChooser.this.m_processExplorer.getExplorerTree();
                    tree.getTree().getSelectionModel().addTreeSelectionListener(PartnerLinkChooser.this);
                    tree.expandPartnerLinkContainerNodes();
                    DefaultMutableTreeNode scopeNode = tree.getLastChildScope(tree.m_partnerLinksNode);
                    if (scopeNode != null) {
                        tree.selectFirstChild(scopeNode);
                    } else {
                        DefaultMutableTreeNode processNode = tree.getProcessNode(tree.m_partnerLinksNode);
                        if (processNode != null) {
                            tree.selectFirstChild(processNode);
                        }
                    }
                }
                finally {
                    PartnerLinkChooser.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.getSelectedPartnerLink() != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            PartnerLinkChooserValidator v = this.getValidator();
            if (v != null && !v.validate(this)) {
                return;
            }
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.updateButtons();
    }

    @Override
    public void onDoubleClick(ExplorerTree tree, MouseEvent e) {
        if (this.m_okBtn.isEnabled()) {
            this.m_okBtn.doClick();
        }
    }
}

