/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.choosers.fault;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.common.ide.IDE;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SystemFaultDatabase {
    private static final String SYSTEM_FAULTS_FILE = "integration/bpm/designer/config/system_faults.xml";
    private static SystemFaultDatabase m_instance = null;
    private LinkedHashMap m_hash = new LinkedHashMap();

    public static synchronized SystemFaultDatabase getInstance() {
        if (m_instance == null) {
            m_instance = new SystemFaultDatabase();
        }
        return m_instance;
    }

    public synchronized void flush() {
        m_instance = null;
    }

    public Iterator getFaultNames() {
        if (this.m_hash != null) {
            return this.m_hash.keySet().iterator();
        }
        return null;
    }

    public String getFaultNameSpace(String name) {
        return (String)this.m_hash.get(name);
    }

    private SystemFaultDatabase() {
        this.load();
    }

    private void load() {
        try {
            URL url = this.getLocalURL();
            Document doc = XMLHelper.loadDocument((String)url.toString());
            if (doc != null) {
                this.parseDoc(doc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private URL getLocalURL() {
        URL url = null;
        StringBuffer sb = new StringBuffer();
        IDE ide = IDEResolver.getIDE();
        URL u = ide.getLibDirectory();
        URL lib = URLFileSystem.getParent((URL)u);
        URL jdev = URLFileSystem.getParent((URL)lib);
        sb.append(jdev);
        sb.append(SYSTEM_FAULTS_FILE);
        try {
            url = new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url;
    }

    private void parseDoc(Document doc) {
        Iterator it = XMLHelper.getChildElementIterator((Element)doc.getDocumentElement());
        while (it.hasNext()) {
            Element childElem = (Element)it.next();
            if (!childElem.getTagName().equalsIgnoreCase("fault")) continue;
            String name = XMLHelper.getAttribute((Element)childElem, (String)"name");
            String namespace = XMLHelper.getAttribute((Element)childElem, (String)"namespace");
            if (name == null) continue;
            this.m_hash.put(name, namespace);
        }
    }
}

