/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.choosers.fault;

import java.util.Iterator;
import javax.swing.tree.MutableTreeNode;
import javax.xml.namespace.QName;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerTreeNode;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.fault.SystemFaultDatabase;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.fault.SystemFaultExplorerTreeNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class SystemFaultDataSource
implements TreeExplorerDataSource {
    private TypeExplorerTreeNode m_root;

    public SystemFaultDataSource() {
        SystemFaultDatabase db = SystemFaultDatabase.getInstance();
        this.m_root = new TypeExplorerTreeNode(BPELStringTranslator.getString("SYSTEM_FAULTS"));
        Iterator it = db.getFaultNames();
        if (it != null) {
            while (it.hasNext()) {
                String name = (String)it.next();
                String ns = db.getFaultNameSpace(name);
                QName qname = this.makeQName(ns, name);
                SystemFaultExplorerTreeNode typeNode = new SystemFaultExplorerTreeNode(qname);
                this.m_root.add((MutableTreeNode)((Object)typeNode));
            }
        }
    }

    public TreeExplorerTreeNode[] getRoots() {
        return new TreeExplorerTreeNode[]{this.m_root};
    }

    private QName makeQName(String ns, String local) {
        return new QName(ns, local);
    }
}

