/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.choosers.fault;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.wsdl.Fault;
import oracle.tip.tools.ide.common.datasources.CompoundDataSource;
import oracle.tip.tools.ide.common.datasources.wsdl.ProjectWSDLFaultDataSource;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.typeexplorer.DefaultSchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.DefaultWSDLImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorer;
import oracle.tip.tools.ide.common.typeexplorer.TypeExplorerTreeNode;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.typeexplorer.WSDLImportHandler;
import oracle.tip.tools.ide.common.ui.DoubleClickListener;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.treeexplorer.DefaultTreeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.pm.bpelgraph.editors.PartnerLinkFaultDataSource;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.dialogs.choosers.fault.SystemFaultDataSource;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class FaultChooser
extends BPELBaseDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected BPELGraphPane m_graph;
    protected TypeExplorer m_explorer;
    protected int m_retVal = 0;

    public FaultChooser(JFrame f, BPELGraphPane graph) {
        super(f, BPELStringTranslator.getString("FAULT_CHOOSER"), true);
        this.m_graph = graph;
        this.createControls();
        this.layoutControls();
        this.m_explorer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String s = evt.getPropertyName();
                if (s != null && s.equalsIgnoreCase("TYPE_SELECTION_CHANGED")) {
                    TypeObject to = FaultChooser.this.m_explorer.getSelectedTypeObject();
                    FaultChooser.this.m_okBtn.setEnabled(to != null);
                }
            }
        });
        this.m_explorer.addDoubleClickListener(new DoubleClickListener(){

            public void onDoubleClick(Object src) {
                FaultChooser.this.handleOK();
            }
        });
    }

    public Fault getFault() {
        TypeObject to = this.m_explorer.getSelectedTypeObject();
        if (to != null) {
            return (Fault)to.getData("FAULT");
        }
        return null;
    }

    public String getFaultNamespace() {
        TypeObject to = this.m_explorer.getSelectedTypeObject();
        if (to != null) {
            return (String)to.getData("TARGET_NAMESPACE");
        }
        return null;
    }

    protected void createControls() {
        this.m_explorer = new TypeExplorer(new Insets(5, 5, 5, 5), (SchemaImportHandler)new DefaultSchemaImportHandler((IDEProject)this.m_graph.getBPELProject()), (WSDLImportHandler)new DefaultWSDLImportHandler((IDEProject)this.m_graph.getBPELProject()));
        this.m_explorer.setLabelVisible(false);
        this.m_explorer.setBorder(null);
        this.m_okBtn = new JButton();
        this.m_okBtn.setEnabled(false);
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton();
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton(BPELStringTranslator.getString("HELP_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void updateButtons() {
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_explorer, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(5, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 480);
        this.setLocationRelativeTo(this.getParent());
    }

    public int display() {
        this.loadControls(this.getDefaultDatasource());
        this.setVisible(true);
        return this.m_retVal;
    }

    public int display(TreeExplorerDataSource ds) {
        this.loadControls(ds);
        this.setVisible(true);
        return this.m_retVal;
    }

    protected TreeExplorerDataSource getDefaultDatasource() {
        CompoundDataSource ds = new CompoundDataSource();
        ds.addDataSource((TreeExplorerDataSource)new SystemFaultDataSource());
        ds.addDataSource((TreeExplorerDataSource)new ProjectWSDLFaultDataSource(this.m_graph.getBPELProject()));
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        ds.addDataSource((TreeExplorerDataSource)new PartnerLinkFaultDataSource(model.getProcess(), true));
        return ds;
    }

    protected void loadControls(TreeExplorerDataSource ds) {
        this.m_explorer.getToolBar().setVisible(false);
        TypeExplorerTreeNode root = new TypeExplorerTreeNode(BPELStringTranslator.getString("FAULT_EXPLORER"));
        root.setIcons(new Icon[]{GlobalImageCache.getIcon((String)"browse16")});
        this.m_explorer.setRoot((DefaultTreeExplorerTreeNode)root);
        this.m_explorer.setDataSource(ds);
        this.m_explorer.load();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.handleOK();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void handleOK() {
        this.m_retVal = 0;
        this.dispose();
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }
}

