/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.gui.dialogs.choosers.correlationset;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.CorrelationSet;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTree;
import oracle.tip.tools.ide.pm.gui.explorer.ProcessExplorer;
import oracle.tip.tools.ide.pm.gui.generalpurpose.BPELBaseDialog;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class CorrelationSetChooser
extends BPELBaseDialog
implements ActionListener,
TreeSelectionListener {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    protected JButton m_okBtn;
    protected JButton m_cancelBtn;
    protected JButton m_helpBtn;
    protected ProcessExplorer m_processExplorer;
    protected int m_retVal = 1;
    protected Activity m_selectedActivity;
    protected BPELGraphPane m_graph;

    public CorrelationSetChooser(JFrame f, BPELGraphPane graph, Activity activity) {
        super(f, BPELStringTranslator.getString("EDITOR_COR_SET_CHOOSER"), true);
        this.m_graph = graph;
        this.m_selectedActivity = activity;
        this.createControls();
        this.layoutControls();
    }

    public CorrelationSet getSelectedCorrelationSet() {
        Object data = this.m_processExplorer.getExplorerTree().getSelectedNodeData();
        if (data instanceof CorrelationSet) {
            return (CorrelationSet)data;
        }
        return null;
    }

    protected void createControls() {
        this.m_processExplorer = new ProcessExplorer();
        this.m_processExplorer.getExplorerTree().setMask(8);
        this.m_processExplorer.getExplorerTree().showFilterButton(false);
        this.m_processExplorer.getExplorerTree().showRootNode(false);
        this.m_processExplorer.setGraphPane(this.m_graph);
        this.m_okBtn = new JButton(BPELStringTranslator.getString("OK_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_okBtn, BPELStringTranslator.getString("OK_BUTTON_TEXT_RES"));
        this.m_okBtn.addActionListener(this);
        this.m_cancelBtn = new JButton(BPELStringTranslator.getString("CANCEL_BUTTON_TEXT"));
        BPELStringTranslator.setButton(this.m_cancelBtn, BPELStringTranslator.getString("CANCEL_BUTTON_TEXT_RES"));
        this.m_cancelBtn.addActionListener(this);
        this.m_helpBtn = new JButton();
        BPELStringTranslator.setButton(this.m_helpBtn, BPELStringTranslator.getString("HELP_BUTTON_TEXT_RES"));
        this.m_helpBtn.addActionListener(this);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.m_okBtn);
        btnPnl.add(this.m_cancelBtn);
        Container c = this.getContentPane();
        c.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)c, (Component)this.m_processExplorer, (int)0, (int)row++, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 0, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)c, (Component)this.m_helpBtn, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 10, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)c, (Component)btnPnl, (int)0, (int)row++, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setSize(480, 480);
        this.setLocationRelativeTo(this.getParent());
    }

    public int display() {
        this.loadControls();
        this.updateButtons();
        this.setVisible(true);
        return this.m_retVal;
    }

    protected void loadControls() {
        this.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ExplorerTree tree = CorrelationSetChooser.this.m_processExplorer.getExplorerTree();
                    CorrelationSetChooser.this.m_processExplorer.loadExplorer(CorrelationSetChooser.this.m_selectedActivity);
                    tree.getTree().getSelectionModel().addTreeSelectionListener(CorrelationSetChooser.this);
                    tree.expandNode(9);
                    DefaultMutableTreeNode scopeNode = tree.getLastChildScope(tree.m_correlationsNode);
                    if (scopeNode != null) {
                        tree.selectFirstChild(scopeNode);
                    } else {
                        DefaultMutableTreeNode processNode = tree.getProcessNode(tree.m_correlationsNode);
                        if (processNode != null) {
                            tree.selectFirstChild(processNode);
                        }
                    }
                }
                finally {
                    CorrelationSetChooser.this.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected void updateButtons() {
        this.m_okBtn.setEnabled(this.getSelectedCorrelationSet() != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_okBtn) {
            this.m_retVal = 0;
            this.dispose();
        } else if (src == this.m_cancelBtn) {
            this.handleCancel();
        } else if (src == this.m_helpBtn) {
            this.helpInvoked();
        }
    }

    protected void handleCancel() {
        this.m_retVal = 1;
        this.dispose();
    }

    protected void helpInvoked() {
        this.handleHelp((Component)((Object)this));
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.updateButtons();
    }
}

