/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.workflow.plugin;

import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.ide.palette2.PaletteItem;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.model.GraphElement;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.NodeRendererFactory;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.services.lookup.LookupDataProvider;
import oracle.tip.tools.ide.common.services.lookup.LookupManager;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilderPlugin;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneDropTargetListener;
import oracle.tip.tools.ide.pm.bpelgraph.views.NodeEditorSource;
import oracle.tip.tools.ide.pm.designerplugins.workflow.plugin.CreateCustomTaskFlowAction;
import oracle.tip.tools.ide.pm.designerplugins.workflow.plugin.CreateTaskFlowAction;
import oracle.tip.tools.ide.pm.designerplugins.workflow.plugin.WFDragListener;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupDataProviderImpl;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.UserTaskNode;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.WFModelBuilderPlugin;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.WFNodeRendererFactory;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.UserTaskView;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.WFDNDDropHandler;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.popupeditor.WFNodeEditorSource;
import oracle.tip.tools.ide.pm.modules.workflow.util.WFUtil;
import oracle.tip.tools.ide.pm.plugin.AbstractBPELModelerPlugin;

public class WorkflowBPELModelerPlugin
extends AbstractBPELModelerPlugin {
    @Override
    public void initialize() {
        LookupManager.getInstance().registerProvider((LookupDataProvider)new LookupDataProviderImpl());
    }

    @Override
    public ModelBuilderPlugin getModelBuilderPlugin() {
        return new WFModelBuilderPlugin();
    }

    @Override
    public NodeEditorSource getNodeEditorSource() {
        return new WFNodeEditorSource();
    }

    @Override
    public NodeRendererFactory getNodeRendererFactory() {
        return new WFNodeRendererFactory();
    }

    @Override
    public void registerDNDHandler(BPELGraphPaneDropTargetListener dropTargetListener, BPELGraphPane graph) {
        WFDNDDropHandler dropHandler = new WFDNDDropHandler();
        dropTargetListener.registerDNDHandler(dropHandler, XmlTransferUtils.FLAVOR_XMLKEY);
        dropTargetListener.registerDNDHandler(dropHandler, PaletteItem.PALETTE_ITEM_FLAVOR);
        dropTargetListener.addDragListener(new WFDragListener());
    }

    @Override
    public boolean handleDeleteGraphElement(BPELGraphPane graph, GraphElement elem) {
        return elem instanceof UserTaskView && this.handleDeleteUserTask(graph, (UserTaskView)elem);
    }

    private boolean handleDeleteUserTask(BPELGraphPane graph, UserTaskView view) {
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        UserTaskNode node = (UserTaskNode)view.getNode();
        UserTask ut = (UserTask)node.getUserObject();
        WFUtil.deleteWFVariable(ut, process);
        graph.deleteNodeRenderer((NodeRenderer)view);
        this.removePartnerLinks(process, graph, ut);
        return true;
    }

    private void removePartnerLinks(Process process, BPELGraphPane graph, UserTask task) {
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        List<PartnerLinkNode> partnerLinkNodes = model.getPartnerLinkNodes();
        List wfPartnerLinkNodeslist = this.getWfPartnerLinkNodes(task, partnerLinkNodes);
        for (int count = 0; count < wfPartnerLinkNodeslist.size(); ++count) {
            PartnerLinkNode pLinkNode = (PartnerLinkNode)((Object)wfPartnerLinkNodeslist.get(count));
            NodeRenderer nodeRenderer = graph.getNodeRendererForNode((Node)pLinkNode);
            graph.deleteGraphElement((GraphElement)nodeRenderer, false);
        }
    }

    private List getWfPartnerLinkNodes(UserTask task, List partnerLinks) {
        ArrayList<PartnerLinkNode> list = new ArrayList<PartnerLinkNode>();
        Invoke invoke = task.getInvoke();
        if (invoke == null || invoke.getPartnerLink() == null) {
            return list;
        }
        String pl = invoke.getPartnerLink();
        PartnerLinkNode pLinkNode = null;
        PartnerLink pLink = null;
        for (int count = 0; count < partnerLinks.size(); ++count) {
            String linkName;
            pLinkNode = (PartnerLinkNode)((Object)partnerLinks.get(count));
            pLink = (PartnerLink)pLinkNode.getUserObject();
            if (pLink == null || !(linkName = pLink.getName()).trim().equals(pl)) continue;
            list.add(pLinkNode);
        }
        return list;
    }

    public static boolean isWorkflowPartnerLink(Process p, String plName) {
        List list = BPELModelUtil.findAllActivitiesUsingPartnerlink((Process)p, (String)plName);
        boolean isWfPL = false;
        for (Activity a : list) {
            Scope s = BPELModelUtil.getParentScope((Activity)a);
            if (!(s instanceof UserTask)) continue;
            isWfPL = true;
            break;
        }
        return isWfPL;
    }

    public static void removeUserTaskActivityByPartnerLinkName(Process proc, String plName, BPELGraphPane pane) {
        List<UserTask> list = WorkflowBPELModelerPlugin.getUserTaskActivitiesByPartnerLink(proc, plName);
        if (list.size() > 0) {
            for (UserTask r : list) {
                ContainerActivity p = (ContainerActivity)r.getParentActivity();
                try {
                    p.deleteActivity((Activity)r);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                WFUtil.deleteWFVariable(r, proc);
                if (pane == null) continue;
                BPELGraphModel gmodel = (BPELGraphModel)pane.getModel();
                Node rn = gmodel.getNodeForActivity((Activity)r);
                Node pn = rn.getParentNode();
                gmodel.deleteNode(pn, rn);
            }
        }
    }

    public static List<UserTask> getUserTaskActivitiesByPartnerLink(Process p, String plName) {
        List list = BPELModelUtil.findAllActivitiesUsingPartnerlink((Process)p, (String)plName);
        ArrayList<UserTask> ret = new ArrayList<UserTask>();
        for (Activity a : list) {
            Scope s = BPELModelUtil.getParentScope((Activity)a);
            if (!(s instanceof UserTask) || ret.contains(s)) continue;
            ret.add((UserTask)s);
        }
        return ret;
    }

    @Override
    public List<GraphAction> addViewAction(View v) {
        if (!(v instanceof UserTaskView)) {
            return null;
        }
        ArrayList<GraphAction> list = new ArrayList<GraphAction>();
        list.add(new CreateTaskFlowAction(v));
        list.add(new CreateCustomTaskFlowAction(v));
        return list;
    }
}

