/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.workflow.plugin;

import java.awt.event.ActionEvent;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ide.workflow.WorkflowProject;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.UserTaskNode;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.UserTaskView;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.util.WFBpelCodeUtil;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import oracle.tip.tools.ide.workflow.taskflow.wizard.TFWizardLauncher;
import oracle.tip.tools.ide.workflow.util.WorkflowUtil;

public class CreateTaskFlowAction
extends GraphAction {
    private View m_view;

    public CreateTaskFlowAction(View v) {
        super(BPELStringTranslator.getString("AUTO_GENERATE_TASK_FORM"));
        this.m_view = v;
        this.putValue("SmallIcon", ImageCache.getIcon("graph/bpel/generated_humantaskform.png"));
    }

    public CreateTaskFlowAction(View v, String scaCompName) {
        super(BPELStringTranslator.getString("OPEN_COMPONENT_EDITOR"));
        this.m_view = v;
        this.putValue("SmallIcon", ImageCache.getIcon("graph/bpel/generated_humantaskform.png"));
    }

    public void actionPerformed(ActionEvent evt) {
        UserTaskView utView = (UserTaskView)this.m_view;
        UserTaskNode utNode = (UserTaskNode)utView.getNode();
        UserTask ut = (UserTask)utNode.getUserObject();
        BPELProject ideGraphProject = ((BPELGraphModel)utView.getBPELGraphPane().getModel()).getBPELProject();
        Project jdevProject = (Project)ideGraphProject.getProjectContext();
        Invoke invoke = ut.getInvoke();
        if (invoke == null) {
            return;
        }
        String plName = invoke.getPartnerLink();
        String filename = WFBpelCodeUtil.getTaskFileForPartnerLink(jdevProject, plName);
        if (filename == null) {
            return;
        }
        SCAProject project = SCAProject.getSCAProject((Project)jdevProject);
        URL url = URLFactory.newURL((URL)project.getBPELRoot(), (String)filename);
        WorkflowProject wp = new WorkflowUtil().getWorkflowProject(url);
        TFWizardLauncher launcher = new TFWizardLauncher();
        try {
            NewEmptyProjectCommand command = new NewEmptyProjectCommand();
            Context context = Context.newIdeContext((Node)jdevProject);
            command.setContext(context);
            if (0 == command.doit()) {
                System.out.println("context project is -- " + command.getContext().getProject().getURL());
                System.out.println("Ide Active prjoject is -- " + Ide.getActiveProject().getURL());
                Ide.setActiveProject((Project)command.getContext().getProject());
                launcher.createTaskFlowForWFProject(wp, true, command.getContext(), null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

