/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.ActivityXPathInfo;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.ValidatorErrorInfo;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.ValidatorErrorInfoTableModel;

public class ValidatorErrorInfoCellRenderer
extends JComponent
implements TableCellRenderer {
    protected static Font m_font = UIManager.getFont("Tree.font");
    protected static Font m_boldFont = new Font(m_font.getFontName(), 1, m_font.getSize());
    protected ArrayList m_iconLst = new ArrayList();
    protected ArrayList m_textLst = new ArrayList();
    protected int m_iconSpace = 3;
    protected int m_leftTextSidePadding = 2;
    protected int m_rightTextSidePadding = 2;
    protected boolean m_bSelected;
    protected boolean m_bHasFocus = false;
    protected Color m_unselectedForeground;
    protected Color m_unselectedBackground;
    protected static Border m_noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected static TextInfo SLASH = ValidatorErrorInfoCellRenderer.createTextInfo("\\", m_font, Color.black);

    public ValidatorErrorInfoCellRenderer() {
        this.setBorder(m_noFocusBorder);
    }

    @Override
    public void paint(Graphics g) {
        Color bgColor = this.getBackground();
        int imageOffset = 0;
        for (Icon icon : this.m_iconLst) {
            if (icon == null) {
                return;
            }
            imageOffset += icon.getIconWidth();
            imageOffset += this.m_iconSpace;
        }
        g.setColor(bgColor);
        g.fillRect(imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
        int x = 0;
        for (Icon icon : this.m_iconLst) {
            if (icon == null) {
                return;
            }
            int iconHeight = icon.getIconHeight();
            int yOffset = Math.max(0, (this.getHeight() - iconHeight) / 2);
            icon.paintIcon(this, g, x, yOffset);
            x += icon.getIconWidth();
            x += this.m_iconSpace;
        }
        x += this.m_leftTextSidePadding;
        for (TextInfo info : this.m_textLst) {
            if (info.getText() == null || info.getText().length() == 0) continue;
            g.setFont(info.getFont());
            Color c = this.m_bSelected ? this.getForeground() : info.getColor();
            g.setColor(c);
            int strWidth = GraphUtils.getStringWidth((Font)info.getFont(), (String)info.getText());
            int yOffset = Math.max(0, (this.getHeight() - GraphUtils.getFontHeight((Font)info.getFont())) / 2);
            g.drawString(info.getText(), x, GraphUtils.getFontAscent((Font)info.getFont()) + yOffset);
            x += strWidth;
        }
        Border b = this.getBorder();
        if (b != null) {
            b.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int w = 0;
        int h = 0;
        for (Icon icon : this.m_iconLst) {
            if (icon == null) continue;
            w += icon.getIconWidth();
            w += this.m_iconSpace;
            h = Math.max(h, icon.getIconHeight());
        }
        w += this.m_leftTextSidePadding;
        for (TextInfo info : this.m_textLst) {
            if (info.getText() == null || info.getText().length() <= 0) continue;
            int strWidth = GraphUtils.getStringWidth((Font)info.getFont(), (String)info.getText());
            w += strWidth;
            h = Math.max(h, GraphUtils.getFontHeight((Font)info.getFont()));
        }
        return new Dimension(w += this.m_rightTextSidePadding, h);
    }

    protected static TextInfo createTextInfo(String s, Font f, Color c) {
        TextInfo info = new TextInfo();
        info.setText(s);
        info.setFont(f);
        info.setColor(c);
        return info;
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.m_unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.m_unselectedBackground = c;
    }

    protected String getToolTipString() {
        StringBuffer sb = new StringBuffer();
        for (TextInfo info : this.m_textLst) {
            if (info.getText() == null || info.getText().length() <= 0) continue;
            sb.append(info.getText());
        }
        return sb.toString();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int nRow, int nCol) {
        this.m_bSelected = hasFocus;
        this.m_bSelected = isSelected;
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.m_unselectedForeground != null ? this.m_unselectedForeground : table.getForeground());
            super.setBackground(this.m_unselectedBackground != null ? this.m_unselectedBackground : table.getBackground());
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(nRow, nCol)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(m_noFocusBorder);
        }
        ValidatorErrorInfoTableModel model = (ValidatorErrorInfoTableModel)((Object)table.getModel());
        ValidatorErrorInfo data = (ValidatorErrorInfo)model.getRowData(nRow);
        Stack s = data.getXPath();
        this.m_textLst.clear();
        for (int i = s.size() - 1; i >= 0; --i) {
            ActivityXPathInfo info = (ActivityXPathInfo)s.elementAt(i);
            TextInfo ti = info.createActivityTextInfo();
            this.m_textLst.add(ti);
            if (i <= 0) continue;
            this.m_textLst.add(SLASH);
        }
        this.setToolTipText(this.getToolTipString());
        return this;
    }
}

