/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow;

import java.util.Stack;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;

public class ValidatorErrorInfo {
    private Validatable m_validatable;
    private ValidationReport m_report;
    private Stack m_xpath;
    private Process m_process;
    private String m_xpathExpression;
    private String m_typeString;

    public ValidatorErrorInfo(Process process, Validatable validatable, ValidationReport report, Stack xpath) {
        this.m_process = process;
        this.m_validatable = validatable;
        this.m_report = report;
        this.m_xpath = xpath;
    }

    public boolean hasErrors() {
        if (this.m_report != null) {
            return this.m_report.getNumErrors() > 0;
        }
        return false;
    }

    public boolean hasWarnings() {
        if (this.m_report != null) {
            return this.m_report.getNumWarnings() > 0;
        }
        return false;
    }

    public String getTypeString() {
        if (this.m_typeString != null) {
            return this.m_typeString;
        }
        Validatable v = this.getValidatable();
        String type = "";
        if (v instanceof Activity) {
            this.m_typeString = BPELModelUtil.getTypeForActivity((Activity)((Activity)v));
        } else if (v instanceof PartnerLink) {
            this.m_typeString = "Partner Link";
        }
        if (this.m_typeString != null) {
            return this.m_typeString;
        }
        return type;
    }

    public Stack getXPath() {
        return this.m_xpath;
    }

    public void setXPath(Stack xpath) {
        this.m_xpath = xpath;
    }

    public String getXPathString() {
        if (this.m_xpathExpression != null) {
            return this.m_xpathExpression;
        }
        if (this.m_validatable instanceof Activity) {
            this.m_xpathExpression = BPELModelUtil.getXPathForActivity((Activity)((Activity)this.m_validatable));
        } else if (this.m_validatable instanceof PartnerLink) {
            this.m_xpathExpression = BPELModelUtil.getXPathForPartnerLink((Process)this.m_process, (PartnerLink)((PartnerLink)this.m_validatable));
        }
        if (this.m_xpathExpression != null) {
            return this.m_xpathExpression;
        }
        return "";
    }

    public Validatable getValidatable() {
        return this.m_validatable;
    }

    public void setValidatable(Validatable validatable) {
        this.m_validatable = validatable;
    }

    public ValidationReport getReport() {
        return this.m_report;
    }

    public void setReport(ValidationReport report) {
        this.m_report = report;
    }

    public Process getProcess() {
        return this.m_process;
    }

    public void setProcess(Process process) {
        this.m_process = process;
    }
}

