/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import oracle.tip.tools.ide.common.bpelparser.search.SearchResult;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.SearchResultTableModel;

public class SearchResultTableCellRenderer
extends JComponent
implements TableCellRenderer {
    protected static Font m_font = UIManager.getFont("Tree.font");
    protected static Font m_boldFont = new Font(m_font.getFontName(), 1, m_font.getSize());
    protected ArrayList m_textLst = new ArrayList();
    protected int m_iconSpace = 3;
    protected int m_leftTextSidePadding = 2;
    protected int m_rightTextSidePadding = 2;
    protected boolean m_bSelected;
    protected boolean m_bHasFocus = false;
    protected Color m_unselectedForeground;
    protected Color m_unselectedBackground;
    protected static Border m_noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public SearchResultTableCellRenderer() {
        this.setBorder(m_noFocusBorder);
    }

    @Override
    public void paint(Graphics g) {
        Color bgColor = this.getBackground();
        int imageOffset = 0;
        g.setColor(bgColor);
        g.fillRect(imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
        int x = this.m_leftTextSidePadding;
        for (TextInfo info : this.m_textLst) {
            if (info.getText() == null || info.getText().length() == 0) continue;
            int fontHeight = GraphUtils.getFontHeight((Font)info.getFont());
            g.setFont(info.getFont());
            int strWidth = GraphUtils.getStringWidth((Font)info.getFont(), (String)info.getText());
            Color bg = info.getBackground();
            if (bg != null) {
                g.setColor(bg);
                g.fillRect(x, 0, strWidth, fontHeight);
            }
            Color c = this.m_bSelected && bg == null ? this.getForeground() : info.getColor();
            g.setColor(c);
            int yOffset = Math.max(0, (this.getHeight() - fontHeight) / 2);
            g.drawString(info.getText(), x, GraphUtils.getFontAscent((Font)info.getFont()) + yOffset);
            x += strWidth;
        }
        Border b = this.getBorder();
        if (b != null) {
            b.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int h = 0;
        int w = this.m_leftTextSidePadding;
        for (TextInfo info : this.m_textLst) {
            if (info.getText() == null || info.getText().length() <= 0) continue;
            w += GraphUtils.getStringWidth((Font)info.getFont(), (String)info.getText());
            h = Math.max(h, GraphUtils.getFontHeight((Font)info.getFont()));
        }
        return new Dimension(w += this.m_rightTextSidePadding, h);
    }

    protected static TextInfo createTextInfo(String s, Font f, Color c) {
        TextInfo info = new TextInfo();
        info.setText(s);
        info.setFont(f);
        info.setColor(c);
        return info;
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.m_unselectedForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.m_unselectedBackground = c;
    }

    protected String getToolTipString() {
        StringBuffer sb = new StringBuffer();
        for (TextInfo info : this.m_textLst) {
            if (info.getText() == null || info.getText().length() <= 0) continue;
            sb.append(info.getText());
        }
        return "<html><body bgcolor=white><table width=500><tr><td align=center>" + sb.toString() + "</td></tr></table></body></html>";
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int nRow, int nCol) {
        SearchResultTableModel model;
        SearchResult data;
        List l;
        this.m_bSelected = hasFocus;
        this.m_bSelected = isSelected;
        this.m_textLst.clear();
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.m_unselectedForeground != null ? this.m_unselectedForeground : table.getForeground());
            super.setBackground(this.m_unselectedBackground != null ? this.m_unselectedBackground : table.getBackground());
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(nRow, nCol)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(m_noFocusBorder);
        }
        if ((l = (data = (SearchResult)(model = (SearchResultTableModel)((Object)table.getModel())).getRowData(nRow)).getTextInfos()) != null && l.size() > 0) {
            this.m_textLst.addAll(l);
        } else {
            this.m_textLst.add(SearchResultTableCellRenderer.createTextInfo(data.getFoundString(), m_font, Color.black));
        }
        this.setToolTipText(this.getToolTipString());
        return this;
    }
}

