/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.JTableCellRendererExtendor;
import oracle.tip.tools.ide.common.ui.SortableTable;
import oracle.tip.tools.ide.common.ui.SortedTableHeaderRenderer;
import oracle.tip.tools.ide.pm.addin.model.ModelWarning;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.StandardBPELEditor;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.ModelTableImageCellRenderer;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.ModelWarningTableModel;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;

public class ModelValidationPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JPopupMenu m_popup;
    protected JTable m_table;
    protected JLabel m_processLbl;
    protected JLabel m_statusLbl;
    protected JLabel m_errorCntLbl;
    protected JLabel m_warningCntLbl;
    protected StandardBPELEditor m_editor;
    protected SortedTableHeaderRenderer m_headerRenderer;
    protected int m_errorCnt;
    protected int m_warningCnt;

    public ModelValidationPanel(StandardBPELEditor editor) {
        this.setBackground(Color.white);
        this.m_editor = editor;
        this.createControls();
        this.layoutControls();
        this.updateControls();
    }

    public void load(final List<ModelWarning> warnings) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ModelWarningTableModel m = (ModelWarningTableModel)((Object)ModelValidationPanel.this.m_table.getModel());
                m.getData().clear();
                m.setData(warnings);
                m.refresh();
                ModelValidationPanel.this.m_errorCnt = 0;
                ModelValidationPanel.this.m_warningCnt = 0;
                for (ModelWarning w : m.getData()) {
                    if (w.isError()) {
                        ++ModelValidationPanel.this.m_errorCnt;
                        continue;
                    }
                    ++ModelValidationPanel.this.m_warningCnt;
                }
                ModelValidationPanel.this.setValidationTimeLabel();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void setProcessLabelText(String text) {
        this.m_processLbl.setText(text);
    }

    protected void setValidationTimeLabel() {
        this.m_statusLbl.setText(BPELStringTranslator.getString("SEARCH_LAST_VALIDATED_ON") + new Date().toGMTString());
        this.m_errorCntLbl.setText(BPELStringTranslator.getString("SEARCH_ERRORS") + this.m_errorCnt);
        this.m_warningCntLbl.setText(BPELStringTranslator.getString("SEARCH_WARNINGS") + this.m_warningCnt);
    }

    protected void setStatusMessage(final String msg) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.m_statusLbl.setText(msg);
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ModelValidationPanel.this.m_statusLbl.setText(msg);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void createControls() {
        this.m_errorCntLbl = new JLabel(BPELStringTranslator.getString("SEARCH_ERRORS"), null, 2);
        this.m_warningCntLbl = new JLabel(BPELStringTranslator.getString("SEARCH_WARNINGS"), null, 2);
        this.m_table = new JTable((TableModel)((Object)new ModelWarningTableModel()));
        this.m_table.setRowHeight(18);
        new JTableCellRendererExtendor(this.m_table);
        this.m_table.setSelectionMode(0);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        SortableTable st = new SortableTable(){

            public void sortColumn(int col, boolean bAscending) {
                ModelValidationPanel.this.sortTable(col, bAscending);
            }

            public JTable getJTable() {
                return ModelValidationPanel.this.m_table;
            }

            public int getSortingColumn() {
                return 1;
            }

            public boolean getSortAscending() {
                return true;
            }
        };
        DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
        defaultRenderer.setHorizontalAlignment(0);
        this.m_headerRenderer = new SortedTableHeaderRenderer(st);
        TableColumnModel colModel = this.m_table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            col.setHeaderRenderer((TableCellRenderer)this.m_headerRenderer);
            if (i != 0) continue;
            col.setMinWidth(30);
            col.setMaxWidth(30);
            col.setCellRenderer(new ModelTableImageCellRenderer());
        }
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = ModelValidationPanel.this.m_table.rowAtPoint(origin);
                int column = ModelValidationPanel.this.m_table.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    ModelValidationPanel.this.handleSelectInDiagram();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ModelValidationPanel.this.handlePopupTrigger(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ModelValidationPanel.this.handlePopupTrigger(e);
                }
            }
        });
        this.m_processLbl = new JLabel("", 2);
        this.m_processLbl.setText(BPELStringTranslator.getString("PM_RELATED_WARNINGS"));
        this.m_statusLbl = new JLabel(BPELStringTranslator.getString("SEARCH_LAST_VALIDATED_ON"), 4);
        this.m_popup = new JPopupMenu();
    }

    protected void handlePopupTrigger(MouseEvent evt) {
        if (this.m_popup.getComponentCount() > 0) {
            this.m_popup.show(this.m_table, evt.getX(), evt.getY());
        }
    }

    protected void updateControls() {
        int numSelectedRows = this.m_table.getSelectedRowCount();
    }

    protected void layoutControls() {
        JPanel botPnl = new JPanel(new GridBagLayout());
        botPnl.setOpaque(false);
        GraphUtils.addComponent((Container)botPnl, (Component)this.m_errorCntLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)botPnl, (Component)this.m_warningCntLbl, (int)1, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 4, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)botPnl, (Component)this.m_statusLbl, (int)2, (int)0, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(0, 2, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_processLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 2, 2), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.m_table), (int)0, (int)1, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)botPnl, (int)0, (int)2, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    protected void sortTable(final int col, final boolean bAscending) {
        ModelWarningTableModel model = (ModelWarningTableModel)((Object)this.m_table.getModel());
        Comparator<ModelWarning> c = new Comparator<ModelWarning>(){

            @Override
            public int compare(ModelWarning w1, ModelWarning w2) {
                String s1 = null;
                String s2 = null;
                switch (col) {
                    case 2: {
                        s1 = w1.getModel();
                        s2 = w2.getModel();
                        break;
                    }
                    case 1: {
                        s1 = w1.getWarning();
                        s2 = w2.getWarning();
                    }
                }
                if (s1 == null) {
                    s1 = "";
                }
                if (s2 == null) {
                    s2 = "";
                }
                if (bAscending) {
                    return s1.compareTo(s2);
                }
                return s2.compareTo(s1);
            }

            @Override
            public boolean equals(Object obj) {
                return obj.equals(this);
            }
        };
        Collections.sort(model.getData(), c);
        model.refresh();
    }

    protected void handleDetails() {
        ListSelectionModel selModel = this.m_table.getSelectionModel();
        if (selModel.isSelectionEmpty()) {
            return;
        }
        int row = selModel.getLeadSelectionIndex();
    }

    protected void handleSelectInDiagram() {
        ListSelectionModel selModel = this.m_table.getSelectionModel();
        if (selModel.isSelectionEmpty()) {
            return;
        }
        int row = selModel.getLeadSelectionIndex();
        ModelWarningTableModel m = (ModelWarningTableModel)((Object)this.m_table.getModel());
        ModelWarning w = (ModelWarning)m.getRowData(row);
        Object editorObj = w.getEditorObject();
        if (editorObj instanceof Activity) {
            Activity a = (Activity)editorObj;
            BPELGraphPane graph = this.m_editor.getBPELGraphPane();
            graph.selectActivity(a);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateControls();
    }
}

