/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Stack;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Handler;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidatorCallback;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.common.ui.JTableCellRendererExtendor;
import oracle.tip.tools.ide.common.ui.SortableTable;
import oracle.tip.tools.ide.common.ui.SortedTableHeaderRenderer;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.ActivityXPathInfo;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.ValidatorErrorInfo;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.ValidatorErrorInfoTableModel;
import oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser.ValidationBrowser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BPELValidatorErrorPanel
extends JPanel
implements ValidatorCallback,
ActionListener,
ListSelectionListener {
    protected JPopupMenu m_popup;
    protected JTable m_table;
    protected JLabel m_processLbl;
    protected JLabel m_statusLbl;
    protected JLabel m_errorCntLbl;
    protected JLabel m_warningCntLbl;
    protected JButton m_detailsBtn;
    protected JButton m_selectInDiagramBtn;
    protected JMenuItem m_selectInDiagramItem;
    protected JMenuItem m_detailsItem;
    protected BPELGraphPane m_graph;
    protected SortedTableHeaderRenderer m_headerRenderer;
    protected Vector<ValidatorErrorInfo> m_data = new Vector();
    protected int m_errorCnt;
    protected int m_warningCnt;

    public BPELValidatorErrorPanel() {
        this.setBackground(Color.white);
        this.createControls();
        this.layoutControls();
        this.updateControls();
    }

    public void setProcessLabelText(String text) {
        this.m_processLbl.setText(text);
    }

    public BPELGraphPane getGraphPane() {
        return this.m_graph;
    }

    public synchronized void setGraphPane(BPELGraphPane pane) {
        this.m_graph = pane;
        if (this.m_graph != null) {
            BPELProject prj = pane.getBPELProject();
            if (prj != null) {
                URL u = prj.getBPELFileURL();
                this.setProcessLabelText(Helper.getFileName((URL)u) + " " + BPELStringTranslator.getString("LOGGING_WARNINGS") + ":");
            }
        } else {
            this.clear();
            this.setProcessLabelText("");
        }
        this.m_statusLbl.setText(" ");
    }

    public void clear() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ValidatorErrorInfoTableModel model = (ValidatorErrorInfoTableModel)((Object)BPELValidatorErrorPanel.this.m_table.getModel());
                model.getData().clear();
                model.refresh();
                BPELValidatorErrorPanel.this.updateControls();
                BPELValidatorErrorPanel.this.m_statusLbl.setText(" ");
                BPELValidatorErrorPanel.this.setProcessLabelText(" ");
                BPELValidatorErrorPanel.this.m_errorCntLbl.setText(BPELStringTranslator.getString("SEARCH_ERRORS"));
                BPELValidatorErrorPanel.this.m_warningCntLbl.setText(BPELStringTranslator.getString("SEARCH_WARNINGS"));
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void setValidationTimeLabel() {
        this.m_statusLbl.setText(BPELStringTranslator.getString("SEARCH_LAST_VALIDATED_ON") + new Date().toGMTString());
        this.m_errorCntLbl.setText(BPELStringTranslator.getString("SEARCH_ERRORS") + this.m_errorCnt);
        this.m_warningCntLbl.setText(BPELStringTranslator.getString("SEARCH_WARNINGS") + this.m_warningCnt);
    }

    protected void setStatusMessage(final String msg) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.m_statusLbl.setText(msg);
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    BPELValidatorErrorPanel.this.m_statusLbl.setText(msg);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void loadTable() {
        this.m_headerRenderer.reset();
        ValidatorErrorInfoTableModel model = (ValidatorErrorInfoTableModel)((Object)this.m_table.getModel());
        model.setData(this.m_data);
        UIHelper.adjustTableColumns((JTable)this.m_table);
        model.refresh();
        this.updateControls();
    }

    protected void createControls() {
        this.m_errorCntLbl = new JLabel(BPELStringTranslator.getString("SEARCH_ERRORS"), null, 2);
        this.m_warningCntLbl = new JLabel(BPELStringTranslator.getString("SEARCH_WARNINGS"), null, 2);
        this.m_table = new JTable((TableModel)((Object)new ValidatorErrorInfoTableModel()));
        this.m_table.setRowHeight(18);
        new JTableCellRendererExtendor(this.m_table);
        this.m_table.setSelectionMode(0);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        SortableTable st = new SortableTable(){

            public void sortColumn(int col, boolean bAscending) {
                BPELValidatorErrorPanel.this.sortResults(col, bAscending);
            }

            public JTable getJTable() {
                return BPELValidatorErrorPanel.this.m_table;
            }

            public int getSortingColumn() {
                return 1;
            }

            public boolean getSortAscending() {
                return true;
            }
        };
        DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
        defaultRenderer.setHorizontalAlignment(0);
        this.m_headerRenderer = new SortedTableHeaderRenderer(st);
        TableColumnModel colModel = this.m_table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            col.setHeaderRenderer((TableCellRenderer)this.m_headerRenderer);
            if (i == 0) {
                col.setMinWidth(30);
                col.setMaxWidth(30);
                col.setCellRenderer(new ImageColumnTableCellRenderer());
                continue;
            }
            if (i == 1) continue;
            col.setCellRenderer(defaultRenderer);
        }
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = BPELValidatorErrorPanel.this.m_table.rowAtPoint(origin);
                int column = BPELValidatorErrorPanel.this.m_table.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    BPELValidatorErrorPanel.this.handleSelectInDiagram();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BPELValidatorErrorPanel.this.handlePopupTrigger(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BPELValidatorErrorPanel.this.handlePopupTrigger(e);
                }
            }
        });
        this.m_processLbl = new JLabel("", 2);
        this.m_detailsBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("wrench16"));
        this.m_detailsBtn.addActionListener(this);
        this.m_detailsBtn.setToolTipText(BPELStringTranslator.getString("VIEW_VALIDATION_DETAILS"));
        this.m_selectInDiagramBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("selection_find.png"));
        this.m_selectInDiagramBtn.addActionListener(this);
        this.m_selectInDiagramBtn.setToolTipText(BPELStringTranslator.getString("SEARCH_SELECT_IN_DIAGRAM"));
        this.m_statusLbl = new JLabel(BPELStringTranslator.getString("SEARCH_LAST_VALIDATED_ON"), 4);
        this.m_popup = new JPopupMenu();
        this.m_selectInDiagramItem = new JMenuItem(BPELStringTranslator.getString("SEARCH_SELECT_IN_DIAGRAM"), ImageCache.getIcon("selection_find.png"));
        this.m_selectInDiagramItem.addActionListener(this);
        this.m_detailsItem = new JMenuItem(BPELStringTranslator.getString("SEARCH_VIEW_VALIDATION_RESULTS"), ImageCache.getIcon("wrench16"));
        this.m_detailsItem.addActionListener(this);
        this.m_popup.add(this.m_detailsItem);
        this.m_popup.add(this.m_selectInDiagramItem);
    }

    protected void handlePopupTrigger(MouseEvent evt) {
        if (this.m_popup.getComponentCount() > 0) {
            this.m_popup.show(this.m_table, evt.getX(), evt.getY());
        }
    }

    protected void updateControls() {
        int numSelectedRows = this.m_table.getSelectedRowCount();
        this.m_detailsBtn.setEnabled(numSelectedRows > 0);
        this.m_selectInDiagramBtn.setEnabled(numSelectedRows > 0);
    }

    protected void layoutControls() {
        JPanel botPnl = new JPanel(new GridBagLayout());
        botPnl.setOpaque(false);
        GraphUtils.addComponent((Container)botPnl, (Component)this.m_errorCntLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)botPnl, (Component)this.m_warningCntLbl, (int)1, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 4, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)botPnl, (Component)this.m_statusLbl, (int)2, (int)0, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(0, 2, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_processLbl, (int)0, (int)0, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(2, 5, 2, 2), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_detailsBtn, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(2, 2, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_selectInDiagramBtn, (int)2, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(2, 0, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)GraphUtils.getScrollPane((Component)this.m_table), (int)0, (int)1, (int)3, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)botPnl, (int)0, (int)2, (int)3, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    protected void sortResults(int col, final boolean bAscending) {
        ValidatorErrorInfoTableModel model = (ValidatorErrorInfoTableModel)((Object)this.m_table.getModel());
        if (col == 1) {
            Comparator<ValidatorErrorInfo> c = new Comparator<ValidatorErrorInfo>(){

                @Override
                public int compare(ValidatorErrorInfo info1, ValidatorErrorInfo info2) {
                    String s2;
                    String s1 = info1.getXPathString();
                    if (s1 == null) {
                        s1 = "";
                    }
                    if ((s2 = info2.getXPathString()) == null) {
                        s2 = "";
                    }
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        } else if (col == 3) {
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    ValidationReport report2;
                    int val1 = 0;
                    int val2 = 0;
                    ValidatorErrorInfo info1 = (ValidatorErrorInfo)o1;
                    ValidatorErrorInfo info2 = (ValidatorErrorInfo)o2;
                    ValidationReport report1 = info1.getReport();
                    if (report1 != null) {
                        val1 = report1.getNumErrors();
                    }
                    if ((report2 = info2.getReport()) != null) {
                        val2 = report2.getNumErrors();
                    }
                    if (val1 == val2) {
                        return 0;
                    }
                    if (bAscending) {
                        return val1 > val2 ? 1 : -1;
                    }
                    return val1 > val2 ? -1 : 1;
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        } else if (col == 2 || col == 0) {
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s2;
                    ValidatorErrorInfo info1 = (ValidatorErrorInfo)o1;
                    ValidatorErrorInfo info2 = (ValidatorErrorInfo)o2;
                    String s1 = info1.getTypeString();
                    if (s1 == null) {
                        s1 = "";
                    }
                    if ((s2 = info2.getTypeString()) == null) {
                        s2 = "";
                    }
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        }
    }

    protected void handleDetails() {
        if (this.m_graph == null) {
            return;
        }
        ListSelectionModel selModel = this.m_table.getSelectionModel();
        if (selModel.isSelectionEmpty()) {
            return;
        }
        int row = selModel.getLeadSelectionIndex();
        ValidatorErrorInfoTableModel model = (ValidatorErrorInfoTableModel)((Object)this.m_table.getModel());
        ValidatorErrorInfo info = (ValidatorErrorInfo)model.getData().elementAt(row);
        ValidationBrowser browser = new ValidationBrowser(GraphUtils.getFrame((Component)((Object)this.m_graph)), this.m_graph, info.getValidatable());
        browser.display();
    }

    protected Stack computeXPath(Validatable validatedObj) {
        Stack<ActivityXPathInfo> stack = new Stack<ActivityXPathInfo>();
        if (validatedObj instanceof Activity) {
            Activity a = (Activity)validatedObj;
            while (a != null) {
                Handler h;
                ActivityXPathInfo item = new ActivityXPathInfo((Validatable)a);
                stack.push(item);
                Activity temp = a;
                if ((a = a.getParentActivity()) != null || (h = temp.getParentHandler()) == null) continue;
                a = h.getHandlerParentActivity();
            }
        } else if (validatedObj instanceof PartnerLink) {
            ActivityXPathInfo item = new ActivityXPathInfo(validatedObj);
            stack.push(item);
        }
        return stack;
    }

    protected void handleSelectInDiagram() {
        if (this.m_graph == null) {
            return;
        }
        ListSelectionModel selModel = this.m_table.getSelectionModel();
        if (selModel.isSelectionEmpty()) {
            return;
        }
        int row = selModel.getLeadSelectionIndex();
        ValidatorErrorInfoTableModel model = (ValidatorErrorInfoTableModel)((Object)this.m_table.getModel());
        ValidatorErrorInfo info = (ValidatorErrorInfo)model.getData().elementAt(row);
        Validatable v = info.getValidatable();
        if (v instanceof Activity) {
            this.m_graph.selectActivity((Activity)v);
        } else if (v instanceof PartnerLink) {
            this.m_graph.selectPartnerLink((PartnerLink)v);
        }
    }

    public void start() {
        this.m_data.clear();
        this.m_errorCnt = 0;
        this.m_warningCnt = 0;
        this.setStatusMessage(BPELStringTranslator.getString("SEARCH_VALIDATING"));
    }

    public void validated(Validatable validatedObj, ValidationReport report) {
        if (this.m_graph == null) {
            return;
        }
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        if (graphModel == null) {
            return;
        }
        Process p = graphModel.getProcess();
        if (report.hasErrors()) {
            this.m_data.add(new ValidatorErrorInfo(p, validatedObj, report, this.computeXPath(validatedObj)));
            this.m_errorCnt += report.getNumErrors();
        }
        if (report.hasWarnings()) {
            this.m_data.add(new ValidatorErrorInfo(p, validatedObj, report, this.computeXPath(validatedObj)));
            this.m_warningCnt += report.getNumWarnings();
        }
    }

    public void statusMessage(String connStr) {
        this.setStatusMessage(connStr);
    }

    public void finish() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BPELValidatorErrorPanel.this.setValidationTimeLabel();
                BPELValidatorErrorPanel.this.loadTable();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public boolean isValidationCanceled() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_detailsBtn || src == this.m_detailsItem) {
            this.handleDetails();
        } else if (src == this.m_selectInDiagramItem || src == this.m_selectInDiagramBtn) {
            this.handleSelectInDiagram();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateControls();
    }

    public class ImageColumnTableCellRenderer
    extends DefaultTableCellRenderer {
        public ImageColumnTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ValidatorErrorInfoTableModel model = (ValidatorErrorInfoTableModel)((Object)table.getModel());
            if (row >= 0 && row < model.getData().size()) {
                ValidatorErrorInfo info = (ValidatorErrorInfo)model.getData().elementAt(row);
                if (info.hasErrors()) {
                    this.setIcon(GlobalImageCache.getIcon((String)"error.png"));
                } else if (info.hasWarnings()) {
                    this.setIcon(ImageCache.getIcon("warning16"));
                } else {
                    this.setIcon(ImageCache.getIcon("help2.png"));
                }
            }
            if (column == 0) {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }
}

