/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.search.SearchData;
import oracle.tip.tools.ide.common.bpelparser.search.SearchResult;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.SortableTable;
import oracle.tip.tools.ide.common.ui.SortedTableHeaderRenderer;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.WaitPanel;
import oracle.tip.tools.ide.common.ui.models.BaseTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.ActivityTypeSearchResultTableModel;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.SearchResultTableCellRenderer;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.SearchResultTableModel;
import oracle.tip.tools.ide.pm.gui.explorer.ExplorerTreeCellRenderer;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BPELSearchResultPanel
extends JPanel
implements ActionListener {
    public static final String TABLE_PANEL = "TABLE_PANEL";
    public static final String WAIT_PANEL = "WAIT_PANEL";
    protected JPopupMenu m_popup;
    protected JMenuItem m_clearItem;
    protected JMenuItem m_selectInDiagramItem;
    protected JTable m_table;
    protected CardPanel m_cardPnl;
    protected BPELGraphPane m_graph;
    protected JLabel m_titleLbl;
    protected JLabel m_foundLbl;
    protected JButton m_clearBtn;
    protected JButton m_selectInDiagramBtn;
    protected SortedTableHeaderRenderer m_header;

    public BPELSearchResultPanel() {
        this.createControls();
        this.layoutControls();
        this.updateControls();
    }

    public BPELGraphPane getGraph() {
        return this.m_graph;
    }

    public void showWaitPanel() {
        this.m_cardPnl.show(WAIT_PANEL);
    }

    public void showTablePanel() {
        this.m_cardPnl.show(TABLE_PANEL);
    }

    public void setActivitySearchData(BPELGraphPane graph, SearchData criteria, List data) {
        this.m_graph = graph;
        String s = BPELStringTranslator.getString("LOGGING_SEARCHING_FOR_TYPES");
        String types = "";
        if (criteria.m_bSearchAssign) {
            types = types + ", Assign";
        }
        if (criteria.m_bSearchInvoke) {
            types = types + ", Invoke";
        }
        if (criteria.m_bSearchReply) {
            types = types + ", Reply";
        }
        if (criteria.m_bSearchReceive) {
            types = types + ", Receive";
        }
        if (criteria.m_bSearchScope) {
            types = types + ", Scope";
        }
        if (criteria.m_bSearchSequence) {
            types = types + ", Sequence";
        }
        if (criteria.m_bSearchTransform) {
            types = types + ", Transform";
        }
        if (criteria.m_bSearchWait) {
            types = types + ", Wait";
        }
        if (criteria.m_bSearchEmpty) {
            types = types + ", Empty";
        }
        if (criteria.m_bSearchCompensate) {
            types = types + ", Compensate";
        }
        if (criteria.m_bSearchJavaEmbed) {
            types = types + ", Java Embedding";
        }
        if (criteria.m_bSearchPartnerLink) {
            types = types + ", Partner Link";
        }
        if (criteria.m_bSearchCatch) {
            types = types + ", Catch";
        }
        if (criteria.m_bSearchCatchAll) {
            types = types + ", CatchAll";
        }
        if (criteria.m_bSearchOnMessage) {
            types = types + ", OnMessage";
        }
        if (criteria.m_bSearchOnAlarm) {
            types = types + ", OnAlarm";
        }
        if (criteria.m_bSearchSwitch) {
            types = types + ", Switch";
        }
        if (criteria.m_bSearchFlow) {
            types = types + ", Flow";
        }
        if (criteria.m_bSearchFlowN) {
            types = types + ", FlowN";
        }
        if (criteria.m_bSearchTerminate) {
            types = types + ", Terminate";
        }
        if (criteria.m_bSearchThrow) {
            types = types + ", Throw";
        }
        if (criteria.m_bSearchWhile) {
            types = types + ", While";
        }
        if (criteria.m_bSearchPick) {
            types = types + ", Pick";
        }
        if (types.startsWith(", ")) {
            types = types.substring(2);
        }
        this.m_titleLbl.setText(s + types);
        this.m_foundLbl.setText(BPELStringTranslator.formatString("LOGGING_SEARCH_FOUND", "" + data.size()));
        final ActivityTypeSearchResultTableModel model = new ActivityTypeSearchResultTableModel();
        Vector v = new Vector(data);
        model.setData(v);
        if (SwingUtilities.isEventDispatchThread()) {
            this.buildTable((TableModel)((Object)model));
            this.updateControls();
            this.showTablePanel();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    BPELSearchResultPanel.this.buildTable((TableModel)((Object)model));
                    BPELSearchResultPanel.this.updateControls();
                    BPELSearchResultPanel.this.showTablePanel();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void buildTable(final TableModel model) {
        this.m_table.setModel(model);
        DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
        defaultRenderer.setHorizontalAlignment(0);
        SortableTable st = new SortableTable(){

            public void sortColumn(int col, boolean bAscending) {
                if (model instanceof SearchResultTableModel) {
                    BPELSearchResultPanel.this.sortResults(col, bAscending);
                }
            }

            public JTable getJTable() {
                return BPELSearchResultPanel.this.m_table;
            }

            public int getSortingColumn() {
                return 1;
            }

            public boolean getSortAscending() {
                return true;
            }
        };
        this.m_header = new SortedTableHeaderRenderer(st);
        if (model instanceof SearchResultTableModel) {
            TableColumnModel colModel = this.m_table.getColumnModel();
            for (int i = 0; i < colModel.getColumnCount(); ++i) {
                TableColumn col = colModel.getColumn(i);
                col.setHeaderRenderer((TableCellRenderer)this.m_header);
                if (i == 0) {
                    col.setMinWidth(30);
                    col.setMaxWidth(30);
                    col.setCellRenderer(new ImageColumnTableCellRenderer());
                    continue;
                }
                if (i == 1) {
                    col.setPreferredWidth(400);
                    col.setWidth(400);
                    col.setCellRenderer(new SearchResultTableCellRenderer());
                    continue;
                }
                col.setPreferredWidth(120);
                col.setCellRenderer(defaultRenderer);
            }
        } else if (model instanceof ActivityTypeSearchResultTableModel) {
            DefaultTableCellRenderer r1 = new DefaultTableCellRenderer();
            DefaultTableCellRenderer r2 = new DefaultTableCellRenderer();
            r2.setHorizontalAlignment(0);
            TableColumnModel colModel = this.m_table.getColumnModel();
            for (int i = 0; i < colModel.getColumnCount(); ++i) {
                TableColumn col = colModel.getColumn(i);
                col.setHeaderRenderer((TableCellRenderer)this.m_header);
                if (i == 0) {
                    col.setMinWidth(30);
                    col.setMaxWidth(30);
                    col.setCellRenderer(new ImageColumnTableCellRenderer());
                    continue;
                }
                if (i == 3) {
                    col.setPreferredWidth(120);
                    col.setCellRenderer(r2);
                    continue;
                }
                col.setPreferredWidth(120);
                col.setCellRenderer(r1);
            }
        }
        this.m_table.getTableHeader().setReorderingAllowed(false);
    }

    public void setData(BPELGraphPane graph, SearchData criteria, List data) {
        this.m_graph = graph;
        this.m_titleLbl.setText(BPELStringTranslator.getString("LOGGING_SEARCHING_FOR") + criteria.m_searchStr);
        this.m_foundLbl.setText(BPELStringTranslator.formatString("LOGGING_SEARCH_FOUND", "" + data.size()));
        final SearchResultTableModel model = new SearchResultTableModel();
        Vector v = new Vector(data);
        model.setData(v);
        if (SwingUtilities.isEventDispatchThread()) {
            this.buildTable((TableModel)((Object)model));
            this.showTablePanel();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    BPELSearchResultPanel.this.buildTable((TableModel)((Object)model));
                    BPELSearchResultPanel.this.updateControls();
                    BPELSearchResultPanel.this.showTablePanel();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    protected void createControls() {
        this.m_cardPnl = new CardPanel();
        this.m_cardPnl.add(TABLE_PANEL, (Component)this.createMainPanel());
        this.m_cardPnl.add(WAIT_PANEL, (Component)this.createWaitPanel());
        this.showTablePanel();
        this.m_clearItem = new JMenuItem(BPELStringTranslator.getString("SEARCH_CLEAR", "Clear"), ImageCache.getIcon("application/bpel/clear.png"));
        this.m_clearItem.addActionListener(this);
        this.m_selectInDiagramItem = new JMenuItem(BPELStringTranslator.getString("SEARCH_SELECT_IN_DIAGRAM", "Select in Diagram"), ImageCache.getIcon("selection_find.png"));
        this.m_selectInDiagramItem.addActionListener(this);
        this.m_popup = new JPopupMenu();
        this.m_popup.add(this.m_selectInDiagramItem);
        this.m_popup.add(this.m_clearItem);
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)this.m_cardPnl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    protected JPanel createWaitPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)new WaitPanel(), (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        return p;
    }

    protected void gotoFoundResult() {
        PartnerLink l;
        if (this.m_graph == null) {
            return;
        }
        ListSelectionModel model = this.m_table.getSelectionModel();
        if (model.isSelectionEmpty()) {
            return;
        }
        int row = model.getLeadSelectionIndex();
        BaseTableModel tableModel = (BaseTableModel)this.m_table.getModel();
        SearchResult r = (SearchResult)tableModel.getRowData(row);
        if (r.getObjectType() == 1) {
            Activity a = r.getActivity();
            this.m_graph.selectActivity(a);
        } else if (r.getObjectType() == 0 && (l = r.getPartnerLink()) != null) {
            this.m_graph.selectPartnerLink(l);
        }
    }

    protected JPanel createMainPanel() {
        this.m_selectInDiagramBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("selection_find.png"));
        this.m_selectInDiagramBtn.addActionListener(this);
        this.m_selectInDiagramBtn.setToolTipText(BPELStringTranslator.getString("SEARCH_SELECT_IN_DIAGRAM", "Select in Diagram"));
        this.m_clearBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("garbage_empty16"));
        this.m_clearBtn.addActionListener(this);
        this.m_clearBtn.setToolTipText(BPELStringTranslator.getString("SEARCH_CLEAR", "Clear"));
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 0, 0));
        btnPnl.add(this.m_selectInDiagramBtn);
        btnPnl.add(this.m_clearBtn);
        this.m_titleLbl = new JLabel();
        this.m_foundLbl = new JLabel();
        this.m_table = new JTable((TableModel)((Object)new SearchResultTableModel()));
        this.m_table.setRowHeight(18);
        this.m_table.setSelectionMode(0);
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BPELSearchResultPanel.this.handlePopupTrigger(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BPELSearchResultPanel.this.handlePopupTrigger(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Point origin = e.getPoint();
                int row = BPELSearchResultPanel.this.m_table.rowAtPoint(origin);
                int column = BPELSearchResultPanel.this.m_table.columnAtPoint(origin);
                if (row == -1 || column == -1) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    BPELSearchResultPanel.this.gotoFoundResult();
                }
            }
        });
        this.m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BPELSearchResultPanel.this.updateControls();
            }
        });
        this.buildTable((TableModel)((Object)new SearchResultTableModel()));
        JPanel p = new JPanel(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)this.m_titleLbl, (int)0, (int)0, (int)1, (int)1, (int)16, (int)2, (Insets)new Insets(2, 5, 2, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)btnPnl, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(2, 0, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)GraphUtils.getScrollPane((Component)this.m_table), (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_foundLbl, (int)0, (int)2, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        return p;
    }

    protected void sortResults(int col, boolean bAscending) {
        BaseTableModel model = (BaseTableModel)this.m_table.getModel();
        if (model instanceof SearchResultTableModel) {
            this.sortTextSearch(col, bAscending);
        } else if (model instanceof ActivityTypeSearchResultTableModel) {
            this.sortActivitySearch(col, bAscending);
        }
    }

    protected void sortActivitySearch(int col, final boolean bAscending) {
        ActivityTypeSearchResultTableModel model = (ActivityTypeSearchResultTableModel)((Object)this.m_table.getModel());
        if (col == 1) {
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    SearchResult r1 = (SearchResult)o1;
                    SearchResult r2 = (SearchResult)o2;
                    String s1 = null;
                    String s2 = null;
                    if (r1.getObjectType() == 1) {
                        s1 = r1.getActivity().getName();
                    } else if (r1.getObjectType() == 0) {
                        s1 = r1.getPartnerLink().getName();
                    }
                    if (r2.getObjectType() == 1) {
                        s2 = r2.getActivity().getName();
                    } else if (r2.getObjectType() == 0) {
                        s2 = r2.getPartnerLink().getName();
                    }
                    if (s1 == null) {
                        s1 = "";
                    }
                    if (s2 == null) {
                        s2 = "";
                    }
                    return bAscending ? s1.compareTo(s2) : s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        } else if (col == 3 || col == 0) {
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    SearchResult r1 = (SearchResult)o1;
                    SearchResult r2 = (SearchResult)o2;
                    if (bAscending) {
                        return r1.getObjectTypeAsString().compareTo(r2.getObjectTypeAsString());
                    }
                    return r2.getObjectTypeAsString().compareTo(r1.getObjectTypeAsString());
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        } else if (col == 2) {
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s2;
                    SearchResult r1 = (SearchResult)o1;
                    SearchResult r2 = (SearchResult)o2;
                    String s1 = r1.getXPath();
                    if (s1 == null) {
                        s1 = "";
                    }
                    if ((s2 = r2.getXPath()) == null) {
                        s2 = "";
                    }
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        }
    }

    protected void sortTextSearch(int col, final boolean bAscending) {
        SearchResultTableModel model = (SearchResultTableModel)((Object)this.m_table.getModel());
        if (col == 1) {
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s2;
                    SearchResult r1 = (SearchResult)o1;
                    SearchResult r2 = (SearchResult)o2;
                    String s1 = r1.getFoundString();
                    if (s1 == null) {
                        s1 = "";
                    }
                    if ((s2 = r2.getFoundString()) == null) {
                        s2 = "";
                    }
                    if (bAscending) {
                        return s1.compareTo(s2);
                    }
                    return s2.compareTo(s1);
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        } else if (col == 0) {
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    SearchResult r1 = (SearchResult)o1;
                    SearchResult r2 = (SearchResult)o2;
                    if (r1.getFoundInType() == r2.getFoundInType()) {
                        return 0;
                    }
                    if (bAscending) {
                        return r1.getFoundInType() < r2.getFoundInType() ? -1 : 1;
                    }
                    return r1.getFoundInType() > r2.getFoundInType() ? -1 : 1;
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        } else if (col == 2) {
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    SearchResult r1 = (SearchResult)o1;
                    SearchResult r2 = (SearchResult)o2;
                    if (bAscending) {
                        return r1.getObjectTypeAsString().compareTo(r2.getObjectTypeAsString());
                    }
                    return r2.getObjectTypeAsString().compareTo(r1.getObjectTypeAsString());
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        } else if (col == 3) {
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    SearchResult r1 = (SearchResult)o1;
                    SearchResult r2 = (SearchResult)o2;
                    if (bAscending) {
                        return r1.getDescription().compareTo(r2.getDescription());
                    }
                    return r2.getDescription().compareTo(r1.getDescription());
                }

                @Override
                public boolean equals(Object obj) {
                    return obj.equals(this);
                }
            };
            Collections.sort(model.getData(), c);
            model.refresh();
        }
    }

    protected void updateControls() {
        this.m_clearBtn.setEnabled(this.m_table.getRowCount() > 0);
        this.m_selectInDiagramBtn.setEnabled(this.m_table.getSelectedRowCount() > 0);
    }

    public void clear() {
        this.m_graph = null;
        this.m_titleLbl.setText(" ");
        this.m_foundLbl.setText(" ");
        BaseTableModel model = (BaseTableModel)this.m_table.getModel();
        this.m_header.reset();
        model.getData().clear();
        model.refresh();
        this.updateControls();
    }

    protected void handlePopupTrigger(MouseEvent evt) {
        if (this.m_popup.getComponentCount() > 0) {
            this.m_popup.show(this.m_table, evt.getX(), evt.getY());
        }
    }

    protected void selectInDiagram() {
        if (this.m_graph == null) {
            return;
        }
        ListSelectionModel selModel = this.m_table.getSelectionModel();
        if (selModel.isSelectionEmpty()) {
            return;
        }
        int row = selModel.getLeadSelectionIndex();
        BaseTableModel model = (BaseTableModel)this.m_table.getModel();
        SearchResult r = (SearchResult)model.getData().elementAt(row);
        if (r.getObjectType() == 1) {
            this.m_graph.selectActivity(r.getActivity());
        } else if (r.getObjectType() == 0) {
            this.m_graph.selectPartnerLink(r.getPartnerLink());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_clearItem || src == this.m_clearBtn) {
            this.clear();
        } else if (src == this.m_selectInDiagramBtn || src == this.m_selectInDiagramItem) {
            this.selectInDiagram();
        }
    }

    public class ImageColumnTableCellRenderer
    extends DefaultTableCellRenderer {
        public ImageColumnTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setText("");
            this.setBackground(Color.white);
            if (value instanceof SearchResult) {
                SearchResult r = (SearchResult)value;
                switch (r.getObjectType()) {
                    case 0: {
                        this.setIcon(ImageCache.getIcon("partner_link_node"));
                        break;
                    }
                    case 1: {
                        this.setIcon(ExplorerTreeCellRenderer.getActivityIcon(r.getActivity()));
                        break;
                    }
                    default: {
                        this.setIcon(ImageCache.getIcon("help2.png"));
                    }
                }
            }
            return this;
        }
    }
}

