/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BPELProjectLogPanel
extends JPanel
implements ActionListener {
    public static final int ERROR_MESSAGE = 0;
    public static final int WARNING_MESSAGE = 1;
    public static final int NORMAL_MESSAGE = 2;
    static SimpleAttributeSet ERROR_STYLE_SET = null;
    static SimpleAttributeSet WARNING_STYLE_SET = null;
    protected JTextPane m_textPane;
    protected JButton m_clearBtn;
    protected JPopupMenu m_popup;
    protected JMenuItem m_clearItem;
    protected JScrollPane m_scroller;

    public BPELProjectLogPanel() {
        this.createControls();
        this.layoutControls();
    }

    public boolean hasText() {
        String s = this.m_textPane.getText();
        return s != null && s.length() > 0;
    }

    public void addLineMessage(String msg, int messageType) {
        if (this.hasText()) {
            this.appendNewlineMessage(msg, messageType);
        } else {
            this.appendMessage(msg, messageType);
        }
    }

    public void appendNewlineMessage(String msg, int messageType) {
        this.appendMessage("\n" + msg, messageType);
    }

    public void appendMessage(String msg, int messageType) {
        try {
            SimpleAttributeSet styles = this.getStylesForType(messageType);
            Document doc = this.m_textPane.getDocument();
            int len = doc.getLength();
            doc.insertString(len, msg, styles);
            this.scrollToEnd();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void clearMessages() {
        this.m_textPane.setText("");
    }

    protected void scrollToEnd() {
        Document doc = this.m_textPane.getDocument();
        this.m_textPane.setCaretPosition(doc.getLength());
    }

    protected void insertIcon(Icon icon) {
        Document doc = this.m_textPane.getDocument();
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setIcon(attr, icon);
        try {
            this.m_textPane.getStyledDocument().insertString(doc.getLength(), " ", attr);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void insertText(String s, SimpleAttributeSet styles) {
        try {
            Document doc = this.m_textPane.getDocument();
            int len = doc.getLength();
            doc.insertString(len, s, styles);
            this.scrollToEnd();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected SimpleAttributeSet getStylesForType(int type) {
        switch (type) {
            case 0: {
                return ERROR_STYLE_SET;
            }
            case 1: {
                return WARNING_STYLE_SET;
            }
        }
        return null;
    }

    protected void createControls() {
        this.m_clearItem = new JMenuItem(BPELStringTranslator.getString("LOGGING_CLEAR_MESSAGES", "Clear Messages"), ImageCache.getIcon("garbage_empty16"));
        this.m_clearItem.addActionListener(this);
        this.m_popup = new JPopupMenu();
        this.m_popup.add(this.m_clearItem);
        this.m_textPane = new JTextPane();
        this.m_textPane.setEditable(false);
        this.m_textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BPELProjectLogPanel.this.handlePopupTrigger(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BPELProjectLogPanel.this.handlePopupTrigger(e);
                }
            }
        });
        this.m_clearBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("garbage_empty16"));
        this.m_clearBtn.addActionListener(this);
        this.m_clearBtn.setToolTipText(BPELStringTranslator.getString("LOGGING_CLEAR_MESSAGES", "Clear Messages"));
    }

    protected void handlePopupTrigger(MouseEvent evt) {
        if (this.m_popup.getComponentCount() > 0) {
            this.m_popup.show(this.m_textPane, evt.getX(), evt.getY());
        }
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        this.m_scroller = new JScrollPane(this.m_textPane);
        GraphUtils.addComponent((Container)this, (Component)this.m_scroller, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 5, 5, 5), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_clearBtn || src == this.m_clearItem) {
            this.clearMessages();
        }
    }

    static {
        ERROR_STYLE_SET = new SimpleAttributeSet();
        StyleConstants.setForeground(ERROR_STYLE_SET, Color.red);
        StyleConstants.setBold(ERROR_STYLE_SET, true);
        WARNING_STYLE_SET = new SimpleAttributeSet();
        StyleConstants.setForeground(WARNING_STYLE_SET, Color.blue);
    }
}

