/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow;

import java.awt.Color;
import java.awt.Font;
import javax.swing.UIManager;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;

public class ActivityXPathInfo {
    private Validatable m_validatable;
    private static Font m_font = UIManager.getFont("Tree.font");
    private static Font m_boldFont = new Font(m_font.getFontName(), 1, m_font.getSize());
    private static Font m_italicFont = new Font(m_font.getFontName(), 2, m_font.getSize());

    public ActivityXPathInfo(Validatable data) {
        this.m_validatable = data;
    }

    public String toString() {
        if (this.m_validatable instanceof Activity) {
            Activity a = (Activity)this.m_validatable;
            String s = a.getName();
            if (s == null) {
                s = BPELModelUtil.getTypeForActivity((Activity)a);
            }
            return s;
        }
        if (this.m_validatable instanceof PartnerLink) {
            PartnerLink plink = (PartnerLink)this.m_validatable;
            return plink.getName();
        }
        return "";
    }

    protected TextInfo createActivityTextInfo() {
        TextInfo info = new TextInfo();
        if (this.m_validatable == null) {
            return null;
        }
        if (this.m_validatable instanceof Activity) {
            Activity a = (Activity)this.m_validatable;
            if (a.getName() != null) {
                info.setText(a.getName());
                info.setFont(m_font);
                info.setColor(Color.black);
            } else {
                info.setText(BPELParser.getActivityTypeName((Activity)a));
                info.setFont(m_italicFont);
                info.setColor(Color.blue);
            }
        } else {
            info.setText(this.toString());
            info.setFont(m_boldFont);
            info.setColor(Color.black);
        }
        return info;
    }
}

