/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette2.PaletteItem;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.ProcessEvent;
import oracle.tip.tools.ide.common.bpelparser.iface.ProcessListener;
import oracle.tip.tools.ide.common.bpelparser.search.SearchData;
import oracle.tip.tools.ide.common.bpelparser.search.SearchUtil;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.util.ResolvedXPathObject;
import oracle.tip.tools.ide.common.bpelparser.validation.Validatable;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationReport;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidatorCallback;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.event.GraphModelEvent;
import oracle.tip.tools.ide.common.graph.event.GraphModelListener;
import oracle.tip.tools.ide.common.graph.event.GraphPaneStatusEvent;
import oracle.tip.tools.ide.common.graph.event.GraphPaneStatusListener;
import oracle.tip.tools.ide.common.graph.event.GraphSelectionEvent;
import oracle.tip.tools.ide.common.graph.event.GraphSelectionListener;
import oracle.tip.tools.ide.common.graph.model.GraphElement;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.StringTransferable;
import oracle.tip.tools.ide.common.graph.view.ViewTransferable;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.JButtonMenu;
import oracle.tip.tools.ide.common.ui.SearchTextField;
import oracle.tip.tools.ide.common.ui.SideBorder;
import oracle.tip.tools.ide.common.ui.buttontab.ButtonTab;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.pm.addin.logging.BPELModelerLogger;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModelListener;
import oracle.tip.tools.ide.pm.addin.model.ISecondaryModel;
import oracle.tip.tools.ide.pm.addin.model.ModelChangeNotifier;
import oracle.tip.tools.ide.pm.addin.model.ModelWarning;
import oracle.tip.tools.ide.pm.addin.model.ValidationContext;
import oracle.tip.tools.ide.pm.addin.preferences.BPELDesignerSettings;
import oracle.tip.tools.ide.pm.addin.structurepane.StructurePanePanel;
import oracle.tip.tools.ide.pm.addin.view.BPELDesignerGUI;
import oracle.tip.tools.ide.pm.addin.view.DrillDownPanel;
import oracle.tip.tools.ide.pm.addin.view.JDevPropertiesPanelUpdater;
import oracle.tip.tools.ide.pm.addin.view.LookAndFeel;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.Bookmark;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkAction;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkCategory;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarkDataStore;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.BookmarksDialog;
import oracle.tip.tools.ide.pm.bpelgraph.bookmarks.EditBookMarksAction;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilderPlugin;
import oracle.tip.tools.ide.pm.bpelgraph.settings.BPELSettings;
import oracle.tip.tools.ide.pm.bpelgraph.settings.GraphicsFileUtil;
import oracle.tip.tools.ide.pm.bpelgraph.settings.PartnerLinkTransferable;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELDNDDropHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneDragGestureHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneDropTargetListener;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPanePopupHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELNodeRendererDNDHandler;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.HeaderPanel;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.BPELSearchResultPanel;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.BPELValidatorErrorPanel;
import oracle.tip.tools.ide.pm.designerplugins.standard.plugin.perspective.logwindow.ValidationLogPanel;
import oracle.tip.tools.ide.pm.gui.dialogs.information.InformationDialog;
import oracle.tip.tools.ide.pm.gui.dialogs.search.SearchActivityTypeDialog;
import oracle.tip.tools.ide.pm.gui.dialogs.search.SearchDialog;
import oracle.tip.tools.ide.pm.gui.dialogs.validationbrowser.ValidationBrowser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.processbuilder.jdev.ProcessBuilderUtil;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Document;

public class StandardBPELEditor
extends JPanel
implements ActionListener,
ChangeListener,
GraphSelectionListener,
GraphPaneStatusListener {
    public static final String SEARCH_TAB = "SEARCH_TAB";
    public static final String VALIDATE_TAB = "VALIDATE_TAB";
    protected BPELGraphPane m_graph;
    protected JSlider m_zoomSlider;
    protected JButton m_zoomResetBtn;
    protected JButton m_informationBtn;
    protected JPanel m_xpathPanel;
    protected JSpinner m_zoomSpinner;
    protected SearchDialog m_searchDlg;
    protected SearchActivityTypeDialog m_searchTypeDlg;
    protected JButtonMenu m_bookMarksMenu;
    protected JButtonMenu m_drillDownMenu;
    protected JTextField m_xpathField;
    protected BPELDesignerGUI m_gui;
    protected JCheckBoxMenuItem m_showSwimLanesMenuItem;
    protected JCheckBoxMenuItem m_showConnectionsMenuItem;
    protected JCheckBoxMenuItem m_layoutMenuItem;
    protected SearchTextField m_searchField;
    protected BPELSearchResultPanel m_searchResultsPanel;
    protected ValidationLogPanel m_validationLogPnl;
    protected URL m_graphURL;
    protected ModelChangeNotifier m_modelChangeNotifier;
    protected ProcessListener m_processListener;
    protected GraphModelListener m_graphModelListener;
    protected BPELXmlModelListener m_saveListener;
    protected ActionListener m_actionListener;
    protected JToolBar m_toolBar;
    protected StructurePanePanel m_structure;
    protected ButtonTab m_logTab;

    public StandardBPELEditor(BPELDesignerGUI gui, URL graphURL) {
        this.m_graphURL = graphURL;
        this.m_gui = gui;
        this.m_modelChangeNotifier = gui;
        this.createGraph();
        this.createToolBar();
        this.createControls();
        this.updateControls();
    }

    public JComponent getStructure() {
        if (this.m_structure == null) {
            this.m_structure = new StructurePanePanel();
            this.m_structure.setGraphPane(this.getBPELGraphPane());
        }
        return this.m_structure;
    }

    public JComponent getLogWindow() {
        this.m_logTab = new ButtonTab();
        this.m_searchResultsPanel = new BPELSearchResultPanel();
        this.m_validationLogPnl = new ValidationLogPanel(this);
        this.m_logTab.addTab(VALIDATE_TAB, BPELStringTranslator.getString("VALIDATION"), (JComponent)this.m_validationLogPnl);
        this.m_logTab.addTab(SEARCH_TAB, BPELStringTranslator.getString("SEARCH"), (JComponent)this.m_searchResultsPanel);
        return this.m_logTab;
    }

    public BPELGraphPane getBPELGraphPane() {
        return this.m_graph;
    }

    public void rebuildGraphModel(String selection) {
        this.setGraphModel(this.buildGraphModel(selection), selection);
    }

    public void unload() {
        this.uninstallModelListeners();
        this.m_graph.setModel(null);
    }

    private BPELGraphModel buildGraphModel(String selectionXPath) {
        BPELXmlModel xmlModel = this.m_gui.getXMLModel();
        Process process = xmlModel.getProcess();
        BPELGraphModel graphModel = (BPELGraphModel)new ModelBuilder().build(process);
        graphModel.setBPELXmlModel(xmlModel);
        BPELProject project = graphModel.getBPELProject();
        Document graphicsDoc = this.loadGraphicsFile(project);
        if (graphicsDoc != null) {
            graphModel.loadGraphicsInformation(graphicsDoc, this.m_graph);
        }
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            ModelBuilderPlugin mb = plugin.getModelBuilderPlugin();
            if (mb == null) continue;
            mb.modelToBeInstalled(graphModel, this.m_graph);
        }
        return graphModel;
    }

    public void loadProcess(final String selectionXPath) {
        final StatusGlassPane glass = new StatusGlassPane((Component)this);
        glass.enableUserInput(false);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BPELXmlModel xmlModel = StandardBPELEditor.this.m_gui.getXMLModel();
                    StandardBPELEditor.this.m_saveListener = new BPELXmlModelListener(){

                        @Override
                        public void saveOccurred(BPELXmlModel model) {
                            StandardBPELEditor.this.saveGraphicsInformation();
                        }
                    };
                    xmlModel.addBPELXmlModelListener(StandardBPELEditor.this.m_saveListener);
                    StandardBPELEditor.this.setGraphModel(StandardBPELEditor.this.buildGraphModel(selectionXPath), selectionXPath);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                finally {
                    glass.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    protected synchronized void setGraphModel(final BPELGraphModel model, final String selectionXPath) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StandardBPELEditor.this.uninstallModelListeners();
                    StandardBPELEditor.this.m_graph.setModel((GraphModel)model);
                    StandardBPELEditor.this.setMenuItemsStates();
                    StandardBPELEditor.this.setGraphSelection(selectionXPath);
                    StandardBPELEditor.this.installModelListeners(model);
                }
                catch (Exception e) {
                    BPELModelerLogger.showUserError(e);
                }
                finally {
                    StandardBPELEditor.this.m_graph.requestFocusInWindow();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void setMenuItemsStates() {
        this.m_layoutMenuItem.setSelected(this.m_graph.isOptimized());
        this.m_showSwimLanesMenuItem.setSelected(this.m_graph.getSwimLanesVisible());
        this.m_showConnectionsMenuItem.setSelected(this.m_graph.getShowEndPointConnections());
        this.buildBookmarksMenu();
    }

    private void setGraphSelection(String selectionXPath) {
        if (selectionXPath != null) {
            try {
                BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
                ResolvedXPathObject r = BPELModelUtil.getObjectFromXPath((Process)model.getProcess(), (String)selectionXPath);
                if (r.getEvalObjectType() == 2) {
                    Activity activity = (Activity)r.getEvalObject();
                    this.m_graph.selectActivity(activity);
                } else if (r.getEvalObjectType() == 4) {
                    PartnerLink partnerLink = (PartnerLink)r.getEvalObject();
                    this.m_graph.selectPartnerLink(partnerLink);
                } else {
                    Activity activity = r.getPreviousEvalActivity();
                    if (activity != null) {
                        this.m_graph.selectActivity(activity);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void editBookmarks() {
        BookmarksDialog dlg = new BookmarksDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)), this.m_graph);
        if (dlg.display() == 0) {
            this.buildBookmarksMenu();
            this.notifyJDevModelChanged();
        }
    }

    public void buildBookmarksMenu() {
        this.m_bookMarksMenu.clearPopupMenu();
        this.m_bookMarksMenu.addToPopupMenu((Action)new EditBookMarksAction(this));
        BookmarkDataStore ds = this.m_graph.getBookmarks();
        if (ds != null && ds.getData().size() > 0) {
            this.m_bookMarksMenu.addSeparatorToPopupMenu();
            for (Object o : ds.getData()) {
                if (o instanceof BookmarkCategory) {
                    BookmarkCategory category = (BookmarkCategory)o;
                    JMenu menu = new JMenu(category.getName());
                    menu.setIcon(ImageCache.getIcon("folder_close_node"));
                    this.m_bookMarksMenu.addToPopupMenu((Component)menu);
                    for (Bookmark bookmark : category.getBookmarks()) {
                        BookmarkAction action = new BookmarkAction(this.m_graph, bookmark);
                        menu.add(new JMenuItem(action));
                    }
                    continue;
                }
                if (!(o instanceof Bookmark)) continue;
                Bookmark bookmark = (Bookmark)o;
                BookmarkAction action = new BookmarkAction(this.m_graph, bookmark);
                this.m_bookMarksMenu.addToPopupMenu((Action)action);
            }
        }
    }

    protected synchronized void uninstallModelListeners() {
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graph.getModel();
        if (graphModel == null) {
            return;
        }
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            plugin.uninstallListeners(this.m_graph, graphModel);
        }
        Process process = graphModel.getProcess();
        if (process != null && this.m_processListener != null) {
            process.removeProcessListener(this.m_processListener);
            this.m_processListener = null;
        }
        if (this.m_graphModelListener != null) {
            graphModel.removeGraphModelListener(this.m_graphModelListener);
        }
    }

    protected synchronized void installModelListeners(BPELGraphModel model) {
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            plugin.installListeners(this.m_graph, model);
        }
        Process process = model.getProcess();
        this.m_processListener = new ProcessListener(){

            public void modelChanged(ProcessEvent evt) {
                StandardBPELEditor.this.notifyJDevModelChanged();
                StandardBPELEditor.this.m_graph.repaint();
            }
        };
        process.addProcessListener(this.m_processListener);
        this.m_graphModelListener = new GraphModelListener(){

            public void graphNodesChanged(GraphModelEvent e) {
                StandardBPELEditor.this.notifyJDevModelChanged();
                StandardBPELEditor.this.updateControls();
            }

            public void graphNodesInserted(GraphModelEvent e) {
                StandardBPELEditor.this.notifyJDevModelChanged();
            }

            public void graphNodesRemoved(GraphModelEvent e) {
                StandardBPELEditor.this.notifyJDevModelChanged();
                StandardBPELEditor.this.updateControls();
            }

            public void graphStructureChanged(GraphModelEvent e) {
                StandardBPELEditor.this.notifyJDevModelChanged();
                StandardBPELEditor.this.updateControls();
            }

            public void edgesInserted(GraphModelEvent e) {
                StandardBPELEditor.this.notifyJDevModelChanged();
            }

            public void edgesRemoved(GraphModelEvent e) {
                StandardBPELEditor.this.notifyJDevModelChanged();
            }
        };
        model.addGraphModelListener(this.m_graphModelListener);
    }

    protected Document loadGraphicsFile(BPELProject prj) {
        URL url;
        URL designerDir = prj.getDesignerDirectoryURL();
        if (!Helper.exists((URL)designerDir)) {
            ProcessBuilderUtil.createDesignerDirectory(prj);
        }
        if (!Helper.exists((URL)(url = prj.getGraphicsFileURL()))) {
            ProcessBuilderUtil.createDefaultGraphicsFile(prj);
        }
        try {
            return GraphicsFileUtil.loadGraphicsFile(url);
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)this, (Throwable)e);
            return null;
        }
    }

    protected void createGraph() {
        this.m_graph = new BPELGraphPane();
        this.m_graph.createAnalysisPanel();
        BPELSettings globalSettings = BPELDesignerSettings.getGlobalSettings().getData();
        BPELSettings settings = this.m_graph.getSettings();
        globalSettings.copyTo(settings);
        new JDevPropertiesPanelUpdater(this.m_graph);
        this.m_graph.addGraphSelectionListener(this);
        this.m_graph.addGraphPaneStatusListener(this);
        new BPELGraphPanePopupHandler(this.m_graph);
        new BPELGraphPaneDragGestureHandler(this.m_graph);
        BPELGraphPaneDropTargetListener dropTargetListener = new BPELGraphPaneDropTargetListener(this.m_graph);
        BPELDNDDropHandler dropHandler = new BPELDNDDropHandler();
        dropTargetListener.registerDNDHandler(dropHandler, XmlTransferUtils.FLAVOR_XMLKEY);
        dropTargetListener.registerDNDHandler(dropHandler, PaletteItem.PALETTE_ITEM_FLAVOR);
        dropTargetListener.registerDNDHandler(dropHandler, StringTransferable.DATA_FLAVOR);
        dropTargetListener.registerDNDHandler(dropHandler, PartnerLinkTransferable.DATA_FLAVOR);
        for (BPELModelerPlugin plugIn : BPELPlugInManager.getPlugins()) {
            plugIn.registerDNDHandler(dropTargetListener, this.m_graph);
        }
        dropTargetListener.registerDNDHandler(new BPELNodeRendererDNDHandler(), ViewTransferable.DATA_FLAVOR);
        new DropTarget((Component)((Object)this.m_graph), dropTargetListener.getAcceptableActions(), (DropTargetListener)((Object)dropTargetListener), true);
    }

    protected void setActivationColors(boolean bActivated) {
        Color c = bActivated ? LookAndFeel.getActivatedColor2() : LookAndFeel.getDeactivatedColor();
        this.m_graph.getAnalysisPanel().setBackground(c);
        this.setBackground(c);
    }

    protected void createControls() {
        this.setBackground(LookAndFeel.getActivatedColor2());
        this.m_graph.getAnalysisPanel().setBackground(LookAndFeel.getActivatedColor2());
        JScrollPane sp = new JScrollPane((Component)((Object)this.m_graph));
        sp.getVerticalScrollBar().setUnitIncrement(25);
        sp.getHorizontalScrollBar().setUnitIncrement(25);
        sp.setBorder((Border)new SideBorder(true, false, true, true, LookAndFeel.getMenuBarBorderColor()));
        sp.getViewport().setBackground(this.m_graph.getSettings().m_swimlaneBackgroundColor);
        JPanel bottomPnl = new JPanel(new GridBagLayout());
        bottomPnl.setOpaque(false);
        GraphUtils.addComponent((Container)bottomPnl, (Component)this.createXPathPanel(), (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)bottomPnl, (Component)this.buildZoomPanel(), (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        int row = 0;
        this.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)this, (Component)sp, (int)0, (int)row, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)this.m_graph.getAnalysisPanel(), (int)1, (int)row++, (int)1, (int)1, (int)17, (int)3, (Insets)new Insets(2, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)this, (Component)bottomPnl, (int)0, (int)row, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(2, 5, 2, 10), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    protected HeaderPanel createHeader() {
        String name = URLFileSystem.getFileName((URL)this.m_graphURL);
        JLabel fileLbl = new JLabel(name, 4);
        JLabel l = new JLabel(BPELStringTranslator.getString("BPEL_EDITOR"), 2);
        HeaderPanel p = new HeaderPanel();
        p.setBorder((Border)new SideBorder(true, false, true, false, LookAndFeel.getMenuBarBorderColor()));
        p.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)0, (int)1, (int)17, (int)2, (Insets)new Insets(2, 5, 2, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)fileLbl, (int)1, (int)0, (int)0, (int)1, (int)13, (int)2, (Insets)new Insets(2, 5, 2, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        return p;
    }

    protected void createToolBar() {
        this.m_informationBtn = new JButton("", ImageCache.getIcon("application/bpel/information.png"));
        this.m_informationBtn.addActionListener(this);
        this.m_informationBtn.setToolTipText(BPELStringTranslator.getString("INFORMATION_TIP"));
        this.m_showSwimLanesMenuItem = new JCheckBoxMenuItem();
        BPELStringTranslator.setButton(this.m_showSwimLanesMenuItem, BPELStringTranslator.getString("SHOW_SWIMLANES_BTN"));
        this.m_showSwimLanesMenuItem.addActionListener(this);
        this.m_showConnectionsMenuItem = new JCheckBoxMenuItem();
        BPELStringTranslator.setButton(this.m_showConnectionsMenuItem, BPELStringTranslator.getString("SHOW_PL_CONNECTIONS_BTN"));
        this.m_showConnectionsMenuItem.addActionListener(this);
        this.m_layoutMenuItem = new JCheckBoxMenuItem();
        BPELStringTranslator.setButton(this.m_layoutMenuItem, BPELStringTranslator.getString("OPTIMIZE_LAYOUT_BTN"));
        this.m_layoutMenuItem.addActionListener(this);
        this.m_toolBar = new JToolBar();
        this.m_toolBar.setOpaque(false);
        this.m_toolBar.setBorderPainted(false);
        JButtonMenu bm1 = new JButtonMenu("", ImageCache.getIcon("check16"));
        bm1.setAction((Action)new ValidateAction());
        bm1.setToolTipText(BPELStringTranslator.getString("COLLAXALAF_VALIDATE_PROCESS"));
        bm1.setOpaque(false);
        bm1.addToPopupMenu((Action)new ValidateAction());
        bm1.addToPopupMenu((Action)new ValidationBrowserAction());
        this.m_toolBar.add((Component)bm1);
        this.m_bookMarksMenu = new JButtonMenu("", ImageCache.getIcon("application/bpel/bookmark.png"));
        this.m_bookMarksMenu.setToolTipText(BPELStringTranslator.getString("COLLAXALAF_BOOKMARKS") + "...");
        this.m_bookMarksMenu.setOpaque(false);
        this.m_toolBar.add((Component)this.m_bookMarksMenu);
        JButtonMenu bm4 = new JButtonMenu("", ImageCache.getIcon("diagramproperties16"));
        bm4.setAction((Action)new DiagramPropertiesAction());
        bm4.setToolTipText(BPELStringTranslator.getString("COLLAXALAF_DIAGRAM_PROPERTIES"));
        bm4.setOpaque(false);
        bm4.addToPopupMenu((Component)this.m_showSwimLanesMenuItem);
        bm4.addToPopupMenu((Component)this.m_showConnectionsMenuItem);
        bm4.addToPopupMenu((Component)this.m_layoutMenuItem);
        bm4.addSeparatorToPopupMenu();
        bm4.addToPopupMenu((Action)new PrintAction());
        bm4.addToPopupMenu((Action)new CreateImageAction());
        this.m_toolBar.add((Component)bm4);
        this.m_drillDownMenu = new JButtonMenu("", ImageCache.getIcon("application/bpel/drillin16.png"));
        this.m_drillDownMenu.addToPopupMenu((Component)new DrillDownPanel(this.m_graph, this.m_drillDownMenu.getPopup()));
        this.m_drillDownMenu.setToolTipText(BPELStringTranslator.getString("DRILL_DOWN_STACK_TIP"));
        this.m_drillDownMenu.setOpaque(false);
        this.m_toolBar.add((Component)this.m_drillDownMenu);
        this.m_toolBar.add(this.m_informationBtn);
        JButton refreshBtn = new JButton(ImageCache.getIcon("refresh16"));
        refreshBtn.setOpaque(false);
        refreshBtn.setToolTipText(BPELStringTranslator.getString("REFRESH_DIAGRAM"));
        refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardBPELEditor.this.m_graph.reloadBPELEditor();
            }
        });
        this.m_toolBar.add(refreshBtn);
        int cnt = 0;
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            List<JComponent> comps = plugin.getStandardPerspectiveToolBarComponents(this.m_graph);
            for (JComponent c : comps) {
                if (cnt++ == 0) {
                    this.m_toolBar.addSeparator();
                }
                this.m_toolBar.add(c);
            }
        }
    }

    protected JComponent getSearchComponent() {
        if (this.m_searchField == null) {
            this.m_searchField = new SearchTextField();
            this.m_searchField.getMenu().addToPopupMenu((Action)new TextSearchAction());
            this.m_searchField.getMenu().addToPopupMenu((Action)new ActivityTypeSearchAction());
            this.m_searchField.getTextField().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    String s;
                    if (e.getKeyCode() == 10 && Helper.hasValue((String)(s = StandardBPELEditor.this.m_searchField.getTextField().getText()))) {
                        SearchData data = new SearchData();
                        data.m_searchStr = s;
                        data.setSearchAll();
                        StandardBPELEditor.this.executeTextSearch(data);
                    }
                }
            });
        }
        return this.m_searchField;
    }

    protected JPanel createXPathPanel() {
        this.m_xpathPanel = new JPanel(new GridBagLayout());
        this.m_xpathPanel.setOpaque(false);
        this.m_xpathField = new JTextField();
        this.m_xpathField.setBorder(null);
        this.m_xpathField.setEditable(false);
        this.m_xpathField.setOpaque(false);
        GraphUtils.addComponent((Container)this.m_xpathPanel, (Component)this.m_xpathField, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        return this.m_xpathPanel;
    }

    protected JPanel buildZoomPanel() {
        this.m_zoomSpinner = new JSpinner(new SpinnerNumberModel(100, 1, 200, 1));
        this.m_zoomSpinner.setOpaque(false);
        this.m_zoomSpinner.getModel().addChangeListener(this);
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        this.m_zoomResetBtn = new JButton(ImageCache.getIcon("zoom_reset16"));
        this.m_zoomResetBtn.setOpaque(false);
        this.m_zoomResetBtn.setToolTipText(BPELStringTranslator.getString("COLLAXALAF_RESET_ZOOM", "Reset Zoom"));
        this.m_actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpinnerNumberModel m = (SpinnerNumberModel)StandardBPELEditor.this.m_zoomSpinner.getModel();
                m.setValue(new Integer(100));
                StandardBPELEditor.this.m_zoomSlider.setValue(100);
            }
        };
        this.m_zoomResetBtn.addActionListener(this.m_actionListener);
        JLabel zoomLabel = new JLabel(BPELStringTranslator.getString("COLLAXALAF_ZOOM", "Zoom") + ":", 4);
        this.m_zoomSlider = new JSlider(0, 1, 200, 100);
        this.m_zoomSlider.setOpaque(false);
        this.m_zoomSlider.addChangeListener(this);
        this.m_zoomSlider.setPreferredSize(new Dimension(150, 20));
        this.m_zoomSlider.setMinimumSize(new Dimension(150, 20));
        JToolBar tb = new JToolBar();
        tb.setOpaque(false);
        tb.setBorderPainted(false);
        tb.add(this.m_zoomResetBtn);
        GraphUtils.addComponent((Container)p, (Component)zoomLabel, (int)0, (int)0, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_zoomSpinner, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 2, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)this.m_zoomSlider, (int)2, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 2, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)p, (Component)tb, (int)3, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        return p;
    }

    protected void updateControls() {
        String text = "";
        Activity a = this.m_graph.getSelectedActivity();
        if (a != null && a.getName() != null && a.getName().length() > 0) {
            text = a.getName() + " - ";
        }
        if ((text = text + this.m_graph.getSelectedXPath()).equals("null")) {
            text = "";
        }
        this.m_xpathField.setText(text);
    }

    protected void executeTextSearch(final SearchData searchCriteria) {
        this.m_logTab.selectTab(SEARCH_TAB);
        this.m_searchResultsPanel.showWaitPanel();
        this.m_searchResultsPanel.clear();
        BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        final Process process = model.getProcess();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                List resultSet = SearchUtil.search((SearchData)searchCriteria, (Process)process);
                StandardBPELEditor.this.m_searchResultsPanel.setData(StandardBPELEditor.this.m_graph, searchCriteria, resultSet);
            }
        };
        new Thread(r).start();
    }

    public void toggleMinimize() {
        this.m_graph.optimizeDisplay(!this.m_graph.isOptimized());
        this.saveGraphicsInformation();
        this.updateMinimizeToggleBtn();
    }

    public void handleToggleMinimize() {
        if (this.m_layoutMenuItem.isSelected()) {
            this.m_graph.optimizeDisplay(true);
        } else {
            this.m_graph.optimizeDisplay(false);
        }
        this.saveGraphicsInformation();
        this.updateMinimizeToggleBtn();
    }

    public synchronized void saveGraphicsInformation() {
        if (this.m_graph != null) {
            try {
                this.m_graph.saveGraphicsFile();
            }
            catch (Exception e) {
                GraphUtils.displayError((Component)this, (Throwable)e);
            }
        }
    }

    public boolean canDeleteSelectedNode() {
        GraphElement selection = this.m_graph.getSelectedGraphElement();
        return selection instanceof NodeRenderer && selection.canDelete();
    }

    public void updateMinimizeToggleBtn() {
        this.m_layoutMenuItem.setSelected(this.m_graph.isOptimized());
    }

    public void handleSearch() {
        if (this.m_searchDlg == null) {
            this.m_searchDlg = new SearchDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)), this.m_graph);
        }
        if (this.m_searchDlg.display() == 0) {
            this.executeTextSearch(this.m_searchDlg.getData());
        }
    }

    public void handleTypeSearch() {
        if (this.m_searchTypeDlg == null) {
            this.m_searchTypeDlg = new SearchActivityTypeDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)), this.m_graph);
        }
        if (this.m_searchTypeDlg.display() == 0) {
            this.m_logTab.selectTab(SEARCH_TAB);
            this.m_searchResultsPanel.showWaitPanel();
            this.m_searchResultsPanel.clear();
            final SearchData searchCriteria = this.m_searchTypeDlg.getData();
            BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
            final Process process = model.getProcess();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    List resultSet = SearchUtil.searchForActivityTypes((SearchData)searchCriteria, (Process)process);
                    StandardBPELEditor.this.m_searchResultsPanel.setActivitySearchData(StandardBPELEditor.this.m_graph, searchCriteria, resultSet);
                }
            };
            new Thread(r).start();
        }
    }

    public void validateProcess() {
        BPELModelerLogger.showLogWindow("BPEL_LOGWINDOW");
        this.m_logTab.selectTab(VALIDATE_TAB);
        final BPELGraphModel model = (BPELGraphModel)this.m_graph.getModel();
        if (model == null) {
            return;
        }
        final BPELXmlModel xmlModel = this.m_gui.getXMLModel();
        this.m_validationLogPnl.getValidatorErrorsPnl().setGraphPane(this.m_graph);
        BPELValidatorErrorPanel delegateCallback = this.m_validationLogPnl.getValidatorErrorsPnl();
        final GatewayCallBack gatewayCallBack = new GatewayCallBack(delegateCallback);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = StandardBPELEditor.this.m_graph.getTreeLock();
                synchronized (object) {
                    BPELModelUtil.validateProcess((Process)model.getProcess(), (ValidatorCallback)gatewayCallBack);
                    ValidationContext ctx = new ValidationContext(xmlModel);
                    ArrayList<ModelWarning> secondaryModelWarnings = new ArrayList<ModelWarning>();
                    for (ISecondaryModel m : xmlModel.getSecondaryModels()) {
                        List<ModelWarning> warnings = m.validate(ctx);
                        if (warnings == null) continue;
                        secondaryModelWarnings.addAll(warnings);
                    }
                    StandardBPELEditor.this.forceGraphLayout();
                    StandardBPELEditor.this.m_validationLogPnl.loadModelWarnings(secondaryModelWarnings);
                }
            }
        };
        new Thread(r).start();
    }

    protected void notifyJDevModelChanged() {
        this.m_modelChangeNotifier.markChange(true);
    }

    protected void handleCreateJPEG() {
        try {
            this.m_graph.createJPEG();
        }
        catch (Exception e) {
            GraphUtils.displayMessage((Component)this, (String)(BPELStringTranslator.getString("ERROR_CREATE_JPG") + "\n" + e.getMessage()), (int)0);
        }
    }

    protected void forceGraphLayout() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                StandardBPELEditor.this.m_graph.forceImmediateLayout();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void graphSelectionOccurred(GraphSelectionEvent evt) {
        this.updateControls();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_showSwimLanesMenuItem) {
            boolean bSwimLanesVisible = this.m_graph.getSwimLanesVisible();
            this.m_graph.showSwimLanes(!bSwimLanesVisible);
            this.m_graph.repaint();
            this.m_showConnectionsMenuItem.setEnabled(!bSwimLanesVisible);
        } else if (src == this.m_showConnectionsMenuItem) {
            this.m_graph.showEndPointConnections(!this.m_graph.getShowEndPointConnections());
            this.m_graph.repaint();
        } else if (src == this.m_layoutMenuItem) {
            this.handleToggleMinimize();
        } else if (src == this.m_informationBtn) {
            InformationDialog dlg = new InformationDialog(GraphUtils.getFrame((Component)((Object)this.m_graph)), this.m_graph.getBPELProject());
            dlg.display();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Integer spinnerValue;
        Object src = e.getSource();
        if (src == this.m_zoomSlider) {
            int sliderValue = this.m_zoomSlider.getValue();
            double zoomFactor = (double)sliderValue / 100.0;
            this.m_graph.setZoom(zoomFactor);
            SpinnerNumberModel spinnerModel = (SpinnerNumberModel)this.m_zoomSpinner.getModel();
            if (sliderValue != (Integer)spinnerModel.getValue()) {
                spinnerModel.setValue(sliderValue);
            }
        } else if (src == this.m_zoomSpinner.getModel() && (spinnerValue = (Integer)this.m_zoomSpinner.getValue()).intValue() != this.m_zoomSlider.getValue()) {
            this.m_zoomSlider.setValue(spinnerValue);
        }
    }

    public void modelLoaded(GraphModel model) {
        if (model != null && this.m_graph.getValidateOnLoad()) {
            this.validateProcess();
        }
    }

    public void statusChanged(GraphPaneStatusEvent evt) {
        switch (evt.getId()) {
            case 0: {
                this.updateControls();
            }
        }
    }

    class CreateImageAction
    extends AbstractAction {
        public CreateImageAction() {
            super(BPELStringTranslator.getString("COLLAXALAF_CREATE_JPEG"), ImageCache.getIcon("camera16"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardBPELEditor.this.handleCreateJPEG();
        }
    }

    class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super(BPELStringTranslator.getString("COLLAXALAF_PRINT"), ImageCache.getIcon("printer16"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardBPELEditor.this.m_graph.printDocument();
        }
    }

    class DiagramPropertiesAction
    extends AbstractAction {
        public DiagramPropertiesAction() {
            super(BPELStringTranslator.getString("COLLAXALAF_DIAGRAM_PROPERTIES") + "...", ImageCache.getIcon("diagramproperties16"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StandardBPELEditor.this.m_graph.showPropertiesDialog() == 0) {
                StandardBPELEditor.this.updateMinimizeToggleBtn();
                StandardBPELEditor.this.notifyJDevModelChanged();
                StandardBPELEditor.this.m_graph.repaint();
            }
        }
    }

    class ValidationBrowserAction
    extends AbstractAction {
        public ValidationBrowserAction() {
            super(BPELStringTranslator.getString("COLLAXALAF_VALIDATION_BROWSER"), ImageCache.getIcon("wrench16"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ValidationBrowser browser = new ValidationBrowser(GraphUtils.getFrame((Component)((Object)StandardBPELEditor.this.m_graph)), StandardBPELEditor.this.m_graph, null);
            browser.display();
        }
    }

    class ValidateAction
    extends AbstractAction {
        public ValidateAction() {
            super(BPELStringTranslator.getString("COLLAXALAF_VALIDATE_PROCESS"), ImageCache.getIcon("check16"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardBPELEditor.this.validateProcess();
        }
    }

    class ActivityTypeSearchAction
    extends AbstractAction {
        public ActivityTypeSearchAction() {
            super(BPELStringTranslator.getString("COLLAXALAF_TYPE_SEARCH") + "...", ImageCache.getIcon("branch_find.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardBPELEditor.this.handleTypeSearch();
        }
    }

    class TextSearchAction
    extends AbstractAction {
        public TextSearchAction() {
            super(BPELStringTranslator.getString("COLLAXALAF_TEXT_SEARCH") + "...", ImageCache.getIcon("find_text.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardBPELEditor.this.handleSearch();
        }
    }

    class GatewayCallBack
    implements ValidatorCallback,
    ActionListener {
        private ValidatorCallback m_delegate;
        private boolean m_bCancel = false;

        public GatewayCallBack(ValidatorCallback delegate) {
            this.m_delegate = delegate;
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            this.m_bCancel = true;
        }

        public boolean isValidationCanceled() {
            return this.m_bCancel;
        }

        public void start() {
            if (this.m_delegate != null) {
                this.m_delegate.start();
            }
        }

        public void validated(Validatable validatedObj, ValidationReport report) {
            if (this.m_delegate != null) {
                this.m_delegate.validated(validatedObj, report);
            }
        }

        public synchronized void statusMessage(String connStr) {
            if (!this.m_bCancel && this.m_delegate != null) {
                this.m_delegate.statusMessage(connStr);
            }
        }

        public void finish() {
            if (this.m_delegate != null) {
                this.m_delegate.finish();
            } else {
                BPELModelerLogger.showLogWindow("BPEL_LOGWINDOW");
            }
        }
    }
}

