/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.sca.plugin;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.xml.namespace.QName;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.view.DNDDropHandler;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.fabric.api.SCAComponent;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.fabric.config.SCAConfig;
import oracle.tip.tools.ide.fabric.resource.SCAComponentRegistry;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELDNDDropHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;
import oracle.tip.tools.ide.pm.processbuilder.jdev.BPELWizardLauncher;
import oracle.tip.tools.ide.pm.processbuilder.model.ProcessData;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class SCADNDDropHandler
implements DNDDropHandler {
    public boolean handleDrop(DropTargetDropEvent e, Object data, GraphPane pane) {
        BPELGraphPane graph = (BPELGraphPane)pane;
        Point pt = graph.inDrillDownMode() ? e.getLocation() : pane.convertToNonScaledTranslatedCoordinates(e.getLocation());
        int x = pt.x;
        int y = pt.y;
        NodeRenderer r = pane.getNodeRendererAtPosition(x, y);
        if (r instanceof SwimLaneView) {
            String taskName = BPELDNDDropHandler.getTaskNameFromDropData(data);
            return this.handleSwimLaneDrop(graph, (SwimLaneView)r, taskName, new Point(x, y));
        }
        return false;
    }

    protected boolean handleSwimLaneDrop(BPELGraphPane graph, SwimLaneView r, String task, Point pt) {
        if (task.equalsIgnoreCase("bpel_process")) {
            this.showBPELProcessWizard(graph, r, pt);
            return true;
        }
        if (task.equalsIgnoreCase("mediator")) {
            this.showMediator(graph, r, pt);
            return true;
        }
        return false;
    }

    protected boolean showBPELProcessWizard(BPELGraphPane graph, SwimLaneView r, Point pt) {
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        PartnerLink plink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
        try {
            ProcessData processData = new ProcessData();
            processData.m_bFromBPEL = true;
            processData.m_bExportAsService = false;
            int retVal = BPELWizardLauncher.displayCreationDialog((Project)model.getBPELProject().getProjectContext(), processData);
            if (retVal != 0 || Helper.isEqual((String)processData.m_templateID, (String)"BPEL_EMPTY_PROCESS")) {
                return false;
            }
            String processName = processData.m_processName;
            plink.setName(processName + "." + processData.m_serviceName);
            URL url = URLFactory.newURL((URL)model.getBPELProject().getBPELDirectoryURL(), (String)(processName + ".wsdl"));
            String wsdlLoc = url.toExternalForm();
            plink.setWSDLLocation(wsdlLoc);
            String ns = process.addNamespace(processData.m_namespace);
            plink.setPartnerLinkType(new QName(processData.m_namespace, processName, ns));
            plink.setMyRole(processName + "Requester");
            plink.setPartnerRole(processName + "Provider");
            JDevBPELProject proj = (JDevBPELProject)model.getBPELProject();
            JDevSCAIntegrationUtil.addReferenceToComponentService(proj.getProject(), proj.getProcessName(), plink, processName, processData.m_serviceName);
            graph.createPartnerLinkNode(r, pt, (Scope)process, plink);
            PartnerLinkNode plNode = model.getPartnerLinkNode(plink.getName(), model.getPartnerLinkNodes());
            Icon icon = ImageCache.getIcon("palette/adapterservice/process_20.png");
            String iconName = "process_20.png";
            plNode.setIcon(icon);
            plNode.setIconName(iconName);
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)((Object)graph), (Throwable)e);
        }
        return true;
    }

    protected boolean showMediator(BPELGraphPane graph, SwimLaneView r, Point pt) {
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        try {
            SCAComponent mediator = SCAComponentRegistry.getInstance().getSCAComponentInstance(SCAConfig.getSCAConfig().getMediatorComponentType().getName());
            JDevBPELProject proj = (JDevBPELProject)model.getBPELProject();
            SCAController scaCon = JDevSCAIntegrationUtil.getSCAController(proj.getProject());
            String newComponentName = mediator.createImplementation(proj.getProject(), scaCon, true);
            if (newComponentName != null) {
                List services = scaCon.getComponentServices(newComponentName);
                if (services.size() <= 0) {
                    return true;
                }
                String newServiceName = (String)services.get(0);
                String currentComponentName = proj.getProcessName();
                String currentReferenceName = newComponentName + "." + newServiceName;
                WsdlInfo wsdlInfo = scaCon.getWsdlInfoForName(newComponentName, newServiceName);
                PartnerLink plink = JDevSCAIntegrationUtil.getPartnerlinkFromWSDLInfo(wsdlInfo, currentReferenceName, proj);
                String ns = process.addNamespace(plink.getPartnerLinkType().getNamespaceURI());
                plink.setPartnerLinkType(new QName(plink.getPartnerLinkType().getNamespaceURI(), plink.getPartnerLinkType().getLocalPart(), ns));
                JDevSCAIntegrationUtil.addReferenceToComponentService(proj.getProject(), currentComponentName, plink, newComponentName, newServiceName);
                graph.createPartnerLinkNode(r, pt, (Scope)process, plink);
                PartnerLinkNode plNode = model.getPartnerLinkNode(plink.getName(), model.getPartnerLinkNodes());
                Icon icon = ImageCache.getIcon("palette/adapterservice/mediator_20.png");
                String iconName = "mediator_20.png";
                plNode.setIcon(icon);
                plNode.setIconName(iconName);
            }
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)((Object)graph), (Throwable)e);
        }
        return true;
    }
}

