/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.sca.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.ide.model.Project;
import oracle.ide.palette2.PaletteItem;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.ProcessListener;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ui.GlobalImageCache;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilderPlugin;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneDropTargetListener;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkView;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.views.RuleView;
import oracle.tip.tools.ide.pm.designerplugins.sca.bpelgraph.actions.OpenCompEditorAction;
import oracle.tip.tools.ide.pm.designerplugins.sca.plugin.GotoCompositeAction;
import oracle.tip.tools.ide.pm.designerplugins.sca.plugin.SCADNDDropHandler;
import oracle.tip.tools.ide.pm.designerplugins.sca.plugin.SCAModelBuilderPlugin;
import oracle.tip.tools.ide.pm.modules.sca.ide.JDevScaProcessListener;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.UserTaskView;
import oracle.tip.tools.ide.pm.plugin.AbstractBPELModelerPlugin;

public class SCABPELModelerPlugin
extends AbstractBPELModelerPlugin {
    private HashMap<Process, ProcessListener> m_listenerMap = new HashMap();
    private SCAModelBuilderPlugin m_modelBuilderPlugin = new SCAModelBuilderPlugin();

    @Override
    public ModelBuilderPlugin getModelBuilderPlugin() {
        return this.m_modelBuilderPlugin;
    }

    @Override
    public List<JComponent> getStandardPerspectiveToolBarComponents(BPELGraphPane graph) {
        JButton btn = new JButton(GlobalImageCache.getIcon((String)"goto_compositediagram.png"));
        btn.setAction(new GotoCompositeAction(graph));
        btn.setOpaque(false);
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(btn);
        return comps;
    }

    @Override
    public void installListeners(BPELGraphPane graph, BPELGraphModel graphModel) {
        BPELProject prj = graph.getBPELProject();
        Project project = (Project)prj.getProjectContext();
        Process p = graphModel.getProcess();
        JDevScaProcessListener lst = new JDevScaProcessListener(project);
        if (this.m_listenerMap.get(p) == null) {
            this.m_listenerMap.put(p, lst);
            p.addProcessListener((ProcessListener)lst);
        }
    }

    @Override
    public void uninstallListeners(BPELGraphPane graph, BPELGraphModel graphModel) {
        Process p = graphModel.getProcess();
        if (this.m_listenerMap.containsKey(p)) {
            ProcessListener lst = this.m_listenerMap.get(p);
            p.removeProcessListener(lst);
            this.m_listenerMap.remove(p);
        }
    }

    @Override
    public void registerDNDHandler(BPELGraphPaneDropTargetListener dropTargetListener, BPELGraphPane graph) {
        SCADNDDropHandler dropHandler = new SCADNDDropHandler();
        dropTargetListener.registerDNDHandler(dropHandler, PaletteItem.PALETTE_ITEM_FLAVOR);
        dropTargetListener.registerDNDHandler(dropHandler, XmlTransferUtils.FLAVOR_XMLKEY);
    }

    @Override
    public List<GraphAction> addViewAction(View v) {
        ArrayList<GraphAction> actions = new ArrayList<GraphAction>();
        if (v instanceof RuleView || v instanceof UserTaskView || v instanceof PartnerLinkView) {
            String linkedSCACompName;
            if (v instanceof PartnerLinkView && (linkedSCACompName = OpenCompEditorAction.linkedSCACompName((PartnerLinkView)v)) == null) {
                return actions;
            }
            actions.add(new OpenCompEditorAction(v));
            return actions;
        }
        return null;
    }
}

