/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.sca.bpelgraph.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import oracle.bpel.services.rules.rpi.RuleEngineFactory;
import oracle.bpel.services.rules.rpi.model.DecisionServices;
import oracle.bpel.services.rules.rpi.model.TRuleEngineProvider;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Rule;
import oracle.tip.tools.ide.common.bpelparser.extension.workflow.iface.UserTask;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.actions.GraphAction;
import oracle.tip.tools.ide.common.graph.view.View;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkView;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.views.RuleView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;
import oracle.tip.tools.ide.pm.modules.workflow.bpelgraph.collaxalaf.UserTaskView;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class OpenCompEditorAction
extends GraphAction {
    private View m_view;

    public OpenCompEditorAction(View v) {
        super(BPELStringTranslator.getString("OPEN_COMPONENT_EDITOR"));
        this.m_view = v;
        this.putValue("SmallIcon", ImageCache.getIcon("graph/bpel/partnerlink_16x16.png"));
        this.putValue("TRANSPARENT_ICON", ImageCache.getIcon("graph/bpel/partnerlink_16x16_fadeout.png"));
    }

    public OpenCompEditorAction(View v, String scaCompName) {
        super(BPELStringTranslator.getString("OPEN_COMPONENT_EDITOR"));
        this.m_view = v;
        this.putValue("SmallIcon", ImageCache.getIcon("graph/bpel/partnerlink_16x16.png"));
        this.putValue("TRANSPARENT_ICON", ImageCache.getIcon("graph/bpel/partnerlink_16x16_fadeout.png"));
    }

    public void actionPerformed(ActionEvent e) {
        BPELGraphPane pane = (BPELGraphPane)this.m_view.getGraphPane();
        JDevBPELProject proj = (JDevBPELProject)pane.getBPELProject();
        SCAController con = JDevSCAIntegrationUtil.getSCAController(proj.getProject());
        String bpelName = proj.getProcessName();
        String plName = null;
        if (this.m_view instanceof RuleView) {
            Rule s = (Rule)this.m_view.getNode().getUserObject();
            if (s.getInvoke() != null) {
                plName = s.getInvoke().getPartnerLink();
            }
        } else if (this.m_view instanceof UserTaskView) {
            UserTask s = (UserTask)this.m_view.getNode().getUserObject();
            if (s.getInvoke() != null) {
                plName = s.getInvoke().getPartnerLink();
            }
        } else if (this.m_view instanceof PartnerLinkView) {
            PartnerLink plink = (PartnerLink)this.m_view.getNode().getUserObject();
            plName = plink.getName();
        }
        if (plName != null) {
            OpenCompEditorAction.openSCAEditorByPartnerLink(plName, bpelName, con, proj.getProject());
        } else {
            GraphUtils.displayMessage((Component)((Object)pane), (String)BPELStringTranslator.getString("COMPONENT_NOT_DEFINED"), (String)BPELStringTranslator.getString("NO_EDITOR_TO_OPEN"), (int)1);
        }
    }

    public static void openSCAEditorByPartnerLink(String plName, String compName, SCAController con, Project proj) {
        String target;
        int i;
        List list = con.getComponentReferenceTarget(compName, plName);
        if (list.size() > 0 && (i = (target = (String)list.get(0)).indexOf("/")) > 0) {
            String targetCompName = target.substring(0, i);
            OpenCompEditorAction.openEditor(targetCompName, con, proj);
        }
    }

    public static void openEditor(String name, SCAController con, Project proj) {
        String l = con.getComponentImplemenation(name);
        if (l == null) {
            return;
        }
        String basePath = SCAProject.getScaDirectoryPath((Project)proj);
        URL compURL = URLFactory.newURL((String)basePath);
        compURL = URLFactory.newURL((URL)compURL, (String)l);
        if (l.endsWith(".decs")) {
            compURL = OpenCompEditorAction.getRuleDictionaryURL(compURL, proj);
        }
        EditorManager.getEditorManager().openDefaultEditorInFrame(compURL);
    }

    public static URL getRuleDictionaryURL(URL decisionFileURL, Project proj) {
        URL rulesFileURL = null;
        try {
            RuleEngineFactory rpi_factory = RuleEngineFactory.getInstance();
            Unmarshaller unmarshaller = rpi_factory.createUnmarshaller();
            DecisionServices services = null;
            services = (DecisionServices)unmarshaller.unmarshal(decisionFileURL);
            String p = Helper.getFileName((URL)Helper.getParent((URL)proj.getURL())) + "/";
            URL parent = URLFileSystem.getParent((URL)proj.getURL());
            for (int count = 0; count < services.getRuleEngineProviders().size(); ++count) {
                TRuleEngineProvider ruleEngineProvider = (TRuleEngineProvider)services.getRuleEngineProviders().get(0);
                if (ruleEngineProvider == null || ruleEngineProvider.getRepository() == null) continue;
                String ruleFilePath = ruleEngineProvider.getRepository().getPath();
                rulesFileURL = ruleFilePath.startsWith(p) ? URLFactory.newURL((URL)parent, (String)ruleFilePath.substring(p.length())) : URLFactory.newURL((URL)parent, (String)ruleFilePath.substring(ruleFilePath.indexOf("/") + 1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rulesFileURL;
    }

    public static String linkedSCACompName(PartnerLinkView v) {
        String target;
        int i;
        String bpelName;
        PartnerLink plink = (PartnerLink)v.getNode().getUserObject();
        String plName = plink.getName();
        BPELGraphPane pane = (BPELGraphPane)v.getGraphPane();
        JDevBPELProject proj = (JDevBPELProject)pane.getBPELProject();
        SCAController con = JDevSCAIntegrationUtil.getSCAController(proj.getProject());
        List list = con.getComponentReferenceTarget(bpelName = proj.getProcessName(), plName);
        if (list.size() > 0 && (i = (target = (String)list.get(0)).indexOf("/")) > 0) {
            String targetCompName = target.substring(0, i);
            String impl = con.getComponentImplemenation(targetCompName);
            if (impl == null) {
                return null;
            }
            return impl;
        }
        return null;
    }
}

