/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.rules.plugin;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Rule;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.ProcessListener;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.GraphElement;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkView;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.RuleNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.views.RuleView;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;
import oracle.tip.tools.ide.pm.plugin.AbstractBPELModelerPlugin;

public class RulesBPELModelerPlugin
extends AbstractBPELModelerPlugin {
    private HashMap<Process, ProcessListener> m_listenerMap = new HashMap();

    @Override
    public boolean handleDeleteGraphElement(BPELGraphPane graph, GraphElement elem) {
        if (elem instanceof RuleView) {
            return this.handleDeleteRule(graph, (RuleView)elem);
        }
        if (elem instanceof PartnerLinkView) {
            return this.handleDeleteRulePL(graph, (PartnerLinkView)elem);
        }
        return false;
    }

    private boolean handleDeleteRule(BPELGraphPane graph, RuleView view) {
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        RuleNode node = (RuleNode)view.getNode();
        Rule rule = (Rule)node.getUserObject();
        Invoke invoke = rule.getInvoke();
        String plName = null;
        if (invoke != null && invoke.getPartnerLink() != null) {
            plName = invoke.getPartnerLink();
        }
        this.removePartnerLinks(process, graph, rule);
        graph.deleteNodeRenderer((NodeRenderer)view);
        return true;
    }

    private void removePartnerLinks(Process process, BPELGraphPane graph, Rule rule) {
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        List<PartnerLinkNode> partnerLinkNodes = model.getPartnerLinkNodes();
        List linkedPartnerLinkNodeslist = this.getLinkedPartnerLinkNodes(rule, partnerLinkNodes);
        for (int count = 0; count < linkedPartnerLinkNodeslist.size(); ++count) {
            PartnerLinkNode pLinkNode = (PartnerLinkNode)((Object)linkedPartnerLinkNodeslist.get(count));
            NodeRenderer nodeRenderer = graph.getNodeRendererForNode((Node)pLinkNode);
            if (nodeRenderer.getChildCount() != 1) continue;
            model.deleteNode(pLinkNode.getParentNode(), (Node)pLinkNode);
            process.deletePartnerLink((PartnerLink)pLinkNode.getUserObject());
        }
    }

    private List getLinkedPartnerLinkNodes(Rule rule, List partnerLinkNodes) {
        ArrayList<PartnerLinkNode> list = new ArrayList<PartnerLinkNode>();
        Invoke invoke = rule.getInvoke();
        if (invoke == null || invoke.getPartnerLink() == null) {
            return list;
        }
        String pl = invoke.getPartnerLink();
        PartnerLinkNode pLinkNode = null;
        PartnerLink pLink = null;
        for (int count = 0; count < partnerLinkNodes.size(); ++count) {
            String linkName;
            pLinkNode = (PartnerLinkNode)((Object)partnerLinkNodes.get(count));
            pLink = (PartnerLink)pLinkNode.getUserObject();
            if (pLink == null || !(linkName = pLink.getName()).trim().equals(pl)) continue;
            list.add(pLinkNode);
        }
        return list;
    }

    private void removeRuleComponent(String plName, BPELGraphPane graph) {
        if (plName == null) {
            return;
        }
        BPELProject prj = graph.getBPELProject();
        Project project = (Project)prj.getProjectContext();
        int index = plName.indexOf(".");
        if (index > 0) {
            String compName = plName.substring(0, index);
            int doRemove = GraphUtils.showConfirmDialog((Component)((Object)graph), (String)BPELStringTranslator.getString("BRL_DELETE_SOA_RULE", "Do you want to delete the Rule component from SOA Editor too?"), (String)BPELStringTranslator.getString("BRL_DELETE_SOA_COMPONENT", "Delete SOA Component"));
            if (doRemove == 0) {
                try {
                    JDevSCAIntegrationUtil.deleteSCAComponent(project, compName, "rule");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static boolean isRulePartnerLink(Process p, String plName) {
        List list = BPELModelUtil.findAllActivitiesUsingPartnerlink((Process)p, (String)plName);
        boolean isRulePL = false;
        for (Activity a : list) {
            Scope s = BPELModelUtil.getParentScope((Activity)a);
            if (!(s instanceof Rule)) continue;
            isRulePL = true;
            break;
        }
        return isRulePL;
    }

    private boolean handleDeleteRulePL(BPELGraphPane graph, PartnerLinkView view) {
        BPELGraphModel model;
        Process process;
        PartnerLinkNode node = (PartnerLinkNode)view.getNode();
        PartnerLink pl = (PartnerLink)node.getUserObject();
        if (pl != null && RulesBPELModelerPlugin.isRulePartnerLink(process = (model = (BPELGraphModel)graph.getModel()).getProcess(), pl.getName())) {
            RulesBPELModelerPlugin.removeRuleActivityByPartnerLinkName(process, pl.getName(), graph);
        }
        return false;
    }

    public static List<Rule> getRulesByPartnerLink(Process p, String plName) {
        List list = BPELModelUtil.findAllActivitiesUsingPartnerlink((Process)p, (String)plName);
        ArrayList<Rule> ret = new ArrayList<Rule>();
        for (Activity a : list) {
            Scope s = BPELModelUtil.getParentScope((Activity)a);
            if (!(s instanceof Rule)) continue;
            ret.add((Rule)s);
        }
        return ret;
    }

    public static void removeRuleActivityByPartnerLinkName(Process proc, String plName, BPELGraphPane pane) {
        List<Rule> list;
        BPELGraphModel gmodel = null;
        if (pane != null) {
            gmodel = (BPELGraphModel)pane.getModel();
            proc = gmodel.getProcess();
        }
        if ((list = RulesBPELModelerPlugin.getRulesByPartnerLink(proc, plName)).size() > 0) {
            for (Rule r : list) {
                ContainerActivity p = (ContainerActivity)r.getParentActivity();
                try {
                    p.deleteActivity((Activity)r);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (pane == null) continue;
                Node rn = null;
                if (gmodel != null) {
                    rn = gmodel.getNodeForActivity((Activity)r);
                }
                Node pn = null;
                if (rn != null) {
                    pn = rn.getParentNode();
                }
                if (rn == null || pn == null) continue;
                gmodel.deleteNode(pn, rn);
            }
        }
    }
}

