/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.resourcecatalog.drophandlers;

import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.net.URL;
import oracle.adf.rc.resource.Resource;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.datatransfer.TransferableContext;
import oracle.jdeveloper.rcwsiladapter.WSDLContext;
import oracle.jdeveloper.rescat2.nodes.ResourceNodeFactory;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.view.DNDDropHandler;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.designerplugins.resourcecatalog.drophandlers.IResourcePaletteDropHandler;

public class WSILDropHandler
implements DNDDropHandler,
IResourcePaletteDropHandler {
    @Override
    public boolean handleDrop(DropTargetDropEvent e, Object data, GraphPane pane) {
        if (data == null || !(data instanceof TransferableContext)) {
            return false;
        }
        TransferableContext transferContext = (TransferableContext)data;
        if (transferContext.size() == 0) {
            return false;
        }
        int count = 0;
        if (count < transferContext.size()) {
            if (this.handleDropData(pane, transferContext.get(count), e)) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    private boolean handleDropData(GraphPane pane, Object object, DropTargetDropEvent e) {
        if (object instanceof XMLSourceNode) {
            return this.handleXMLSourceNodeDrop(pane, (XMLSourceNode)object, e);
        }
        return false;
    }

    private boolean handleXMLSourceNodeDrop(GraphPane pane, XMLSourceNode node, DropTargetDropEvent e) {
        BPELGraphPane graph = (BPELGraphPane)pane;
        URL url = node.getURL();
        Resource res = ResourceNodeFactory.getInstance().resolveURL(url);
        if (res instanceof WSDLContext) {
            Point pt = pane.inDrillDownMode() ? e.getLocation() : pane.convertToNonScaledTranslatedCoordinates(e.getLocation());
            int x = pt.x;
            int y = pt.y;
            NodeRenderer r = pane.getNodeRendererAtPosition(x, y);
            SwimLaneView view = null;
            view = r instanceof SwimLaneView ? (SwimLaneView)r : graph.getLeftSwimLaneView();
            BPELGraphModel model = (BPELGraphModel)pane.getModel();
            Process process = model.getProcess();
            graph.createPartnerLink(view, new Point(x, y), (Scope)process, ((WSDLContext)res).getWsdlInfo().getWSDLUrl().toExternalForm());
            return true;
        }
        return false;
    }
}

