/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.phase.plugin;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import javax.swing.SwingUtilities;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.event.GraphPaneStatusEvent;
import oracle.tip.tools.ide.common.graph.event.GraphPaneStatusListener;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.model.GraphNode;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.DNDDropHandler;
import oracle.tip.tools.ide.common.graph.view.DropZone;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELDNDDropHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;

public class PhaseDNDDropHandler
implements DNDDropHandler {
    public boolean handleDrop(DropTargetDropEvent e, Object data, GraphPane pane) {
        BPELGraphPane graph = (BPELGraphPane)pane;
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        boolean bValidate = graph.getValidateOnLoad();
        Point pt = graph.inDrillDownMode() ? e.getLocation() : pane.convertToNonScaledTranslatedCoordinates(e.getLocation());
        int x = pt.x;
        int y = pt.y;
        NodeRenderer r = pane.getNodeRendererAtPosition(x, y);
        String taskName = BPELDNDDropHandler.getTaskNameFromDropData(data);
        if (!(r instanceof DropZone)) {
            return false;
        }
        DropZone dropView = (DropZone)r;
        if (!dropView.isDropAllowed()) {
            return false;
        }
        dropView.setHighLightOn(false);
        Node dropNode = r.getNode();
        boolean bEditOnDrop = false;
        boolean bRebuildPartnerLinks = false;
        GraphNode newNode = null;
        if (taskName.equalsIgnoreCase("phase_scope")) {
            newNode = ModelBuilder.createGraphNode(214, process, bValidate);
            bEditOnDrop = true;
        }
        if (newNode != null) {
            Activity activity = (Activity)newNode.getUserObject();
            Node parentNode = r.getParent().getNode();
            ContainerActivity parentActivity = (ContainerActivity)parentNode.getUserObject();
            if (BPELDNDDropHandler.checkForSequenceInsertion(parentNode, (Node)newNode, graph, dropNode, process)) {
                return true;
            }
            int index = parentNode.indexOf(dropNode);
            if (parentActivity != null && activity != null) {
                try {
                    parentActivity.insertActivity(index / 2, activity);
                }
                catch (Exception e1) {
                    GraphUtils.displayError((Component)((Object)graph), (Throwable)e1);
                }
            }
            if (bEditOnDrop) {
                this.setupDelayedEditing((Node)newNode, graph);
            }
            model.insertChildNode(parentNode, (Node)newNode, index);
            if (bRebuildPartnerLinks) {
                model.buildPartnerLinkConnections();
            }
        }
        return newNode != null;
    }

    private void setupDelayedEditing(final Node n, final BPELGraphPane graph) {
        GraphPaneStatusListener lst = new GraphPaneStatusListener(){

            public void modelLoaded(GraphModel model) {
            }

            public void statusChanged(GraphPaneStatusEvent evt) {
                if (evt.getId() == 2) {
                    PhaseDNDDropHandler.this.startEditingNode(n, graph);
                    graph.removeGraphPaneStatusListener(this);
                }
            }
        };
        graph.addGraphPaneStatusListener(lst);
    }

    private void startEditingNode(Node n, final BPELGraphPane graph) {
        final NodeRenderer r = graph.getNodeRendererForNode(n);
        if (r != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                graph.startEditing(r);
            } else {
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        graph.startEditing(r);
                    }
                };
                SwingUtilities.invokeLater(runner);
            }
        }
    }
}

