/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.phase.plugin;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFile;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileRegistry;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.ide.model.Project;
import oracle.ide.palette2.PaletteItem;
import oracle.tip.tools.ide.common.bpelparser.extension.phase.iface.Phase;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.plugin.BPELParserPlugin;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.GraphElement;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.NodeRendererFactory;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.pm.addin.BPELAddin;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilderPlugin;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneDropTargetListener;
import oracle.tip.tools.ide.pm.bpelgraph.views.NodeEditorSource;
import oracle.tip.tools.ide.pm.bpelgraph.views.PartnerLinkView;
import oracle.tip.tools.ide.pm.designerplugins.phase.bpelgraph.model.PhaseNode;
import oracle.tip.tools.ide.pm.designerplugins.phase.bpelgraph.views.PhaseView;
import oracle.tip.tools.ide.pm.designerplugins.phase.plugin.PhaseDNDDropHandler;
import oracle.tip.tools.ide.pm.designerplugins.phase.plugin.PhaseModelBuilderPlugin;
import oracle.tip.tools.ide.pm.designerplugins.phase.plugin.PhaseNodeEditorSource;
import oracle.tip.tools.ide.pm.designerplugins.phase.plugin.PhaseNodeRendererFactory;
import oracle.tip.tools.ide.pm.designerplugins.phase.plugin.PhaseParserExtensionsPlugin;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;
import oracle.tip.tools.ide.pm.plugin.AbstractBPELModelerPlugin;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class PhaseBPELModelerPlugin
extends AbstractBPELModelerPlugin {
    private static final String PHASE_PALETTE_SCHEMA = "documents/phase/phase_activity.xsd";

    @Override
    public void registerMetaDataFiles(Object obj) {
        try {
            StandaloneMetadataFileRegistry registry = (StandaloneMetadataFileRegistry)obj;
            URL url = BPELAddin.class.getResource("documents/phase/phase_activity_metadata.xml");
            StandaloneMetadataFile file = OracleStandaloneMetadataFactory.createStandaloneMetadataFile((URL)url);
            registry.addStandaloneMetadataFile(file);
        }
        catch (StandaloneMetadataFileException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<URL> getSchemaGrammers() {
        ArrayList<URL> schemas = new ArrayList<URL>();
        URL url = BPELAddin.class.getResource(PHASE_PALETTE_SCHEMA);
        schemas.add(url);
        return schemas;
    }

    @Override
    public ModelBuilderPlugin getModelBuilderPlugin() {
        return new PhaseModelBuilderPlugin();
    }

    @Override
    public BPELParserPlugin getBPELParserPlugin() {
        return new PhaseParserExtensionsPlugin();
    }

    @Override
    public NodeRendererFactory getNodeRendererFactory() {
        return new PhaseNodeRendererFactory();
    }

    @Override
    public NodeEditorSource getNodeEditorSource() {
        return new PhaseNodeEditorSource();
    }

    @Override
    public void registerDNDHandler(BPELGraphPaneDropTargetListener dropTargetListener, BPELGraphPane graph) {
        PhaseDNDDropHandler dropHandler = new PhaseDNDDropHandler();
        dropTargetListener.registerDNDHandler(dropHandler, PaletteItem.PALETTE_ITEM_FLAVOR);
        dropTargetListener.registerDNDHandler(dropHandler, XmlTransferUtils.FLAVOR_XMLKEY);
    }

    @Override
    public boolean handleDeleteGraphElement(BPELGraphPane graph, GraphElement elem) {
        if (elem instanceof PhaseView) {
            return this.handleDeletePhaseActivity(graph, (PhaseView)elem);
        }
        if (elem instanceof PartnerLinkView) {
            return this.handleDeletePhase2MediatorPL(graph, (PartnerLinkView)elem);
        }
        return false;
    }

    private boolean handleDeletePhaseActivity(BPELGraphPane graph, PhaseView view) {
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        PhaseNode node = (PhaseNode)view.getNode();
        Phase phase = (Phase)node.getUserObject();
        Invoke invoke = phase.getInvoke();
        String plName = null;
        if (invoke != null && invoke.getPartnerLink() != null) {
            plName = invoke.getPartnerLink();
        }
        this.removePartnerLinks(process, graph, phase);
        graph.deleteNodeRenderer((NodeRenderer)view);
        return true;
    }

    private void removePartnerLinks(Process process, BPELGraphPane graph, Phase phase) {
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        List<PartnerLinkNode> partnerLinkNodes = model.getPartnerLinkNodes();
        List linkedPartnerLinkNodeslist = this.getLinkedPartnerLinkNodes(phase, partnerLinkNodes);
        for (int count = 0; count < linkedPartnerLinkNodeslist.size(); ++count) {
            PartnerLinkNode pLinkNode = (PartnerLinkNode)((Object)linkedPartnerLinkNodeslist.get(count));
            NodeRenderer nodeRenderer = graph.getNodeRendererForNode((Node)pLinkNode);
            if (nodeRenderer.getChildCount() != 2) continue;
            model.deleteNode(pLinkNode.getParentNode(), (Node)pLinkNode);
            process.deletePartnerLink((PartnerLink)pLinkNode.getUserObject());
        }
    }

    private List getLinkedPartnerLinkNodes(Phase phase, List partnerLinkNodes) {
        ArrayList<PartnerLinkNode> list = new ArrayList<PartnerLinkNode>();
        Invoke invoke = phase.getInvoke();
        if (invoke == null || invoke.getPartnerLink() == null) {
            return list;
        }
        String pl = invoke.getPartnerLink();
        PartnerLinkNode pLinkNode = null;
        PartnerLink pLink = null;
        for (int count = 0; count < partnerLinkNodes.size(); ++count) {
            String linkName;
            pLinkNode = (PartnerLinkNode)((Object)partnerLinkNodes.get(count));
            pLink = (PartnerLink)pLinkNode.getUserObject();
            if (pLink == null || !(linkName = pLink.getName()).trim().equals(pl)) continue;
            list.add(pLinkNode);
        }
        return list;
    }

    private void removeRuleAndMediatorComponents(String plName, BPELGraphPane graph) {
        if (plName == null) {
            return;
        }
        BPELProject prj = graph.getBPELProject();
        Project project = (Project)prj.getProjectContext();
        int index = plName.indexOf(".");
        if (index > 0) {
            String compName = plName.substring(0, index);
            int doRemove = GraphUtils.showConfirmDialog((Component)((Object)graph), (String)BPELStringTranslator.getString("BRL_DELETE_SOA_RULE", "Do you want to delete the Phase component from SOA Editor too?"), (String)BPELStringTranslator.getString("BRL_DELETE_SOA_COMPONENT", "Delete SOA Component"));
            if (doRemove == 0) {
                try {
                    JDevSCAIntegrationUtil.deleteSCAComponent(project, compName, "rule");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static boolean isPhasePartnerLink(Process p, String plName) {
        List list = BPELModelUtil.findAllActivitiesUsingPartnerlink((Process)p, (String)plName);
        boolean isPhasePL = false;
        for (Activity a : list) {
            Scope s = BPELModelUtil.getParentScope((Activity)a);
            if (!(s instanceof Phase)) continue;
            isPhasePL = true;
            break;
        }
        return isPhasePL;
    }

    private boolean handleDeletePhase2MediatorPL(BPELGraphPane graph, PartnerLinkView view) {
        BPELGraphModel model;
        Process process;
        PartnerLinkNode node = (PartnerLinkNode)view.getNode();
        PartnerLink pl = (PartnerLink)node.getUserObject();
        if (pl != null && PhaseBPELModelerPlugin.isPhasePartnerLink(process = (model = (BPELGraphModel)graph.getModel()).getProcess(), pl.getName())) {
            PhaseBPELModelerPlugin.removePhaseActivityByPartnerLinkName(model.getProcess(), pl.getName(), graph);
        }
        return false;
    }

    public static List<Phase> getPhasesByPartnerLink(Process p, String plName) {
        List list = BPELModelUtil.findAllActivitiesUsingPartnerlink((Process)p, (String)plName);
        ArrayList<Phase> ret = new ArrayList<Phase>();
        for (Activity a : list) {
            Scope s = BPELModelUtil.getParentScope((Activity)a);
            if (!(s instanceof Phase) || ret.contains(s)) continue;
            ret.add((Phase)s);
        }
        return ret;
    }

    public static void removePhaseActivityByPartnerLinkName(Process proc, String plName, BPELGraphPane pane) {
        List<Phase> list = PhaseBPELModelerPlugin.getPhasesByPartnerLink(proc, plName);
        if (list.size() > 0) {
            for (Phase r : list) {
                ContainerActivity p = (ContainerActivity)r.getParentActivity();
                try {
                    p.deleteActivity((Activity)r);
                }
                catch (Exception e) {
                    GraphUtils.displayError((Component)((Object)pane), (Throwable)e);
                    return;
                }
                if (pane == null) continue;
                BPELGraphModel gmodel = (BPELGraphModel)pane.getModel();
                Node rn = gmodel.getNodeForActivity((Activity)r);
                Node pn = rn.getParentNode();
                gmodel.deleteNode(pn, rn);
            }
        }
    }

    @Override
    public Icon getDragIconForActivity(String name) {
        if (name.equalsIgnoreCase("phase")) {
            return ImageCache.getIcon("graph/extensions/phase_40x40.png");
        }
        return null;
    }
}

