/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.phase.bpelgraph.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PLProperties;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpeldesigner.util.PartnerLinkWSDLUtil;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.annotation.iface.Documentation;
import oracle.tip.tools.ide.common.bpelparser.extension.phase.iface.Phase;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Assign;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Sequence;
import oracle.tip.tools.ide.common.bpelparser.iface.To;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.model.PortNode;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.ide.IDE;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.common.utils.ContentUtil;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.WSDLPartData;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.InterfaceInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.fabric.common.mediator.MediatorUtils;
import oracle.tip.tools.ide.fabric.model.SCAComposite;
import oracle.tip.tools.ide.pm.bpelgraph.editors.BaseEditingPage;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesSelectionPanel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariablesSelectionTableModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.AssignNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.InvokeNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ReceiveNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SequenceNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.SwimLaneNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPageChangeListener;
import oracle.tip.tools.ide.pm.designerplugins.phase.bpelgraph.editors.PhaseDictionaryFileBuilder;
import oracle.tip.tools.ide.pm.designerplugins.phase.bpelgraph.model.PhaseNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.modules.rules.DecisionServiceConstants;
import oracle.tip.tools.ide.pm.modules.rules.RulesUtil;
import oracle.tip.tools.ide.pm.modules.sca.util.JDevSCAIntegrationUtil;
import oracle.tip.tools.ide.rules.dictionarybuilder.DictionaryFileBuilder;
import oracle.tip.tools.ide.rules.dictionarybuilder.RuleType;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;
import oracle.tip.tools.ide.rules.dictionarybuilder.jdev.JDevDictionaryFileBuilder;
import oracle.tip.tools.ide.rules.sdkmodel.SchemaElem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PhaseEditPage
extends BaseEditingPage
implements ActionListener {
    private static final String PHASE_ACTIVITY_NAME = BPELStringTranslator.getString("PHASE_ACTIVITY_NAME");
    JTextField m_nameField = new JTextField();
    JTextField m_descField = new JTextField();
    BPELProject m_prj = null;
    Phase m_phaseActivity;
    PhaseNode m_phaseNode;
    Sequence m_sequence;
    SequenceNode m_sequenceNode;
    InvokeNode m_invokeNode;
    ReceiveNode m_receiveNode;
    JButton m_createServiceBtn;
    protected JButton m_editBtn;
    boolean m_validate = false;
    boolean m_bEditing = true;
    List<Variable> m_serviceInVarList = new ArrayList<Variable>();
    List<Variable> m_serviceOutVarList = new ArrayList<Variable>();
    SCAComposite m_composite;
    protected VariablesSelectionPanel m_varsPanel;
    protected List<Variable> m_inputVars = new ArrayList<Variable>();
    protected List<Variable> m_outputVars = new ArrayList<Variable>();
    protected VariablesSelectionTableModel m_tableModel;
    protected String m_uname = null;
    protected URL m_ruleDictionaryURL = null;
    protected String m_ruleDictionaryName = null;
    protected String m_ruleServiceName = null;
    protected String m_ruleNS = null;
    protected WizardData m_ruleWizardData = null;
    private List m_outputVarsXSD;
    protected String m_mediatorNS = null;
    protected String m_mediatorName = null;
    protected String m_mediatorServiceName;
    protected String m_mediatorPortType = "ServicePT";
    protected String m_mediatorCallbackPortType = "ServiceCallbackPT";
    protected URL m_mediatorWsdlURL = null;
    protected DictionaryFileBuilder m_builder = null;
    public static String NL = "\n";
    private String m_applicationName = "";
    private String m_projectName = "";

    public PhaseEditPage(GraphPane pane, Node n) throws Exception {
        super((BPELGraphPane)pane);
        this.m_prj = this.getBPELProject();
        this.m_phaseNode = (PhaseNode)n;
        this.m_tableModel = new VariablesSelectionTableModel();
        this.m_varsPanel = new VariablesSelectionPanel(this.m_tableModel, this.m_graphPane, (Scope)this.m_phaseActivity);
    }

    @Override
    public void setUserObject(Object model) {
        this.m_phaseActivity = (Phase)model;
        this.m_composite = ((JDevBPELProject)this.m_prj).getSCAComposite();
        if (this.m_phaseActivity != null) {
            this.m_nameField.setText(this.m_phaseActivity.getName());
            Documentation doc = this.m_phaseActivity.getAnnotation().getDocumentation();
            if (doc != null) {
                this.m_descField.setText(doc.getValue());
            }
            if (this.m_phaseActivity.getInvoke() != null) {
                this.m_bEditing = false;
                this.populateVariablesTable();
            }
        } else {
            String name = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)PHASE_ACTIVITY_NAME, Phase.class);
            this.m_nameField.setText(name);
            this.createNewPhaseNode();
        }
        this.loadUI();
        this.jbInit();
        if (!this.m_bEditing) {
            this.m_nameField.setEnabled(false);
            this.m_varsPanel.setEnabled(false);
        }
        this.m_uname = this.m_prj.getProcessName() + "_" + this.m_nameField.getText();
        this.m_ruleDictionaryName = "OracleRules_" + this.m_uname;
        URL dirURL = this.getScaProject().getProjectRoot();
        String packageName = URLFileSystem.getFileName((URL)dirURL);
        if (packageName != null) {
            packageName = packageName.toLowerCase() + "/";
        }
        if (packageName == null) {
            packageName = "";
        }
        this.m_ruleDictionaryURL = URLFactory.newURL((URL)dirURL, (String)("/oracle/rules/" + packageName + this.m_ruleDictionaryName + ".rules"));
        this.m_ruleServiceName = this.m_ruleDictionaryName + "_" + "RuleService";
        this.m_ruleNS = JDevDictionaryFileBuilder.getDecisionServiceNameSpace((String)this.m_ruleDictionaryName, (String)this.m_ruleServiceName);
    }

    private void populateVariablesTable() {
        VariablesSelectionTableModel.VarRowData data;
        Variable v;
        String vName;
        Copy r;
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graphPane.getModel();
        Process processModel = graphModel.getProcess();
        Assign b2s = this.m_phaseActivity.getBPELToServiceAssign();
        List rules = b2s.getCopyRules();
        for (Object o : rules) {
            r = (Copy)o;
            vName = r.getFrom().getVariable();
            v = BPELModelUtil.getVariableForName((Process)processModel, (String)vName, (boolean)true);
            data = new VariablesSelectionTableModel.VarRowData();
            data.m_isInputVar = true;
            data.m_variable = v;
            if (v == null) continue;
            this.m_tableModel.getData().addElement(data);
        }
        b2s = this.m_phaseActivity.getServiceToBPELAssign();
        rules = b2s.getCopyRules();
        for (Object o : rules) {
            r = (Copy)o;
            vName = r.getTo().getVariable();
            v = BPELModelUtil.getVariableForName((Process)processModel, (String)vName, (boolean)true);
            data = new VariablesSelectionTableModel.VarRowData();
            data.m_isInputVar = false;
            data.m_variable = v;
            if (v == null) continue;
            this.m_tableModel.getData().addElement(data);
        }
        this.m_tableModel.refresh();
    }

    private void loadUI() {
        this.m_phaseNode.setUserObject(this.m_phaseActivity);
        this.m_phaseNode.setName(this.m_nameField.getText());
        this.m_phaseActivity.setName(this.m_nameField.getText());
        Documentation doc = this.m_phaseActivity.getAnnotation().getDocumentation();
        if (doc != null) {
            this.m_descField.setText(doc.getValue());
        }
    }

    private SCAProject getScaProject() {
        JDevBPELProject p = (JDevBPELProject)this.m_prj;
        return (SCAProject)p.getSCAProject();
    }

    private void createNewPhaseNode() {
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        Object p = null;
        int index = 0;
        Node pNode = this.m_phaseNode.getParentNode();
        if (pNode != null) {
            p = pNode.getUserObject();
            index = pNode.indexOf((Node)this.m_phaseNode);
        }
        if (p != null) {
            try {
                ((ContainerActivity)p).deleteActivity((Activity)this.m_phaseActivity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_phaseActivity = (Phase)BPELParser.createImplementation(Phase.class);
        this.m_phaseActivity.setDOMElement(this.m_phaseActivity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        this.m_phaseNode.setUserObject(this.m_phaseActivity);
        if (p != null) {
            try {
                ((ContainerActivity)p).insertActivity(index / 2, (Activity)this.m_phaseActivity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createInvokeReply() {
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        Invoke invoke = (Invoke)BPELParser.createImplementation(Invoke.class);
        invoke.setDOMElement(invoke.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        try {
            this.m_sequence.addActivity((Activity)invoke);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_invokeNode = new InvokeNode();
        this.m_invokeNode.setUserObject(invoke);
        this.m_graphModel.addChildNode((Node)this.m_sequenceNode, (Node)this.m_invokeNode);
        this.m_invokeNode.setName("Invoke");
        this.m_graphModel.addChildNode((Node)this.m_invokeNode, (Node)new PortNode(1));
        this.m_graphModel.addChildNode((Node)this.m_invokeNode, (Node)new PortNode(1));
        if (this.hasOutput()) {
            Receive receive = (Receive)BPELParser.createImplementation(Receive.class);
            receive.setDOMElement(receive.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            try {
                this.m_sequence.addActivity((Activity)receive);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_receiveNode = new ReceiveNode();
            this.m_receiveNode.setUserObject(receive);
            this.m_graphModel.addChildNode((Node)this.m_sequenceNode, (Node)this.m_receiveNode);
            this.m_receiveNode.setName("Receive");
            this.m_graphModel.addChildNode((Node)this.m_receiveNode, (Node)new PortNode(0));
            this.m_graphModel.addChildNode((Node)this.m_receiveNode, (Node)new PortNode(0));
        }
    }

    private Sequence createSequenceNode() {
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        Sequence sequence = (Sequence)BPELParser.createImplementation(Sequence.class);
        sequence.setDOMElement(sequence.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        String name = BPELModelUtil.generateUniqueName((Process)this.m_processModel, (String)"Sequence", Sequence.class);
        sequence.setName(name);
        try {
            this.m_phaseActivity.addActivity((Activity)sequence);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SequenceNode sequenceNode = new SequenceNode();
        sequenceNode.setUserObject(sequence);
        this.m_graphModel.addChildNode(this.m_phaseNode, (Node)sequenceNode);
        this.m_sequence = sequence;
        this.m_sequenceNode = sequenceNode;
        return sequence;
    }

    private Assign createAssignNode(String name) {
        Element processElem = this.m_processModel.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        Assign assign = (Assign)BPELParser.createImplementation(Assign.class);
        assign.setDOMElement(assign.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        try {
            this.m_sequence.addActivity((Activity)assign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        assign.setName(name);
        AssignNode assignNode = new AssignNode();
        assignNode.setUserObject(assign);
        this.m_graphModel.addChildNode((Node)this.m_sequenceNode, (Node)assignNode);
        assignNode.setName(name);
        return assign;
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        JLabel nameLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)nameLbl, (Component)this.m_nameField, (String)BPELStringTranslator.getString("GENERAL_EDITOR_NAME"));
        JLabel descLbl = new JLabel();
        ResourceUtils.resLabel((JLabel)descLbl, (Component)this.m_descField, (String)BPELStringTranslator.getString("PHASE_DLG_LBL_DECRIPTION"));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)panel, (Component)nameLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_nameField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)descLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_descField, (int)1, (int)row++, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 5, 0, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)panel, (Component)this.m_varsPanel, (int)0, (int)row++, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        this.m_editBtn = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_editBtn, (String)BPELStringTranslator.getString("PHASE_EDIT_DYNMAMIC_RULES"));
        this.m_editBtn.addActionListener(this);
        GraphUtils.addComponent((Container)panel, (Component)this.m_editBtn, (int)1, (int)row++, (int)1, (int)1, (int)12, (int)0, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        row = 0;
        GraphUtils.addComponent((Container)this, (Component)panel, (int)0, (int)row++, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
    }

    public Node getNode() {
        return this.m_phaseNode;
    }

    public void editRuleDictionary(final URL dictURL) {
        final StatusGlassPane status = new StatusGlassPane((Component)((Object)this.m_graphPane));
        status.enableUserInput(false);
        status.setStatusMessage(BPELStringTranslator.getString("PLEASE_WAIT_MSG"), BPELStringTranslator.getString("BRL_UPDATING_SCA_PROJECT"));
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PhaseEditPage.openRuleDictionary(dictURL);
                }
                finally {
                    status.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    public static void openRuleDictionary(URL dictURL) {
        try {
            IDE ide = IDEResolver.getIDE();
            ide.openEditor(dictURL);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_editBtn && this.m_ruleDictionaryURL != null && URLFileSystem.exists((URL)this.m_ruleDictionaryURL)) {
            this.editRuleDictionary(this.m_ruleDictionaryURL);
        }
    }

    private void updatePhaseNode() {
        this.m_phaseNode.setName(this.m_nameField.getText());
        this.m_phaseActivity.setName(this.m_nameField.getText());
        this.setDecription();
        if (this.m_validate) {
            this.m_phaseActivity.getValidationReport(new ValidationContext(this.m_processModel), true);
        }
    }

    @Override
    public Object getUserObject() {
        return this.m_phaseActivity;
    }

    private void setDecription() {
        String desc = this.m_descField.getText();
        if (Helper.hasValue((String)desc)) {
            Documentation doc = this.m_phaseActivity.getAnnotation().getDocumentation();
            if (doc == null) {
                doc = (Documentation)BPELParser.createImplementation(Documentation.class);
                this.m_phaseActivity.getAnnotation().setDocumentation(doc);
            }
            doc.setValue(desc);
        }
    }

    @Override
    public void saveChanges() {
        this.save();
    }

    public void save() {
        this.updatePhaseNode();
        if (!this.m_bEditing) {
            return;
        }
        this.m_phaseNode.setUserObject(this.m_phaseActivity);
        if (this.m_tableModel.getData().size() == 0) {
            return;
        }
        this.m_uname = this.m_prj.getProcessName() + "_" + this.m_nameField.getText();
        this.m_ruleDictionaryName = "OracleRules_" + this.m_uname;
        URL dirURL = this.getScaProject().getProjectRoot();
        this.m_ruleServiceName = this.m_ruleDictionaryName + "_" + "RuleService";
        this.m_ruleNS = JDevDictionaryFileBuilder.getDecisionServiceNameSpace((String)this.m_ruleDictionaryName, (String)this.m_ruleServiceName);
        this.getAppAndProjNames();
        this.setUpRuleWizardData();
        this.m_ruleDictionaryURL = URLFactory.newURL((URL)dirURL, (String)("/oracle/rules/" + this.m_builder.getDefaultPackage() + "/" + this.m_ruleDictionaryName + ".rules"));
        this.m_mediatorName = "Mediator_" + this.m_uname;
        this.m_mediatorNS = "http://oracle.com/sca/mediator/" + this.m_applicationName + "/" + this.m_projectName + "/" + this.m_mediatorName;
        this.m_mediatorServiceName = this.m_mediatorName;
        this.m_mediatorWsdlURL = URLFactory.newURL((URL)this.m_prj.getProjectURL(), (String)(this.m_mediatorName + ".wsdl"));
        String template = this.getWSDLTemplate(this.m_mediatorName, this.m_mediatorNS);
        PhaseEditPage.buildWsdl(template, this.m_mediatorWsdlURL, this.m_ruleWizardData.getInputVarsXSD(), this.m_outputVarsXSD, null);
        this.preparePhaseNode();
        this.getInputOutputVariabls();
        String mediatorPrefix = this.m_graphModel.getProcess().addNamespace(this.m_mediatorNS);
        String opName = "execute";
        PartnerLink pl = null;
        try {
            pl = this.createPL(URLFileSystem.getFileName((URL)this.m_mediatorWsdlURL));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String plName = pl.getName();
        Invoke invoke = this.m_phaseActivity.getInvoke();
        Receive receive = this.m_phaseActivity.getReceive();
        QName portType = new QName(this.m_mediatorNS, this.m_mediatorPortType, mediatorPrefix);
        invoke.setPartnerLink(plName);
        invoke.setPortType(portType);
        invoke.setOperation("execute");
        QName callbackPortType = new QName(this.m_mediatorNS, this.m_mediatorCallbackPortType, mediatorPrefix);
        if (this.hasOutput()) {
            receive.setPartnerLink(plName);
            receive.setPortType(callbackPortType);
            receive.setOperation("callback");
        }
        Variable variable = null;
        variable = this.createVariable(this.m_processModel, (Activity)this.m_phaseActivity, pl, portType, opName, plName, true);
        variable.setName("ServiceInVar");
        this.m_phaseActivity.addVariable(variable);
        this.m_serviceInVarList.add(variable);
        invoke.setInputVariable(variable.getName());
        if (this.m_serviceInVarList != null && this.m_serviceInVarList.size() > 0) {
            this.setBpelToServiceCopyList(variable, mediatorPrefix, "request");
        }
        if (this.hasOutput()) {
            variable = this.createVariable(this.m_processModel, (Activity)this.m_phaseActivity, pl, callbackPortType, "callback", plName, true);
            variable.setName("ServiceOutVar");
            this.m_phaseActivity.addVariable(variable);
            this.m_serviceOutVarList.add(variable);
            receive.setVariable(variable.getName());
            if (this.m_serviceOutVarList != null && this.m_serviceOutVarList.size() > 0) {
                this.setServiceToBpelCopyList(variable, mediatorPrefix, "reply");
            }
        }
        final StatusGlassPane status = new StatusGlassPane((Component)((Object)this.m_graphPane));
        status.enableUserInput(false);
        status.setStatusMessage(BPELStringTranslator.getString("PLEASE_WAIT_MSG"), BPELStringTranslator.getString("BRL_UPDATING_SCA_PROJECT"));
        final PartnerLink partnerLink = pl;
        this.m_graphModel.buildPartnerLinkConnections();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PhaseEditPage.this.createDecisionService();
                    PhaseEditPage.this.createMediator();
                    PhaseEditPage.this.updateComposite(partnerLink);
                }
                finally {
                    status.enableUserInput(true);
                    if (PhaseEditPage.this.m_ruleDictionaryURL != null && URLFileSystem.exists((URL)PhaseEditPage.this.m_ruleDictionaryURL)) {
                        PhaseEditPage.this.editRuleDictionary(PhaseEditPage.this.m_ruleDictionaryURL);
                    }
                }
            }
        };
        new Thread(r).start();
    }

    protected void updateComposite(PartnerLink pl) {
        boolean newReferenceCreated = this.createReference(pl);
        if (newReferenceCreated) {
            this.addWire(this.m_mediatorName, pl);
            this.setPLProperties(pl);
        }
    }

    private void addWire(String string, PartnerLink pl) {
        SCAController c = JDevSCAIntegrationUtil.getSCAController(this.m_prj);
        c.addWire(this.m_prj.getProcessName(), pl.getName(), string, this.m_mediatorName);
    }

    private void preparePhaseNode() {
        if (this.m_sequence != null) {
            try {
                this.m_phaseActivity.deleteActivity((Activity)this.m_sequence);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.m_sequenceNode != null) {
            this.m_phaseNode.removeAllChildNodes();
        }
        this.createSequenceNode();
        this.createAssignNode("BPEL_To_Service");
        this.createInvokeReply();
        if (this.hasOutput()) {
            this.createAssignNode("Service_To_BPEL");
        }
    }

    private boolean hasOutput() {
        return this.m_outputVarsXSD.size() > 0;
    }

    private boolean createReference(PartnerLink pl) {
        boolean newReferenceCreated = false;
        SCAController c = JDevSCAIntegrationUtil.getSCAController(this.m_prj);
        WsdlInfo wsdlInfoRef = null;
        try {
            wsdlInfoRef = JDevSCAIntegrationUtil.getWsdlInfoFromPartnerLink(this.m_prj, pl, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.hasOutput()) {
            QName rep = wsdlInfoRef.getReplyPorttype();
            wsdlInfoRef.setReplyPorttype(wsdlInfoRef.getRequestPorttype());
            wsdlInfoRef.setRequestPorttype(rep);
        }
        if (c.isNameUniqueWithinComponent(this.m_prj.getProcessName(), pl.getName())) {
            c.addReference(this.m_prj.getProcessName(), pl.getName(), (InterfaceInfo)wsdlInfoRef);
            newReferenceCreated = true;
        }
        return newReferenceCreated;
    }

    private void setServiceToBpelCopyList(Variable serviceVarOut, String mediatorPrefix, String elemName) {
        Assign assign = this.m_phaseActivity.getServiceToBPELAssign();
        List copyList = assign.getCopyRules();
        for (int i = 0; i < this.m_outputVars.size(); ++i) {
            Variable var = this.m_outputVars.get(i);
            From from = (From)BPELParser.createImplementation(From.class);
            To to = (To)BPELParser.createImplementation(To.class);
            to.setVariable(var.getName());
            from.setVariable(serviceVarOut.getName());
            QName qname = var.getElement();
            String prefix = qname.getPrefix();
            String elementName = qname.getLocalPart();
            from.setPart(elementName);
            prefix = this.m_processModel.getPrefixForNamespace(qname.getNamespaceURI());
            from.setQuery("/" + prefix + ":" + elementName);
            Copy append = (Copy)BPELParser.createImplementation(Copy.class);
            append.createDOMElement(assign.getDOMElement().getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            append.setFrom(from);
            append.setTo(to);
            copyList.add(append);
        }
        assign.setCopyRules(copyList);
    }

    private void setBpelToServiceCopyList(Variable serviceVarIn, String mediatorPrefix, String elemName) {
        Assign assign = this.m_phaseActivity.getBPELToServiceAssign();
        if (assign == null) {
            return;
        }
        List copyList = assign.getCopyRules();
        for (int i = 0; i < this.m_inputVars.size(); ++i) {
            Variable var = this.m_inputVars.get(i);
            From from = (From)BPELParser.createImplementation(From.class);
            To to = (To)BPELParser.createImplementation(To.class);
            from.setVariable(var.getName());
            to.setVariable(serviceVarIn.getName());
            QName qname = var.getElement();
            String prefix = qname.getPrefix();
            String elementName = qname.getLocalPart();
            to.setPart(elementName);
            prefix = this.m_processModel.getPrefixForNamespace(qname.getNamespaceURI());
            to.setQuery("/" + prefix + ":" + elementName);
            Copy append = (Copy)BPELParser.createImplementation(Copy.class);
            append.createDOMElement(assign.getDOMElement().getOwnerDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            append.setFrom(from);
            append.setTo(to);
            copyList.add(append);
        }
        assign.setCopyRules(copyList);
    }

    @Override
    public boolean validateEditorChanges() {
        String activityName = this.m_nameField.getText();
        String msg = null;
        if (activityName == null || activityName.equals("") || !Helper.isValidNCName((String)activityName)) {
            msg = BPELStringTranslator.getString("GENERAL_EDITOR_NAME_INVALID");
        }
        if (msg != null) {
            GraphUtils.displayMessage((Component)GraphUtils.getFrame((Component)((Object)this.m_graphPane)), (String)msg, (String)MessageBundleUtil.getCommonString((String)"XXERROR"), (int)0);
            return false;
        }
        return true;
    }

    @Override
    public void removeEditorPageChangeListener(EditorPageChangeListener l) {
    }

    @Override
    public void onSelection() {
    }

    @Override
    public void onDeselection() {
    }

    private PartnerLink createPL(String wsdlName) throws Exception {
        String pLinkWsdlLocation = this.getScaProject().getSCARoot() + wsdlName;
        BPELGraphModel graphModel = (BPELGraphModel)this.m_graphPane.getModel();
        Process processModel = graphModel.getProcess();
        PartnerLinks pLinks = processModel.getPartnerLinks();
        if (pLinks == null) {
            pLinks = processModel.createPartnerLinks();
        }
        List partnerLinks = pLinks.getPartnerLinks();
        String plinkName = this.m_mediatorName;
        Map links = PartnerLinkWSDLUtil.getPartnerLinkTypes((Definition)WSDLUtil.parseWSDLDocument((String)pLinkWsdlLocation));
        if (links != null && links.size() == 0) {
            PartnerLinkWSDLUtil.addPLTypesIntoWSDL((String)pLinkWsdlLocation, null);
        }
        for (int count = 0; count < partnerLinks.size(); ++count) {
            PartnerLink partnerLink = (PartnerLink)partnerLinks.get(count);
            if (!partnerLink.getName().equals(plinkName)) continue;
            return partnerLink;
        }
        PartnerLink pLink = (PartnerLink)BPELParser.createImplementation(PartnerLink.class);
        pLink.setName(plinkName);
        pLink.setProcessURL(this.m_prj.getBPELFileURL());
        pLink.setWSDLLocation(this.getScaProject().getSCARoot() + wsdlName);
        pLink.setInbound(false);
        pLink.setPartnerRole("serviceProvider");
        if (this.hasOutput()) {
            pLink.setMyRole("serviceRequester");
        }
        String prefix = processModel.addNamespace(this.m_mediatorNS);
        QName qname = new QName(this.m_mediatorNS, "servicePLT", prefix);
        pLink.setPartnerLinkType(qname);
        pLinks.addPartnerLink(pLink);
        PartnerLinkNode partnerLinkNode = new PartnerLinkNode();
        partnerLinkNode.setUserObject(pLink);
        partnerLinkNode.setIcon(DecisionServiceConstants.PARTNERLINK_ICON);
        partnerLinkNode.setIconName("application/rules/decision_service_16x16.png");
        SwimLaneNode m_swimLaneNode = graphModel.getRightSwimLaneNode();
        graphModel.addChildNode((Node)m_swimLaneNode, (Node)partnerLinkNode);
        return pLink;
    }

    private void setPLProperties(PartnerLink pLink) {
        ArrayList<PLProperties> propertyList = pLink.getPropertyList();
        if (propertyList == null) {
            propertyList = new ArrayList<PLProperties>();
        }
        PLProperties prop = new PLProperties("DecisionService", this.getName(), null);
        propertyList.add(prop);
        prop = new PLProperties("wsdlRuntimeLocation", "http://${hostname}:${http_port}/rules/${domain_id}/${process_id}/${process_revision}/" + this.getName() + "/" + this.getName() + "?WSDL", null);
        propertyList.add(prop);
        prop = new PLProperties("decisionServiceDetails", "http://${hostname}:${http_port}/rules/${domain_id}/${process_id}/${process_revision}/" + this.getName() + "/public_html/" + "GetDecisionServiceInfo.jsp", null);
        propertyList.add(prop);
        propertyList.add(new PLProperties("optSoapShortcut", "False", null));
        pLink.setPropertyList(propertyList);
        DeploymentFile depFile = this.m_prj.getDeploymentFile();
        try {
            depFile.setPLProperties(pLink.getName(), propertyList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addNewComponent(String businessRuleComponentName, String serviceName) {
        if (this.m_composite == null) {
            return;
        }
        List components = this.m_composite.getComponents();
        Object component = null;
        if (component == null) {
            return;
        }
        SCAProject project = this.getScaProject();
        if (project == null) {
            return;
        }
    }

    private void getInputOutputVariabls() {
        if (this.m_tableModel == null) {
            return;
        }
        Vector data = this.m_tableModel.getData();
        for (Object o : data) {
            VariablesSelectionTableModel.VarRowData l = (VariablesSelectionTableModel.VarRowData)o;
            boolean dir = l.m_isInputVar;
            Variable var = l.m_variable;
            if (dir) {
                this.m_inputVars.add(var);
                continue;
            }
            this.m_outputVars.add(var);
        }
    }

    private Object createDecisionService() {
        this.m_builder.createRuleDictionary(this.m_ruleWizardData);
        return null;
    }

    private Object createMediator() {
        WsdlInfo mediatorWsdlInfo = null;
        String opName = null;
        String wsdlFileName = URLFileSystem.getFileName((URL)this.m_mediatorWsdlURL);
        if (this.hasOutput()) {
            mediatorWsdlInfo = new WsdlInfo(wsdlFileName, new QName(this.m_mediatorNS, "ServicePT"), new QName(this.m_mediatorNS, "ServiceCallbackPT"));
            opName = MediatorUtils.DECISION_SERVICE_OPERATION_NAME;
        } else {
            mediatorWsdlInfo = new WsdlInfo(wsdlFileName, new QName(this.m_mediatorNS, "ServicePT"), null);
            opName = MediatorUtils.DECISION_SERVICE_OPERATION_NAME;
        }
        try {
            WsdlInfo ruleWsdlInfo = new WsdlInfo(this.m_ruleServiceName + ".wsdl", new QName(this.m_ruleNS, "IDecisionService"), null);
            MediatorUtils.createDynamicMediator((IDEProject)this.m_prj, (String)this.m_mediatorName, (WsdlInfo)mediatorWsdlInfo, (String)"execute", (WsdlInfo)mediatorWsdlInfo, (String)this.m_ruleDictionaryName, (String)this.m_ruleServiceName, (WsdlInfo)ruleWsdlInfo, (String)opName, (String)(this.m_prj.getProcessName() + "/" + this.m_mediatorName));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private void setUpRuleWizardData() {
        this.m_ruleWizardData = new WizardData();
        this.m_ruleWizardData.setProject((Project)this.m_graphModel.getBPELProject().getProjectContext());
        this.m_builder = new PhaseDictionaryFileBuilder(this.m_ruleWizardData);
        this.m_ruleWizardData.setPackageName(this.m_builder.getDefaultPackage());
        this.m_ruleWizardData.setServiceName(this.m_ruleServiceName);
        this.m_ruleWizardData.setName(this.m_ruleDictionaryName);
        URL dirURL = URLFactory.newURL((URL)this.m_builder.getRulesDirectory(), (String)this.m_ruleWizardData.getPackageName());
        this.m_ruleWizardData.setType(RuleType.DECISION_TABLE);
        this.extractSchemaInfo(this.m_ruleWizardData);
    }

    protected void extractSchemaInfo(WizardData wizardData) {
        Vector data = this.m_tableModel.getData();
        ArrayList inputXSD = new ArrayList();
        ArrayList outputXSD = new ArrayList();
        HashSet<SchemaElem> inXSDs = new HashSet<SchemaElem>();
        HashSet<SchemaElem> outXSDs = new HashSet<SchemaElem>();
        for (Object o : data) {
            VariablesSelectionTableModel.VarRowData l = (VariablesSelectionTableModel.VarRowData)o;
            boolean isInput = l.m_isInputVar;
            Variable var = l.m_variable;
            BPELGraphModel graphModel = (BPELGraphModel)this.m_graphPane.getModel();
            Process processModel = graphModel.getProcess();
            URL loc = RulesUtil.resolveVariableDef(var, this.m_prj, processModel);
            SchemaElem pair = new SchemaElem();
            try {
                if (loc != null && !ContentUtil.isXSDDocument((URL)loc)) {
                    URI uri = new URI(URIUtil.escapeURIString((String)loc.toExternalForm()));
                    WSDLPartData[] parts = WSDLUtil.getParts((URI)uri, (String)var.getMessageType().getLocalPart(), (String)var.getMessageType().getNamespaceURI());
                    List inlineSchemaList = null;
                    for (WSDLPartData part : parts) {
                        String type = part.getPartType();
                        int xsdType = part.getPartXSDType();
                        if (xsdType == 3) {
                            pair.m_elemName = new QName(part.getTargetNamespace(), type);
                        } else {
                            if (inlineSchemaList == null) {
                                inlineSchemaList = WSDLUtil.getSchemaElement((URI)uri);
                            }
                            pair.m_schemaURL = loc;
                            pair.m_elemName = new QName(part.getTargetNamespace(), type);
                            pair.m_inlineSchemas = inlineSchemaList;
                        }
                        pair.m_aliasInfo = var.getName() + "_" + part.getPartName();
                    }
                } else if (loc == null) {
                    pair.m_elemName = var.getType();
                    pair.m_aliasInfo = var.getName();
                } else {
                    pair.m_schemaURL = loc;
                    if (var.getElement() != null) {
                        pair.m_elemName = var.getElement();
                    } else {
                        pair.m_elemType = var.getType();
                    }
                    pair.m_aliasInfo = var.getName();
                }
                if (isInput) {
                    inXSDs.add(pair);
                    continue;
                }
                outXSDs.add(pair);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        inputXSD.addAll(inXSDs);
        outputXSD.addAll(outXSDs);
        wizardData.setInputVarsXSD(inputXSD);
        this.m_outputVarsXSD = outputXSD;
        URL linkedDictURL = URLFactory.newURL((String)"oramds:/soa/shared/mediator/oracle/rules/oracle/tip/mediator/rules/dictionary/DynamicRouting.rules");
        if (URLFileSystem.exists((URL)linkedDictURL)) {
            wizardData.setLinkedRules(linkedDictURL);
            ArrayList<String> extranOutputFacts = new ArrayList<String>();
            extranOutputFacts.add("oracle.tip.mediator.rules.model.DynamicRouting");
            wizardData.setExtraOutputFacts(extranOutputFacts);
        }
    }

    public String getWSDLTemplate(String name, String ns) {
        String template = "<?xml version= '1.0' encoding= 'UTF-8' ?>" + NL + "<wsdl:definitions" + NL + "     name=\"templateName\"" + NL + "     targetNamespace=\"templateNS\"" + NL + "     xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"" + NL + "     xmlns:tns=\"templateNS\"" + NL + "     xmlns:plnk=\"http://schemas.xmlsoap.org/ws/2003/05/partner-link/\"" + NL + "     xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"" + NL + "     NSS" + NL + "    >" + NL + "    <wsdl:types>" + NL + "        <xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"" + NL + "            targetNamespace=\"templateNS\"" + NL + "            elementFormDefault =\"qualified\"" + NL + "            NSS" + NL + "            >" + NL + "            IMPORTS" + NL + "        </xsd:schema>" + NL + "    </wsdl:types>" + NL + "    <wsdl:message name=\"requestMessage\">" + NL + "        REQUESTPARTS" + NL + "    </wsdl:message>" + NL;
        if (this.hasOutput()) {
            template = template + "    <wsdl:message name=\"replyMessage\">" + NL + "        REPLYPARTS" + NL + "    </wsdl:message>" + NL;
        }
        template = template + "    <wsdl:portType name=\"ServicePT\">" + NL + "        <wsdl:operation name=\"execute\">" + NL + "            <wsdl:input message=\"tns:requestMessage\"/>" + NL + "        </wsdl:operation>" + NL + "    </wsdl:portType>" + NL;
        if (this.hasOutput()) {
            template = template + "    <wsdl:portType name=\"ServiceCallbackPT\">" + NL + "        <wsdl:operation name=\"callback\">" + NL + "            <wsdl:input message=\"tns:replyMessage\"/>" + NL + "        </wsdl:operation>" + NL + "    </wsdl:portType>" + NL;
        }
        template = template + "    <plnk:partnerLinkType name=\"servicePLT\">" + NL + "        <plnk:role name=\"serviceProvider\">" + NL + "            <plnk:portType name=\"tns:ServicePT\"/>" + NL + "        </plnk:role>" + NL;
        if (this.hasOutput()) {
            template = template + "        <plnk:role name=\"serviceRequester\">" + NL + "            <plnk:portType name=\"tns:ServiceCallbackPT\"/>" + NL + "        </plnk:role>" + NL;
        }
        template = template + "    </plnk:partnerLinkType>" + NL;
        template = template + "    <wsdl:service name=\"dynamic\">" + NL + "         <wsdl:port name=\"ServicePT\" binding=\"tns:ServicePTBinding\">" + NL + "             <soap:address xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" location=\"http://www.dummy.com\"/>" + NL + "         </wsdl:port>" + NL + "     </wsdl:service>" + NL;
        template = template + "     <wsdl:binding name=\"ServicePTBinding\" type=\"tns:ServicePT\">" + NL + "         <soap:binding xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>" + NL + "         <wsdl:operation name=\"execute\">" + NL + "             <soap:operation xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" " + NL + "                             style=\"document\" soapAction=\"execute\"/>" + NL + "             <wsdl:input>" + NL + "                 <soap:body xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" use=\"literal\"" + NL + "                            namespace=\"templateNS\"/>" + NL + "             </wsdl:input>" + NL + "         </wsdl:operation>" + NL + "     </wsdl:binding>" + NL;
        template = template + "</wsdl:definitions>";
        template = template.replace("templateName", name);
        template = template.replace("templateNS", ns);
        return template;
    }

    public static Definition buildWsdl(String template, URL wsdlURL, List inputXSDs, List outputXSDs, NamespaceResolver nsResolver) {
        try {
            URL url;
            SchemaElem pair;
            int cnt;
            HashSet<QName> xsds = new HashSet<QName>();
            StringBuffer sbuf = new StringBuffer();
            StringBuffer extraNs = new StringBuffer();
            StringBuffer extraImports = new StringBuffer();
            String space = "                       ";
            StringBuffer partBuf = new StringBuffer();
            if (inputXSDs != null) {
                cnt = 0;
                for (Object obj : inputXSDs) {
                    pair = (SchemaElem)obj;
                    url = pair.m_schemaURL;
                    if (++cnt > 1) {
                        sbuf.append(space);
                    }
                    if (pair.m_elemName != null) {
                        sbuf.append("<xsd:element ref=\"" + PhaseEditPage.toQName(pair.m_elemName) + "\"/>" + NL);
                        xsds.add(new QName(pair.m_elemName.getNamespaceURI(), url.toExternalForm(), pair.m_elemName.getPrefix() + NL));
                        partBuf.append("<wsdl:part name = \"" + pair.m_elemName.getLocalPart() + "\" element = \"" + PhaseEditPage.toQName(pair.m_elemName) + "\"/>");
                        continue;
                    }
                    sbuf.append("<xsd:element name=\"" + pair.m_elemType.getLocalPart() + "\" type=\"" + PhaseEditPage.toQName(pair.m_elemType) + "\"/>" + NL);
                    partBuf.append("<wsdl:part name = \"" + pair.m_elemType.getLocalPart() + "\" element = \"" + PhaseEditPage.toQName(pair.m_elemType) + "\"/>");
                    xsds.add(new QName(pair.m_elemType.getNamespaceURI(), url.toExternalForm(), pair.m_elemType.getPrefix() + NL));
                }
            }
            template = template.replace("REQUESTPARTS", partBuf.toString());
            sbuf = new StringBuffer();
            partBuf = new StringBuffer();
            if (outputXSDs != null) {
                cnt = 0;
                for (Object obj : outputXSDs) {
                    pair = (SchemaElem)obj;
                    url = pair.m_schemaURL;
                    if (++cnt > 1) {
                        sbuf.append(space);
                    }
                    if (pair.m_elemName != null) {
                        sbuf.append("<xsd:element ref=\"" + PhaseEditPage.toQName(pair.m_elemName) + "\"/>");
                        xsds.add(new QName(pair.m_elemName.getNamespaceURI(), url.toExternalForm(), pair.m_elemName.getPrefix() + NL));
                        partBuf.append("<wsdl:part name = \"" + pair.m_elemName.getLocalPart() + "\" element = \"" + PhaseEditPage.toQName(pair.m_elemName) + "\"/>");
                        continue;
                    }
                    sbuf.append("<xsd:element name=\"" + pair.m_elemType.getLocalPart() + "\" type=\"" + PhaseEditPage.toQName(pair.m_elemType) + "\"/>" + NL);
                    xsds.add(new QName(pair.m_elemType.getNamespaceURI(), url.toExternalForm(), pair.m_elemType.getPrefix()));
                    partBuf.append("<wsdl:part name = \"" + pair.m_elemType.getLocalPart() + "\" element = \"" + PhaseEditPage.toQName(pair.m_elemType) + "\"/>");
                }
            }
            template = template.replace("REPLYPARTS", partBuf.toString());
            StringBuffer nss = new StringBuffer();
            StringBuffer imports = new StringBuffer();
            int cnt2 = 0;
            for (QName qn : xsds) {
                if (++cnt2 > 1) {
                    imports.append("            ");
                    nss.append("     ");
                }
                String loc = URLFileSystem.toRelativeSpec((URL)new URL(qn.getLocalPart()), (URL)wsdlURL);
                imports.append("<xsd:import namespace=\"" + qn.getNamespaceURI() + "\" schemaLocation=\"" + loc + "\"/>");
                if (cnt2 < xsds.size()) {
                    imports.append(NL);
                }
                if (Helper.hasValue((String)qn.getPrefix())) {
                    nss.append("xmlns:" + qn.getPrefix().trim() + "=\"" + qn.getNamespaceURI() + "\"");
                } else {
                    nss.append("xmlns=\"" + qn.getNamespaceURI() + "\"");
                }
                if (cnt2 >= xsds.size()) continue;
                nss.append(NL);
            }
            template = template.replace("IMPORTS", imports);
            template = template.replace("NSS", nss);
            OutputStreamWriter pw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(URLFileSystem.openOutputStream((URL)wsdlURL)), "UTF8");
            pw.write(template);
            pw.flush();
            pw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static String toQName(QName qn) {
        String prefix = qn.getPrefix();
        if (Helper.hasValue((String)prefix)) {
            return prefix + ":" + qn.getLocalPart();
        }
        return qn.getLocalPart();
    }

    protected void getAppAndProjNames() {
        URL prj = this.m_prj.getProjectURL();
        URL app = Helper.getParent((URL)prj);
        this.m_projectName = URLFileSystem.getFileName((URL)prj);
        this.m_applicationName = URLFileSystem.getFileName((URL)app);
    }
}

