/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.phase.bpelgraph.editors;

import java.net.URL;
import java.util.List;
import oracle.ide.net.URLFileSystem;
import oracle.rules.sdk2.decisiontable.DTAction;
import oracle.rules.sdk2.decisiontable.RuleSheet;
import oracle.rules.sdk2.dictionary.DictionaryLink;
import oracle.rules.sdk2.ruleset.Expression;
import oracle.rules.sdk2.ruleset.ExpressionTable;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;
import oracle.tip.tools.ide.rules.dictionarybuilder.jdev.JDevDictionaryFileBuilder;
import oracle.tip.tools.ide.rules.sdkmodel.SDKModel;

public class PhaseDictionaryFileBuilder
extends JDevDictionaryFileBuilder {
    public static String PACKAGE_NAME = "oracle.tip.mediator.rules.dictionary";
    public static String DICTIONARY_NAME = "DynamicRouting";
    private String m_dynamicRef = null;

    public PhaseDictionaryFileBuilder(WizardData data) {
        super(data.getProject());
    }

    public void postRuleRuleSheetCreation(RuleSheet sh, String dictionaryName, List<String> ruleSetList) {
        sh.setName("RoutingTable");
        ruleSetList.add("DynamicRoutingCreator");
        DTAction dta = (DTAction)sh.getDTActionTable().add();
        dta.setForm("Assert New");
        dta.setTarget("DynamicRouting.RoutingAction");
        ExpressionTable expTable = dta.getExpressionTable();
        for (Expression exp : expTable) {
            if (exp.getParameterName().equals("serviceBindingInfo")) {
                exp.setDTActionParameterName(exp.getParameterName());
                continue;
            }
            if (exp.getParameterName().equals("caseName")) {
                exp.setValue("\"dynamic_case\"");
                continue;
            }
            if (exp.getParameterName().equals("executionType")) {
                exp.setValue("\"direct\"");
                continue;
            }
            if (exp.getParameterName().equals("onCbkOperation")) {
                exp.setValue("\"callback\"");
                continue;
            }
            if (exp.getParameterName().equals("cbkOperation")) {
                exp.setValue("\"callback\"");
                continue;
            }
            if (exp.getParameterName().equals("serviceOperation")) {
                exp.setValue("\"execute\"");
                continue;
            }
            if (!exp.getParameterName().equals("serviceReference")) continue;
            if (this.m_dynamicRef == null) {
                this.m_dynamicRef = dictionaryName.replaceFirst("OracleRules", "DynamicReference_Mediator");
            }
            exp.setValue("\"" + this.m_dynamicRef + "\"");
        }
    }

    public void setLinkedDictionary(SDKModel sdkModel, WizardData data) {
        URL linkedDictURL;
        if (data.getLinkedRules() != null && URLFileSystem.exists((URL)(linkedDictURL = data.getLinkedRules()))) {
            DictionaryLink link = sdkModel.getDictionary().createDictionaryLink(PACKAGE_NAME, DICTIONARY_NAME);
            link.setAlias(DICTIONARY_NAME);
        }
    }

    public void setDynamicRefName(String name) {
        this.m_dynamicRef = name;
    }

    public String getDynamicRefName() {
        return this.m_dynamicRef;
    }
}

