/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.plugin;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.palette2.PaletteItem;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.jdevimpl.webservices.ide.WSDLArtifactNode;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.event.GraphPaneStatusEvent;
import oracle.tip.tools.ide.common.graph.event.GraphPaneStatusListener;
import oracle.tip.tools.ide.common.graph.model.GraphModel;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.DNDDropHandler;
import oracle.tip.tools.ide.common.graph.view.DropZone;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELDNDDropHandler;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.SwimLaneView;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.PatternNode;
import oracle.tip.tools.ide.pm.modules.rules.wizard.DecisionServiceWizard;

public class ExtensionsDNDDropHandler
implements DNDDropHandler {
    public boolean handleDrop(DropTargetDropEvent e, Object data, GraphPane pane) {
        BPELGraphPane graph = (BPELGraphPane)pane;
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        Process process = model.getProcess();
        boolean bValidate = graph.getValidateOnLoad();
        Point pt = graph.inDrillDownMode() ? e.getLocation() : pane.convertToNonScaledTranslatedCoordinates(e.getLocation());
        int x = pt.x;
        int y = pt.y;
        NodeRenderer r = pane.getNodeRendererAtPosition(x, y);
        String taskName = BPELDNDDropHandler.getTaskNameFromDropData(data);
        String taskType = "";
        String taskID = "";
        if (data instanceof PaletteItem) {
            taskID = ((PaletteItem)data).getItemId();
            if (PatternNode.isPattern(taskID)) {
                taskType = "pattern";
            }
        } else if (data instanceof PaletteItemImpl) {
            taskID = ((PaletteItemImpl)data).getItem().getInfo();
            taskName = ((PaletteItemImpl)data).getItem().getShortLabel();
            taskType = "pattern";
        } else if (data instanceof TransferableContext) {
            return this.handleJDeveloperDrop(graph, r, new Point(x, y), (Scope)process, (TransferableContext)data);
        }
        if (r instanceof SwimLaneView && this.handleSwimLaneDrop(graph, (SwimLaneView)r, taskName, new Point(x, y))) {
            return true;
        }
        if (!(r instanceof DropZone)) {
            return false;
        }
        DropZone dropView = (DropZone)r;
        if (!dropView.isDropAllowed()) {
            return false;
        }
        dropView.setHighLightOn(false);
        Node dropNode = r.getNode();
        Node newNode = null;
        boolean bEditOnDrop = false;
        if (taskType.equals("pattern")) {
            newNode = PatternNode.createNode(taskName, taskID, graph);
        } else if (taskName.equalsIgnoreCase("signal")) {
            newNode = ModelBuilder.createGraphNode(203, process, bValidate);
        } else if (taskName.equalsIgnoreCase("receive_signal")) {
            newNode = ModelBuilder.createGraphNode(204, process, bValidate);
        } else if (taskName.equalsIgnoreCase("java_embedding")) {
            newNode = ModelBuilder.createGraphNode(205, process, bValidate);
        } else if (taskName.equalsIgnoreCase("bind_entity")) {
            newNode = ModelBuilder.createGraphNode(211, process, bValidate);
        } else if (taskName.equalsIgnoreCase("create_entity")) {
            newNode = ModelBuilder.createGraphNode(216, process, bValidate);
        } else if (taskName.equalsIgnoreCase("remove_entity")) {
            newNode = ModelBuilder.createGraphNode(217, process, bValidate);
        } else if (taskName.equalsIgnoreCase("email_scope")) {
            newNode = ModelBuilder.createGraphNode(206, process, bValidate);
            bEditOnDrop = true;
        } else if (taskName.equalsIgnoreCase("voice_scope")) {
            newNode = ModelBuilder.createGraphNode(207, process, bValidate);
            bEditOnDrop = true;
        } else if (taskName.equalsIgnoreCase("sms_scope")) {
            newNode = ModelBuilder.createGraphNode(210, process, bValidate);
            bEditOnDrop = true;
        } else if (taskName.equalsIgnoreCase("im_scope")) {
            newNode = ModelBuilder.createGraphNode(213, process, bValidate);
            bEditOnDrop = true;
        } else if (taskName.equalsIgnoreCase("user_notification_scope")) {
            newNode = ModelBuilder.createGraphNode(215, process, bValidate);
            bEditOnDrop = true;
        } else if (taskName.equalsIgnoreCase("business_rule_scope")) {
            newNode = ModelBuilder.createGraphNode(201, process, bValidate);
            bEditOnDrop = true;
        } else if (taskName.equalsIgnoreCase("validate")) {
            newNode = ModelBuilder.createGraphNode(202, process, bValidate);
        } else if (taskName.equalsIgnoreCase("checkpoint")) {
            newNode = ModelBuilder.createGraphNode(219, process, bValidate);
        }
        if (newNode != null) {
            Activity activity = (Activity)newNode.getUserObject();
            Node parentNode = r.getParent().getNode();
            ContainerActivity parentActivity = (ContainerActivity)parentNode.getUserObject();
            if (BPELDNDDropHandler.checkForSequenceInsertion(parentNode, newNode, graph, dropNode, process)) {
                return true;
            }
            int index = parentNode.indexOf(dropNode);
            if (parentActivity != null && activity != null) {
                try {
                    parentActivity.insertActivity(index / 2, activity);
                }
                catch (Exception e1) {
                    GraphUtils.displayError((Component)((Object)graph), (Throwable)e1);
                    return false;
                }
            }
            if (bEditOnDrop) {
                this.setupDelayedEditing(newNode, graph);
            }
            model.insertChildNode(parentNode, newNode, index);
        }
        return newNode != null;
    }

    protected boolean handleJDeveloperDrop(BPELGraphPane graph, NodeRenderer r, Point dropPoint, Scope s, TransferableContext data) {
        WSDLArtifactNode node = ExtensionsDNDDropHandler.getWSDLArtifactNode(data);
        if (node != null) {
            SwimLaneView view = null;
            view = r instanceof SwimLaneView ? (SwimLaneView)r : graph.getLeftSwimLaneView();
            graph.createPartnerLink(view, dropPoint, s, node.getURL().toExternalForm());
            return true;
        }
        return false;
    }

    public static WSDLArtifactNode getWSDLArtifactNode(TransferableContext data) {
        try {
            WSDLArtifactNode node;
            Object dropData;
            List lst;
            Object obj = data.getTransferData(TransferableContext.contextFlavor);
            if (obj instanceof List && (lst = (List)obj).size() > 0 && (dropData = lst.get(0)) instanceof WSDLArtifactNode && (node = (WSDLArtifactNode)dropData).getURL().getProtocol().startsWith("file")) {
                return (WSDLArtifactNode)dropData;
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected boolean handleSwimLaneDrop(BPELGraphPane graph, SwimLaneView r, String task, Point pt) {
        if (task.equalsIgnoreCase("decision_service")) {
            this.showDecisionServiceWizard(r);
            return true;
        }
        return false;
    }

    protected void showDecisionServiceWizard(SwimLaneView r) {
        BPELGraphPane graph = (BPELGraphPane)r.getGraphPane();
        try {
            DecisionServiceWizard wizard = new DecisionServiceWizard(GraphUtils.getFrame((Component)((Object)graph)), graph, r);
            wizard.display();
        }
        catch (Exception e) {
            GraphUtils.displayError((Component)((Object)graph), (Throwable)e);
        }
    }

    private void setupDelayedEditing(final Node n, final BPELGraphPane graph) {
        GraphPaneStatusListener lst = new GraphPaneStatusListener(){

            public void modelLoaded(GraphModel model) {
            }

            public void statusChanged(GraphPaneStatusEvent evt) {
                if (evt.getId() == 2) {
                    ExtensionsDNDDropHandler.this.startEditingNode(n, graph);
                    graph.removeGraphPaneStatusListener(this);
                }
            }
        };
        graph.addGraphPaneStatusListener(lst);
    }

    private void startEditingNode(Node n, final BPELGraphPane graph) {
        final NodeRenderer r = graph.getNodeRendererForNode(n);
        if (r != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                graph.startEditing(r);
            } else {
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        graph.startEditing(r);
                    }
                };
                SwingUtilities.invokeLater(runner);
            }
        }
    }
}

