/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.model.Project;
import oracle.ide.palette2.PaletteItem;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.PLProperties;
import oracle.tip.tools.ide.common.bpelparser.extension.plugin.BPELParserExtensionsPlugin;
import oracle.tip.tools.ide.common.bpelparser.iface.Invoke;
import oracle.tip.tools.ide.common.bpelparser.iface.OnMessage;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.ProcessEvent;
import oracle.tip.tools.ide.common.bpelparser.iface.ProcessListener;
import oracle.tip.tools.ide.common.bpelparser.iface.Receive;
import oracle.tip.tools.ide.common.bpelparser.iface.Reply;
import oracle.tip.tools.ide.common.bpelparser.plugin.BPELParserPlugin;
import oracle.tip.tools.ide.common.graph.model.GraphElement;
import oracle.tip.tools.ide.common.graph.model.Node;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.common.graph.view.NodeRendererFactory;
import oracle.tip.tools.ide.common.graph.view.StringTransferable;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.InvokeNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilderPlugin;
import oracle.tip.tools.ide.pm.bpelgraph.model.PartnerLinkNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPaneDropTargetListener;
import oracle.tip.tools.ide.pm.bpelgraph.views.InvokeView;
import oracle.tip.tools.ide.pm.bpelgraph.views.NodeEditorSource;
import oracle.tip.tools.ide.pm.bpelgraph.views.OnMessageView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ReceiveView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ReplyView;
import oracle.tip.tools.ide.pm.bpelgraph.views.ScopeView;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.views.EmailView;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.views.IMView;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.views.SMSView;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.views.UserNotificationView;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.views.VoiceView;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.plugin.ExtensionModelBuilderPlugin;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.plugin.ExtensionsDNDDropHandler;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.plugin.ExtensionsDragListener;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.plugin.ExtensionsNodeEditorSource;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.plugin.ExtensionsNodeRendererFactory;
import oracle.tip.tools.ide.pm.modules.rules.RulesUtil;
import oracle.tip.tools.ide.pm.plugin.AbstractBPELModelerPlugin;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ExtensionsBPELModelerPlugin
extends AbstractBPELModelerPlugin {
    @Override
    public void installListeners(final BPELGraphPane graph, BPELGraphModel graphModel) {
        Process p = graphModel.getProcess();
        p.addProcessListener(new ProcessListener(){

            public void modelChanged(ProcessEvent event) {
                switch (event.getID()) {
                    case 6: {
                        PartnerLink link = (PartnerLink)event.getChangeObject();
                        ExtensionsBPELModelerPlugin.this.handlePartnerLinkRemoved(graph, link);
                        break;
                    }
                }
            }
        });
    }

    @Override
    public BPELParserPlugin getBPELParserPlugin() {
        return new BPELParserExtensionsPlugin();
    }

    @Override
    public ModelBuilderPlugin getModelBuilderPlugin() {
        return new ExtensionModelBuilderPlugin();
    }

    @Override
    public NodeEditorSource getNodeEditorSource() {
        return new ExtensionsNodeEditorSource();
    }

    @Override
    public NodeRendererFactory getNodeRendererFactory() {
        return new ExtensionsNodeRendererFactory();
    }

    @Override
    public void registerDNDHandler(BPELGraphPaneDropTargetListener dropTargetListener, BPELGraphPane graph) {
        ExtensionsDNDDropHandler dropHandler = new ExtensionsDNDDropHandler();
        dropTargetListener.registerDNDHandler(dropHandler, PaletteItem.PALETTE_ITEM_FLAVOR);
        dropTargetListener.registerDNDHandler(dropHandler, XmlTransferUtils.FLAVOR_XMLKEY);
        dropTargetListener.registerDNDHandler(dropHandler, TransferableContext.contextFlavor);
        dropTargetListener.registerDNDHandler(dropHandler, StringTransferable.DATA_FLAVOR);
        dropTargetListener.addDragListener(new ExtensionsDragListener());
    }

    @Override
    public Icon getDragIconForActivity(String name) {
        if (name.equalsIgnoreCase("signal")) {
            return ImageCache.getIcon("graph/extensions/signal_40x40.png");
        }
        if (name.equalsIgnoreCase("receive_signal")) {
            return ImageCache.getIcon("graph/extensions/receivesignal_40x40.png");
        }
        if (name.equalsIgnoreCase("java_embedding")) {
            return ImageCache.getIcon("graph/extensions/javaembedding_40x40.png");
        }
        if (name.equalsIgnoreCase("human_task_scope")) {
            return ImageCache.getIcon("graph/extensions/humantask_40x40.png");
        }
        if (name.equalsIgnoreCase("flowN")) {
            return ImageCache.getIcon("graph/bpel/flown_47x47.png");
        }
        if (name.equalsIgnoreCase("transform")) {
            return ImageCache.getIcon("graph/bpel/transform_40x40.png");
        }
        if (name.equalsIgnoreCase("BindEntity")) {
            return ImageCache.getIcon("graph/extensions/bind_entity_40x40.png");
        }
        if (name.equalsIgnoreCase("checkpoint")) {
            return ImageCache.getIcon("graph/extensions/checkpoint28.png");
        }
        if (name.equalsIgnoreCase("CreateEntity")) {
            return ImageCache.getIcon("graph/extensions/create_entity_40x40.png");
        }
        if (name.equalsIgnoreCase("RemoveEntity")) {
            return ImageCache.getIcon("graph/extensions/remove_entity_40x40.png");
        }
        if (name.equalsIgnoreCase("mediator")) {
            return ImageCache.getIcon("palette/adapterservice/mediator_20.png");
        }
        if (name.equalsIgnoreCase("im_scope")) {
            return ImageCache.getIcon("graph/extensions/im_40.png");
        }
        if (name.equalsIgnoreCase("business_rule_scope")) {
            return ImageCache.getIcon("graph/rules/businessrule_40x40.png");
        }
        if (name.equalsIgnoreCase("email_scope")) {
            return ImageCache.getIcon("graph/extensions/email_notification_32x32.png");
        }
        if (name.equalsIgnoreCase("voice_scope")) {
            return ImageCache.getIcon("graph/extensions/voice_notification_32x32.png");
        }
        if (name.equalsIgnoreCase("pager_scope")) {
            return ImageCache.getIcon("graph/extensions/pager_notification_32x32.png");
        }
        if (name.equalsIgnoreCase("sms_scope")) {
            return ImageCache.getIcon("graph/extensions/sms_notification_32x32.png");
        }
        if (name.equalsIgnoreCase("fax_scope")) {
            return ImageCache.getIcon("graph/extensions/fax_notification_32x32.png");
        }
        if (name.equalsIgnoreCase("user_notification_scope")) {
            return ImageCache.getIcon("graph/extensions/genericnotification_40x40.png");
        }
        if (name.equalsIgnoreCase("notification_scope")) {
            return ImageCache.getIcon("graph/extensions/notification_40x40.png");
        }
        if (name.equalsIgnoreCase("validate")) {
            return ImageCache.getIcon("graph/extensions/validate_32x32.png");
        }
        return null;
    }

    private void handlePartnerLinkRemoved(BPELGraphPane graph, PartnerLink l) {
        List propList = null;
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        DeploymentFile depFile = model.getBPELProject().getDeploymentFile();
        if (depFile != null) {
            propList = depFile.getPLProperties(l.getName());
        }
        if (propList != null) {
            for (PLProperties prop : propList) {
                if (!prop.m_name.equals("DecisionService")) continue;
                RulesUtil.removeService(graph, prop.m_value);
            }
        }
    }

    @Override
    public boolean handleDeleteGraphElement(BPELGraphPane graph, GraphElement elem) {
        Reply e;
        if (elem instanceof VoiceView || elem instanceof EmailView || elem instanceof SMSView || elem instanceof IMView || elem instanceof UserNotificationView) {
            return this.handleDeleteNotificationNode(graph, (ScopeView)elem);
        }
        if (elem instanceof InvokeView) {
            Invoke e2 = (Invoke)((Node)elem.getModelElement()).getUserObject();
            if (e2 != null && e2.getEventName() != null) {
                e2.setEventName(null);
            }
        } else if (elem instanceof ReceiveView) {
            Receive e3 = (Receive)((Node)elem.getModelElement()).getUserObject();
            if (e3 != null && e3.getEventName() != null) {
                e3.setEventName(null);
            }
        } else if (elem instanceof OnMessageView) {
            OnMessage e4 = (OnMessage)((Node)elem.getModelElement()).getUserObject();
            if (e4 != null && e4.getEventName() != null) {
                e4.setEventName(null);
            }
        } else if (elem instanceof ReplyView && (e = (Reply)((Node)elem.getModelElement()).getUserObject()) != null && e.getEventName() != null) {
            e.setEventName(null);
        }
        return false;
    }

    private boolean handleDeleteNotificationNode(BPELGraphPane graph, ScopeView view) {
        Node node = view.getNode();
        this.removePartnerLinks(graph, node);
        graph.deleteNodeRenderer((NodeRenderer)view);
        return true;
    }

    private List findPartnerLikNodesForActivity(BPELGraphPane graph, Node n) {
        ArrayList<Node> list = new ArrayList<Node>();
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        int[] types = new int[]{100};
        model.findNodeOfType(n, types, list);
        return list;
    }

    private void removePartnerLinks(BPELGraphPane graph, Node n) {
        BPELGraphModel model = (BPELGraphModel)graph.getModel();
        List notifInvokeNodeslist = this.findPartnerLikNodesForActivity(graph, n);
        if (notifInvokeNodeslist == null || notifInvokeNodeslist.size() != 1) {
            return;
        }
        InvokeNode invokeNode = (InvokeNode)((Object)notifInvokeNodeslist.get(0));
        Invoke invoke = (Invoke)invokeNode.getUserObject();
        String plName = invoke.getPartnerLink();
        PartnerLinkNode plNode = this.getPartnerLinkNodeByName(model.getPartnerLinkNodes(), plName);
        if (plNode == null) {
            return;
        }
        NodeRenderer nodeRenderer = graph.getNodeRendererForNode((Node)plNode);
        this.firePartnerLinkDeteled((Project)graph.getBPELProject().getProjectContext(), (PartnerLink)plNode.getUserObject(), model.getProcess(), plName);
        graph.deleteGraphElement((GraphElement)nodeRenderer, false);
    }

    private PartnerLinkNode getPartnerLinkNodeByName(List partnerLinks, String plName) {
        PartnerLinkNode pLinkNode = null;
        PartnerLink pLink = null;
        for (int count = 0; count < partnerLinks.size(); ++count) {
            String linkName;
            pLinkNode = (PartnerLinkNode)((Object)partnerLinks.get(count));
            pLink = (PartnerLink)pLinkNode.getUserObject();
            if (pLink == null || !(linkName = pLink.getName()).trim().equals(plName)) continue;
            return pLinkNode;
        }
        return null;
    }

    private void firePartnerLinkDeteled(Project proj, PartnerLink plink, Process process, String componentServiceName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OutboundPartnerLink", Boolean.TRUE);
        map.put("Reference_Name", componentServiceName);
        process.fireModelChanged((Object)process, 6, (Object)plink, map);
        this.removeExternalReference(proj, componentServiceName);
    }

    private void removeExternalReference(Project proj, String referenceName) {
        SCAControllerImpl sca = new SCAControllerImpl(proj);
        if (sca == null) {
            return;
        }
        sca.deleteExternalReference(referenceName);
    }
}

