/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.plugin;

import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Bind;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.CheckPoint;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.CreateEntity;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Email;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.IM;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Pattern;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.ReceiveSignal;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.RemoveEntity;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Rule;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.SMS;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Signal;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Validate;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Voice;
import oracle.tip.tools.ide.common.bpelparser.extension.notification.iface.UserNotification;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.JavaEmbedding;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.validation.ValidationContext;
import oracle.tip.tools.ide.common.graph.model.GraphNode;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.BindNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.CheckPointNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.CreateEntityNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.EmailNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.IMNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.JavaEmbeddingNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.PatternNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.ReceiveSignalNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.RemoveEntityNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.RuleNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.SMSNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.SignalNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.UserNotificationNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.ValidateNode;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model.VoiceNode;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.AbstractModelBuilderPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExtensionModelBuilderPlugin
extends AbstractModelBuilderPlugin {
    protected ModelBuilder m_mainBuilder;

    @Override
    public void setModelBuilder(ModelBuilder builder) {
        this.m_mainBuilder = builder;
    }

    @Override
    public int getNodeIDForActivity(Activity a) {
        if (a instanceof Validate) {
            return 202;
        }
        if (a instanceof Validate) {
            return 203;
        }
        if (a instanceof ReceiveSignal) {
            return 204;
        }
        if (a instanceof JavaEmbedding) {
            return 205;
        }
        return -1;
    }

    @Override
    public GraphNode getNodeForActivity(Activity a) {
        if (a instanceof Validate) {
            return this.handleValidate((Validate)a);
        }
        if (a instanceof Signal) {
            return this.handleSignal((Signal)a);
        }
        if (a instanceof ReceiveSignal) {
            return this.handleReceiveSignal((ReceiveSignal)a);
        }
        if (a instanceof Rule) {
            return this.handleRule((Rule)a);
        }
        if (a instanceof Pattern) {
            return this.handlePattern((Pattern)a);
        }
        if (a instanceof Email) {
            return this.handleEMail((Email)a);
        }
        if (a instanceof Voice) {
            return this.handleVoice((Voice)a);
        }
        if (a instanceof SMS) {
            return this.handleSMS((SMS)a);
        }
        if (a instanceof IM) {
            return this.handleIM((IM)a);
        }
        if (a instanceof JavaEmbedding) {
            if (((JavaEmbedding)a).getImport() == null) {
                return this.handleJavaEmbedding((JavaEmbedding)a);
            }
        } else {
            if (a instanceof Bind) {
                return this.handleBind((Bind)a);
            }
            if (a instanceof CreateEntity) {
                return this.handleCreateEntity((CreateEntity)a);
            }
            if (a instanceof RemoveEntity) {
                return this.handleRemoveEntity((RemoveEntity)a);
            }
            if (a instanceof UserNotification) {
                return this.handleUserNotification((UserNotification)a);
            }
            if (a instanceof CheckPoint) {
                return this.handleCheckPoint((CheckPoint)a);
            }
        }
        return null;
    }

    @Override
    public GraphNode createGraphNode(int type, Process p, boolean bValidate) {
        Element processElem = p.getDOMElement();
        Document doc = processElem.getOwnerDocument();
        if (type == 202) {
            ValidateNode newNode = new ValidateNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Validate", Validate.class);
            newNode.setName(name);
            Validate v = (Validate)BPELParser.createImplementation(Validate.class);
            v.setDOMElement(v.createDOMElement(doc, "http://schemas.oracle.com/bpel/extension", true));
            v.setName(name);
            newNode.setUserObject(v);
            return newNode;
        }
        if (type == 203) {
            SignalNode newNode = new SignalNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Signal", Signal.class);
            newNode.setName(name);
            Signal v = (Signal)BPELParser.createImplementation(Signal.class);
            v.setDOMElement(v.createDOMElement(doc, "http://schemas.oracle.com/bpel/extension", true));
            v.setName(name);
            newNode.setUserObject(v);
            return newNode;
        }
        if (type == 204) {
            ReceiveSignalNode newNode = new ReceiveSignalNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"receiveSignal", ReceiveSignal.class);
            newNode.setName(name);
            ReceiveSignal v = (ReceiveSignal)BPELParser.createImplementation(ReceiveSignal.class);
            v.setDOMElement(v.createDOMElement(doc, "http://schemas.oracle.com/bpel/extension", true));
            v.setName(name);
            newNode.setUserObject(v);
            return newNode;
        }
        if (type == 205) {
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Java_Embedding", JavaEmbedding.class);
            JavaEmbeddingNode newNode = new JavaEmbeddingNode();
            newNode.setName(name);
            JavaEmbedding activity = (JavaEmbedding)BPELParser.createImplementation(JavaEmbedding.class);
            activity.setDOMElement(activity.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
            activity.setName(name);
            if (bValidate) {
                activity.getValidationReport(new ValidationContext(p), true);
            }
            newNode.setUserObject(activity);
            return newNode;
        }
        if (type == 219) {
            CheckPointNode newNode = new CheckPointNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"CheckPoint", CheckPoint.class);
            newNode.setName(name);
            CheckPoint v = (CheckPoint)BPELParser.createImplementation(CheckPoint.class);
            v.setDOMElement(v.createDOMElement(doc, "http://schemas.oracle.com/bpel/extension", true));
            v.setName(name);
            newNode.setUserObject(v);
            return newNode;
        }
        if (type == 211) {
            BindNode newNode = new BindNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"BindEntity", Bind.class);
            newNode.setName(name);
            Bind v = (Bind)BPELParser.createImplementation(Bind.class);
            v.setDOMElement(v.createDOMElement(doc, "http://schemas.oracle.com/bpel/extension", true));
            v.setName(name);
            newNode.setUserObject(v);
            return newNode;
        }
        if (type == 216) {
            CreateEntityNode newNode = new CreateEntityNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"CreateEntity", CreateEntity.class);
            newNode.setName(name);
            CreateEntity v = (CreateEntity)BPELParser.createImplementation(CreateEntity.class);
            v.setDOMElement(v.createDOMElement(doc, "http://schemas.oracle.com/bpel/extension", true));
            v.setName(name);
            newNode.setUserObject(v);
            return newNode;
        }
        if (type == 217) {
            RemoveEntityNode newNode = new RemoveEntityNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"RemoveEntity", RemoveEntity.class);
            newNode.setName(name);
            RemoveEntity v = (RemoveEntity)BPELParser.createImplementation(RemoveEntity.class);
            v.setDOMElement(v.createDOMElement(doc, "http://schemas.oracle.com/bpel/extension", true));
            v.setName(name);
            newNode.setUserObject(v);
            return newNode;
        }
        if (type == 215) {
            UserNotificationNode newNode = new UserNotificationNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"UserNotification", UserNotification.class);
            newNode.setName(name);
            UserNotification v = (UserNotification)BPELParser.createImplementation(UserNotification.class);
            v.setDOMElement(v.createDOMElement(doc, "bpelx:usrnotif", true));
            v.setName(name);
            newNode.setUserObject(v);
            return newNode;
        }
        if (type == 206) {
            EmailNode newNode = new EmailNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Email", Email.class);
            newNode.setName(name);
            Email v = (Email)BPELParser.createImplementation(Email.class);
            v.setDOMElement(v.createDOMElement(doc, "bpelx:email", true));
            v.setName(name);
            newNode.setUserObject(v);
            return newNode;
        }
        if (type == 207) {
            VoiceNode newNode = new VoiceNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"Voice", Voice.class);
            newNode.setName(name);
            Voice v = (Voice)BPELParser.createImplementation(Voice.class);
            v.setDOMElement(v.createDOMElement(doc, "bpelx:voice", true));
            v.setName(name);
            newNode.setUserObject(v);
            return newNode;
        }
        if (type == 213) {
            IMNode newNode = new IMNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"IM", IM.class);
            newNode.setName(name);
            IM v = (IM)BPELParser.createImplementation(IM.class);
            v.setDOMElement(v.createDOMElement(doc, "bpelx:im", true));
            v.setName(name);
            newNode.setUserObject(v);
            return newNode;
        }
        if (type == 210) {
            SMSNode newNode = new SMSNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)"SMS", SMS.class);
            newNode.setName(name);
            SMS v = (SMS)BPELParser.createImplementation(SMS.class);
            v.setDOMElement(v.createDOMElement(doc, "bpelx:sms", true));
            v.setName(name);
            newNode.setUserObject(v);
            return newNode;
        }
        if (type == 201) {
            RuleNode newNode = new RuleNode();
            String name = BPELModelUtil.generateUniqueName((Process)p, (String)BPELStringTranslator.getString("BUSINESS_RULE_ACTIVITY_NAME"), Rule.class);
            newNode.setName(name);
            Rule rule = (Rule)BPELParser.createImplementation(Rule.class);
            rule.setDOMElement(rule.createDOMElement(doc, "http://schemas.oracle.com/bpel/extension", true));
            rule.setName(name);
            newNode.setUserObject(rule);
            return newNode;
        }
        return null;
    }

    protected GraphNode handleJavaEmbedding(JavaEmbedding e) {
        JavaEmbeddingNode n = new JavaEmbeddingNode();
        n.setName(e.getName());
        n.setUserObject(e);
        return n;
    }

    protected GraphNode handleValidate(Validate c) {
        ValidateNode n = new ValidateNode();
        n.setName(c.getName());
        n.setUserObject(c);
        return n;
    }

    protected GraphNode handleCheckPoint(CheckPoint c) {
        CheckPointNode n = new CheckPointNode();
        n.setName(c.getName());
        n.setUserObject(c);
        return n;
    }

    protected GraphNode handleSignal(Signal c) {
        SignalNode n = new SignalNode();
        n.setName(c.getName());
        n.setUserObject(c);
        return n;
    }

    protected GraphNode handleReceiveSignal(ReceiveSignal c) {
        ReceiveSignalNode n = new ReceiveSignalNode();
        n.setName(c.getName());
        n.setUserObject(c);
        return n;
    }

    protected GraphNode handleRule(Rule c) {
        RuleNode n = new RuleNode();
        this.m_mainBuilder.buildScopeNode(n, (Scope)c);
        return n;
    }

    protected GraphNode handleEMail(Email e) {
        EmailNode n = new EmailNode();
        n.setName(e.getName());
        n.setUserObject(e);
        this.m_mainBuilder.addChildNodes(n, (ContainerActivity)e);
        return n;
    }

    protected GraphNode handleVoice(Voice e) {
        VoiceNode n = new VoiceNode();
        n.setName(e.getName());
        n.setUserObject(e);
        this.m_mainBuilder.addChildNodes(n, (ContainerActivity)e);
        return n;
    }

    protected GraphNode handleIM(IM e) {
        IMNode n = new IMNode();
        n.setName(e.getName());
        n.setUserObject(e);
        this.m_mainBuilder.addChildNodes(n, (ContainerActivity)e);
        return n;
    }

    protected GraphNode handleSMS(SMS e) {
        SMSNode n = new SMSNode();
        n.setName(e.getName());
        n.setUserObject(e);
        this.m_mainBuilder.addChildNodes(n, (ContainerActivity)e);
        return n;
    }

    protected GraphNode handlePattern(Pattern c) {
        if (!c.getPatternId().endsWith("_old")) {
            return null;
        }
        return PatternNode.handlePattern(c, this.m_mainBuilder);
    }

    protected GraphNode handleBind(Bind c) {
        BindNode n = new BindNode();
        n.setName(c.getName());
        n.setUserObject(c);
        return n;
    }

    protected GraphNode handleCreateEntity(CreateEntity c) {
        CreateEntityNode n = new CreateEntityNode();
        n.setName(c.getName());
        n.setUserObject(c);
        return n;
    }

    protected GraphNode handleRemoveEntity(RemoveEntity c) {
        RemoveEntityNode n = new RemoveEntityNode();
        n.setName(c.getName());
        n.setUserObject(c);
        return n;
    }

    protected GraphNode handleUserNotification(UserNotification notification) {
        UserNotificationNode n = new UserNotificationNode();
        n.setName(notification.getName());
        n.setUserObject(notification);
        this.m_mainBuilder.addChildNodes(n, (ContainerActivity)notification);
        return n;
    }
}

