/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.model;

import java.awt.Component;
import java.util.Map;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.extension.iface.Pattern;
import oracle.tip.tools.ide.common.bpelparser.iface.ContainerActivity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.bpelparser.util.XMLHelper;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.graph.model.GraphNode;
import oracle.tip.tools.ide.common.graph.view.GraphPane;
import oracle.tip.tools.ide.common.graph.view.NodeEditor;
import oracle.tip.tools.ide.common.graph.view.NodeEditorDialog;
import oracle.tip.tools.ide.common.graph.view.NodeRenderer;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.model.ModelBuilder;
import oracle.tip.tools.ide.pm.bpelgraph.model.ScopeNode;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.bpelgraph.views.nodeeditors.EditorPage;
import oracle.tip.tools.ide.pm.designerplugins.bpelextensions.bpelgraph.views.PatternView;
import oracle.tip.tools.ide.pm.modules.uipatterns.BPELPattern;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternHandler;
import oracle.tip.tools.ide.pm.modules.uipatterns.PatternManager;
import oracle.tip.tools.ide.pm.modules.uipatterns.model.impl.BPELModelImpl;
import oracle.tip.tools.ide.pm.modules.uipatterns.ui.PatternFieldsEditPage;
import oracle.tip.tools.ide.pm.modules.uipatterns.ui.PatternNodeEditor;
import oracle.tip.tools.ide.pm.modules.uipatterns.util.PatternUtil;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PatternNode
extends ScopeNode {
    private String m_patternName;

    public PatternNode() {
        super(200);
    }

    public void setPatternName(String name) {
        this.m_patternName = name;
    }

    public String getPatternName() {
        if (this.m_patternName != null && !this.m_patternName.equals("")) {
            return this.m_patternName;
        }
        Pattern pattern = (Pattern)this.getUserObject();
        this.m_patternName = pattern.getDOMElement().getAttributeNS("http://schemas.oracle.com/bpel/jdev/designer", "pattern");
        return this.m_patternName == null ? "" : this.m_patternName;
    }

    public static GraphNode handlePattern(Pattern c, ModelBuilder builder) {
        PatternNode n = new PatternNode();
        n.setName(c.getName());
        n.setUserObject(c);
        builder.addChildNodes(n, (ContainerActivity)c);
        return n;
    }

    public static boolean isPattern(String taskId) {
        return PatternManager.getPattern(taskId) != null;
    }

    public static oracle.tip.tools.ide.common.graph.model.Node createNode(String taskName, String taskId, BPELGraphPane pane) {
        PatternNode node1 = null;
        BPELPattern bpelPattern = PatternManager.getPattern(taskId);
        PatternUtil.copyPatternFilesToProject(bpelPattern, pane);
        BPELGraphModel model = (BPELGraphModel)pane.getModel();
        String nodeName = BPELModelUtil.generateUniqueName((Process)model.getProcess(), (String)bpelPattern.getName(), Scope.class);
        PatternHandler handler = bpelPattern.getPatternHandler();
        if (handler != null) {
            PatternNode patternNode = PatternNode.invokePatternHandler(taskName, taskId, pane);
            if (patternNode == null) {
                return null;
            }
            patternNode.setName(nodeName);
            ((Pattern)patternNode.getUserObject()).setName(nodeName);
            ((Pattern)patternNode.getUserObject()).setPatternId(taskId);
            return patternNode;
        }
        node1 = new PatternNode();
        node1.setName(nodeName);
        Pattern pattern = (Pattern)BPELParser.createImplementation(Pattern.class);
        Document doc = ((BPELGraphModel)pane.getModel()).getProcess().getDOMElement().getOwnerDocument();
        pattern.setDOMElement(pattern.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true));
        pattern.setName(nodeName);
        pattern.setPatternId(taskId);
        node1.setUserObject(pattern);
        if (PatternNode.isOK(pane, node1)) {
            Map map = PatternUtil.importNamespaces(bpelPattern, pane);
            PatternUtil.createPLinks(bpelPattern, pane, map);
            PatternUtil.createVars(bpelPattern, pane);
            node1.setName(nodeName);
            ((Pattern)node1.getUserObject()).setName(nodeName);
            return node1;
        }
        return null;
    }

    private static boolean isOK(BPELGraphPane pane, PatternNode pNode) {
        PatternNodeEditor editor = new PatternNodeEditor();
        Component editorComp = editor.getNodeEditorComponent((GraphPane)pane, pNode);
        EditorPage[] pages = editor.getEditorPages(pane, pNode);
        EditorPage page = pages[0];
        if (page == null) {
            return false;
        }
        PatternFieldsEditPage fieldPage = (PatternFieldsEditPage)pages[0];
        PatternView view = new PatternView((GraphPane)pane, null, pNode);
        NodeEditorDialog dlg = new NodeEditorDialog(GraphUtils.getFrame((Component)((Object)pane)), (GraphPane)pane, (NodeEditor)editor, (NodeRenderer)view, editorComp);
        dlg.setVisible(true);
        return !fieldPage.isCancelled();
    }

    private static PatternNode invokePatternHandler(String taskName, String taskId, BPELGraphPane pane) {
        PatternNode node1 = new PatternNode();
        Pattern pattern = (Pattern)BPELParser.createImplementation(Pattern.class);
        Document doc = ((BPELGraphModel)pane.getModel()).getProcess().getDOMElement().getOwnerDocument();
        Element domElement = pattern.createDOMElement(doc, "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        BPELPattern bpelPattern = PatternManager.getPattern(taskId);
        Map map = PatternUtil.importNamespaces(bpelPattern, pane);
        PatternUtil.createPLinks(bpelPattern, pane, map);
        PatternUtil.createVars(bpelPattern, pane);
        PatternHandler handler = bpelPattern.getPatternHandler();
        if (handler == null) {
            return null;
        }
        pattern.setPatternId(taskId);
        node1.setUserObject(pattern);
        BPELModelImpl bpelModel = new BPELModelImpl(pane);
        try {
            Node node = handler.createNode(taskName, null, bpelPattern.getFragment(), bpelModel);
            if (node == null) {
                return null;
            }
            try {
                System.out.println("===================================================================");
                System.out.println(XMLHelper.getElementMarkup((Element)((Element)node)));
                System.out.println("===================================================================");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Node newNode = domElement.getOwnerDocument().importNode(node, true);
            pattern.setDOMElement((Element)newNode);
            BPELGraphModel graphModel = (BPELGraphModel)pane.getModel();
            Process processModel = graphModel.getProcess();
            String prefix = processModel.addNamespace("http://schemas.oracle.com/bpel/jdev/designer");
            ((XMLElement)newNode).setAttributeNS("http://schemas.oracle.com/bpel/jdev/designer", prefix + ":pattern", taskId);
            pattern.readFromElement((Element)newNode, processModel.createParserContext(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return node1;
    }
}

